/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgPointSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PgPointSet_MP
extends PsPanel
implements ItemListener {
    protected PgPointSet m_pointSet;
    protected Panel m_pSwitches;
    protected Panel m_pGlobalColor;
    protected PsPanel m_pGlobalSizes;
    protected Checkbox m_cVertex;
    protected Checkbox m_cVectorArrow;
    protected Checkbox m_cVertexNormal;
    protected Checkbox m_cVectorField;
    protected Checkbox m_cBndBox;
    protected Checkbox m_cLabels;
    protected Checkbox m_cRGB;
    protected Checkbox m_cHSB;
    protected Canvas m_cColor;
    private static /* synthetic */ Class class$jv$geom$PgPointSet_MP;

    public PgPointSet_MP() {
        if (this.getClass() == (class$jv$geom$PgPointSet_MP != null ? class$jv$geom$PgPointSet_MP : (class$jv$geom$PgPointSet_MP = PgPointSet_MP.class$("jv.geom.PgPointSet_MP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        PsDebug.notify("entered");
        if (source == this.m_cVertex) {
            this.m_pointSet.showVertices(this.m_cVertex.getState());
        } else if (source == this.m_cVertexNormal) {
            this.m_pointSet.showVertexNormals(this.m_cVertexNormal.getState());
        } else if (source == this.m_cBndBox) {
            this.m_pointSet.showBndBox(this.m_cBndBox.getState());
        } else if (source == this.m_cLabels) {
            this.m_pointSet.showIndices(this.m_cLabels.getState());
        } else if (source == this.m_cVectorField) {
            this.m_pointSet.showVectorField(this.m_cVectorField.getState());
        } else {
            return;
        }
        this.m_pointSet.update(this);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pointSet = (PgPointSet)parent;
        this.m_pGlobalSizes.add(this.m_pointSet.m_globalVertexSize.getInfoPanel());
        this.m_pGlobalSizes.add(this.m_pointSet.m_globalVertexNormalLength.getInfoPanel());
        this.m_pGlobalSizes.add(this.m_pointSet.m_globalVertexNormalSize.getInfoPanel());
        this.m_pGlobalSizes.add(this.m_pointSet.m_globalVectorLength.getInfoPanel());
        this.m_pGlobalSizes.add(this.m_pointSet.m_globalVectorSize.getInfoPanel());
        this.m_pGlobalColor.add(this.m_pointSet.m_globalVertexColor.getInfoPanel());
        this.m_pGlobalColor.add(this.m_pointSet.m_globalVertexNormalColor.getInfoPanel());
        this.m_pGlobalColor.add(this.m_pointSet.m_globalVectorColor.getInfoPanel());
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_pointSet == null) {
            PsDebug.warning("missing pointSet");
            return true;
        }
        if (object == this.m_pointSet) {
            this.setTitle(PsConfig.getMessage("MaterialOf") + " " + this.m_pointSet.getName());
            PsPanel.assureEnable(this.m_cVectorField, this.m_pointSet.getVectorField() != null);
            PsPanel.assureEnable(this.m_cVertexNormal, this.m_pointSet.hasVertexNormals());
            PsPanel.assureEnable(this.m_pointSet.m_globalVertexColor.getInfoPanel(), !this.m_pointSet.isShowingVertexColors());
            PsPanel.assureState(this.m_cVertex, this.m_pointSet.isShowingVertices());
            PsPanel.assureState(this.m_cVertexNormal, this.m_pointSet.isShowingVertexNormals());
            PsPanel.assureState(this.m_cVectorField, this.m_pointSet.isShowingVectorField());
            PsPanel.assureState(this.m_cLabels, this.m_pointSet.isShowingIndices());
            return true;
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        Panel pShow = new Panel();
        pShow.setLayout(new BorderLayout());
        this.add(pShow);
        Panel pHeader = new Panel();
        pHeader.setLayout(new BorderLayout());
        Label lTitle = new Label(PsConfig.getMessage("Show") + "      ", 0);
        lTitle.setFont(PsConfig.getFont(3));
        pHeader.add("North", lTitle);
        pShow.add("West", pHeader);
        this.m_pSwitches = new Panel();
        this.m_pSwitches.setLayout(new GridLayout(3, 2));
        this.m_cBndBox = new Checkbox(PsConfig.getMessage("cBndBox"));
        this.m_cBndBox.addItemListener(this);
        this.m_cBndBox.setEnabled(false);
        this.m_cLabels = new Checkbox(PsConfig.getMessage("cLabels"));
        this.m_cLabels.addItemListener(this);
        this.m_pSwitches.add(this.m_cLabels);
        this.m_cVectorField = new Checkbox(PsConfig.getMessage("VectorField"));
        this.m_cVectorField.addItemListener(this);
        this.m_cVectorField.setEnabled(false);
        this.m_pSwitches.add(this.m_cVectorField);
        this.m_cVertex = new Checkbox(PsConfig.getMessage("cVertex"));
        this.m_cVertex.addItemListener(this);
        this.m_pSwitches.add(this.m_cVertex);
        this.m_cVertexNormal = new Checkbox(PsConfig.getMessage("cVertexNormal"));
        this.m_cVertexNormal.addItemListener(this);
        this.m_pSwitches.add(this.m_cVertexNormal);
        pShow.add("Center", this.m_pSwitches);
        this.addLine(1);
        this.m_pGlobalColor = new PsPanel();
        this.add(this.m_pGlobalColor);
        pHeader = new PsPanel();
        pHeader.setLayout(new GridLayout(1, 2));
        ((PsPanel)pHeader).addSubTitle(PsConfig.getMessage("GlobalColor"));
        Panel pColorMode = new Panel();
        pColorMode.setLayout(new GridLayout(1, 2));
        CheckboxGroup gColorMode = new CheckboxGroup();
        this.m_cRGB = new Checkbox("RGB", gColorMode, true);
        this.m_cRGB.addItemListener(this);
        pColorMode.add(this.m_cRGB);
        this.m_cHSB = new Checkbox("HSB", gColorMode, false);
        this.m_cHSB.addItemListener(this);
        this.m_cHSB.setEnabled(false);
        pColorMode.add(this.m_cHSB);
        pHeader.add(pColorMode);
        this.m_pGlobalColor.add(pHeader);
        this.addLine(1);
        this.m_pGlobalSizes = new PsPanel();
        this.m_pGlobalSizes.addSubTitle(PsConfig.getMessage("pGlobalSizes"));
        this.add(this.m_pGlobalSizes);
    }
}

