/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Component;
import java.awt.Image;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsImage;

public class PgTexture
extends PsObject {
    protected String m_imageName = null;
    protected Image m_image = null;
    protected PuInteger m_uMin = new PuInteger(PsConfig.getMessage("textureUMin"), this);
    protected PuInteger m_vMin = new PuInteger(PsConfig.getMessage("textureVMin"), this);
    protected PuInteger m_uMax = new PuInteger(PsConfig.getMessage("textureUMax"), this);
    protected PuInteger m_vMax = new PuInteger(PsConfig.getMessage("textureVMax"), this);
    private static /* synthetic */ Class class$jv$geom$PgTexture;

    public PgTexture() {
        if (this.getClass() == (class$jv$geom$PgTexture != null ? class$jv$geom$PgTexture : (class$jv$geom$PgTexture = PgTexture.class$("jv.geom.PgTexture")))) {
            this.init();
        }
    }

    public String getImageName() {
        return this.m_imageName;
    }

    public void setImageName(String name) {
        this.m_imageName = name;
    }

    protected Image loadImage(Component comp) {
        Image img = PsImage.getImage(this.m_imageName);
        if (comp == null) {
            comp = PsConfig.getFrame();
        }
        if (!PsImage.loadImage(comp, img)) {
            PsDebug.warning("failed loading image = " + this.m_imageName);
            return null;
        }
        this.setImage(img);
        return img;
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == null) {
            return super.update(event);
        }
        if (event == this.m_uMin) {
            return super.update(this);
        }
        if (event == this.m_vMin) {
            return super.update(this);
        }
        if (event == this.m_uMax) {
            return super.update(this);
        }
        if (event == this.m_vMax) {
            return super.update(this);
        }
        return super.update(event);
    }

    public int getUMin() {
        return this.m_uMin.getValue();
    }

    public void setUMin(int value) {
        this.m_uMin.setValue(value);
    }

    public int getVMin() {
        return this.m_vMin.getValue();
    }

    public void setVMin(int value) {
        this.m_vMin.setValue(value);
    }

    public void copy(PgTexture src) {
        super.copy(src);
        this.m_imageName = src.m_imageName;
        this.m_image = src.m_image;
        this.m_uMin.copy(src.m_uMin);
        this.m_vMin.copy(src.m_vMin);
        this.m_uMax.copy(src.m_uMax);
        this.m_vMax.copy(src.m_vMax);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void setImage(String name) {
        this.m_imageName = name;
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
        this.init();
    }

    public int getHeight() {
        return this.m_vMax.getValue() - this.m_vMin.getValue();
    }

    public void init() {
        super.init();
        int width = 1280;
        int height = 1024;
        if (this.m_image != null) {
            width = this.m_image.getWidth(null);
            height = this.m_image.getHeight(null);
        }
        this.m_uMin.setDefBounds(0, width, 5, 10);
        this.m_uMin.setDefValue(0);
        this.m_uMin.init();
        this.m_vMin.setDefBounds(0, height, 5, 10);
        this.m_vMin.setDefValue(0);
        this.m_vMin.init();
        this.m_uMax.setDefBounds(0, width, 5, 10);
        this.m_uMax.setDefValue(width);
        this.m_uMax.init();
        this.m_vMax.setDefBounds(0, height, 5, 10);
        this.m_vMax.setDefValue(height);
        this.m_vMax.init();
    }

    public Object clone() {
        PgTexture clone = (PgTexture)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_uMin = (PuInteger)this.m_uMin.clone();
        clone.m_vMin = (PuInteger)this.m_vMin.clone();
        clone.m_uMax = (PuInteger)this.m_uMax.clone();
        clone.m_vMax = (PuInteger)this.m_vMax.clone();
        return clone;
    }

    public int getWidth() {
        return this.m_uMax.getValue() - this.m_uMin.getValue();
    }

    public int getUMax() {
        return this.m_uMax.getValue();
    }

    public void setUMax(int value) {
        this.m_uMax.setValue(value);
    }

    public int getVMax() {
        return this.m_vMax.getValue();
    }

    public void setVMax(int value) {
        this.m_vMax.setValue(value);
    }
}

