/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;

public final class PgExport_Dialog
extends PsDialog {
    protected TextArea m_output;
    protected String m_dir;
    protected String m_ext = "txt";
    protected String m_fileName = "javaview";
    protected int[] m_exportBounds = new int[]{10, 10, 400, 400};

    public PgExport_Dialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        if (PsConfig.getViewer() != null) {
            this.removeKeyListener(PsConfig.getViewer());
        }
        this.init();
    }

    public String getDirectory() {
        return this.m_dir;
    }

    public void setDirectory(String dir) {
        this.m_dir = dir;
    }

    public String getFilename() {
        return this.m_fileName;
    }

    public void setFilename(String fileName) {
        this.m_fileName = fileName;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bSave) {
            PsDebug.notify("save text to file");
            PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), this.getTitle(), 1);
            if (this.m_ext != null) {
                fd.setFile(this.m_fileName + "." + this.m_ext);
            } else {
                fd.setFile(this.m_fileName + ".txt");
            }
            if (this.m_dir != null) {
                ((FileDialog)fd).setDirectory(this.m_dir);
            } else {
                ((FileDialog)fd).setDirectory(PsConfig.getCodeBase());
            }
            ((Component)fd).setVisible(true);
            if (((FileDialog)fd).getDirectory() == null || fd.getFile() == null) {
                PsDebug.warning("missing dir or file name");
                return;
            }
            this.m_dir = ((FileDialog)fd).getDirectory();
            if (!this.m_dir.endsWith("/") && !this.m_dir.endsWith("\\")) {
                this.m_dir = this.m_dir + "/";
            }
            this.m_fileName = fd.getFile();
            this.m_fileName = this.m_fileName.substring(0, this.m_fileName.lastIndexOf(46));
            File out = null;
            if (PsConfig.isApplication()) {
                out = new File(((FileDialog)fd).getDirectory() + fd.getFile());
                if (out == null) {
                    PsDebug.warning("could not open file = " + fd.getFile() + " in directory = " + ((FileDialog)fd).getDirectory());
                    return;
                }
            } else {
                out = new File(fd.getFile());
                if (out == null) {
                    PsDebug.warning("could not open file = " + fd.getFile());
                    return;
                }
            }
            try {
                FileWriter fw = new FileWriter(out);
                PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(fw), true);
                pw.println(this.getText());
                pw.close();
            }
            catch (IOException ie) {
                PsDebug.warning("could not open file\n\t File Name = " + fd.getFile() + "\n\t Exception = " + ie.toString());
                return;
            }
        }
        super.actionPerformed(event);
    }

    public void setFilenameExtension(String extension) {
        this.m_ext = extension;
    }

    public void init() {
        super.init();
        ((Component)this).setFont(PsConfig.getFont(1));
        this.setLayout(new BorderLayout(5, 5));
        if (!PsConfig.isApplication()) {
            PsPanel pMessage = new PsPanel();
            pMessage.setBorderType(1);
            pMessage.addTitle(PsConfig.getMessage("HowToSaveOutput") + ":");
            TextArea tMessage = new TextArea(PsConfig.getMessage("tMessage"), 6, 65, 1);
            tMessage.setEditable(false);
            pMessage.add(tMessage);
            this.add("North", pMessage);
        }
        this.m_output = new TextArea(40, 80);
        this.m_output.setEditable(true);
        this.add("Center", this.m_output);
        Panel fill = this.getBottomButtons(48);
        ((Component)fill).setFont(PsConfig.getFont(0));
        this.add("South", fill);
        this.setLocation(this.m_exportBounds[0], this.m_exportBounds[1]);
        ((Component)this).setSize(this.m_exportBounds[2], this.m_exportBounds[3]);
        this.validate();
    }

    public void setText(String txt) {
        this.m_output.setText(txt);
    }

    public String getText() {
        if (this.m_output == null) {
            return null;
        }
        return this.m_output.getText();
    }
}

