/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMapleLoader
implements PgLoaderIf {
    protected boolean m_bIsAnimation = false;

    private static int[] parse2ArrayOfDoubles(StreamTokenizer st, Vector vector) throws IOException {
        int numULines = 0;
        int numVLines = 0;
        st.nextToken();
        while (st.ttype != 93) {
            st.nextToken();
            ++numVLines;
            int uLinesOld = numULines;
            numULines = 0;
            while (st.ttype != 93) {
                ++numULines;
                Double d = new Double(PgLoader.parseDouble(st));
                vector.addElement(d);
                st.nextToken();
            }
            if (numVLines > 1 && uLinesOld != numULines) {
                throw new IOException("numULines differ");
            }
            st.nextToken();
        }
        return new int[]{numULines, numVLines};
    }

    private static PdVector parsePoint(StreamTokenizer st, int dim) throws IOException {
        PdVector v = new PdVector(dim);
        st.nextToken();
        int i = 0;
        while (i < dim) {
            v.m_data[i] = PgLoader.parseDouble(st);
            st.nextToken();
            ++i;
        }
        return v;
    }

    public PgJvxSrc[] read(BufferedReader bufReader) {
        this.m_bIsAnimation = false;
        if (bufReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        Vector geom = null;
        geom = this.parseMaple(bufReader);
        if (geom == null || geom.size() == 0) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        PgJvxSrc[] geomArr = new PgJvxSrc[geom.size()];
        int i = 0;
        Enumeration e = geom.elements();
        while (e.hasMoreElements()) {
            geomArr[i] = (PgJvxSrc)e.nextElement();
            switch (geomArr[i].getType()) {
                case 30: {
                    geomArr[i].showVertices(true);
                    break;
                }
                case 33: {
                    if (geomArr[i].getElementColors() == null) {
                        geomArr[i].makeElementColorsFromXYZ();
                    }
                    geomArr[i].showElementColors(true);
                    geomArr[i].assureNeighbours();
                    geomArr[i].showEdges(true);
                    geomArr[i].showElements(true);
                    break;
                }
                case 32: {
                    geomArr[i].showVertices(true);
                    geomArr[i].showPolygons(true);
                    geomArr[i].showEdges(true);
                    break;
                }
            }
            ++i;
        }
        return geomArr;
    }

    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open = " + fileName);
            return null;
        }
        PgMapleLoader loader = new PgMapleLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        if (geomArr != null) {
            int i = 0;
            while (i < geomArr.length) {
                if (geomArr[i] != null && geomArr[i].getName() == null) {
                    geomArr[i].setName(PsUtil.getFileBaseName(fileName) + "[" + i + "]");
                }
                ++i;
            }
        }
        try {
            in.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return geomArr;
    }

    private static PdVector parsePoint(StreamTokenizer st) throws IOException {
        int maxNum = 10;
        int num = 0;
        PdVector v = new PdVector(maxNum);
        st.nextToken();
        while (st.ttype != 91) {
            if (num == maxNum) {
                v.setSize(maxNum *= 2);
            }
            v.m_data[num++] = PgLoader.parseDouble(st);
            st.nextToken();
        }
        v.setSize(num);
        return v;
    }

    private static int[] parse2ArrayOfPoints(StreamTokenizer st, Vector vector, int dim) throws IOException {
        int numULines = 0;
        int numVLines = 0;
        st.nextToken();
        while (st.ttype != 93) {
            st.nextToken();
            st.pushBack();
            if (st.ttype == 91) {
                ++numVLines;
                int uLinesOld = numULines;
                numULines = 0;
                st.nextToken();
                while (st.ttype != 93) {
                    PdVector v = PgMapleLoader.parsePoint(st, dim);
                    vector.addElement(v);
                    ++numULines;
                    st.nextToken();
                }
                if (numVLines > 1 && uLinesOld != numULines) {
                    throw new IOException("numULines differ");
                }
            } else {
                PgMapleLoader.parseUnknown(st);
            }
            st.nextToken();
        }
        return new int[]{numULines, numVLines};
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption option) {
    }

    public void setAnimation(boolean flag) {
        this.m_bIsAnimation = flag;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        int k;
        String ver;
        int j;
        int len;
        int i;
        int numOfPolygons;
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("#    JavaView software by " + PsConfig.getAuthors() + "\n");
        writer.write("#    Info about JavaView at URL = " + PsConfig.getHomepage() + "\n");
        writer.write("#    File Format = Maple Graphics MPL\n");
        writer.write("#    Geometry    = " + geom.getName() + "\n");
        writer.write("#    Date        = " + new Date().toString() + "\n");
        int numOfVertices = geom.getNumVertices();
        writer.write("#    Number of Vertices = " + numOfVertices + "\n");
        int numOfElements = geom.getNumElements();
        if (numOfElements > 0) {
            writer.write("#    Number of Elements = " + numOfElements + "\n");
        }
        if ((numOfPolygons = geom.getNumPolygons()) > 0) {
            writer.write("#    Number of Polygons = " + numOfPolygons + "\n");
        }
        writer.write("# End of Header\n");
        if (geom.getDimOfVertices() == 3) {
            writer.write("PLOT3D(");
        } else {
            writer.write("PLOT(");
        }
        PdVector[] vertex = geom.getVertices();
        String col = null;
        Color[] color = null;
        writer.write("TITLE('`" + geom.getName() + "`')");
        if (numOfPolygons > 0) {
            writer.write(",\nCURVES(");
            PiVector[] polygon = geom.getPolygons();
            i = 0;
            while (i < numOfPolygons) {
                if (i > 0) {
                    writer.write(",\n");
                }
                writer.write("[");
                len = polygon[i].getSize();
                j = 0;
                while (j < len) {
                    if (j > 0) {
                        writer.write(",");
                    }
                    ver = PgMapleLoader.writeVertex(vertex[polygon[i].m_data[j]]);
                    writer.write(ver);
                    ++j;
                }
                writer.write("]");
                ++i;
            }
            writer.write(",\n");
            if (geom.isShowingPolygonColors()) {
                color = geom.getPolygonColors();
                writer.write("COLOR(RGB");
                k = 0;
                while (k < numOfPolygons) {
                    writer.write(",\n" + String.valueOf((double)color[k].getRed() / 255.0) + "," + String.valueOf((double)color[k].getGreen() / 255.0) + "," + String.valueOf((double)color[k].getBlue() / 255.0));
                    ++k;
                }
                writer.write(")");
            } else {
                col = PgMapleLoader.writeColor(geom.getGlobalPolygonColor());
                writer.write(col);
            }
            if (geom.getGlobalPolygonSize() > 1.0) {
                writer.write(",THICKNESS(" + (int)geom.getGlobalPolygonSize() + ")");
            }
            if (geom.isShowingPolygons()) {
                writer.write(",STYLE(PATCH)");
            } else {
                writer.write(",STYLE(POINT)");
            }
            writer.write(")");
        } else if (numOfElements > 0) {
            writer.write(",\nPOLYGONS(");
            PiVector[] element = geom.getElements();
            i = 0;
            while (i < numOfElements) {
                if (i > 0) {
                    writer.write(",\n");
                }
                writer.write("[");
                len = element[i].getSize();
                j = 0;
                while (j < len) {
                    if (j > 0) {
                        writer.write(",");
                    }
                    ver = PgMapleLoader.writeVertex(vertex[element[i].m_data[j]]);
                    writer.write(ver);
                    ++j;
                }
                writer.write("]");
                ++i;
            }
            writer.write(",\n");
            if (geom.isShowingElementColors()) {
                color = geom.getElementColors();
                writer.write("COLOR(RGB");
                k = 0;
                while (k < numOfElements) {
                    writer.write(",\n" + String.valueOf((double)color[k].getRed() / 255.0) + "," + String.valueOf((double)color[k].getGreen() / 255.0) + "," + String.valueOf((double)color[k].getBlue() / 255.0));
                    ++k;
                }
                writer.write(")");
            } else if (geom.isShowingElements()) {
                col = PgMapleLoader.writeColor(geom.getGlobalElementColor());
                writer.write(col);
            } else if (!geom.isShowingElements()) {
                col = PgMapleLoader.writeColor(geom.getGlobalEdgeColor());
                writer.write(col);
            }
            if (geom.getGlobalEdgeSize() > 1.0) {
                writer.write(",THICKNESS(" + (int)geom.getGlobalEdgeSize() + ")");
            }
            if (geom.isShowingElements() && geom.isShowingEdges()) {
                writer.write(",STYLE(PATCH)");
            } else if (geom.isShowingElements() && !geom.isShowingEdges()) {
                writer.write(",STYLE(PATCHNOGRID)");
            } else if (!geom.isShowingElements() && geom.isShowingEdges()) {
                writer.write(",STYLE(LINE)");
            } else {
                writer.write(",STYLE(POINT)");
            }
            writer.write(")");
        }
        if (numOfVertices > 0 && geom.isShowingVertices()) {
            writer.write(",\nPOINTS(");
            i = 0;
            while (i < numOfVertices) {
                if (i > 0) {
                    writer.write(",\n");
                }
                String ver2 = PgMapleLoader.writeVertex(vertex[i]);
                writer.write(ver2);
                ++i;
            }
            writer.write(",\n");
            if (geom.isShowingVertexColors()) {
                color = geom.getVertexColors();
                writer.write("COLOR(RGB");
                k = 0;
                while (k < numOfVertices) {
                    writer.write(",\n" + String.valueOf((double)color[k].getRed() / 255.0) + "," + String.valueOf((double)color[k].getGreen() / 255.0) + "," + String.valueOf((double)color[k].getBlue() / 255.0));
                    ++k;
                }
                writer.write(")");
            } else {
                col = PgMapleLoader.writeColor(geom.getGlobalVertexColor());
                writer.write(col);
            }
            if (geom.getGlobalVertexSize() > 1.0) {
                writer.write(",THICKNESS(" + (int)geom.getGlobalVertexSize() + ")");
                writer.write(",SYMBOL(CIRCLE," + 2 * (int)geom.getGlobalVertexSize() + ")");
            } else {
                writer.write(",SYMBOL(CIRCLE)");
            }
            writer.write(")");
        }
        writer.write(",SCALING(CONSTRAINED)");
        writer.write(",LIGHTMODEL(LIGHT_3)");
        writer.write(");");
        return true;
    }

    private static String writeColor(Color col) {
        if (col == null) {
            PsDebug.warning("missing color");
            return null;
        }
        StringBuffer tmp = new StringBuffer("COLOR(RGB,");
        tmp.append(String.valueOf((double)col.getRed() / 255.0) + ", " + String.valueOf((double)col.getGreen() / 255.0) + ", " + String.valueOf((double)col.getBlue() / 255.0) + ")");
        return tmp.toString();
    }

    private static String writeVertex(PdVector v) {
        if (v == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int len = v.getSize();
        if (len < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (len > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            len = 3;
        }
        StringBuffer tmp = new StringBuffer("[" + String.valueOf(v.m_data[0]));
        int j = 1;
        while (j < len) {
            tmp.append(",");
            if (Math.abs(v.m_data[j]) > 1.0E-10) {
                tmp.append((float)v.m_data[j]);
            } else {
                tmp.append(0.0f);
            }
            ++j;
        }
        tmp.append("]");
        return tmp.toString();
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static double[] parseRange(StreamTokenizer st) throws IOException {
        double xMin = PgLoader.parseDouble(st);
        double xMax = PgLoader.parseDouble(st);
        st.nextToken();
        if (st.ttype == -2) {
            st.pushBack();
            double x3 = PgLoader.parseDouble(st);
            st.nextToken();
            if (st.ttype == -2) {
                st.pushBack();
                double x4 = PgLoader.parseDouble(st);
                st.nextToken();
                xMax = 10.0 * x3 + x4;
            } else {
                xMax = xMax == 0.0 ? 10.0 * x3 : 10.0 * xMax + x3;
            }
        } else {
            xMax *= 10.0;
        }
        st.pushBack();
        return new double[]{xMin, xMax};
    }

    protected Vector readGraphics(StreamTokenizer st, int dim, Vector geomVec) throws IOException {
        String unUsedText = "";
        Vector<PdVector> vertexVector = new Vector<PdVector>();
        Vector<PiVector> elementVector = new Vector<PiVector>();
        Vector<PiVector> polygonVector = new Vector<PiVector>();
        PgJvxSrc geom = null;
        String title = null;
        int numOpenBrackets1 = 0;
        int numOpenBrackets2 = 0;
        do {
            int ind;
            int len;
            st.nextToken();
            if (st.ttype == 41) {
                --numOpenBrackets1;
                continue;
            }
            if (st.ttype == 40) {
                ++numOpenBrackets1;
                continue;
            }
            if (st.ttype == 91) {
                ++numOpenBrackets2;
                continue;
            }
            if (st.ttype == 93) {
                --numOpenBrackets2;
                continue;
            }
            if (st.ttype == 44) continue;
            if (st.ttype != -3) {
                throw new IOException("Graphics primitive identifyer expected");
            }
            if ("TITLE".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                title = st.sval;
                st.nextToken();
                while (st.ttype != 41) {
                    unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    st.nextToken();
                }
            } else if ("POLYGONS".equals(st.sval)) {
                st.nextToken();
                int off = 0;
                while (st.ttype != 41) {
                    PiVector p;
                    PdVector v;
                    st.nextToken();
                    st.pushBack();
                    if (st.ttype == 91) {
                        len = 0;
                        st.nextToken();
                        while (st.ttype != 93) {
                            v = PgMapleLoader.parsePoint(st, dim);
                            vertexVector.addElement(v);
                            ++len;
                            st.nextToken();
                        }
                        p = new PiVector(len);
                        int i = 0;
                        while (i < len) {
                            p.setEntry(i, off + i);
                            ++i;
                        }
                        off += len;
                        elementVector.addElement(p);
                    } else if ("Array".equals(st.sval) || "hfarray".equals(st.sval)) {
                        while ("Array".equals(st.sval)) {
                            len = 0;
                            st.nextToken();
                            st.nextToken();
                            double[] range = PgMapleLoader.parseRange(st);
                            st.nextToken();
                            range = PgMapleLoader.parseRange(st);
                            st.nextToken();
                            st.nextToken();
                            while (st.ttype != 93) {
                                v = PgMapleLoader.parsePoint(st, dim);
                                vertexVector.addElement(v);
                                ++len;
                                st.nextToken();
                            }
                            st.nextToken();
                            while (st.ttype != 41) {
                                unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                                st.nextToken();
                            }
                            p = new PiVector(len);
                            int i = 0;
                            while (i < len) {
                                p.setEntry(i, off + i);
                                ++i;
                            }
                            off += len;
                            elementVector.addElement(p);
                        }
                    } else if (st.ttype != 44) {
                        unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    }
                    st.nextToken();
                }
                if (elementVector.size() == 0) continue;
                geom = new PgJvxSrc();
                geom.setDimOfVertices(dim);
                geom.setNumVertices(vertexVector.size());
                ind = 0;
                Enumeration e = vertexVector.elements();
                while (e.hasMoreElements()) {
                    geom.setVertex(ind++, (PdVector)e.nextElement());
                }
                geom.setDimOfElements(-1);
                geom.setNumElements(elementVector.size());
                ind = 0;
                e = elementVector.elements();
                while (e.hasMoreElements()) {
                    geom.setElement(ind++, (PiVector)e.nextElement());
                }
                geom.setName("ElementSet imported from Maple");
                geom.setType(33);
                geomVec.addElement(geom);
                vertexVector.removeAllElements();
                elementVector.removeAllElements();
            } else if ("POINTS".equals(st.sval)) {
                st.nextToken();
                while (st.ttype != 41) {
                    st.nextToken();
                    st.pushBack();
                    if (st.ttype == 91) {
                        PdVector v = PgMapleLoader.parsePoint(st, dim);
                        vertexVector.addElement(v);
                    } else {
                        unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    }
                    st.nextToken();
                }
                geom = new PgJvxSrc();
                geom.setDimOfVertices(dim);
                geom.setNumVertices(vertexVector.size());
                ind = 0;
                Enumeration e = vertexVector.elements();
                while (e.hasMoreElements()) {
                    geom.setVertex(ind++, (PdVector)e.nextElement());
                }
                geom.setName("PointSet imported from Maple");
                geom.setType(30);
                geomVec.addElement(geom);
                vertexVector.removeAllElements();
            } else if ("CURVES".equals(st.sval)) {
                st.nextToken();
                int off = 0;
                double thickness = 0.0;
                while (st.ttype != 41) {
                    st.nextToken();
                    st.pushBack();
                    if (st.ttype == 91) {
                        len = 0;
                        st.nextToken();
                        while (st.ttype != 93) {
                            PdVector v = PgMapleLoader.parsePoint(st, dim);
                            vertexVector.addElement(v);
                            ++len;
                            st.nextToken();
                        }
                        PiVector p = new PiVector(len);
                        int i = 0;
                        while (i < len) {
                            p.setEntry(i, off + i);
                            ++i;
                        }
                        off += len;
                        polygonVector.addElement(p);
                    } else if ("THICKNESS".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        thickness = PgLoader.parseDouble(st);
                        st.nextToken();
                    } else {
                        unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    }
                    st.nextToken();
                }
                geom = new PgJvxSrc();
                geom.setDimOfVertices(dim);
                geom.setNumVertices(vertexVector.size());
                ind = 0;
                Enumeration e = vertexVector.elements();
                while (e.hasMoreElements()) {
                    geom.setVertex(ind++, (PdVector)e.nextElement());
                }
                geom.setDimOfPolygons(-1);
                geom.setNumPolygons(polygonVector.size());
                ind = 0;
                e = polygonVector.elements();
                while (e.hasMoreElements()) {
                    geom.setPolygon(ind++, (PiVector)e.nextElement());
                }
                geom.setName("PolygonSet imported from Maple");
                geom.setType(32);
                geom.showVertices(false);
                if (thickness > 0.0) {
                    geom.setGlobalPolygonSize(thickness);
                }
                geomVec.addElement(geom);
                vertexVector.removeAllElements();
                polygonVector.removeAllElements();
            } else if ("TEXT".equals(st.sval)) {
                st.nextToken();
                PdVector v = null;
                while (st.ttype != 41) {
                    st.nextToken();
                    st.pushBack();
                    if (st.ttype == 91) {
                        v = PgMapleLoader.parsePoint(st, dim);
                        vertexVector.addElement(v);
                    } else if (st.ttype == 39) {
                        st.nextToken();
                        if (v != null) {
                            v.setName(st.sval);
                        } else {
                            PsDebug.warning("text position must occur before label, line = " + st.lineno());
                        }
                    } else {
                        unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    }
                    st.nextToken();
                }
                geom = new PgJvxSrc();
                geom.setDimOfVertices(dim);
                geom.setNumVertices(vertexVector.size());
                ind = 0;
                Enumeration e = vertexVector.elements();
                while (e.hasMoreElements()) {
                    geom.setVertex(ind++, (PdVector)e.nextElement());
                }
                if (v != null) {
                    geom.setName("Text: " + v.getName());
                }
                geom.setType(30);
                geom.showIndices(true);
                geom.setGlobalVertexSize(0.0);
                geomVec.addElement(geom);
                vertexVector.removeAllElements();
            } else if ("GRID".equals(st.sval)) {
                int j;
                st.nextToken();
                int numULines = 0;
                int numVLines = 0;
                double xMin = 0.0;
                double xMax = 0.0;
                double yMin = 0.0;
                double yMax = 0.0;
                while (st.ttype != 41) {
                    double[] range;
                    st.nextToken();
                    st.pushBack();
                    if (st.ttype == -2) {
                        range = PgMapleLoader.parseRange(st);
                        xMin = range[0];
                        xMax = range[1];
                        st.nextToken();
                        range = PgMapleLoader.parseRange(st);
                        yMin = range[0];
                        yMax = range[1];
                    } else if ("Array".equals(st.sval) || "hfarray".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        range = PgMapleLoader.parseRange(st);
                        st.nextToken();
                        range = PgMapleLoader.parseRange(st);
                        st.nextToken();
                        int[] dimArr = PgMapleLoader.parse2ArrayOfDoubles(st, vertexVector);
                        if (dimArr != null) {
                            numULines = dimArr[0];
                            numVLines = dimArr[1];
                        }
                        st.nextToken();
                        while (st.ttype != 41) {
                            unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                            st.nextToken();
                        }
                    } else if (st.ttype == 91) {
                        int[] dimArr = PgMapleLoader.parse2ArrayOfDoubles(st, vertexVector);
                        if (dimArr != null) {
                            numULines = dimArr[0];
                            numVLines = dimArr[1];
                        }
                    } else {
                        unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    }
                    st.nextToken();
                }
                if (numULines == 0 || numVLines == 0) continue;
                double dx = (xMax - xMin) / (double)(numULines - 1);
                double dy = (yMax - yMin) / (double)(numVLines - 1);
                ind = 0;
                geom = new PgJvxSrc();
                geom.setDimOfVertices(3);
                geom.setNumVertices(numULines * numVLines);
                int i = 0;
                while (i < numVLines) {
                    j = 0;
                    while (j < numULines) {
                        Double d = (Double)vertexVector.elementAt(ind);
                        geom.getVertex(ind++).set(xMin + (double)j * dx, yMin + (double)i * dy, d);
                        ++j;
                    }
                    ++i;
                }
                geom.setDimOfElements(4);
                geom.setNumElements((numULines - 1) * (numVLines - 1));
                ind = 0;
                i = 0;
                while (i < numVLines - 1) {
                    j = 0;
                    while (j < numULines - 1) {
                        geom.getElement(ind++).set(i * numULines + j, (i + 1) * numULines + j, (i + 1) * numULines + j + 1, i * numULines + j + 1);
                        ++j;
                    }
                    ++i;
                }
                geom.setName("Grid imported from Maple");
                geom.setType(33);
                geomVec.addElement(geom);
                vertexVector.removeAllElements();
            } else if ("MESH".equals(st.sval)) {
                st.nextToken();
                int numULines = 0;
                int numVLines = 0;
                while (st.ttype != 41) {
                    st.nextToken();
                    st.pushBack();
                    if ("Array".equals(st.sval) || "hfarray".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        double[] range = PgMapleLoader.parseRange(st);
                        st.nextToken();
                        range = PgMapleLoader.parseRange(st);
                        st.nextToken();
                        range = PgMapleLoader.parseRange(st);
                        st.nextToken();
                        int[] dimArr = PgMapleLoader.parse2ArrayOfPoints(st, vertexVector, dim);
                        if (dimArr != null) {
                            numULines = dimArr[0];
                            numVLines = dimArr[1];
                        }
                        st.nextToken();
                        while (st.ttype != 41) {
                            unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                            st.nextToken();
                        }
                    } else if (st.ttype == 91) {
                        int[] dimArr = PgMapleLoader.parse2ArrayOfPoints(st, vertexVector, dim);
                        if (dimArr != null) {
                            numULines = dimArr[0];
                            numVLines = dimArr[1];
                        }
                    } else {
                        unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
                    }
                    st.nextToken();
                }
                if (numULines == 0 || numVLines == 0) continue;
                geom = new PgJvxSrc();
                geom.setDimOfVertices(dim);
                geom.setNumVertices(vertexVector.size());
                ind = 0;
                Enumeration e = vertexVector.elements();
                while (e.hasMoreElements()) {
                    geom.setVertex(ind++, (PdVector)e.nextElement());
                }
                geom.setDimOfElements(4);
                geom.setNumElements((numULines - 1) * (numVLines - 1));
                ind = 0;
                int i = 0;
                while (i < numVLines - 1) {
                    int j = 0;
                    while (j < numULines - 1) {
                        geom.getElement(ind++).set(i * numULines + j, (i + 1) * numULines + j, (i + 1) * numULines + j + 1, i * numULines + j + 1);
                        ++j;
                    }
                    ++i;
                }
                geom.setName("Mesh imported from Maple");
                geom.setType(33);
                geomVec.addElement(geom);
                vertexVector.removeAllElements();
            } else if ("ANIMATE".equals(st.sval)) {
                this.m_bIsAnimation = true;
            } else {
                st.pushBack();
                unUsedText = unUsedText + PgMapleLoader.parseUnknown(st);
            }
            if (title == null || geom == null) continue;
            geom.setTitle(title);
            geom.setName(title);
            geom.showTitle(true);
        } while (numOpenBrackets1 > 0);
        return geomVec;
    }

    protected Vector parseMaple(BufferedReader bufReader) {
        Vector geomVec;
        block17: {
            StreamTokenizer st = new StreamTokenizer(bufReader);
            st.ordinaryChar(91);
            st.ordinaryChar(93);
            st.ordinaryChar(40);
            st.ordinaryChar(41);
            st.ordinaryChar(42);
            st.ordinaryChar(94);
            st.ordinaryChar(44);
            st.commentChar(35);
            st.parseNumbers();
            st.eolIsSignificant(false);
            st.whitespaceChars(92, 92);
            st.whitespaceChars(96, 96);
            st.quoteChar(39);
            geomVec = new Vector();
            int numOpenBrackets1 = 0;
            int numOpenBrackets2 = 0;
            try {
                block12: while (true) {
                    switch (st.nextToken()) {
                        default: {
                            throw new IOException("parsing broke abnormally");
                        }
                        case -1: {
                            PsDebug.notify("\t EOF token = " + st.sval);
                            if (numOpenBrackets1 != 0) {
                                throw new IOException("'}' missing");
                            }
                            if (numOpenBrackets2 != 0) {
                                throw new IOException("']' missing");
                            }
                            break block17;
                        }
                        case -3: {
                            if ("PLOT".equals(st.sval)) {
                                if ((geomVec = this.readGraphics(st, 2, geomVec)) != null) continue block12;
                                throw new IOException("failed reading PLOT");
                            }
                            if ("PLOT3D".equals(st.sval)) {
                                if ((geomVec = this.readGraphics(st, 3, geomVec)) != null) continue block12;
                                throw new IOException("failed reading PLOT3D");
                            }
                            PsDebug.warning("Unknown command:" + st.sval);
                            break;
                        }
                        case 44: {
                            break;
                        }
                        case 123: {
                            ++numOpenBrackets1;
                            break;
                        }
                        case 125: {
                            if (--numOpenBrackets1 >= 0) continue block12;
                            throw new IOException("More '}' than '{'");
                        }
                        case 59: {
                            break;
                        }
                        case 91: {
                            ++numOpenBrackets2;
                            break;
                        }
                        case 93: {
                            if (--numOpenBrackets2 >= 0) continue block12;
                            throw new IOException("More ']' than '['");
                        }
                    }
                }
            }
            catch (IOException e) {
                PsDebug.warning("Exception thrown = " + e.toString() + "\n\tparsing broke abnormally in line=" + st.lineno() + ",\n\treading st.sval=" + st.sval + ",\n\tst.ttype=" + st.ttype);
                return null;
            }
        }
        PsDebug.notify("... finished");
        return geomVec;
    }

    private static String parseUnknown(StreamTokenizer st) throws IOException {
        String unUsedText = "";
        st.nextToken();
        unUsedText = st.sval;
        st.nextToken();
        if (st.ttype == 44 || st.ttype == 41) {
            st.pushBack();
            return unUsedText;
        }
        if (st.ttype != 40) {
            int numRoundBrackets = 0;
            int numSquareBrackets = 0;
            while (st.ttype != 44 && st.ttype != -1 && numRoundBrackets >= 0 && numSquareBrackets >= 0) {
                st.nextToken();
                if (st.ttype == 40) {
                    unUsedText = unUsedText + "(";
                    ++numRoundBrackets;
                    continue;
                }
                if (st.ttype == 41) {
                    unUsedText = unUsedText + ")";
                    --numRoundBrackets;
                    continue;
                }
                if (st.ttype == 91) {
                    unUsedText = unUsedText + "[";
                    ++numSquareBrackets;
                    continue;
                }
                if (st.ttype != 93) continue;
                unUsedText = unUsedText + "]";
                --numSquareBrackets;
            }
            if (st.ttype == 44 || st.ttype == 41 || st.ttype == 93) {
                st.pushBack();
            }
            return unUsedText;
        }
        int numOpenBrackets = 1;
        unUsedText = unUsedText + "(";
        while (numOpenBrackets != 0) {
            if (st.ttype == -1) {
                PsDebug.warning("')' missing.");
                return unUsedText;
            }
            if (st.nextToken() == -1) {
                PsDebug.warning("premature end of file.");
                return unUsedText;
            }
            if (st.ttype == 40) {
                ++numOpenBrackets;
                unUsedText = unUsedText + "(";
                continue;
            }
            if (st.ttype == 41) {
                --numOpenBrackets;
                unUsedText = unUsedText + ")";
                continue;
            }
            if (st.ttype == -3 || st.ttype == 39) {
                unUsedText = unUsedText + st.sval;
                continue;
            }
            if (st.ttype == -2) {
                st.pushBack();
                unUsedText = unUsedText + Double.toString(PgLoader.parseDouble(st));
                continue;
            }
            if (st.ttype == 91) {
                unUsedText = unUsedText + "[";
                unUsedText = unUsedText + "[";
                continue;
            }
            if (st.ttype == 93) {
                unUsedText = unUsedText + "]";
                unUsedText = unUsedText + "]";
                continue;
            }
            if (st.ttype == 44) {
                unUsedText = unUsedText + ",";
                unUsedText = unUsedText + ",";
                continue;
            }
            if (st.ttype == 42) {
                unUsedText = unUsedText + "*";
                unUsedText = unUsedText + "*";
                continue;
            }
            if (st.ttype != 94) continue;
            unUsedText = unUsedText + "^";
            unUsedText = unUsedText + "^";
        }
        return unUsedText;
    }
}

