/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgObjLoader
implements PgLoaderIf {
    protected int m_numVertices = 0;
    protected int m_numVertexNormals = 0;
    protected int m_numVertexTextures = 0;
    protected int m_numVertexVectors = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected int m_numMeshType = 0;
    protected Vector m_vVertex;
    protected Vector m_vVertexColor;
    protected PiVector m_vVertexColorInd;
    protected Vector m_vVertexNormal;
    protected Vector m_vVertexTexture;
    protected Vector m_vVertexVector;
    protected int[] m_meshType;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementColor;
    protected PiVector m_vElementColorInd;
    protected Vector m_vElementNormal;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    protected Vector m_vPolygonColor;
    protected PiVector m_vPolygonColorInd;
    private static final String StrNL = "\n";
    protected static boolean m_bVertexNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bElements = false;
    protected static boolean m_bPolygons = false;
    protected static boolean m_bPolygonColors = false;
    protected static boolean m_bPolygonNormals = false;

    protected static String writePolygons(int num, PiVector[] polygon) {
        if (num <= 0 || polygon == null || num > polygon.length) {
            return null;
        }
        StringBuffer tmp = new StringBuffer("# Polygon List\n");
        tmp.append("# Number of Polygons = " + num + StrNL);
        int i = 0;
        while (i < num) {
            tmp.append("l  ");
            if (polygon[i] == null) {
                return null;
            }
            int j = 0;
            while (j < polygon[i].m_data.length) {
                int vertexInd = polygon[i].m_data[j] + 1;
                tmp.append(vertexInd);
                if (m_bPolygonNormals) {
                    tmp.append("/" + vertexInd);
                }
                if (j < polygon[i].m_data.length - 1) {
                    tmp.append(" ");
                }
                ++j;
            }
            tmp.append(StrNL);
            ++i;
        }
        return tmp.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse(BufferedReader bufReader) throws IOException {
        block51: {
            maxColorSize = 3;
            maxFaceSize = 200;
            maxVertexSize = 4;
            maxMeshType = 5;
            color = new float[maxColorSize];
            coord = new double[maxVertexSize];
            normal = new double[maxVertexSize];
            texture = new double[maxVertexSize];
            data = new double[maxVertexSize];
            face = new int[maxFaceSize];
            normalInd = new int[maxFaceSize];
            textureInd = new int[maxFaceSize];
            polygon = new int[maxFaceSize];
            this.m_vVertex = new Vector<E>();
            this.m_vVertexColor = new Vector<E>();
            this.m_vVertexColorInd = new PiVector();
            this.m_vVertexNormal = new Vector<E>();
            this.m_vVertexTexture = new Vector<E>();
            this.m_vVertexVector = new Vector<E>();
            this.m_vElement = new Vector<E>();
            this.m_vElementColor = new Vector<E>();
            this.m_vElementColorInd = new PiVector();
            this.m_vElementNormal = new Vector<E>();
            this.m_vPolygon = new Vector<E>();
            this.m_vPolygonColor = new Vector<E>();
            this.m_vPolygonColorInd = new PiVector();
            st = new StreamTokenizer(bufReader);
            st.eolIsSignificant(true);
            st.ordinaryChars(47, 47);
            st.commentChar(35);
            st.commentChar(36);
            this.m_numVertices = 0;
            this.m_numVertexNormals = 0;
            this.m_numVertexTextures = 0;
            this.m_numElements = 0;
            try {
                block7: while (true) {
                    switch (st.nextToken()) {
                        default: {
                            PsDebug.warning("parsing broke abnormally in line=" + st.lineno() + " reading st.sval=" + st.sval + ", st.ttype=" + st.ttype);
                            return false;
                        }
                        case 10: {
                            break;
                        }
                        case -1: {
                            PsDebug.notify("eof token = " + st.sval);
                            break block51;
                        }
                        case -3: {
                            if (!"mt".equals(st.sval)) ** GOTO lbl56
                            this.m_numMeshType = 0;
                            this.m_meshType = new int[maxMeshType];
                            while (st.nextToken() == -2) {
                                this.m_meshType[this.m_numMeshType] = (int)st.nval;
                                ++this.m_numMeshType;
                            }
                            ** GOTO lbl238
lbl56:
                            // 1 sources

                            if (!"v".equals(st.sval)) ** GOTO lbl71
                            num = 0;
                            while (st.nextToken() == -2) {
                                st.pushBack();
                                coord[num] = PgLoader.parseDouble(st);
                                ++num;
                            }
                            if (num > 0) {
                                ++this.m_numVertices;
                                v = new PdVector(num);
                                v.copy(coord, num);
                                this.m_vVertex.addElement(v);
                            } else {
                                PsDebug.warning("vertex with no coords in line=" + st.lineno());
                            }
                            ** GOTO lbl238
lbl71:
                            // 1 sources

                            if (!"vc".equals(st.sval)) ** GOTO lbl88
                            num = 0;
                            while (st.nextToken() == -2) {
                                st.pushBack();
                                color[num] = (float)PgLoader.parseDouble(st);
                                ++num;
                            }
                            if (num == 3) {
                                vc = new Color(color[0], color[1], color[2]);
                                if (this.m_vVertexColorInd.getSize() <= this.m_vVertexColor.size() + 1) {
                                    this.m_vVertexColorInd.setSize(this.m_vVertexColor.size() + 1000);
                                }
                                this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
                                this.m_vVertexColor.addElement(vc);
                            } else {
                                PsDebug.warning("vertex color with wrong num coords in line=" + st.lineno());
                            }
                            ** GOTO lbl238
lbl88:
                            // 1 sources

                            if (!"vn".equals(st.sval)) ** GOTO lbl103
                            num = 0;
                            while (st.nextToken() == -2) {
                                st.pushBack();
                                normal[num] = PgLoader.parseDouble(st);
                                ++num;
                            }
                            if (num > 0) {
                                ++this.m_numVertexNormals;
                                vn = new PdVector(num);
                                vn.copy(normal, num);
                                this.m_vVertexNormal.addElement(vn);
                            } else {
                                PsDebug.warning("vertex normal with no coords in line=" + st.lineno());
                            }
                            ** GOTO lbl238
lbl103:
                            // 1 sources

                            if (!"vt".equals(st.sval)) ** GOTO lbl117
                            num = 0;
                            while (st.nextToken() == -2) {
                                st.pushBack();
                                texture[num++] = PgLoader.parseDouble(st);
                            }
                            if (num > 0) {
                                ++this.m_numVertexTextures;
                                vt = new PdVector(num);
                                vt.copy(texture, num);
                                this.m_vVertexTexture.addElement(vt);
                            } else {
                                PsDebug.warning("vertex texture with no coords in line=" + st.lineno());
                            }
                            ** GOTO lbl238
lbl117:
                            // 1 sources

                            if (!"vd".equals(st.sval)) ** GOTO lbl131
                            num = 0;
                            while (st.nextToken() == -2) {
                                st.pushBack();
                                data[num++] = PgLoader.parseDouble(st);
                            }
                            if (num > 0) {
                                ++this.m_numVertexVectors;
                                vd = new PdVector(num);
                                vd.copy(data, num);
                                this.m_vVertexVector.addElement(vd);
                            } else {
                                PsDebug.warning("vertex user data with no values in line=" + st.lineno());
                            }
                            ** GOTO lbl238
lbl131:
                            // 1 sources

                            if (!"f".equals(st.sval) && !"fo".equals(st.sval)) ** GOTO lbl178
                            if (st.nextToken() == 92) {
                                st.nextToken();
                            } else {
                                st.pushBack();
                            }
                            num = 0;
                            while (st.nextToken() == -2) {
                                face[num] = (int)st.nval - 1;
                                st.nextToken();
                                if (st.ttype != 47) ** GOTO lbl163
                                if (st.nextToken() != -2) ** GOTO lbl155
                                textureInd[num] = (int)st.nval - 1;
                                st.nextToken();
                                if (st.ttype != 47) ** GOTO lbl153
                                if (st.nextToken() == -2) {
                                    normalInd[num] = (int)st.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + st.lineno());
                                    break;
lbl153:
                                    // 1 sources

                                    st.pushBack();
                                }
                                ** GOTO lbl164
lbl155:
                                // 1 sources

                                if (st.ttype != 47) ** GOTO lbl161
                                if (st.nextToken() == -2) {
                                    normalInd[num] = (int)st.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + st.lineno());
                                    break;
lbl161:
                                    // 1 sources

                                    PsDebug.warning("parse error in face/ = " + this.m_numElements + "/" + num);
                                    break;
lbl163:
                                    // 1 sources

                                    st.pushBack();
                                }
lbl164:
                                // 4 sources

                                ++num;
                            }
                            if (num > 0) {
                                ++this.m_numElements;
                                f = new PiVector(num);
                                f.copy(face, num);
                                this.m_vElement.addElement(f);
                            } else {
                                PsDebug.warning("face with no vertex in line=" + st.lineno());
                            }
                            while (st.ttype != 10 && st.ttype != -1) {
                                st.nextToken();
                            }
                            ** GOTO lbl238
lbl178:
                            // 1 sources

                            if (!"l".equals(st.sval) && !"lo".equals(st.sval)) ** GOTO lbl220
                            num = 0;
                            while (st.nextToken() == -2) {
                                polygon[num] = (int)st.nval - 1;
                                st.nextToken();
                                if (st.ttype != 47) ** GOTO lbl205
                                if (st.nextToken() != -2) ** GOTO lbl197
                                textureInd[num] = (int)st.nval - 1;
                                st.nextToken();
                                if (st.ttype != 47) ** GOTO lbl195
                                if (st.nextToken() == -2) {
                                    normalInd[num] = (int)st.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + st.lineno());
                                    break;
lbl195:
                                    // 1 sources

                                    st.pushBack();
                                }
                                ** GOTO lbl206
lbl197:
                                // 1 sources

                                if (st.ttype != 47) ** GOTO lbl203
                                if (st.nextToken() == -2) {
                                    normalInd[num] = (int)st.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + st.lineno());
                                    break;
lbl203:
                                    // 1 sources

                                    PsDebug.warning("parse error in polygon/ = " + this.m_numPolygons + "/" + num);
                                    break;
lbl205:
                                    // 1 sources

                                    st.pushBack();
                                }
lbl206:
                                // 4 sources

                                ++num;
                            }
                            if (num > 0) {
                                ++this.m_numPolygons;
                                p = new PiVector(num);
                                p.copy(polygon, num);
                                this.m_vPolygon.addElement(p);
                            } else {
                                PsDebug.warning("polygon with no vertex in line=" + st.lineno());
                            }
                            while (st.ttype != 10 && st.ttype != -1) {
                                st.nextToken();
                            }
                            ** GOTO lbl238
lbl220:
                            // 1 sources

                            if (!"lc".equals(st.sval)) ** GOTO lbl237
                            num = 0;
                            while (st.nextToken() == -2) {
                                st.pushBack();
                                color[num] = (float)PgLoader.parseDouble(st);
                                ++num;
                            }
                            if (num == 3) {
                                lc = new Color(color[0], color[1], color[2]);
                                if (this.m_vPolygonColorInd.getSize() <= this.m_vPolygonColor.size() + 1) {
                                    this.m_vPolygonColorInd.setSize(this.m_vPolygonColor.size() + 1000);
                                }
                                this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                                this.m_vPolygonColor.addElement(lc);
                            } else {
                                PsDebug.warning("polygon color with wrong num coords in line=" + st.lineno());
                            }
                            ** GOTO lbl238
lbl237:
                            // 1 sources

                            if (!"g".equals(st.sval)) ** GOTO lbl238
lbl238:
                            // 16 sources

                            while (true) {
                                if (st.ttype == 10 || st.ttype == -1) continue block7;
                                st.nextToken();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                PsDebug.warning("Exception thrown in line=" + st.lineno() + ", Exception = " + e);
                return false;
            }
        }
        if (this.m_vVertexColorInd.getSize() > 0) {
            this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
        }
        if (this.m_vElementColorInd.getSize() > 0) {
            this.m_vElementColorInd.setEntry(this.m_vElementColor.size(), this.m_numElements);
        }
        if (this.m_vPolygonColorInd.getSize() > 0) {
            this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
        }
        PsDebug.notify("num of lines  = " + st.lineno());
        PsDebug.notify("m_numVertices = " + this.m_numVertices);
        PsDebug.notify("m_numVertexTextures = " + this.m_numVertexTextures);
        PsDebug.notify("m_numVertexNormals  = " + this.m_numVertexNormals);
        PsDebug.notify("m_numElements = " + this.m_numElements);
        PsDebug.notify("m_numPolygons = " + this.m_numPolygons);
        PsDebug.notify("... finished");
        return true;
    }

    protected static String writePdVectors(String type, String id, int num, PdVector[] vector) {
        if (num <= 0 || vector == null || num > vector.length) {
            return null;
        }
        StringBuffer tmp = new StringBuffer("# " + type + " List\n");
        tmp.append("# Number of " + type + "s = " + num + StrNL);
        int i = 0;
        while (i < num) {
            tmp.append(id + " ");
            if (vector[i] == null) {
                return null;
            }
            int j = 0;
            while (j < vector[i].m_data.length) {
                if (Math.abs(vector[i].m_data[j]) > 1.0E-10) {
                    tmp.append((float)vector[i].m_data[j]);
                } else {
                    tmp.append(0.0f);
                }
                if (j < vector[i].m_data.length - 1) {
                    tmp.append(" ");
                }
                ++j;
            }
            tmp.append(StrNL);
            ++i;
        }
        return tmp.toString();
    }

    public PgJvxSrc[] read(BufferedReader in) {
        int j;
        Enumeration elements;
        int i;
        if (in == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        try {
            boolean check = this.parse(in);
            if (!check) {
                PsDebug.warning("error during parsing of reader");
                return null;
            }
        }
        catch (IOException e) {
            PsDebug.warning("exception during parsing of reader");
            e.printStackTrace();
            return null;
        }
        PgJvxSrc geom = new PgJvxSrc();
        if (this.m_numMeshType > 0 && this.m_meshType[0] == 1) {
            switch (this.m_meshType[1]) {
                case 1: {
                    geom.setType(32);
                    break;
                }
                case 2: {
                    geom.setType(33);
                    break;
                }
                case 3: {
                    geom.setType(34);
                    break;
                }
                default: {
                    geom.setType(30);
                    break;
                }
            }
        } else if (this.m_numElements > 0) {
            geom.setType(33);
        } else if (this.m_numPolygons > 0) {
            geom.setType(32);
        } else {
            geom.setType(30);
        }
        if (this.m_numVertices > 0) {
            PdVector v = (PdVector)this.m_vVertex.elementAt(0);
            geom.setDimOfVertices(v.getSize());
            geom.setNumVertices(this.m_numVertices);
            PdVector[] vertex = geom.getVertices();
            i = 0;
            Enumeration elements2 = this.m_vVertex.elements();
            while (elements2.hasMoreElements()) {
                vertex[i++].copy((PdVector)elements2.nextElement());
            }
        }
        if (this.m_numVertexNormals > 0) {
            if (this.m_numVertexNormals == this.m_numVertices) {
                geom.assureVertexNormals();
                PdVector[] vertexNormal = geom.getVertexNormals();
                i = 0;
                elements = this.m_vVertexNormal.elements();
                while (elements.hasMoreElements()) {
                    vertexNormal[i++].copy((PdVector)elements.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexNormals=" + this.m_numVertexNormals + " != " + this.m_numVertices + "=numVertices");
            }
        }
        if (this.m_numVertexTextures > 0) {
            if (this.m_numVertexTextures == this.m_numVertices) {
                geom.assureVertexTextures();
                PdVector[] vertexTexture = geom.getVertexTextures();
                i = 0;
                elements = this.m_vVertexTexture.elements();
                while (elements.hasMoreElements()) {
                    vertexTexture[i++].copy((PdVector)elements.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexTextures != numVertices");
            }
        }
        if (this.m_numVertexVectors > 0) {
            if (this.m_numVertexVectors % this.m_numVertices == 0) {
                int numVectorFields = this.m_numVertexVectors / this.m_numVertices;
                geom.setNumVectorFields(numVectorFields);
                elements = this.m_vVertexVector.elements();
                int k = 0;
                while (k < numVectorFields) {
                    PdVector v = (PdVector)this.m_vVertexVector.elementAt(k * this.m_numVertices);
                    geom.setNumVectors(k, this.m_numVertices, v.getSize());
                    PdVector[] vector = geom.getVectors(k);
                    i = 0;
                    j = 0;
                    while (j < this.m_numVertices) {
                        vector[i++] = (PdVector)elements.nextElement();
                        ++j;
                    }
                    ++k;
                }
            } else {
                PsDebug.warning("numVertexVectors%numVertices!=0");
            }
        }
        if (this.m_numElements > 0) {
            geom.setDimOfElements(this.m_dimOfElements);
            geom.setNumElements(this.m_numElements);
            PiVector[] element = geom.getElements();
            i = 0;
            elements = this.m_vElement.elements();
            while (elements.hasMoreElements()) {
                element[i++].copy((PiVector)elements.nextElement());
            }
        }
        if (this.m_numPolygons > 0) {
            geom.setDimOfPolygons(this.m_dimOfPolygons);
            geom.setNumPolygons(this.m_numPolygons);
            PiVector[] polygon = geom.getPolygons();
            i = 0;
            Enumeration polygons = this.m_vPolygon.elements();
            while (polygons.hasMoreElements()) {
                polygon[i++].copy((PiVector)polygons.nextElement());
            }
        }
        if (this.m_vPolygonColor != null && this.m_vPolygonColor.size() > 0) {
            geom.assurePolygonColors();
            Color[] polygonColor = geom.getPolygonColors();
            i = 0;
            Color currColor = (Color)this.m_vPolygonColor.firstElement();
            j = 0;
            while (j < this.m_vPolygonColorInd.getEntry(0)) {
                polygonColor[j] = currColor;
                ++j;
            }
            Enumeration polygons = this.m_vPolygonColor.elements();
            while (polygons.hasMoreElements()) {
                currColor = (Color)polygons.nextElement();
                j = this.m_vPolygonColorInd.getEntry(i);
                while (j < this.m_vPolygonColorInd.getEntry(i + 1)) {
                    polygonColor[j] = currColor;
                    ++j;
                }
                ++i;
            }
        }
        PgObjLoader.geomInitType(geom);
        return new PgJvxSrc[]{geom};
    }

    public PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open = " + fileName);
            return null;
        }
        PgObjLoader loader = new PgObjLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        if (geomArr != null && geomArr.length > 0 && geomArr[0] != null) {
            geomArr[0].setName(PsUtil.getFileBaseName(fileName));
        }
        try {
            in.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption option) {
    }

    public void setAnimation(boolean flag) {
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        String tmp;
        int numOfPolygons;
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = Wavefront OBJ\n");
        writer.write("#     Geometry    = " + geom.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int numOfVertices = geom.getNumVertices();
        writer.write("#     Number of Vertices = " + numOfVertices + StrNL);
        int numOfElements = geom.getNumElements();
        if (numOfElements > 0) {
            writer.write("#     Number of Elements = " + numOfElements + StrNL);
        }
        if ((numOfPolygons = geom.getNumPolygons()) > 0) {
            writer.write("#     Number of Polygons = " + numOfPolygons + StrNL);
        }
        if (geom.getVertexNormals() != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (geom.getVertexTextures() != null) {
            writer.write("#     Additional: Vertex Texture Coordinates\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(PgObjLoader.writePdVectors("Vertex", "v", numOfVertices, geom.getVertices()));
        m_bVertexNormals = false;
        if (geom.getVertexNormals() != null && (tmp = PgObjLoader.writePdVectors("Vertex Normal", "vn", numOfVertices, geom.getVertexNormals())) != null) {
            writer.write(tmp);
            m_bVertexNormals = true;
        }
        m_bVertexTextures = false;
        if (geom.getVertexTextures() != null && (tmp = PgObjLoader.writePdVectors("Vertex Texture", "vt", numOfVertices, geom.getVertexTextures())) != null) {
            writer.write(tmp);
            m_bVertexTextures = true;
        }
        m_bElements = false;
        if (geom.getElements() != null && (tmp = PgObjLoader.writeElements(numOfElements, geom.getElements())) != null) {
            writer.write(tmp);
            m_bElements = true;
        }
        m_bPolygonNormals = false;
        if (geom.getPolygonNormals() != null && (tmp = PgObjLoader.writePdVectors("Polygon Normal", "ln", numOfPolygons, geom.getPolygonNormals())) != null) {
            writer.write(tmp);
            m_bPolygonNormals = true;
        }
        m_bPolygons = false;
        if (geom.getPolygons() != null && (tmp = PgObjLoader.writePolygons(numOfPolygons, geom.getPolygons())) != null) {
            writer.write(tmp);
            m_bPolygons = true;
        }
        return true;
    }

    public boolean isAnimation() {
        return false;
    }

    private static void geomInitType(PgJvxSrc geom) {
        switch (geom.getType()) {
            case 30: {
                geom.showVertices(true);
                break;
            }
            case 33: {
                geom.assureNeighbours();
                geom.showEdges(true);
                geom.showElements(true);
                break;
            }
            case 32: {
                geom.showVertices(true);
                geom.showPolygons(true);
                geom.showEdges(true);
                break;
            }
        }
    }

    protected static String writeElements(int num, PiVector[] element) {
        if (num <= 0 || element == null || num > element.length) {
            return null;
        }
        StringBuffer tmp = new StringBuffer("# Face List\n");
        tmp.append("# Number of Faces = " + num + StrNL);
        int i = 0;
        while (i < num) {
            tmp.append("f  ");
            if (element[i] == null) {
                return null;
            }
            int j = 0;
            while (j < element[i].m_data.length) {
                int vertexInd = element[i].m_data[j] + 1;
                tmp.append(vertexInd);
                if (m_bVertexNormals) {
                    tmp.append("/" + vertexInd);
                    if (m_bVertexTextures) {
                        tmp.append("/" + vertexInd);
                    }
                } else if (!m_bVertexNormals && m_bVertexTextures) {
                    tmp.append("//" + vertexInd);
                }
                if (j < element[i].m_data.length - 1) {
                    tmp.append(" ");
                }
                ++j;
            }
            tmp.append(StrNL);
            ++i;
        }
        return tmp.toString();
    }
}

