/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;

public abstract class PsObject
implements PsUpdateIf,
Cloneable,
Serializable {
    private static int m_numObjects = 0;
    protected String m_name;
    protected transient PsUpdateIf m_parent;
    protected transient Vector m_updateList;
    protected transient Hashtable m_panelList;
    protected transient PsPanel m_infoPanel;
    protected BitSet m_tag;
    public static final int NUM_TAGS = 32;
    public static final int IS_USED = 0;
    public static final int IS_SELECTED = 1;
    public static final int IS_DELETED = 2;
    public static final int IS_FIXED = 3;
    public static final int HAS_INFO_PANEL = 4;
    public static final int HAS_MATERIAL_PANEL = 5;
    public static final int HAS_TEXTURE_PANEL = 6;
    public static final int HAS_CONFIG_PANEL = 7;
    public static final String INSPECTOR_INFO_EXT = "_IP";
    public static final String INSPECTOR_INFO = "Info";

    public boolean hasUpdateListener(PsUpdateIf listener) {
        if (this.m_updateList == null) {
            return false;
        }
        return this.m_updateList.contains(listener);
    }

    public boolean removeUpdateListener(PsUpdateIf listener) {
        if (this.m_updateList == null) {
            return false;
        }
        return this.m_updateList.removeElement(listener);
    }

    public PsPanel getInfoPanel() {
        return this.assureInspector(INSPECTOR_INFO, INSPECTOR_INFO_EXT);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append("PsObject.toString(): " + super.toString() + "\n");
        strBuf.append("\t ******* jv.object.PsObject *************\n");
        strBuf.append("\t Name = " + this.m_name + "  Version = " + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + "\n");
        strBuf.append("\t m_tag = " + this.m_tag + "\n");
        return strBuf.toString();
    }

    public void setParent(PsUpdateIf aParent) {
        this.m_parent = aParent;
    }

    public PsObject() {
        ++m_numObjects;
        this.m_tag = null;
        this.m_parent = null;
        this.m_updateList = null;
        this.m_panelList = null;
        this.m_infoPanel = null;
    }

    public void clearTag(int aBit) {
        if (this.m_tag == null) {
            return;
        }
        this.m_tag.clear(aBit);
    }

    public void setTag(int aBit) {
        if (this.m_tag == null) {
            this.m_tag = new BitSet(32);
        }
        this.m_tag.set(aBit);
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public boolean addUpdateListener(PsUpdateIf listener) {
        if (this.m_updateList == null) {
            this.m_updateList = new Vector();
        } else if (this.hasUpdateListener(listener)) {
            PsDebug.warning("name = " + listener.getName() + " of listener already used.");
            return false;
        }
        this.m_updateList.addElement(listener);
        return true;
    }

    public boolean update(Object event) {
        if (event == this || event != null && this.m_panelList != null && this.m_panelList.contains(event)) {
            this.updatePanels(event);
        } else if (event != null) {
            String msg = "could not handle event:\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = " + event.getClass().getName();
            if (event instanceof PsUpdateIf) {
                msg = msg + ", name=" + ((PsUpdateIf)event).getName();
            }
            msg = msg + "\n\tmissing implementation of update(Object)";
            PsDebug.warning(msg);
            return false;
        }
        if (this.m_updateList != null) {
            Enumeration e = this.m_updateList.elements();
            while (e.hasMoreElements()) {
                PsUpdateIf listener = (PsUpdateIf)e.nextElement();
                PsDebug.notify("updating listener = " + listener.getName());
                listener.update(this);
            }
        }
        if (this.m_parent != null) {
            PsDebug.notify("update parent");
            return this.m_parent.update(this);
        }
        return true;
    }

    public PsPanel getInspector(String name) {
        if (this.m_panelList == null) {
            return null;
        }
        return (PsPanel)this.m_panelList.get(name);
    }

    public PsPanel assureInspector(String type, String ext) {
        PsPanel panel;
        if (this.hasInspector(type)) {
            panel = this.getInspector(type);
            if (panel.getLanguage().equals(PsConfig.getLanguage())) {
                return panel;
            }
            this.removeInspector(type);
        }
        if ((panel = (PsPanel)PsUtil.newInstance(this.getClass(), ext)) == null) {
            return null;
        }
        this.addInspector(type, panel);
        return panel;
    }

    public boolean updatePanels(Object event) {
        if (this.m_panelList == null) {
            return true;
        }
        if (event == null) {
            PsDebug.warning("unknown event==null");
            event = this;
        }
        if (event == this || this.m_panelList.contains(event)) {
            PsDebug.notify("updating panels");
            Enumeration e = this.m_panelList.elements();
            while (e.hasMoreElements()) {
                PsPanel panel = (PsPanel)e.nextElement();
                if (panel == event) continue;
                if (panel.isShowing()) {
                    PsDebug.notify("updating panel = " + panel.getName());
                    panel.update(this);
                    continue;
                }
                panel.setOutOfDate(true);
            }
        } else {
            String msg = "could not handle event:\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = " + event.getClass().getName();
            if (event instanceof PsUpdateIf) {
                msg = msg + ", name=" + ((PsUpdateIf)event).getName();
            }
            msg = msg + "\n\tmissing implementation of updatePanel(Object)";
            PsDebug.warning(msg);
            return false;
        }
        return true;
    }

    public boolean hasTag(int aBit) {
        if (this.m_tag == null) {
            return false;
        }
        return this.m_tag.get(aBit);
    }

    public void copy(PsObject object) {
        if (this.m_name == null || this.m_name.equals(object.getName())) {
            String name;
            this.m_name = name = object.getName();
        }
        if (object.m_tag != null) {
            this.m_tag = (BitSet)object.m_tag.clone();
        }
    }

    public boolean hasInspector(String name) {
        if (this.m_panelList == null) {
            return false;
        }
        return this.m_panelList.containsKey(name);
    }

    public boolean removeInspector(String name) {
        if (!this.hasInspector(name)) {
            return false;
        }
        this.m_panelList.remove(name);
        if (INSPECTOR_INFO.equals(name)) {
            this.m_infoPanel = null;
        }
        return true;
    }

    public static int getNumObjects() {
        return m_numObjects;
    }

    public String getName() {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public void setName(String aName) {
        if (aName == null) {
            PsDebug.warning("missing name");
            return;
        }
        this.m_name = aName;
    }

    public final boolean instanceOf(String className) {
        String fullClassName = this.getClass().getName();
        return fullClassName.endsWith(className);
    }

    public static boolean instanceOf(Object obj, Class cl) {
        Class scl;
        if (obj == null || cl == null) {
            return false;
        }
        Class<?> ocl = obj.getClass();
        if (ocl.equals(cl)) {
            return true;
        }
        if (!cl.isInterface()) {
            Class<?>[] ifs = cl.getInterfaces();
            int i = 0;
            while (i < ifs.length) {
                if (PsObject.instanceOf(obj, ifs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return (scl = cl.getSuperclass()) != null && PsObject.instanceOf(obj, scl);
    }

    public void init() {
        if (this.m_name == null) {
            this.m_name = "object_" + m_numObjects;
        }
    }

    public static PsObject[][] clone(PsObject[][] src) {
        PsObject[][] clone = (PsObject[][])src.clone();
        if (clone == null) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            clone[i] = PsObject.clone(src[i]);
            ++i;
        }
        return clone;
    }

    public static PsObject[] clone(PsObject[] src) {
        PsObject[] clone = (PsObject[])src.clone();
        if (clone == null) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            clone[i] = (PsObject)src[i].clone();
            ++i;
        }
        return clone;
    }

    public Object clone() {
        String name;
        PsObject clone = null;
        try {
            clone = (PsObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (this.m_tag != null) {
            clone.m_tag = (BitSet)this.m_tag.clone();
        }
        clone.m_parent = null;
        clone.m_updateList = null;
        clone.m_panelList = null;
        clone.m_infoPanel = null;
        clone.m_name = name = this.getName();
        return clone;
    }

    public boolean addInspector(String name, PsPanel panel) {
        if (this.m_panelList == null) {
            this.m_panelList = new Hashtable();
        } else if (this.hasInspector(name)) {
            PsDebug.warning("name = " + name + " of panel already used.");
            return false;
        }
        panel.setParent(this);
        panel.update(this);
        this.m_panelList.put(name, panel);
        if (INSPECTOR_INFO.equals(name)) {
            this.m_infoPanel = panel;
        }
        return true;
    }
}

