/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PsUtil {
    private static /* synthetic */ Class class$java$lang$Object;

    public static String getFileBaseName(String fullFileName) {
        if (fullFileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String baseFileName = PsUtil.getFileName(fullFileName);
        if (baseFileName == null) {
            return null;
        }
        if (baseFileName.endsWith("zip") || baseFileName.endsWith("gz")) {
            baseFileName = baseFileName.substring(0, baseFileName.lastIndexOf(46));
        }
        return baseFileName.substring(0, baseFileName.lastIndexOf(46));
    }

    public static String getFileExtension(String fullFileName) {
        if (fullFileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String fileName = PsUtil.getFileName(fullFileName);
        String comp = "";
        if (fileName.endsWith("zip")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            comp = ".zip";
        } else if (fileName.endsWith("gz")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            comp = ".gz";
        }
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        return ext + comp;
    }

    public static BufferedReader open(String fileName) {
        BufferedReader bufReader;
        if (fileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        PsDebug.notify("file " + fileName);
        if (PsConfig.isApplication()) {
            PsDebug.notify("as application");
            bufReader = fileName.startsWith("http:") || fileName.startsWith("ftp:") || fileName.startsWith("file:") ? PsUtil.openURL(fileName) : PsUtil.openFile(fileName);
        } else {
            PsDebug.notify("as applet");
            if (fileName.startsWith("http:") || fileName.startsWith("ftp:") || fileName.startsWith("file:")) {
                bufReader = PsUtil.openURL(fileName);
            } else {
                bufReader = PsUtil.openFile(fileName);
                if (bufReader == null) {
                    PsDebug.warning("relative url encountered, try with codebase.");
                    bufReader = PsUtil.openURL(PsConfig.getCodeBase() + fileName);
                }
            }
        }
        return bufReader;
    }

    public static PrintWriter writeFile(String aFileName) {
        if (aFileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        FileWriter file = null;
        PsDebug.notify("opening file = " + aFileName + " .......");
        try {
            file = new FileWriter(aFileName);
            BufferedWriter d = new BufferedWriter(file);
            PrintWriter p = new PrintWriter(d);
            PsDebug.notify("... succeeded");
            return p;
        }
        catch (IOException e1) {
            PsDebug.warning("file " + file + " not found, IOException" + "\n\texception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, file = ", aFileName);
            return null;
        }
        catch (SecurityException e1) {
            PsDebug.warning("exception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, file = ", aFileName);
            return null;
        }
    }

    public static boolean hasSomeBits(int flag, int bit) {
        return (flag & bit) > 0;
    }

    public static Object newInstance(Class baseClass, String nameSuffix) {
        if (baseClass == null || nameSuffix == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Class currentClass = baseClass;
        String className = null;
        Object instance = null;
        try {
            do {
                if ((instance = PsUtil.newInstance(className = currentClass.getName() + nameSuffix)) == null) continue;
                return instance;
            } while ((currentClass = currentClass.getSuperclass()) != null && currentClass != (class$java$lang$Object != null ? class$java$lang$Object : PsUtil.class$("java.lang.Object")));
            return null;
        }
        catch (SecurityException e) {
            PsDebug.warning("failed with security exception, className = " + className + "\n\t SecurityExceptionEx = " + e.toString() + ", Message = " + e.getMessage());
            return null;
        }
    }

    public static Object newInstance(String className) {
        if (className == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Class<?> findClass = null;
        try {
            findClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            PsDebug.notify("Class not found: " + className + "\n\tException = " + e.toString() + ", Message = " + e.getMessage());
            return null;
        }
        try {
            Object instance = findClass.newInstance();
            return instance;
        }
        catch (NoSuchMethodError e) {
            PsDebug.error("failed to create instance, className = " + className + "\n\tNoSuchMethodError = " + e.toString() + ", Message = " + e.getMessage());
            return null;
        }
        catch (InstantiationException e) {
            PsDebug.warning("failed to create instance, className = " + className + "\n\tInstantiationException = " + e.toString() + ", Message = " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            PsDebug.warning("failed with access exception, className = " + className + "\n\tIllegalAccessException = " + e.toString() + ", Message = " + e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            PsDebug.warning("failed with security exception, className = " + className + "\n\tSecurityExceptionEx = " + e.toString() + ", Message = " + e.getMessage());
            return null;
        }
    }

    public static int clearBits(int flag, int bit) {
        return flag &= ~bit;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public static BufferedReader openURL(String aURL) {
        if (aURL == null) {
            PsDebug.warning("missing url");
            return null;
        }
        PsDebug.notify("opening file = " + aURL + " .......");
        try {
            URL url = new URL(aURL);
            InputStream is = url.openStream();
            if (aURL.endsWith("gz")) {
                is = new GZIPInputStream(is);
            } else if (aURL.endsWith("zip")) {
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                is = zis;
            }
            BufferedReader d = new BufferedReader(new InputStreamReader(is));
            return d;
        }
        catch (MalformedURLException e1) {
            PsDebug.warning("file " + aURL + " not found, MalformedURLFoundException" + "\n\texception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, URL = ", aURL);
            return null;
        }
        catch (IOException e1) {
            PsDebug.warning("file " + aURL + " not found, IOException" + "\n\texception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, URL = ", aURL);
            return null;
        }
        catch (SecurityException e1) {
            PsDebug.warning("file " + aURL + " not found, SecurityException" + "\n\texception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, URL = ", aURL);
            return null;
        }
    }

    public static boolean hasAllBits(int flag, int bit) {
        return (flag & bit) == bit;
    }

    public static int setBits(int flag, int bit) {
        return flag |= bit;
    }

    public static boolean hasBits(int flag, int bit) {
        return (flag & bit) == bit;
    }

    public static String getFilePath(String fullFileName) {
        if (fullFileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        if (fullFileName.indexOf(92) > -1) {
            return fullFileName.substring(0, fullFileName.lastIndexOf(92) + 1);
        }
        return fullFileName.substring(0, fullFileName.lastIndexOf(47) + 1);
    }

    public static BufferedReader openFile(String aFileName) {
        if (aFileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        File file = null;
        PsDebug.notify("opening file = " + aFileName + " .......");
        try {
            file = new File(aFileName);
            InputStream is = new FileInputStream(file);
            if (aFileName.endsWith("gz")) {
                is = new GZIPInputStream(is);
            } else if (aFileName.endsWith("zip")) {
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                is = zis;
            }
            BufferedReader d = new BufferedReader(new InputStreamReader(is));
            PsDebug.notify("... succeeded");
            return d;
        }
        catch (FileNotFoundException e1) {
            PsDebug.warning("file " + file + " not found, FileNotFoundException" + "\n\texception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, file = ", aFileName);
            return null;
        }
        catch (IOException e1) {
            PsDebug.warning("file " + file + " not found, FileNotFoundException" + "\n\texception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, file = ", aFileName);
            return null;
        }
        catch (SecurityException e1) {
            PsDebug.warning("exception.getMessage() = " + e1.getMessage() + "\n\texception.toString()   = " + e1.toString());
            PsDebug.error("... failed, file = ", aFileName);
            return null;
        }
    }

    public static String getFileName(String fullFileName) {
        if (fullFileName == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        if (fullFileName.indexOf(92) > -1) {
            return fullFileName.substring(fullFileName.lastIndexOf(92) + 1, fullFileName.length());
        }
        return fullFileName.substring(fullFileName.lastIndexOf(47) + 1, fullFileName.length());
    }
}

