/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgGeometry
extends PsObject
implements PgGeometryIf,
Cloneable {
    protected String m_version = "0.10";
    protected String m_versionType = "dump";
    protected String m_title;
    protected PsAuthorInfo m_authorInfo;
    protected PsGeometryInfo m_geometryInfo;
    protected int m_dim;
    protected int m_dimOfSimplex = 0;
    protected boolean m_bShowing = true;
    protected boolean m_bShowTitle;
    protected boolean m_bShowBndBox;
    protected boolean m_bShowCenter;
    protected PdVector m_center = null;
    protected int m_ambientSpace = 3;
    protected int m_ambientProj = 0;
    protected PdMatrix m_modelMatrix = null;
    protected PdMatrix m_ambientMatrix;
    protected PdMatrix m_ambientInvMatrix;
    protected transient PsMethodMenu m_methodMenu = null;
    protected Vector m_displayList = null;
    protected PiVector[] m_labelAttribute = PiVector.realloc(null, 6, 4);

    public int addPolygon(PiVector aPolygon) {
        return -1;
    }

    public boolean hasTagPolygon(int index, int aTag) {
        return false;
    }

    public Image getTextureImage() {
        return null;
    }

    public void setTextureImage(Image img) {
        PsDebug.warning("missing implementation of method in subclass.");
    }

    public void setState(int aKey, boolean aState) {
        PsDebug.warning("invalid key = " + aKey);
    }

    public PvPickEvent intersectionWithLine(PdVector base, PdVector dir) {
        return null;
    }

    public boolean isShowingBndBox() {
        return this.m_bShowBndBox;
    }

    public PsPanel getMaterialPanel() {
        return this.assureInspector("Material", "_MP");
    }

    public void showBndBox(boolean flag) {
        this.m_bShowBndBox = flag;
    }

    public int getAmbientProjection() {
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int mode) {
        this.m_ambientProj = mode;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public int addElement(PiVector anElement) {
        return -1;
    }

    public boolean hasTagElement(int index, int aTag) {
        return false;
    }

    public boolean isVisible() {
        return this.m_bShowing;
    }

    public int addVertex(PdVector aVertex) {
        return -1;
    }

    public boolean hasTagVertex(int index, int aTag) {
        return false;
    }

    public Object clone() {
        PgGeometry clone = (PgGeometry)super.clone();
        if (clone == null) {
            return null;
        }
        if (this.m_authorInfo != null) {
            clone.m_authorInfo = (PsAuthorInfo)this.m_authorInfo.clone();
        }
        if (this.m_geometryInfo != null) {
            clone.m_geometryInfo = (PsGeometryInfo)this.m_geometryInfo.clone();
        }
        if (this.m_center != null) {
            clone.m_center = (PdVector)this.m_center.clone();
        }
        if (this.m_modelMatrix != null) {
            clone.m_modelMatrix = (PdMatrix)this.m_modelMatrix.clone();
        }
        if (this.m_ambientMatrix != null) {
            clone.m_ambientMatrix = (PdMatrix)this.m_ambientMatrix.clone();
            clone.m_ambientInvMatrix = (PdMatrix)this.m_ambientInvMatrix.clone();
        }
        clone.m_methodMenu = null;
        clone.m_displayList = null;
        clone.m_labelAttribute = (PiVector[])P_Vector.clone(this.m_labelAttribute);
        return clone;
    }

    public int getAmbientSpace() {
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int mode) {
        this.m_ambientSpace = mode;
    }

    public Enumeration getDisplays() {
        if (this.m_displayList == null) {
            return null;
        }
        return this.m_displayList.elements();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgGeometry ***********\n");
        strBuf.append("\t Title = " + this.getTitle());
        strBuf.append("\t Registered Displays:\n");
        if (this.m_displayList != null) {
            Enumeration e = this.m_displayList.elements();
            while (e.hasMoreElements()) {
                PvDisplayIf display = (PvDisplayIf)e.nextElement();
                strBuf.append("\t\t display = " + display.getName() + "\n");
            }
        } else {
            strBuf.append("\t\t no displays\n");
        }
        strBuf.append("\t Dimension of vertices: m_dim = " + this.m_dim + "\n");
        return strBuf.toString();
    }

    public PdMatrix getAmbientInvMatrix() {
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientInvMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientMatrix.setIdentity();
            this.m_ambientInvMatrix.setIdentity();
        }
        return this.m_ambientInvMatrix;
    }

    public PdVector getCenter() {
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        return this.m_center;
    }

    public void setCenter(PdVector aCenter) {
        if (aCenter == null) {
            PsDebug.warning("missing argument.");
            return;
        }
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        this.m_center.copy(aCenter);
    }

    public boolean isShowingCenter() {
        return this.m_bShowCenter;
    }

    public String getTextureImageName() {
        return null;
    }

    public void setTextureImageName(String name) {
        PsDebug.warning("missing implementation of method in subclass.");
    }

    public void showCenter(boolean flag) {
        this.m_bShowCenter = flag;
    }

    public PdVector[] getAmbientBounds() {
        PdVector[] bndBox = new PdVector[]{new PdVector(this.m_dim), new PdVector(this.m_dim)};
        return bndBox;
    }

    public void copy(PgGeometry geom) {
        super.copy(geom);
        if (geom.getTitle() != null) {
            this.setTitle(geom.getTitle());
        }
        this.setCenter(geom.getCenter());
        PiVector.copy(this.m_labelAttribute, 0, geom.m_labelAttribute, 0, geom.m_labelAttribute.length);
    }

    public double getDiameter() {
        PdVector[] bndBox = this.getBounds();
        if (bndBox == null) {
            return 0.0;
        }
        return PdVector.dist(bndBox[0], bndBox[1]);
    }

    public PgGeometry reflect(PdMatrix mat, boolean bOrient, boolean bVector) {
        if (mat == null || mat.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + mat);
            return null;
        }
        PgGeometry reflGeom = (PgGeometry)this.clone();
        String name = this.getName();
        if (name == null || !name.startsWith("Reflect")) {
            name = "Reflect(0) of " + name;
        } else {
            int b0 = name.indexOf("(");
            if (b0 != -1) {
                int b1 = name.indexOf(")");
                String number = name.substring(b0 + 1, b1);
                b0 = Integer.parseInt(number) + 1;
            }
            int pos = name.indexOf(" of ");
            String baseName = name.substring(pos + 4, name.length());
            name = "Reflect(" + b0 + ") of " + baseName;
        }
        reflGeom.setName(name);
        return reflGeom;
    }

    public void init() {
        super.init();
        this.m_bShowing = true;
        this.m_bShowBndBox = false;
        this.m_bShowCenter = false;
        this.m_bShowTitle = false;
    }

    public Menu fillMethodMenu(Menu aMenu) {
        if (this.m_methodMenu == null || !this.m_methodMenu.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_methodMenu = (PsMethodMenu)PsUtil.newInstance(this.getClass(), "_Menu");
            if (this.m_methodMenu == null) {
                PsDebug.warning("could not create menu");
                return null;
            }
            this.m_methodMenu.init(this);
            Class<?> currentClass = this.getClass();
            try {
                do {
                    String className = currentClass.getName();
                    String baseClass = className.substring(className.lastIndexOf(46) + 1, className.length());
                    PsMethodMenu extMenu = (PsMethodMenu)PsUtil.newInstance("jvx.geom." + baseClass + "_Menu");
                    if (extMenu == null) continue;
                    Enumeration e = this.m_methodMenu.elements();
                    while (e.hasMoreElements()) {
                        extMenu.addElement((MenuItem)e.nextElement());
                    }
                    extMenu.init(this);
                    this.m_methodMenu.removeAllElements();
                    e = extMenu.elements();
                    while (e.hasMoreElements()) {
                        this.m_methodMenu.addElement((MenuItem)e.nextElement());
                    }
                    break;
                } while ((currentClass = currentClass.getSuperclass()) != null);
            }
            catch (SecurityException e) {
                PsDebug.warning("failed with security exception,\n\t SecurityExceptionEx = " + e.toString() + ", Message = " + e.getMessage());
            }
        }
        aMenu.removeAll();
        Enumeration e = this.m_methodMenu.elements();
        while (e.hasMoreElements()) {
            aMenu.add((MenuItem)e.nextElement());
        }
        return aMenu;
    }

    public boolean merge(PgGeometryIf geom) {
        if (geom == null) {
            PsDebug.warning("missing argument.", this);
            return false;
        }
        if (this.getDimOfVertices() != geom.getDimOfVertices()) {
            PsDebug.warning("different dimension of vertices.", this);
            return false;
        }
        return true;
    }

    public PiVector getElement(int anIndex) {
        return null;
    }

    public boolean setElement(int anIndex, PiVector aElement) {
        return false;
    }

    public void clearTagElement(int index, int aTag) {
    }

    public static PdVector getCenterOfElement(PdVector center, PdVector[] vertex, int[] vertInd) {
        if (vertInd == null || vertInd.length == 0) {
            PsDebug.warning("missing index array");
            return center;
        }
        center.copyArray(vertex[vertInd[0]]);
        int i = 1;
        while (i < vertInd.length) {
            center.add(vertex[vertInd[i]]);
            ++i;
        }
        center.multScalar(1.0 / (double)vertInd.length);
        return center;
    }

    public int getDimOfVertices() {
        return this.m_dim;
    }

    protected void setDimOfVertices(int dim) {
        if (this.m_dim == dim) {
            return;
        }
        this.m_dim = dim;
        switch (this.m_dim) {
            default: {
                this.setAmbientSpace(3);
                break;
            }
            case 5: {
                this.setAmbientSpace(9);
                break;
            }
            case 4: {
                this.setAmbientSpace(6);
                break;
            }
            case 2: {
                this.setAmbientSpace(1);
                break;
            }
            case 1: {
                this.setAmbientSpace(0);
                break;
            }
        }
        this.setAmbientProjection(0);
    }

    public boolean hasDisplay(PvDisplayIf display) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.contains(display);
    }

    public boolean removeDisplay(PvDisplayIf display) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.removeElement(display);
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (!super.update(event)) {
            String msg = "super has returned 'false'\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = ";
            msg = event == null ? msg + "null" : (event instanceof PsObject ? msg + event.getClass().getName() + ", name=" + ((PsObject)event).getName() : (event instanceof PsPanel ? msg + event.getClass().getName() + ", name=" + ((PsPanel)event).getName() : msg + event.getClass().getName()));
            PsDebug.warning(msg);
        }
        if (this.m_displayList != null) {
            Enumeration e = this.m_displayList.elements();
            while (e.hasMoreElements()) {
                PvDisplayIf display = (PvDisplayIf)e.nextElement();
                PsDebug.notify("updating display = " + display.getName());
                display.update(this);
            }
        }
        if (this.m_methodMenu != null) {
            this.m_methodMenu.update(this);
        }
        return true;
    }

    public PiVector getLabelAttribute(int type) {
        if (type < 0 || this.m_labelAttribute.length <= type) {
            PsDebug.warning("type out of bounds, type = " + type);
            return null;
        }
        return this.m_labelAttribute[type];
    }

    public boolean setLabelAttribute(int type, int xOffset, int yOffset, int horAdjust, int verAdjust, int font) {
        if (type < 0 || this.m_labelAttribute.length <= type) {
            PsDebug.warning("type=" + type + " out of bounds.");
            return false;
        }
        this.m_labelAttribute[type].setEntry(0, xOffset);
        this.m_labelAttribute[type].setEntry(1, yOffset);
        this.m_labelAttribute[type].setEntry(2, horAdjust);
        this.m_labelAttribute[type].setEntry(3, verAdjust);
        this.m_labelAttribute[type].setEntry(4, font);
        return true;
    }

    public boolean setLabelAttribute(int type, PiVector labelAtt) {
        if (labelAtt == null || labelAtt.getSize() < 5) {
            PsDebug.warning("missing attribute parameter.");
            return false;
        }
        int[] att = labelAtt.getEntries();
        this.setLabelAttribute(type, att[0], att[1], att[2], att[3], att[4]);
        return true;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public int getDimOfSimplex() {
        return this.m_dimOfSimplex;
    }

    public void setDimOfSimplex(int dim) {
        this.m_dimOfSimplex = dim;
    }

    public boolean isShowingTitle() {
        return this.m_bShowTitle;
    }

    public PiVector getPolygon(int anIndex) {
        return null;
    }

    public boolean setPolygon(int anIndex, PiVector aPolygon) {
        return false;
    }

    public void clearTagPolygon(int index, int aTag) {
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String versionType) {
        this.m_versionType = versionType;
    }

    public PdVector[] getBounds() {
        PdVector[] bndBox = new PdVector[]{new PdVector(3), new PdVector(3)};
        return bndBox;
    }

    public void showTitle(boolean flag) {
        this.m_bShowTitle = flag;
    }

    public PsAuthorInfo getAuthors() {
        return this.m_authorInfo;
    }

    public void setAuthors(PsAuthorInfo author) {
        this.m_authorInfo = author;
    }

    public PsPanel getControlPanel() {
        return this.assureInspector("Control", "_CP");
    }

    public boolean isConfigurable(int panel) {
        return this.hasTag(panel);
    }

    public int[] removePolygon(int anIndex) {
        return null;
    }

    public void setTagPolygon(int index, int aTag) {
    }

    public void paint(PvGeometryIf dc) {
        dc.setVisible(this.isVisible());
        dc.setState(69, this.m_bShowBndBox);
        dc.setState(70, this.m_bShowCenter);
        dc.setState(86, this.m_bShowTitle);
        dc.setLabelAttributes(this.m_labelAttribute);
        dc.setAmbientSpace(this.getAmbientSpace());
        dc.setAmbientProjection(this.getAmbientProjection());
        if (this.hasModelMatrix()) {
            dc.setModelMatrix(this.getModelMatrix());
        }
        if (this.hasAmbientMatrix()) {
            dc.setAmbientMatrix(this.getAmbientMatrix(), this.getAmbientInvMatrix());
        }
    }

    public boolean blend(double s, PgGeometry a, double t, PgGeometry b) {
        if (a == null && b == null) {
            PsDebug.warning("missing arguments");
            return false;
        }
        if (a == null) {
            this.copy(b);
            return true;
        }
        if (b == null) {
            this.copy(a);
            return true;
        }
        this.m_dim = a.getDimOfVertices();
        return true;
    }

    public int[] removeElement(int anIndex) {
        return null;
    }

    public PdVector getVertex(int anIndex) {
        return null;
    }

    public boolean setVertex(int anIndex, PdVector aVertex) {
        return false;
    }

    public void clearTagVertex(int index, int aTag) {
    }

    public void setVisible(boolean flag) {
        this.m_bShowing = flag;
    }

    public void setTagElement(int index, int aTag) {
    }

    public PgGeometry() {
        this.setLabelAttribute(0, 0, 0, 0, 0, 1);
        this.setLabelAttribute(1, 4, 4, 0, 0, 1);
        this.setLabelAttribute(2, -10, 10, 0, 0, 1);
        this.setLabelAttribute(3, -3, 5, 0, 0, 1);
        this.setLabelAttribute(4, -3, 5, 0, 0, 1);
        this.setLabelAttribute(5, 4, 4, 0, 0, 3);
    }

    public PgGeometry(int aDim) {
        this();
        this.setDimOfVertices(aDim);
    }

    public PsGeometryInfo getGeometryInfo() {
        return this.m_geometryInfo;
    }

    public void setGeometryInfo(PsGeometryInfo geometryInfo) {
        this.m_geometryInfo = geometryInfo;
    }

    public int[] removeVertex(int anIndex) {
        return null;
    }

    public void setTagVertex(int index, int aTag) {
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setAuthorInfo(PsAuthorInfo authorInfo) {
        this.m_authorInfo = authorInfo;
    }

    public PdMatrix getModelMatrix() {
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
            this.m_modelMatrix.setIdentity();
        }
        return PdMatrix.copyNew(this.m_modelMatrix);
    }

    public void setModelMatrix(PdMatrix modelMat) {
        if (modelMat == null) {
            this.m_modelMatrix = null;
            return;
        }
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
        }
        this.m_modelMatrix.copy(modelMat);
    }

    public PdMatrix getAmbientMatrix() {
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientInvMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientMatrix.setIdentity();
            this.m_ambientInvMatrix.setIdentity();
        }
        return this.m_ambientMatrix;
    }

    public void setAmbientMatrix(PdMatrix ambientMat, PdMatrix ambientInvMat) {
        if (ambientMat == null) {
            this.m_ambientMatrix = null;
            this.m_ambientInvMatrix = null;
            return;
        }
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = (PdMatrix)ambientMat.clone();
            this.m_ambientInvMatrix = (PdMatrix)ambientInvMat.clone();
        }
        this.m_ambientMatrix.copy(ambientMat);
        this.m_ambientInvMatrix.copy(ambientInvMat);
    }

    public boolean addDisplay(PvDisplayIf display) {
        if (this.m_displayList == null) {
            this.m_displayList = new Vector();
        } else if (this.hasDisplay(display)) {
            PsDebug.warning("display = " + display.getName() + " of display already used.");
            return false;
        }
        this.m_displayList.addElement(display);
        return true;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc jvx = new PgJvxSrc();
        jvx.setName(this.getName());
        jvx.setVersion(this.getVersion());
        jvx.setVersionType(this.getVersionType());
        jvx.setTitle(this.getTitle());
        jvx.setAuthorInfo(this.getAuthorInfo());
        jvx.setGeometryInfo(this.getGeometryInfo());
        jvx.setDimOfVertices(this.getDimOfVertices());
        jvx.setDimOfSimplex(this.getDimOfSimplex());
        jvx.setVisible(this.isVisible());
        jvx.showBndBox(this.isShowingBndBox());
        jvx.showCenter(this.isShowingCenter());
        jvx.showTitle(this.isShowingTitle());
        PiVector.copy(jvx.m_labelAttribute, 0, this.m_labelAttribute, 0, this.m_labelAttribute.length);
        return jvx;
    }

    public void setJvx(PgJvxSrc src) {
        this.init();
        this.setName(src.getName());
        this.setVersion(src.getVersion());
        this.setVersionType(src.getVersionType());
        this.setTitle(src.getTitle());
        this.setAuthorInfo(src.getAuthorInfo());
        this.setGeometryInfo(src.getGeometryInfo());
        this.setDimOfSimplex(src.getDimOfSimplex());
        this.m_dim = src.getDimOfVertices();
        this.setVisible(src.isVisible());
        this.showBndBox(src.isShowingBndBox());
        this.showCenter(src.isShowingCenter());
        this.showTitle(src.isShowingTitle());
        PiVector.copy(this.m_labelAttribute, 0, src.m_labelAttribute, 0, src.m_labelAttribute.length);
    }

    public boolean hasModelMatrix() {
        return this.m_modelMatrix != null;
    }

    public boolean hasAmbientMatrix() {
        return this.m_ambientMatrix != null;
    }
}

