/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.StringTokenizer;
import jv.object.PsDebug;
import jv.rsrc.PsXmlNode;

public class PsXmlSrc
implements Serializable {
    protected String m_docName = null;
    protected String m_docType = null;
    protected PsXmlNode m_root = null;
    protected String m_rsrcFile = null;

    public static PsXmlNode assureChild(PsXmlNode parent, String type) {
        PsXmlNode node = PsXmlSrc.getRsrcNode(parent, type);
        if (node == null) {
            node = parent.addChild(type);
        }
        return node;
    }

    public static boolean getRsrcAsBoolean(PsXmlNode rsrcNode, String type) {
        String tmp = PsXmlSrc.getRsrc(rsrcNode, type);
        if (tmp == null || tmp.equals("")) {
            PsDebug.notify("missing content, return false as default.");
            return false;
        }
        return tmp.equalsIgnoreCase("true");
    }

    public static String getRsrc(PsXmlNode rsrcNode, String type) {
        if (rsrcNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        String runType = rsrcNode.getType();
        if (runType != null && runType.equals(type)) {
            return rsrcNode.getContent();
        }
        PsXmlNode child = rsrcNode.getChild(type);
        if (child == null) {
            return null;
        }
        return child.getContent();
    }

    public PsXmlNode getRootNode() {
        return this.m_root;
    }

    public void setRootNode(PsXmlNode root) {
        this.m_root = root;
    }

    public static PsXmlNode getRsrcNode(PsXmlNode rsrcNode, String type) {
        if (rsrcNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        String ownType = rsrcNode.getType();
        if (ownType != null && ownType.equals(type)) {
            return rsrcNode;
        }
        PsXmlNode node = rsrcNode.getChild(type);
        if (node == null) {
            return null;
        }
        return node;
    }

    public String getDocName() {
        return this.m_docName;
    }

    public void setDocName(String name) {
        this.m_docName = name;
    }

    public String getDocType() {
        return this.m_docType;
    }

    public void setDocType(String type) {
        this.m_docType = type;
    }

    public static double getRsrcAsDouble(PsXmlNode rsrcNode, String type) {
        String tmp = PsXmlSrc.getRsrc(rsrcNode, type);
        if (tmp == null || tmp.equals("")) {
            PsDebug.notify("missing content, return 0. as default.");
            return 0.0;
        }
        try {
            double d = new Double(tmp);
            return d;
        }
        catch (NumberFormatException e) {
            PsDebug.warning("wrong format, rsrc = " + tmp);
            return 0.0;
        }
    }

    public static int getRsrcAsInteger(PsXmlNode rsrcNode, String type) {
        String tmp = PsXmlSrc.getRsrc(rsrcNode, type);
        if (tmp == null || tmp.equals("")) {
            PsDebug.notify("missing content, return 0 as default.");
            return 0;
        }
        try {
            int i = Integer.parseInt(tmp);
            return i;
        }
        catch (NumberFormatException e) {
            PsDebug.warning("wrong format, rsrc = " + tmp);
            return 0;
        }
    }

    public static String write(PsXmlSrc src) {
        if (src == null) {
            PsDebug.warning("missing XML source.");
            return null;
        }
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("missing root node in XML source.");
            return null;
        }
        String docName = src.getDocName();
        String docType = src.getDocType();
        StringBuffer xml = new StringBuffer("");
        xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>\n");
        if (docName != null && docType != null) {
            xml.append("<!DOCTYPE " + docName + " SYSTEM \"" + docType + "\">" + "\n");
        } else {
            PsDebug.message("missing DTD information.", false);
        }
        xml = PsXmlNode.writeNode(xml, root, "");
        return xml.toString();
    }

    public static boolean write(Writer writer, PsXmlSrc src) throws IOException {
        if (src == null) {
            PsDebug.warning("missing XML source.");
            return false;
        }
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("missing root node in XML source.");
            return false;
        }
        String docName = src.getDocName();
        String docType = src.getDocType();
        writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>\n");
        if (docName != null && docType != null) {
            writer.write("<!DOCTYPE " + docName + " SYSTEM \"" + docType + "\">" + "\n");
        } else {
            PsDebug.message("missing DTD information.", false);
        }
        return PsXmlNode.writeNode(writer, root, "");
    }

    public static PsXmlNode[] getRsrcNodes(PsXmlNode rsrcNode, String type) {
        if (rsrcNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        PsXmlNode[] node = rsrcNode.getChildren(type);
        if (node == null) {
            return null;
        }
        return node;
    }

    public static PsXmlNode[] getRsrcNodes(PsXmlNode rsrcNode) {
        if (rsrcNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        PsXmlNode[] node = rsrcNode.getChildren();
        if (node == null) {
            return null;
        }
        return node;
    }

    public String getParameter(String name) {
        PsXmlNode node;
        if (this.m_root == null) {
            PsDebug.warning("missing resource tree.");
            return null;
        }
        if (name == null || name.equals("")) {
            PsDebug.warning("missing argument = " + name);
            return null;
        }
        int ind = -1;
        try {
            node = this.getRootNode();
            StringTokenizer st = new StringTokenizer(name, "/");
            do {
                String type;
                if ((node = PsXmlSrc.getRsrcNode(node, type = st.nextToken())) != null) continue;
                PsDebug.warning("failed to find node = " + type + " while parsing = " + name);
                return null;
            } while ((ind = name.indexOf(47, ind + 1)) != -1);
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown at position=" + ind + " while parsing = " + name);
            return null;
        }
        if (node == null) {
            PsDebug.warning("failure during parsing = " + name);
            return null;
        }
        return node.getContent();
    }

    public String getRsrcFile() {
        return this.m_rsrcFile;
    }

    public void setRsrcFile(String rsrcFile) {
        this.m_rsrcFile = rsrcFile;
    }
}

