/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdBaryDir
extends P_Vector {
    public double[] m_data;

    public void multScalar(double scalar) {
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] * scalar;
        }
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PdBaryDir *********\n");
        int size = this.getSize();
        strBuf.append("\t size = " + size + "\n");
        if (size > 0) {
            strBuf.append("\t m_data = (" + this.m_data[0]);
            int i = 1;
            while (i < size) {
                strBuf.append(", " + this.m_data[i]);
                ++i;
            }
            strBuf.append(")\n");
        } else {
            strBuf.append("\t m_data = null\n");
        }
        return strBuf.toString();
    }

    public PdBaryDir() {
        this.m_data = null;
    }

    public PdBaryDir(int aSize) {
        this.m_data = new double[aSize];
    }

    public PdBaryDir(double x, double y) {
        this(2);
        this.m_data[0] = x;
        this.m_data[1] = y;
    }

    public PdBaryDir(double x, double y, double z) {
        this(3);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
    }

    public PdBaryDir(double x, double y, double z, double w) {
        this(4);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
        this.m_data[3] = w;
    }

    public String toShortString() {
        int j;
        StringBuffer strBuf = new StringBuffer("");
        int size = this.getSize();
        if (this.m_data == null || size == 0) {
            strBuf.append("{ m_data = null} \t");
        } else {
            strBuf.append("{ " + String.valueOf(this.m_data[0]));
            j = 1;
            while (j < size) {
                strBuf.append(", " + String.valueOf(this.m_data[j]));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("Attr = ");
        if (this.m_bits == null) {
            strBuf.append("{ } \t");
        } else {
            strBuf.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            j = 1;
            while (j < this.m_bits.length) {
                strBuf.append("\t " + PuString.intToString((int)this.m_bits[j], 4));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("\n");
        return strBuf.toString();
    }

    public static void getVector(PdVector p, PdBaryDir bary, PdVector v0, PdVector v1, PdVector v2) {
        int dim = v0.getSize();
        double[] b = bary.m_data;
        int i = 0;
        while (i < dim) {
            p.m_data[i] = b[0] * v0.m_data[i] + b[1] * v1.m_data[i] + b[2] * v2.m_data[i];
            ++i;
        }
    }

    public void validate() {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) < 1.0E-10) {
                this.m_data[i] = 0.0;
            }
            sum += this.m_data[i];
            ++i;
        }
        sum /= (double)this.m_data.length;
        i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] - sum;
        }
    }

    public void sub(PdBary x, PdBary y) {
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = x.m_data[i] - y.m_data[i];
            ++i;
        }
    }

    public static PdBaryDir copyNew(PdBaryDir v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdBaryDir newBary = new PdBaryDir(v.getSize());
        newBary.copy(v);
        return newBary;
    }

    public void copy(PdBaryDir vec) {
        if (vec == null) {
            PsDebug.warning("missing argument");
            return;
        }
        super.copy(vec);
        if (vec.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data.length != vec.getSize()) {
            this.setSize(vec.getSize());
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = vec.m_data[i];
            ++i;
        }
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int aSize) {
        if (this.m_data == null || this.m_data.length != aSize) {
            this.m_data = PuData.realloc(this.m_data, aSize);
        }
        return aSize;
    }

    public Object clone() {
        return PdBaryDir.copyNew(this);
    }
}

