/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;

public class PdVector
extends P_Vector {
    public double[] m_data;

    public static double[][] getEntries(PdVector[] vArr) {
        if (vArr == null) {
            return null;
        }
        int size = vArr.length;
        double[][] data = new double[size][];
        int i = 0;
        while (i < size) {
            data[i] = vArr[i].getEntries();
            ++i;
        }
        return data;
    }

    public double[] getEntries() {
        return (double[])this.m_data.clone();
    }

    public void leftMultAffin(PdMatrix m, PdVector v, boolean bPoint) {
        int i;
        int size = this.m_data.length;
        if (m.m_iSize != m.m_jSize || m.m_iSize - 1 != size) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        if (this == v) {
            PsDebug.warning("this must be different from argument");
            return;
        }
        if (bPoint) {
            i = 0;
            while (i < size) {
                this.m_data[i] = m.m_data[i][size];
                ++i;
            }
        } else {
            this.setConstant(0.0);
        }
        i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                int n = i;
                this.m_data[n] = this.m_data[n] + m.m_data[i][j] * v.m_data[j];
                ++j;
            }
            ++i;
        }
    }

    public double getEntry(int ind) {
        if (ind < 0 || this.m_data.length <= ind) {
            PsDebug.warning("index out of range, index=" + ind);
            return 0.0;
        }
        return this.m_data[ind];
    }

    public void setEntry(int ind, double value) {
        if (this.m_data.length <= ind) {
            this.setSize(ind + 1);
        }
        this.m_data[ind] = value;
    }

    public void setEntry(int ind, int value) {
        this.setEntry(ind, (double)value);
    }

    public double getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0.0;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(double value) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = value;
    }

    public int indexOfMax() {
        int index = 0;
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public PdVector orthogonalPart(PdVector vCompl, PdVector e) {
        if (vCompl == null) {
            vCompl = new PdVector(this.getSize());
        }
        double skp = PdVector.dot(this, e);
        vCompl.blendBase(this, -skp, e);
        return vCompl;
    }

    public static double angleWithOrientation(double[] angle, PdVector[] p, int len) {
        if (angle == null || p == null) {
            PsDebug.warning("missing angle or vertex array.");
            return 0.0;
        }
        if (angle.length < len || p.length < len) {
            PsDebug.warning("angle or vertex array too small.");
            return 0.0;
        }
        if (p.length < 1 || p[0] == null) {
            PsDebug.warning("empty polygon, no vertex found.");
            return 0.0;
        }
        int dim = p[0].getSize();
        PdVector[] av = new PdVector[len];
        PdVector jp = new PdVector(dim);
        PdVector jn = new PdVector(dim);
        int i = 0;
        while (i < len) {
            av[i] = PdVector.subNew(p[(i + 1) % len], p[i]);
            av[i].normalize();
            ++i;
        }
        boolean bSign = true;
        double sum = 0.0;
        i = 0;
        while (i < len) {
            int ip = (i - 1 + len) % len;
            angle[i] = PdVector.dot(av[ip], av[i]);
            if (angle[i] < -1.0) {
                angle[i] = -1.0;
            } else if (angle[i] > 1.0) {
                angle[i] = 1.0;
            }
            angle[i] = Math.acos(angle[i]);
            if (!bSign) {
                angle[i] = -angle[i];
            }
            sum += angle[i];
            int in = (i + 1 + len) % len;
            jp = av[ip].orthogonalPart(jp, av[i]);
            jp = av[in].orthogonalPart(jn, av[i]);
            if (PdVector.dot(jn, jp) > 0.0) {
                bSign = !bSign;
            }
            ++i;
        }
        if (sum < 0.0) {
            i = 0;
            while (i < len) {
                angle[i] = -angle[i];
                ++i;
            }
            sum = -sum;
        }
        return sum;
    }

    public static double angleWithOrientation(PdVector v, PdVector w, PdVector orient) {
        double vlen = v.length();
        double wlen = w.length();
        if (vlen == 0.0 || wlen == 0.0) {
            PsDebug.notify("vector with zero length");
            return 0.0;
        }
        double angle = PdVector.dot(v, w) / vlen / wlen;
        if (angle < -1.0) {
            angle = -1.0;
        } else if (angle > 1.0) {
            angle = 1.0;
        }
        angle = Math.acos(angle);
        PdVector normal = PdVector.crossNew(v, w);
        if (PdVector.dot(normal, orient) < 0.0) {
            angle = -angle;
        }
        return angle;
    }

    public static double dist(PdVector v, PdVector w) {
        double sum = 0.0;
        int i = 0;
        while (i < v.m_data.length) {
            double tmp = v.m_data[i] - w.m_data[i];
            sum += tmp * tmp;
            ++i;
        }
        return Math.sqrt(sum);
    }

    public double dist(PdVector v) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            double tmp = this.m_data[i] - v.m_data[i];
            sum += tmp * tmp;
            ++i;
        }
        return Math.sqrt(sum);
    }

    public static PdVector[] copyNew(double[][] data) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int size = data.length;
        PdVector[] newData = new PdVector[size];
        int i = 0;
        while (i < size) {
            newData[i] = new PdVector(data[i]);
            ++i;
        }
        return newData;
    }

    public static PdVector[] copyNew(PdVector[] data) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdVector.copyNew(data, data.length);
    }

    public static PdVector[] copyNew(PdVector[] data, int size) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector[] newData = new PdVector[size];
        int i = 0;
        while (i < size) {
            newData[i] = PdVector.copyNew(data[i]);
            ++i;
        }
        return newData;
    }

    public static PdVector copyNew(PdVector v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdVector newVector = new PdVector(v.m_data.length);
        newVector.copy(v);
        return newVector;
    }

    public static PdVector crossNew(PdVector v, PdVector w) {
        PdVector cv = new PdVector(3);
        cv.cross(v, w);
        return cv;
    }

    public boolean equals(double[] list) {
        int len = this.getSize();
        if (list == null && len == 0) {
            return true;
        }
        if (list == null) {
            return false;
        }
        if (len != list.length) {
            return false;
        }
        --len;
        while (len >= 0) {
            if (this.m_data[len] != list[len]) {
                return false;
            }
            --len;
        }
        return true;
    }

    public boolean equals(PdVector vec) {
        if (vec == null && this.getSize() == 0) {
            return true;
        }
        return this.equals(vec.m_data);
    }

    public boolean equals(PdVector vec, double eps) {
        if (vec == null && this.getSize() == 0) {
            return true;
        }
        if (this.getSize() != vec.getSize()) {
            return false;
        }
        return !(PdVector.sqrDist(this, vec) > eps * eps);
    }

    public static PdVector normalToVectorNew(PdVector v) {
        PdVector normal = new PdVector(v.getSize());
        normal.normalToVector(v);
        return normal;
    }

    public static int getSameSize(PdVector[] vecArray, int numUsed) {
        if (vecArray == null || vecArray.length == 0) {
            return -1;
        }
        if (vecArray[0] == null) {
            return -1;
        }
        if (vecArray.length < numUsed) {
            PsDebug.warning("used vectors larger than array size.");
            numUsed = vecArray.length;
        }
        int len = vecArray[0].getSize();
        int i = 1;
        while (i < numUsed) {
            if (len != vecArray[i].getSize()) {
                len = -1;
                break;
            }
            ++i;
        }
        return len;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int aSize) {
        if (this.m_data == null) {
            this.m_data = new double[aSize];
        } else if (this.m_data.length != aSize) {
            this.m_data = PuData.realloc(this.m_data, aSize);
        }
        return aSize;
    }

    public void blendBase(PdVector v, double b, PdVector w) {
        if (this.m_data == null) {
            this.setSize(v.m_data.length);
        }
        if (this.m_data.length != v.m_data.length || this.m_data.length != w.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = v.m_data[i] + b * w.m_data[i];
            ++i;
        }
    }

    public Object clone() {
        return PdVector.copyNew(this);
    }

    public double sqrLength() {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            sum += this.m_data[i] * this.m_data[i];
            ++i;
        }
        return sum;
    }

    public double length() {
        return PdVector.length(this.m_data.length, this.m_data);
    }

    public static double length(int num, double[] data) {
        double sum = 0.0;
        int i = 0;
        while (i < num) {
            sum += data[i] * data[i];
            ++i;
        }
        return Math.sqrt(sum);
    }

    public boolean setLength(double aLength) {
        double fac = this.length();
        if (fac == 0.0) {
            return false;
        }
        fac /= aLength;
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] / fac;
        }
        return true;
    }

    public int changeValue(int usedSize, double oldValue, double newValue) {
        int count = 0;
        int k = 0;
        while (k < usedSize) {
            if (this.m_data[k] == oldValue) {
                this.m_data[k] = newValue;
                ++count;
            }
            ++k;
        }
        return count;
    }

    public int changeValue(double oldValue, double newValue) {
        int count = 0;
        int k = 0;
        while (k < this.m_data.length) {
            if (this.m_data[k] == oldValue) {
                this.m_data[k] = newValue;
                ++count;
            }
            ++k;
        }
        return count;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PdVector ***********\n");
        int size = this.getSize();
        strBuf.append("\t size\t = " + size + "\n");
        if (size > 0) {
            strBuf.append("\t m_data = (" + this.m_data[0]);
            int i = 1;
            while (i < size) {
                strBuf.append(", " + this.m_data[i]);
                ++i;
            }
            strBuf.append(")\n");
        } else {
            strBuf.append("\t m_data = null\n");
        }
        return strBuf.toString();
    }

    public boolean normalOfPlane(PdVector p, PdVector q, PdVector r) {
        PdVector w;
        PdVector v = PdVector.subNew(p, q);
        if (!this.cross(v, w = PdVector.subNew(p, r))) {
            return false;
        }
        return this.normalize();
    }

    public static final boolean max(PdVector max, PdVector[] aVecArray, int arrayLength) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray.length < arrayLength || aVecArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (max == null || max.m_data == null) {
            PsDebug.warning("missing max argument");
            return false;
        }
        if (arrayLength == 0) {
            max.setConstant(0.0);
            return false;
        }
        max.setConstant(Double.NEGATIVE_INFINITY);
        int i = 0;
        while (i < arrayLength) {
            int k = Math.min(max.m_data.length, aVecArray[i].m_data.length) - 1;
            while (k >= 0) {
                if (max.m_data[k] < aVecArray[i].m_data[k]) {
                    max.m_data[k] = aVecArray[i].m_data[k];
                }
                --k;
            }
            ++i;
        }
        return true;
    }

    public double max() {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
            }
            ++i;
        }
        return max;
    }

    public static double[] frameToStandardFrame(PdVector first, PdVector second, PdVector third) {
        if (first == null || second == null || third == null || first.getSize() != 3 || second.getSize() != 3 || third.getSize() != 3) {
            PsDebug.warning("wrong argument(s)");
            return null;
        }
        PdVector first2 = new PdVector(3);
        PdVector third2 = new PdVector(3);
        PdVector xaxis = new PdVector(1.0, 0.0, 0.0);
        PdVector yaxis = new PdVector(0.0, 1.0, 0.0);
        PdVector zaxis = new PdVector(0.0, 0.0, 1.0);
        third2.set(0.0, 1.0, 0.0);
        third2.multScalar(-PdVector.dot(third2, third));
        third2.add(third);
        double firstangle = PdVector.angleWithOrientation(third2, zaxis, yaxis);
        double cos = Math.cos(firstangle);
        double sin = Math.sin(firstangle);
        double[] dat = first.m_data;
        first2.set(cos * dat[0] + sin * dat[2], dat[1], -sin * dat[0] + cos * dat[2]);
        dat = third.m_data;
        third2.set(cos * dat[0] + sin * dat[2], dat[1], -sin * dat[0] + cos * dat[2]);
        double secondangle = PdVector.angleWithOrientation(third2, zaxis, xaxis);
        cos = Math.cos(secondangle);
        sin = Math.sin(secondangle);
        dat = first2.m_data;
        first2.set(dat[0], cos * dat[1] - sin * dat[2], sin * dat[1] + cos * dat[2]);
        dat = third2.m_data;
        third2.set(dat[0], cos * dat[1] - sin * dat[2], sin * dat[1] + cos * dat[2]);
        double thirdangle = PdVector.angleWithOrientation(first2, xaxis, zaxis);
        double[] ret = new double[]{firstangle, secondangle, thirdangle};
        return ret;
    }

    public static double area(PdVector p, PdVector q, PdVector r) {
        double c;
        double b;
        double a = PdVector.dist(q, r);
        double s = (a + (b = PdVector.dist(r, p)) + (c = PdVector.dist(p, q))) / 2.0;
        double area = s * (s - a) * (s - b) * (s - c);
        if (area < 0.0) {
            return 0.0;
        }
        return Math.sqrt(area);
    }

    public static double area(PdVector[] p) {
        if (p == null) {
            PsDebug.warning("missing points");
            return 0.0;
        }
        if (p.length < 3) {
            PsDebug.warning("array must have length >=3", p);
            return 0.0;
        }
        double area = 0.0;
        int j = 2;
        while (j < p.length) {
            double c;
            double b;
            double a = PdVector.dist(p[j - 1], p[j]);
            double s = (a + (b = PdVector.dist(p[j], p[0])) + (c = PdVector.dist(p[0], p[j - 1]))) / 2.0;
            double tmp = s * (s - a) * (s - b) * (s - c);
            if (tmp > 0.0) {
                area += Math.sqrt(tmp);
            }
            ++j;
        }
        return area;
    }

    public static double sqrDist(PdVector v, PdVector w) {
        double sum = 0.0;
        int i = 0;
        while (i < v.m_data.length) {
            double tmp = v.m_data[i] - w.m_data[i];
            sum += tmp * tmp;
            ++i;
        }
        return sum;
    }

    public void sub(PdVector m) {
        if (this.m_data == null) {
            this.setSize(m.m_data.length);
        }
        if (this.m_data.length != m.m_data.length) {
            PsDebug.notify("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i;
            this.m_data[n] = this.m_data[n] - m.m_data[i];
            ++i;
        }
    }

    public void sub(PdVector m1, PdVector m2) {
        if (this.m_data == null) {
            this.setSize(m1.m_data.length);
        }
        if (this.m_data.length != m1.m_data.length) {
            PsDebug.notify("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = m1.m_data[i] - m2.m_data[i];
            ++i;
        }
    }

    public double sqrDist(PdVector v) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            double tmp = this.m_data[i] - v.m_data[i];
            sum += tmp * tmp;
            ++i;
        }
        return sum;
    }

    public double getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0.0;
        }
        return this.m_data[0];
    }

    public static boolean copy(PdVector[] dataDest, int destInd, PdVector[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.warning("missing space in dataDest", dataSrc);
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i].copy(dataSrc[srcInd + i]);
            ++i;
        }
        return true;
    }

    public void setFirstEntry(double value) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = value;
    }

    public boolean copy(int destInd, PdVector dataSrc, int srcInd, int size) {
        if (this.m_data.length < destInd + size) {
            PsDebug.warning("missing space in this");
            return false;
        }
        if (this.m_data == null || this.m_data.length < destInd + size) {
            this.setSize(destInd + size);
        }
        System.arraycopy(dataSrc.m_data, srcInd, this.m_data, destInd, size);
        return true;
    }

    public void copy(PdVector v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(v);
        super.copy(v);
    }

    public void copy(double[] anArray, int aSize) {
        if (anArray == null) {
            PsDebug.warning("null vector 'anArray' passed");
            return;
        }
        if (this.m_data == null) {
            this.setSize(aSize);
        }
        int len = Math.min(this.m_data.length, aSize);
        System.arraycopy(anArray, 0, this.m_data, 0, len);
        int i = len;
        while (i < this.m_data.length) {
            this.m_data[i] = 0.0;
            ++i;
        }
    }

    public void copy(double[] anArray, int srcPos, int aSize) {
        if (anArray == null) {
            PsDebug.warning("null vector 'anArray' passed");
            return;
        }
        if (anArray.length < srcPos + aSize) {
            PsDebug.warning("ind+size is bigger than array");
            return;
        }
        if (this.m_data == null) {
            this.setSize(aSize);
        }
        int len = Math.min(this.m_data.length, aSize);
        System.arraycopy(anArray, srcPos, this.m_data, 0, len);
        int i = len;
        while (i < this.m_data.length) {
            this.m_data[i] = 0.0;
            ++i;
        }
    }

    public int indexOfAbsMin() {
        int index = 0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) < min) {
                min = Math.abs(this.m_data[i]);
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void normalToVector(PdVector v) {
        this.setLength(v.getSize());
        this.setConstant(1.0);
        this.m_data[v.indexOfAbsMax()] = 0.0;
        this.orthonormalize(v);
    }

    public static void setConstant(PdVector[] aVecArray, double aValue) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray[0] == null) {
            return;
        }
        int i = 0;
        while (i < aVecArray.length) {
            aVecArray[i].setConstant(aValue);
            ++i;
        }
    }

    public static void setConstant(PdVector[] aVecArray, double[] data) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray[0] == null) {
            return;
        }
        if (aVecArray[0].m_data.length != data.length) {
            PsDebug.warning("arrays have different length");
            return;
        }
        int len = Math.min(aVecArray[0].m_data.length, data.length);
        int i = 0;
        while (i < aVecArray.length) {
            int j = 0;
            while (j < len) {
                aVecArray[i].m_data[j] = data[j];
                ++j;
            }
            ++i;
        }
    }

    public static void setConstant(PdVector[] aVecArray, PdVector aVector) {
        if (aVector == null || aVector.m_data == null) {
            return;
        }
        PdVector.setConstant(aVecArray, aVector.m_data);
    }

    public static void setConstant(PdVector v, double aValue) {
        if (v == null || v.m_data == null) {
            return;
        }
        int i = v.getSize() - 1;
        while (i >= 0) {
            v.m_data[i] = aValue;
            --i;
        }
    }

    public void setConstant(double aValue) {
        if (this.m_data == null) {
            return;
        }
        int i = this.m_data.length - 1;
        while (i >= 0) {
            this.m_data[i] = aValue;
            --i;
        }
    }

    public int addEntry(double val) {
        int size = this.setSize(this.getSize() + 1);
        this.m_data[size - 1] = val;
        return size;
    }

    public int indexOfMin() {
        int index = 0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static PdVector[] realloc(PdVector[] data, int arraySize, int vectorSize) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            int j = 0;
            while (j < data.length) {
                if (data[j].m_data == null || data[j].m_data.length != vectorSize) {
                    data[j].setSize(vectorSize);
                }
                ++j;
            }
            return data;
        }
        PdVector[] newData = new PdVector[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = 0;
        while (i < commonSize) {
            if (newData[i].m_data == null || newData[i].m_data.length != vectorSize) {
                newData[i].setSize(vectorSize);
            }
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdVector(vectorSize);
            ++i;
        }
        return newData;
    }

    public static PdVector[] realloc(PdVector[] data, int arraySize) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            return data;
        }
        PdVector[] newData = new PdVector[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdVector();
            ++i;
        }
        return newData;
    }

    public static double getOrientation(PdVector[] v) {
        int dim = v.length;
        PdMatrix mat = new PdMatrix(dim);
        int i = 0;
        while (i < dim) {
            if (v[i] == null || v[i].getSize() < dim) {
                PsDebug.warning("missing or invalid vector v[" + i + "]");
                return 0.0;
            }
            int j = 0;
            while (j < dim) {
                mat.m_data[i][j] = v[i].m_data[j];
                ++j;
            }
            ++i;
        }
        return mat.det();
    }

    public boolean cross(PdVector v, PdVector w) {
        if (this.m_data.length != 3) {
            return false;
        }
        int vSize = v.getSize();
        int wSize = w.getSize();
        if (vSize == 3 && wSize == 3) {
            this.m_data[0] = v.m_data[1] * w.m_data[2] - v.m_data[2] * w.m_data[1];
            this.m_data[1] = -v.m_data[0] * w.m_data[2] + v.m_data[2] * w.m_data[0];
            this.m_data[2] = v.m_data[0] * w.m_data[1] - v.m_data[1] * w.m_data[0];
        } else if (vSize == 2 && wSize == 3) {
            this.m_data[0] = v.m_data[1] * w.m_data[2];
            this.m_data[1] = -v.m_data[0] * w.m_data[2];
            this.m_data[2] = v.m_data[0] * w.m_data[1] - v.m_data[1] * w.m_data[0];
        } else if (vSize == 3 && wSize == 2) {
            this.m_data[0] = -v.m_data[2] * w.m_data[1];
            this.m_data[1] = v.m_data[2] * w.m_data[0];
            this.m_data[2] = v.m_data[0] * w.m_data[1] - v.m_data[1] * w.m_data[0];
        } else if (vSize == 2 && wSize == 2) {
            this.set(0.0, 0.0, v.m_data[0] * w.m_data[1] - v.m_data[1] * w.m_data[0]);
        } else {
            PsDebug.error("wrong dimension of arguments: vSize = " + vSize + " wSize = " + wSize, this);
            return false;
        }
        return true;
    }

    public static double dot(PdVector v, PdVector w) {
        double sum = 0.0;
        int i = 0;
        while (i < v.m_data.length) {
            sum += v.m_data[i] * w.m_data[i];
            ++i;
        }
        return sum;
    }

    public double dot(PdVector v) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            sum += this.m_data[i] * v.m_data[i];
            ++i;
        }
        return sum;
    }

    public boolean normalize() {
        double length = this.length();
        if (length < 1.0E-10) {
            return false;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] / length;
        }
        return true;
    }

    public boolean normalize(PdVector v) {
        double length = v.length();
        if (length < 1.0E-10) {
            this.copy(v);
            return false;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = v.m_data[i] / length;
            ++i;
        }
        return true;
    }

    public void add(double val) {
        if (this.m_data == null) {
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] + val;
        }
    }

    public void add(PdVector m) {
        if (this.m_data == null) {
            this.setSize(m.m_data.length);
        }
        if (this.m_data.length != m.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i;
            this.m_data[n] = this.m_data[n] + m.m_data[i];
            ++i;
        }
    }

    public void add(PdVector m1, PdVector m2) {
        if (this.m_data == null) {
            this.setSize(m1.m_data.length);
        }
        if (this.m_data.length != m1.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = m1.m_data[i] + m2.m_data[i];
            ++i;
        }
    }

    public String toShortString() {
        int j;
        StringBuffer strBuf = new StringBuffer("");
        int size = this.getSize();
        if (this.m_data == null || size == 0) {
            strBuf.append("{ m_data = null} \t");
        } else {
            strBuf.append("{ " + String.valueOf(this.m_data[0]));
            j = 1;
            while (j < size) {
                strBuf.append(", " + String.valueOf(this.m_data[j]));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("Attr = ");
        if (this.m_bits == null) {
            strBuf.append("{ } \t");
        } else {
            strBuf.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            j = 1;
            while (j < this.m_bits.length) {
                strBuf.append("\t " + PuString.intToString((int)this.m_bits[j], 4));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("\n");
        return strBuf.toString();
    }

    public static double angle(PdVector p, PdVector q, PdVector r) {
        PdVector v = PdVector.subNew(p, q);
        PdVector w = PdVector.subNew(p, r);
        return PdVector.angle(v, w);
    }

    public static void angle(double[] angle, PdVector p, PdVector q, PdVector r) {
        PdVector.angle(angle, new PdVector[]{p, q, r});
    }

    public static void angle(double[] angle, PdVector[] p) {
        int len = p.length;
        PdVector[] av = new PdVector[len];
        int i = 0;
        while (i < len) {
            av[i] = PdVector.subNew(p[(i + 1) % len], p[i]);
            av[i].normalize();
            ++i;
        }
        i = 0;
        while (i < len) {
            angle[i] = PdVector.dot(av[(i - 1 + len) % len], av[i]);
            if (angle[i] < -1.0) {
                angle[i] = -1.0;
            } else if (angle[i] > 1.0) {
                angle[i] = 1.0;
            }
            angle[i] = Math.PI - Math.acos(angle[i]);
            ++i;
        }
    }

    public static double angle(PdVector v, PdVector w) {
        double vlen = v.length();
        double wlen = w.length();
        if (vlen == 0.0 || wlen == 0.0) {
            PsDebug.notify("vector with zero length");
            return 0.0;
        }
        double angle = PdVector.dot(v, w) / vlen / wlen;
        if (angle < -1.0) {
            angle = -1.0;
        } else if (angle > 1.0) {
            angle = 1.0;
        }
        angle = Math.acos(angle) * 180.0 / Math.PI;
        return angle;
    }

    public void copyArray(PdVector v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int argLen = v.m_data.length;
        if (this.m_data == null) {
            this.setSize(argLen);
        }
        if (this.m_data.length > argLen) {
            int i = argLen;
            while (i < this.m_data.length) {
                this.m_data[i] = 0.0;
                ++i;
            }
        } else {
            argLen = this.m_data.length;
        }
        switch (argLen) {
            case 3: {
                this.m_data[2] = v.m_data[2];
            }
            case 2: {
                this.m_data[1] = v.m_data[1];
            }
            case 1: {
                this.m_data[0] = v.m_data[0];
                break;
            }
            default: {
                System.arraycopy(v.m_data, 0, this.m_data, 0, argLen);
            }
        }
    }

    public void leftMultMatrix(PdMatrix m) {
        if (m.m_iSize != m.m_jSize || m.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] tmp = new double[this.m_data.length];
        int i = 0;
        while (i < this.m_data.length) {
            tmp[i] = 0.0;
            int j = 0;
            while (j < this.m_data.length) {
                int n = i;
                tmp[n] = tmp[n] + m.m_data[i][j] * this.m_data[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = tmp[i];
            ++i;
        }
    }

    public void leftMultMatrix(PdMatrix m, PdVector v) {
        if (this == v) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != m.m_iSize) {
            this.setSize(m.m_iSize);
        }
        int i = 0;
        while (i < m.m_iSize) {
            this.m_data[i] = 0.0;
            int j = 0;
            while (j < v.m_data.length) {
                int n = i;
                this.m_data[n] = this.m_data[n] + m.m_data[i][j] * v.m_data[j];
                ++j;
            }
            ++i;
        }
    }

    public void invert(int usedSize) {
        int nop = usedSize / 2;
        int k = 0;
        while (k < nop) {
            double tmp = this.m_data[k];
            this.m_data[k] = this.m_data[usedSize - 1 - k];
            this.m_data[usedSize - 1 - k] = tmp;
            ++k;
        }
    }

    public void invert() {
        int nop = this.m_data.length / 2;
        int k = 0;
        while (k < nop) {
            double tmp = this.m_data[k];
            this.m_data[k] = this.m_data[this.m_data.length - 1 - k];
            this.m_data[this.m_data.length - 1 - k] = tmp;
            ++k;
        }
    }

    public static final boolean min(PdVector min, PdVector[] aVecArray, int arrayLength) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray.length < arrayLength || aVecArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (min == null || min.m_data == null) {
            PsDebug.warning("missing min argument");
            return false;
        }
        min.setConstant(Double.MAX_VALUE);
        int i = 0;
        while (i < arrayLength) {
            int k = Math.min(min.m_data.length, aVecArray[i].m_data.length) - 1;
            while (k >= 0) {
                if (min.m_data[k] > aVecArray[i].m_data[k]) {
                    min.m_data[k] = aVecArray[i].m_data[k];
                }
                --k;
            }
            ++i;
        }
        return true;
    }

    public double min() {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
            }
            ++i;
        }
        return min;
    }

    public double maxAbs() {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) > max) {
                max = Math.abs(this.m_data[i]);
            }
            ++i;
        }
        return max;
    }

    public static PdVector addNew(PdVector m1, PdVector m2) {
        int size2;
        if (m1 == null || m2 == null) {
            PsDebug.notify("missing argument");
            return null;
        }
        int minSize = m1.getSize();
        if (minSize != (size2 = m2.getSize())) {
            PsDebug.notify("different size of argument vectors");
            minSize = Math.min(minSize, size2);
        }
        PdVector v = new PdVector(minSize);
        v.add(m1, m2);
        return v;
    }

    public static PdVector blendNew(double a, PdVector v, double b, PdVector w) {
        PdVector bv = new PdVector(v.getSize());
        bv.blend(a, v, b, w);
        return bv;
    }

    public void multScalar(double scalar) {
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] * scalar;
        }
    }

    public void multScalar(PdVector v, double scalar) {
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = v.m_data[i] * scalar;
            ++i;
        }
    }

    public void set(PdVector x, int from, int len) {
        if (x == null || x.getSize() < from + len) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != len) {
            this.setSize(len);
        }
        int i = 0;
        while (i < len) {
            this.m_data[i] = x.m_data[from + i];
            ++i;
        }
    }

    public void set(double[] x, int from, int len) {
        if (x == null || x.length < from + len) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != len) {
            this.setSize(len);
        }
        int i = 0;
        while (i < len) {
            this.m_data[i] = x[from + i];
            ++i;
        }
    }

    public void set(double[] x, int len) {
        this.set(x, 0, len);
    }

    public void set(double[] x) {
        if (x == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(x, 0, x.length);
    }

    public void set(int[] x, int from, int len) {
        if (x == null || x.length < from + len) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != len) {
            this.setSize(len);
        }
        int i = 0;
        while (i < len) {
            this.m_data[i] = x[from + i];
            ++i;
        }
    }

    public PdVector() {
    }

    public PdVector(int aSize) {
        this.m_data = new double[aSize];
    }

    public PdVector(double x) {
        this(1);
        this.m_data[0] = x;
    }

    public PdVector(double x, double y) {
        this(2);
        this.m_data[0] = x;
        this.m_data[1] = y;
    }

    public PdVector(double x, double y, double z) {
        this(3);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
    }

    public PdVector(double x, double y, double z, double w) {
        this(4);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
        this.m_data[3] = w;
    }

    public PdVector(double[] x) {
        this();
        this.set(x);
    }

    public void set(int[] x, int len) {
        this.set(x, 0, len);
    }

    public void set(int[] x) {
        if (x == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(x, 0, x.length);
    }

    public void set(double x) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = x;
    }

    public void set(double x, double y) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = x;
        this.m_data[1] = y;
    }

    public void set(double x, double y, double z) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
    }

    public void set(double x, double y, double z, double w) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
        this.m_data[3] = w;
    }

    public static PdVector subNew(PdVector m1, PdVector m2) {
        int size2;
        if (m1 == null || m2 == null) {
            PsDebug.notify("missing argument");
            return null;
        }
        int minSize = m1.getSize();
        if (minSize != (size2 = m2.getSize())) {
            PsDebug.notify("different size of argument vectors");
            minSize = Math.min(minSize, size2);
        }
        PdVector v = new PdVector(minSize);
        v.sub(m1, m2);
        return v;
    }

    public void blend(double a, PdVector v, double b, PdVector w) {
        if (this.m_data == null) {
            this.setSize(v.m_data.length);
        }
        if (this.m_data.length != v.m_data.length || this.m_data.length != w.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = a * v.m_data[i] + b * w.m_data[i];
            ++i;
        }
    }

    public void sort(PdVector vecOut) {
        int size = this.getSize();
        if (vecOut == null || vecOut.m_data == null) {
            vecOut = new PdVector(size);
        }
        if (vecOut.getSize() != size) {
            vecOut.setSize(size);
        }
        if (size < 10) {
            double[] data = vecOut.m_data;
            int i = 0;
            while (i < size) {
                data[i] = this.m_data[i];
                ++i;
            }
            int i2 = size - 1;
            while (i2 > 0) {
                int j = 0;
                while (j < i2) {
                    if (data[j] > data[j + 1]) {
                        double d = data[j + 1];
                        data[j + 1] = data[j];
                        data[j] = d;
                    }
                    ++j;
                }
                --i2;
            }
        } else {
            int[] index = new int[size];
            PuMath.heapsort(size, this.m_data, index);
            int i = 0;
            while (i < size) {
                vecOut.m_data[i] = this.m_data[index[i]];
                ++i;
            }
        }
    }

    public void sort() {
        int size = this.getSize();
        if (size < 10) {
            int i = size - 1;
            while (i > 0) {
                int j = 0;
                while (j < i) {
                    if (this.m_data[j] > this.m_data[j + 1]) {
                        double d = this.m_data[j + 1];
                        this.m_data[j + 1] = this.m_data[j];
                        this.m_data[j] = d;
                    }
                    ++j;
                }
                --i;
            }
        } else {
            int[] index = new int[size];
            double[] data = new double[size];
            int i = 0;
            while (i < size) {
                data[i] = this.m_data[i];
                ++i;
            }
            PuMath.heapsort(size, data, index);
            i = 0;
            while (i < size) {
                this.m_data[i] = data[index[i]];
                ++i;
            }
        }
    }

    public void rightMultMatrix(PdMatrix m) {
        if (m.m_iSize != m.m_jSize || m.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] tmp = new double[this.m_data.length];
        int j = 0;
        while (j < this.m_data.length) {
            tmp[j] = 0.0;
            int i = 0;
            while (i < this.m_data.length) {
                int n = j;
                tmp[n] = tmp[n] + this.m_data[i] * m.m_data[i][j];
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = tmp[i];
            ++i;
        }
    }

    public void rightMultMatrix(PdVector v, PdMatrix m) {
        if (this == v) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != m.m_jSize) {
            this.setSize(m.m_jSize);
        }
        int j = 0;
        while (j < m.m_jSize) {
            this.m_data[j] = 0.0;
            int i = 0;
            while (i < m.m_iSize) {
                int n = j;
                this.m_data[n] = this.m_data[n] + v.m_data[i] * m.m_data[i][j];
                ++i;
            }
            ++j;
        }
    }

    public void orthogonalize(PdVector e) {
        this.orthogonalPart(this, e);
    }

    public void orthonormalize(PdVector e) {
        this.orthogonalize(e);
        this.normalize();
    }

    public void invStereoProj(double x, double y) {
        if (this.m_data.length != 3) {
            return;
        }
        double h = 1.0 + x * x + y * y;
        this.m_data[0] = 2.0 * x / h;
        this.m_data[1] = 2.0 * y / h;
        this.m_data[2] = (2.0 - h) / h;
    }

    public PdVector orthogonalPartWrtONB(PdVector e1, PdVector e2) {
        PdVector compl = new PdVector(this.m_data.length);
        double skp1 = PdVector.dot(this, e1);
        double skp2 = PdVector.dot(this, e2);
        int i = 0;
        while (i < this.m_data.length) {
            compl.m_data[i] = this.m_data[i] - skp1 * e1.m_data[i] - skp2 * e2.m_data[i];
            ++i;
        }
        return compl;
    }

    public PdVector projectOntoONB(PdVector e1, PdVector e2) {
        PdVector proj = new PdVector(this.m_data.length);
        double skp1 = PdVector.dot(this, e1);
        double skp2 = PdVector.dot(this, e2);
        int i = 0;
        while (i < this.m_data.length) {
            proj.m_data[i] = skp1 * e1.m_data[i] + skp2 * e2.m_data[i];
            ++i;
        }
        return proj;
    }

    public int indexOfAbsMax() {
        int index = 0;
        double max = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) > max) {
                max = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }
}

