/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;

public class PuMath {
    public static final double EPS = 1.0E-10;
    public static final double GOLD = 1.61803398875;

    public static int gcd(int m, int n) {
        int r;
        if (m > n) {
            r = m;
            m = n;
            n = r;
        }
        while (m > 0) {
            r = n % m;
            n = m;
            m = r;
        }
        return n;
    }

    public static double binom(int n, int k) {
        double val = 1.0;
        int j = k;
        int i = n;
        while (i > n - k) {
            val *= (double)i;
            if (j > 1) {
                val /= (double)j;
                --j;
            }
            --i;
        }
        return val;
    }

    public static int sign(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    public static double sign(double a, double b) {
        if (b > 0.0) {
            return Math.abs(a);
        }
        return -Math.abs(a);
    }

    public static double dot(double[] v, double[] w) {
        double sum = 0.0;
        int i = 0;
        while (i < v.length) {
            sum += v[i] * w[i];
            ++i;
        }
        return sum;
    }

    public static double log(double basis, double arg) {
        if (basis < 1.0000000001) {
            return 0.0;
        }
        return Math.log(arg) / Math.log(basis);
    }

    public static double acosh(double x) {
        if (x > 1.0) {
            return Math.log(x + Math.sqrt(x * x - 1.0));
        }
        return 0.0;
    }

    public static void projectOnto(double[] v, double[] dir) {
        double skp = PuMath.dot(v, dir);
        int i = 0;
        while (i < v.length) {
            v[i] = skp * dir[i];
            ++i;
        }
    }

    public static double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static double tanh(double x) {
        double ex = Math.exp(x);
        double emx = Math.exp(-x);
        return (ex - emx) / (ex + emx);
    }

    public static double coth(double x) {
        double ex = Math.exp(x);
        double emx = Math.exp(-x);
        return (ex + emx) / (ex - emx);
    }

    public static double angle(double a, double b, double c) {
        double div = 2.0 * b * c;
        if (div <= 0.0) {
            return 0.0;
        }
        return Math.acos((b * b + c * c - a * a) / div);
    }

    public static boolean angle(double[] agl, double a, double b, double c) {
        if (agl == null || agl.length < 3) {
            return false;
        }
        agl[0] = PuMath.angle(a, b, c);
        agl[1] = PuMath.angle(b, c, a);
        agl[2] = PuMath.angle(c, b, a);
        return true;
    }

    public static final void heapsort(int n, double[] arrin, int[] indx) {
        int j = 0;
        while (j < n) {
            indx[j] = j;
            ++j;
        }
        int l = n / 2 + 1;
        int ir = n - 1;
        while (true) {
            double q;
            int indxt;
            if (l > 1) {
                indxt = indx[--l - 1];
                q = arrin[indxt];
            } else {
                indxt = indx[ir];
                q = arrin[indxt];
                indx[ir] = indx[0];
                if (--ir <= 0) {
                    indx[0] = indxt;
                    return;
                }
            }
            int i = l - 1;
            j = l << 1;
            while (j <= ir + 1) {
                if (j < ir + 1 && arrin[indx[j - 1]] < arrin[indx[j]]) {
                    ++j;
                }
                if (q < arrin[indx[j - 1]]) {
                    indx[i] = indx[j - 1];
                    i = j - 1;
                    j += j;
                    continue;
                }
                j = ir + 2;
            }
            indx[i] = indxt;
        }
    }

    public static final void heapsort(int n, int[] arrin, int[] indx) {
        int j = 0;
        while (j < n) {
            indx[j] = j;
            ++j;
        }
        int l = n / 2 + 1;
        int ir = n - 1;
        while (true) {
            int q;
            int indxt;
            if (l > 1) {
                indxt = indx[--l - 1];
                q = arrin[indxt];
            } else {
                indxt = indx[ir];
                q = arrin[indxt];
                indx[ir] = indx[0];
                if (--ir <= 0) {
                    indx[0] = indxt;
                    return;
                }
            }
            int i = l - 1;
            j = l << 1;
            while (j <= ir + 1) {
                if (j < ir + 1 && arrin[indx[j - 1]] < arrin[indx[j]]) {
                    ++j;
                }
                if (q < arrin[indx[j - 1]]) {
                    indx[i] = indx[j - 1];
                    i = j - 1;
                    j += j;
                    continue;
                }
                j = ir + 2;
            }
            indx[i] = indxt;
        }
    }

    public static double dist(double[] v, double[] w) {
        return Math.sqrt(PuMath.sqrDist(v, w));
    }

    public static double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double area(double a, double b, double c) {
        double s = (a + b + c) / 2.0;
        double areaSqr = s * (s - a) * (s - b) * (s - c);
        if (areaSqr < 0.0) {
            return 0.0;
        }
        return Math.sqrt(areaSqr);
    }

    public static double sqrDist(double[] v, double[] w) {
        double sum = 0.0;
        int i = 0;
        while (i < v.length) {
            double tmp = v[i] - w[i];
            sum += tmp * tmp;
            ++i;
        }
        return sum;
    }

    public static void main(String[] args) {
        double[] testArray = new double[]{2.0, -1.0, 7.0, 6.0, 5.0, 4.0, 10.0, 11.0, 12.0, 13.0, -4.0};
        int length = testArray.length;
        int[] index = new int[length];
        System.out.print("orig: ");
        int i = 0;
        while (i < length - 1) {
            System.out.print(testArray[i] + ", ");
            ++i;
        }
        System.out.println(testArray[length - 1] + "##");
        PuMath.heapsort(length, testArray, index);
        System.out.print("indx: ");
        i = 0;
        while (i < length - 1) {
            System.out.print(testArray[index[i]] + ", ");
            ++i;
        }
        System.out.println(testArray[index[length - 1]] + "##");
        System.out.flush();
    }

    public static double ctg(double a, double b, double c) {
        double s = (a + b + c) / 2.0;
        double t1 = s * (s - a);
        double t2 = (s - b) * (s - c);
        double ctg = 2.0 * Math.sqrt(t1 * t2);
        ctg = ctg < 1.0E-10 ? 0.0 : (t1 - t2) / ctg;
        return ctg;
    }

    public static void ctg(double[] ctg, double a, double b, double c) {
        double s = (a + b + c) / 2.0;
        double area2 = 2.0 * Math.sqrt(s * (s - a) * (s - b) * (s - c));
        if (area2 < 1.0E-10) {
            ctg[2] = 0.0;
            ctg[1] = 0.0;
            ctg[0] = 0.0;
            return;
        }
        ctg[0] = (s * (s - a) - (s - b) * (s - c)) / area2;
        ctg[1] = (s * (s - b) - (s - a) * (s - c)) / area2;
        ctg[2] = (s * (s - c) - (s - b) * (s - a)) / area2;
    }

    public static int factorial(int n) {
        int MAX_FACTORIAL = 33;
        if (n <= 1) {
            return 1;
        }
        if (n >= MAX_FACTORIAL) {
            PsDebug.warning("factorial: argument too big");
            return Integer.MAX_VALUE;
        }
        int[] fac = new int[MAX_FACTORIAL];
        fac[1] = 1;
        fac[0] = 1;
        int i = 2;
        while (i < MAX_FACTORIAL) {
            fac[i] = i * fac[i - 1];
            ++i;
        }
        return fac[n];
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double atanh(double x) {
        return Math.log((1.0 + x) / (1.0 - x)) / 2.0;
    }

    public static double acoth(double x) {
        return Math.log((1.0 + x) / (x - 1.0)) / 2.0;
    }
}

