/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuReflect {
    public static PdMatrix planeReflect(PdVector a, PdVector normal) {
        PdVector dir = new PdVector(3);
        dir.m_data[0] = normal.m_data[0];
        dir.m_data[1] = normal.m_data[1];
        dir.m_data[2] = normal.m_data[2];
        if (!dir.normalize()) {
            PsDebug.notify("normal has zero length");
            return null;
        }
        double x = dir.m_data[0];
        double y = dir.m_data[1];
        double z = dir.m_data[2];
        double proj = PdVector.dot(a, dir);
        PdMatrix mat = new PdMatrix(4, 4);
        mat.m_data[0][0] = 1.0 - 2.0 * x * x;
        mat.m_data[0][1] = -2.0 * x * y;
        mat.m_data[0][2] = -2.0 * x * z;
        mat.m_data[0][3] = 2.0 * x * proj;
        mat.m_data[1][0] = -2.0 * x * y;
        mat.m_data[1][1] = 1.0 - 2.0 * y * y;
        mat.m_data[1][2] = -2.0 * y * z;
        mat.m_data[1][3] = 2.0 * y * proj;
        mat.m_data[2][0] = -2.0 * x * z;
        mat.m_data[2][1] = -2.0 * y * z;
        mat.m_data[2][2] = 1.0 - 2.0 * z * z;
        mat.m_data[2][3] = 2.0 * z * proj;
        mat.m_data[3][0] = 0.0;
        mat.m_data[3][1] = 0.0;
        mat.m_data[3][2] = 0.0;
        mat.m_data[3][3] = 1.0;
        return mat;
    }

    public static PdMatrix pointReflect(PdVector p) {
        PdMatrix mat = new PdMatrix(4, 4);
        mat.m_data[0][0] = -1.0;
        mat.m_data[0][1] = 0.0;
        mat.m_data[0][2] = 0.0;
        mat.m_data[0][3] = 2.0 * p.m_data[0];
        mat.m_data[1][0] = 0.0;
        mat.m_data[1][1] = -1.0;
        mat.m_data[1][2] = 0.0;
        mat.m_data[1][3] = 2.0 * p.m_data[1];
        mat.m_data[2][0] = 0.0;
        mat.m_data[2][1] = 0.0;
        mat.m_data[2][2] = -1.0;
        mat.m_data[2][3] = 2.0 * p.m_data[2];
        mat.m_data[3][0] = 0.0;
        mat.m_data[3][1] = 0.0;
        mat.m_data[3][2] = 0.0;
        mat.m_data[3][3] = 1.0;
        return mat;
    }

    public static PdMatrix rotateLine(PdVector base, PdVector axis) {
        if (base == null || base.getSize() < 3) {
            PsDebug.warning("argument base missing or dimension too small");
            return null;
        }
        if (axis == null || axis.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return null;
        }
        double px = base.m_data[0];
        double py = base.m_data[1];
        double pz = base.m_data[2];
        PdVector dir = axis;
        double dx = dir.m_data[0];
        double dy = dir.m_data[1];
        double dz = dir.m_data[2];
        double dd = dir.sqrLength();
        PdMatrix mat = new PdMatrix(4, 4);
        mat.m_data[0][0] = 2.0 * dx * dx / dd;
        mat.m_data[0][1] = 2.0 * dy * dx / dd;
        mat.m_data[0][2] = 2.0 * dz * dx / dd;
        mat.m_data[0][3] = 2.0 * px - mat.m_data[0][0] * px - mat.m_data[0][1] * py - mat.m_data[0][2] * pz;
        mat.m_data[1][0] = mat.m_data[0][1];
        mat.m_data[1][1] = 2.0 * dy * dy / dd;
        mat.m_data[1][2] = 2.0 * dz * dy / dd;
        mat.m_data[1][3] = 2.0 * py - mat.m_data[1][0] * px - mat.m_data[1][1] * py - mat.m_data[1][2] * pz;
        mat.m_data[2][0] = mat.m_data[0][2];
        mat.m_data[2][1] = mat.m_data[1][2];
        mat.m_data[2][2] = 2.0 * dz * dz / dd;
        mat.m_data[2][3] = 2.0 * pz - mat.m_data[2][0] * px - mat.m_data[2][1] * py - mat.m_data[2][2] * pz;
        double[] dArray = mat.m_data[0];
        dArray[0] = dArray[0] - 1.0;
        double[] dArray2 = mat.m_data[1];
        dArray2[1] = dArray2[1] - 1.0;
        double[] dArray3 = mat.m_data[2];
        dArray3[2] = dArray3[2] - 1.0;
        mat.m_data[3][0] = 0.0;
        mat.m_data[3][1] = 0.0;
        mat.m_data[3][2] = 0.0;
        mat.m_data[3][3] = 1.0;
        return mat;
    }

    public static PdMatrix rotateLine(PdVector base, PdVector axis, double fi) {
        if (base == null || base.getSize() < 3) {
            PsDebug.warning("argument base missing or dimension too small");
            return null;
        }
        if (axis == null || axis.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return null;
        }
        PdVector dir = new PdVector(3);
        dir.m_data[0] = axis.m_data[0];
        dir.m_data[1] = axis.m_data[1];
        dir.m_data[2] = axis.m_data[2];
        if (!dir.normalize()) {
            PsDebug.notify("dir has zero length");
            return null;
        }
        double cosfi = Math.cos(fi);
        double sinfi = Math.sin(fi);
        PdMatrix mat = new PdMatrix(4, 4);
        mat.m_data[0][0] = cosfi + (1.0 - cosfi) * dir.m_data[0] * dir.m_data[0];
        mat.m_data[0][1] = -sinfi * dir.m_data[2] + (1.0 - cosfi) * dir.m_data[0] * dir.m_data[1];
        mat.m_data[0][2] = sinfi * dir.m_data[1] + (1.0 - cosfi) * dir.m_data[0] * dir.m_data[2];
        mat.m_data[0][3] = base.m_data[0] - mat.m_data[0][0] * base.m_data[0] - mat.m_data[0][1] * base.m_data[1] - mat.m_data[0][2] * base.m_data[2];
        mat.m_data[1][0] = sinfi * dir.m_data[2] + (1.0 - cosfi) * dir.m_data[0] * dir.m_data[1];
        mat.m_data[1][1] = cosfi + (1.0 - cosfi) * dir.m_data[1] * dir.m_data[1];
        mat.m_data[1][2] = -sinfi * dir.m_data[0] + (1.0 - cosfi) * dir.m_data[1] * dir.m_data[2];
        mat.m_data[1][3] = base.m_data[1] - mat.m_data[1][0] * base.m_data[0] - mat.m_data[1][1] * base.m_data[1] - mat.m_data[1][2] * base.m_data[2];
        mat.m_data[2][0] = -sinfi * dir.m_data[1] + (1.0 - cosfi) * dir.m_data[0] * dir.m_data[2];
        mat.m_data[2][1] = sinfi * dir.m_data[0] + (1.0 - cosfi) * dir.m_data[1] * dir.m_data[2];
        mat.m_data[2][2] = cosfi + (1.0 - cosfi) * dir.m_data[2] * dir.m_data[2];
        mat.m_data[2][3] = base.m_data[2] - mat.m_data[2][0] * base.m_data[0] - mat.m_data[2][1] * base.m_data[1] - mat.m_data[2][2] * base.m_data[2];
        mat.m_data[3][0] = 0.0;
        mat.m_data[3][1] = 0.0;
        mat.m_data[3][2] = 0.0;
        mat.m_data[3][3] = 1.0;
        return mat;
    }

    public static PdMatrix translate(PdVector vec) {
        PdMatrix mat = new PdMatrix(4, 4);
        mat.setIdentity();
        mat.m_data[0][3] = vec.m_data[0];
        mat.m_data[1][3] = vec.m_data[1];
        mat.m_data[2][3] = vec.m_data[2];
        return mat;
    }

    public static boolean makeRotation(PdMatrix mat, PdVector axis, double angle) {
        if (mat == null) {
            PsDebug.warning("missing matrix argument");
            return false;
        }
        if (axis == null || axis.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return false;
        }
        PdVector dir = new PdVector(3);
        dir.m_data[0] = axis.m_data[0];
        dir.m_data[1] = axis.m_data[1];
        dir.m_data[2] = axis.m_data[2];
        if (!dir.normalize()) {
            PsDebug.notify("dir has zero length");
            return false;
        }
        double wcos = Math.cos(angle);
        double wsin = Math.sin(angle);
        double emwcos = 1.0 - wcos;
        double xt = dir.m_data[0];
        double yt = dir.m_data[1];
        double zt = dir.m_data[2];
        mat.m_data[0][0] = wcos + emwcos * xt * xt;
        mat.m_data[0][1] = -zt * wsin + emwcos * xt * yt;
        mat.m_data[0][2] = yt * wsin + emwcos * xt * zt;
        mat.m_data[1][0] = zt * wsin + emwcos * xt * yt;
        mat.m_data[1][1] = wcos + emwcos * yt * yt;
        mat.m_data[1][2] = -xt * wsin + emwcos * yt * zt;
        mat.m_data[2][0] = -yt * wsin + emwcos * xt * zt;
        mat.m_data[2][1] = xt * wsin + emwcos * yt * zt;
        mat.m_data[2][2] = wcos + emwcos * zt * zt;
        return true;
    }

    public static PdMatrix scale(PdVector vec) {
        PdMatrix mat = new PdMatrix(4, 4);
        mat.setIdentity();
        mat.setDiagonal(vec);
        return mat;
    }

    public static PdMatrix planeReflect(PdVector a, PdVector b, PdVector c) {
        PdVector normal = new PdVector(3);
        normal.normalOfPlane(a, b, c);
        double x = normal.m_data[0];
        double y = normal.m_data[1];
        double z = normal.m_data[2];
        double proj = PdVector.dot(a, normal);
        PdMatrix mat = new PdMatrix(4, 4);
        mat.m_data[0][0] = 1.0 - 2.0 * x * x;
        mat.m_data[0][1] = -2.0 * x * y;
        mat.m_data[0][2] = -2.0 * x * z;
        mat.m_data[0][3] = 2.0 * x * proj;
        mat.m_data[1][0] = -2.0 * x * y;
        mat.m_data[1][1] = 1.0 - 2.0 * y * y;
        mat.m_data[1][2] = -2.0 * y * z;
        mat.m_data[1][3] = 2.0 * y * proj;
        mat.m_data[2][0] = -2.0 * x * z;
        mat.m_data[2][1] = -2.0 * y * z;
        mat.m_data[2][2] = 1.0 - 2.0 * z * z;
        mat.m_data[2][3] = 2.0 * z * proj;
        mat.m_data[3][0] = 0.0;
        mat.m_data[3][1] = 0.0;
        mat.m_data[3][2] = 0.0;
        mat.m_data[3][3] = 1.0;
        return mat;
    }
}

