/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;

public class PvCamera_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvCamera m_camera;
    protected PvDisplay m_disp;
    protected CheckboxGroup m_gProjection;
    protected Checkbox m_rPerspective;
    protected Checkbox m_rTop;
    protected Checkbox m_rFront;
    protected Checkbox m_rRight;
    protected PsPanel m_pOrient;
    protected Panel m_pOrient2;
    protected Checkbox m_cOrient;
    protected Checkbox m_cLocal;
    protected CheckboxGroup m_gTransform;
    protected Checkbox m_rCameraTransform;
    protected Checkbox m_rModelTransform;
    protected Checkbox m_rAmbientTransform;
    protected int m_spaceMode = 3;
    protected Choice m_cAmbient;
    protected Label m_lAmbient;
    protected Choice m_cProj;
    protected Label m_lProj;
    protected PdVector m_viewDir;
    protected PdVector_IP m_pViewDir;
    protected PdVector m_interest;
    protected PdVector_IP m_pInterest;
    protected PuDouble m_dist;
    protected PsPanel m_pDist;
    protected Panel m_pClip;
    protected Checkbox m_cClip;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bReset;
    protected Button m_bResetAll;
    private static /* synthetic */ Class class$jv$viewer$PvCamera_IP;

    private void setAmbientSpace(int spaceMode) {
        int i;
        if (spaceMode != this.m_spaceMode) {
            this.m_cAmbient.removeAll();
            this.m_cProj.removeAll();
            i = 0;
            while (i < PgGeometryIf.AMBIENT_SPACES[spaceMode].length) {
                this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[spaceMode][i]);
                ++i;
            }
            switch (spaceMode) {
                case 0: 
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    this.m_cAmbient.select(0);
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: {
                    this.m_cAmbient.select(1);
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    this.m_cAmbient.select(2);
                    break;
                }
            }
            this.m_spaceMode = spaceMode;
        }
        if (this.m_cProj.getItemCount() == 0) {
            i = 0;
            while (i < PgGeometryIf.AMBIENT_PROJECTIONS[spaceMode].length) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[spaceMode][i]);
                ++i;
            }
        }
        int projMode = this.m_disp.getAmbientProjection();
        if (this.m_cProj.getSelectedIndex() != projMode) {
            if (this.m_cProj.getItemCount() > projMode + 1) {
                this.m_cProj.select(projMode);
            } else {
                PsDebug.warning("ambient projection not updated");
            }
        }
    }

    public PvCamera_IP() {
        if (this.getClass() == (class$jv$viewer$PvCamera_IP != null ? class$jv$viewer$PvCamera_IP : (class$jv$viewer$PvCamera_IP = PvCamera_IP.class$("jv.viewer.PvCamera_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_camera == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_rPerspective) {
            PsDebug.notify("perspective");
            this.m_disp.selectCamera(0);
            this.m_camera.update(null);
        } else if (source == this.m_rTop) {
            PsDebug.notify("ortho xy");
            this.m_disp.selectCamera(1);
            this.m_camera.update(null);
        } else if (source == this.m_rFront) {
            PsDebug.notify("ortho xz");
            this.m_disp.selectCamera(2);
            this.m_camera.update(null);
        } else if (source == this.m_rRight) {
            PsDebug.notify("ortho yz");
            this.m_disp.selectCamera(3);
            this.m_camera.update(null);
        } else if (source == this.m_cOrient) {
            PsDebug.notify("orient");
            this.m_pViewDir.setEnabled(this.m_cOrient.getState());
            this.m_pInterest.setEnabled(this.m_cOrient.getState());
            this.m_dist.setEnabled(this.m_cOrient.getState());
            this.m_camera.m_roll.setEnabled(this.m_cOrient.getState());
        } else if (source == this.m_cLocal) {
            PsDebug.notify("local");
            this.m_disp.setEnabledLocalTransform(this.m_cLocal.getState());
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_rCameraTransform) {
            PsDebug.notify("camera transform");
            this.m_disp.setTransformationMode(0);
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_rModelTransform) {
            PsDebug.notify("model transform");
            this.m_disp.setTransformationMode(1);
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_rAmbientTransform) {
            PsDebug.notify("ambient model transform");
            this.m_disp.setTransformationMode(2);
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_cAmbient) {
            PsDebug.notify("ambient space");
            int ind = this.m_cAmbient.getSelectedIndex();
            int ambDim = this.m_disp.getAmbientDim();
            switch (ind) {
                case 0: {
                    if (this.m_spaceMode == 0 || this.m_spaceMode == 1 || this.m_spaceMode == 3 || this.m_spaceMode == 6 || this.m_spaceMode == 9) {
                        return;
                    }
                    if (ambDim == 2) {
                        this.m_spaceMode = 1;
                        break;
                    }
                    if (ambDim == 3) {
                        this.m_spaceMode = 3;
                        break;
                    }
                    if (ambDim == 4) {
                        this.m_spaceMode = 6;
                        break;
                    }
                    if (ambDim != 5) break;
                    this.m_spaceMode = 9;
                    break;
                }
                case 1: {
                    if (this.m_spaceMode == 2 || this.m_spaceMode == 4 || this.m_spaceMode == 7 || this.m_spaceMode == 10) {
                        return;
                    }
                    if (ambDim == 2) {
                        this.m_spaceMode = 2;
                        break;
                    }
                    if (ambDim == 3) {
                        this.m_spaceMode = 4;
                        break;
                    }
                    if (ambDim == 4) {
                        this.m_spaceMode = 7;
                        break;
                    }
                    if (ambDim != 5) break;
                    this.m_spaceMode = 10;
                    break;
                }
                case 2: {
                    if (this.m_spaceMode == 5 || this.m_spaceMode == 8 || this.m_spaceMode == 11) {
                        return;
                    }
                    if (ambDim == 3) {
                        this.m_spaceMode = 5;
                        break;
                    }
                    if (ambDim == 4) {
                        this.m_spaceMode = 8;
                        break;
                    }
                    if (ambDim != 5) break;
                    this.m_spaceMode = 11;
                    break;
                }
            }
            this.m_disp.setAmbientSpace(this.m_spaceMode);
            this.m_cProj.removeAll();
            int i = 0;
            while (i < PgGeometryIf.AMBIENT_PROJECTIONS[this.m_spaceMode].length) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[this.m_spaceMode][i]);
                ++i;
            }
            if (this.m_disp.getAmbientProjection() >= this.m_cProj.getItemCount()) {
                this.m_disp.setAmbientProjection(0);
            }
            this.m_cProj.select(this.m_disp.getAmbientProjection());
            this.m_disp.update(this.m_disp);
        } else if (source == this.m_cProj) {
            PsDebug.notify("ambient proj");
            this.m_disp.setAmbientProjection(this.m_cProj.getSelectedIndex());
            this.m_disp.update(this.m_disp);
        } else if (source == this.m_cClip) {
            PsDebug.notify("switch clipping");
            this.m_disp.setEnabledClip(this.m_cClip.getState());
            this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
            this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
            PdVector[] bndBox = this.m_camera.getBounds();
            if (this.m_cClip.getState() && bndBox != null) {
                double near;
                double far;
                if (bndBox[1].m_data[2] < bndBox[0].m_data[2]) {
                    far = bndBox[1].m_data[2];
                    near = bndBox[0].m_data[2];
                } else {
                    far = bndBox[0].m_data[2];
                    near = bndBox[1].m_data[2];
                }
                this.m_camera.m_nearClip.setBounds(far - (-far + near) / 2.0, near + (-far + near) / 2.0, 0.02, 1.0);
                this.m_camera.m_farClip.setBounds(far - (-far + near) / 2.0, near + (-far + near) / 2.0, 0.02, 1.0);
                this.m_camera.m_nearClip.setValue(near);
                this.m_camera.m_farClip.setValue(far);
            }
            this.m_camera.update(null);
        }
    }

    public void setParent(PsUpdateIf aCamera) {
        if (aCamera == null) {
            PsDebug.warning("missing camera");
            return;
        }
        super.setParent(aCamera);
        this.m_camera = (PvCamera)aCamera;
        this.m_disp = this.m_camera.m_display;
        this.m_pOrient2.removeAll();
        this.m_pOrient2.add(this.m_camera.m_roll.getInfoPanel());
        this.m_pOrient2.validate();
        this.m_pViewDir.setEnabled(this.m_cOrient.getState());
        this.m_pInterest.setEnabled(this.m_cOrient.getState());
        this.m_dist.setEnabled(this.m_cOrient.getState());
        this.m_camera.m_roll.setEnabled(this.m_cOrient.getState());
        this.m_pClip.removeAll();
        this.m_pClip.add(this.m_camera.m_nearClip.getInfoPanel());
        this.m_pClip.add(this.m_camera.m_farClip.getInfoPanel());
        this.m_pClip.validate();
        this.m_cClip.setState(this.m_camera.m_bEnableClip);
        this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
        this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
        this.setTransformationMode(this.m_disp.getTransformationMode());
        switch (this.m_camera.getProjectionMode()) {
            default: {
                PsDebug.warning("unknown projection mode = " + this.m_camera.getProjectionMode());
            }
            case 0: {
                this.m_gProjection.setSelectedCheckbox(this.m_rPerspective);
                break;
            }
            case 1: {
                this.m_gProjection.setSelectedCheckbox(this.m_rTop);
                break;
            }
            case 2: {
                this.m_gProjection.setSelectedCheckbox(this.m_rFront);
                break;
            }
            case 3: {
                this.m_gProjection.setSelectedCheckbox(this.m_rRight);
                break;
            }
        }
        this.setTitle(PsConfig.getMessage("Camera") + ": " + this.m_disp.getName());
    }

    public boolean update(Object object) {
        if (this.m_camera == null) {
            PsDebug.warning("missing camera");
            return false;
        }
        if (object == this.m_camera) {
            this.m_disp = this.m_camera.m_display;
            this.m_viewDir.copy(this.m_camera.getViewDir());
            this.m_pViewDir.update(this.m_viewDir);
            this.m_interest.copy(this.m_camera.getInterest());
            this.m_pInterest.update(this.m_interest);
            this.m_dist.setValue(this.m_camera.getDist());
            this.m_camera.getRoll();
            if (this.m_cClip.getState() != this.m_camera.m_bEnableClip) {
                this.m_cClip.setState(this.m_camera.m_bEnableClip);
                this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
                this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
            }
            if (this.m_cLocal.getState() != this.m_disp.isEnabledLocalTransform()) {
                this.m_cLocal.setState(this.m_disp.isEnabledLocalTransform());
            }
            this.setTransformationMode(this.m_disp.getTransformationMode());
            this.setAmbientSpace(this.m_disp.getAmbientSpace());
            return true;
        }
        if (object == this) {
            PsDebug.notify("this called");
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            this.m_camera.setInterest(this.m_pInterest.getVector());
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        if (object == this.m_pViewDir) {
            PsDebug.notify("(m_pViewDir) called");
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_pInterest) {
            PsDebug.notify("(m_pInterest) called");
            this.m_camera.setInterest(this.m_pInterest.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_dist) {
            PsDebug.notify("(m_dist) called");
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_camera == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_bCenter) {
            this.m_disp.center();
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_bFit) {
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_bReset) {
            PdMatrix mat;
            int mode = this.m_disp.getTransformationMode();
            if (mode == 0) {
                this.m_camera.init();
            } else if (mode == 1) {
                PdMatrix mat2 = this.m_disp.getTransMatrix(8);
                if (mat2 != null) {
                    mat2.setIdentity();
                    mat2 = this.m_disp.getTransMatrix(256);
                    mat2.setIdentity();
                }
            } else if (mode == 2 && (mat = this.m_disp.getTransMatrix(512)) != null) {
                mat.setIdentity();
                mat = this.m_disp.getTransMatrix(1024);
                mat.setIdentity();
            }
            this.m_camera.update(this.m_camera);
        } else if (source == this.m_bResetAll) {
            this.m_disp.resetTransformModel();
            this.m_camera.init();
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
        }
    }

    private void setTransformationMode(int mode) {
        Checkbox currCb = this.m_gTransform.getSelectedCheckbox();
        Checkbox newCb = null;
        switch (mode) {
            default: {
                PsDebug.warning("unknown transformation mode = " + mode);
            }
            case 0: {
                newCb = this.m_rCameraTransform;
                break;
            }
            case 1: {
                newCb = this.m_rModelTransform;
                break;
            }
            case 2: {
                newCb = this.m_rAmbientTransform;
                break;
            }
        }
        if (currCb != newCb) {
            this.m_gTransform.setSelectedCheckbox(newCb);
        }
        this.m_cLocal.setEnabled(mode != 2);
        this.m_cAmbient.setEnabled(mode == 2);
        this.m_lAmbient.setEnabled(mode == 2);
        this.m_cProj.setEnabled(mode == 2);
        this.m_lProj.setEnabled(mode == 2);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        Panel pProjection = new Panel();
        pProjection.setLayout(new GridLayout(2, 2));
        this.add(pProjection);
        this.m_gProjection = new CheckboxGroup();
        this.m_rPerspective = new Checkbox(PsConfig.getMessage("rPerspective"), this.m_gProjection, true);
        this.m_rPerspective.addItemListener(this);
        pProjection.add(this.m_rPerspective);
        this.m_rTop = new Checkbox(PsConfig.getMessage("rTop"), this.m_gProjection, false);
        this.m_rTop.addItemListener(this);
        pProjection.add(this.m_rTop);
        this.m_rFront = new Checkbox(PsConfig.getMessage("rFront"), this.m_gProjection, false);
        this.m_rFront.addItemListener(this);
        pProjection.add(this.m_rFront);
        this.m_rRight = new Checkbox(PsConfig.getMessage("rRight"), this.m_gProjection, false);
        this.m_rRight.addItemListener(this);
        pProjection.add(this.m_rRight);
        this.addLine(1);
        this.m_pOrient = new PsPanel();
        this.m_pOrient.addTitle(PsConfig.getMessage("pPosition"));
        this.add(this.m_pOrient);
        this.m_cOrient = new Checkbox("Position");
        this.m_cOrient.setState(true);
        this.m_pViewDir = new PdVector_IP();
        this.m_pViewDir.setTitle(PsConfig.getMessage("pViewDir"));
        this.m_pViewDir.setParent(this);
        this.m_viewDir = new PdVector(3);
        this.m_pViewDir.setVector(this.m_viewDir);
        this.m_pOrient.add(this.m_pViewDir);
        this.m_pInterest = new PdVector_IP();
        this.m_pInterest.setTitle(PsConfig.getMessage("pInterest"));
        this.m_pInterest.setParent(this);
        this.m_interest = new PdVector(3);
        this.m_pInterest.setVector(this.m_interest);
        this.m_pOrient.add(this.m_pInterest);
        this.m_dist = new PuDouble(PsConfig.getMessage("dist"), this);
        this.m_dist.setBounds(0.001, 100.0, 1.0, 10.0);
        this.m_dist.setValue(10.0);
        this.m_pDist = this.m_dist.getInfoPanel();
        this.m_pOrient.add(this.m_pDist);
        this.m_pOrient2 = new PsPanel();
        this.m_pOrient2.setLayout(new GridLayout(1, 1));
        this.add(this.m_pOrient2);
        this.addLine(1);
        PsPanel pTransform = new PsPanel();
        this.add(pTransform);
        PsPanel pTransHeader = new PsPanel();
        pTransHeader.setLayout(new GridLayout(1, 2));
        pTransHeader.addTitle(PsConfig.getMessage("rTransform"));
        this.m_cLocal = new Checkbox(PsConfig.getMessage("rCameraLocal"), true);
        this.m_cLocal.addItemListener(this);
        pTransHeader.add(this.m_cLocal);
        pTransform.add(pTransHeader);
        PsPanel pTypes = new PsPanel();
        pTypes.setLayout(new GridLayout(1, 3));
        pTransform.add(pTypes);
        this.m_gTransform = new CheckboxGroup();
        this.m_rCameraTransform = new Checkbox(PsConfig.getMessage("rCameraTransform"), this.m_gTransform, true);
        this.m_rCameraTransform.addItemListener(this);
        pTypes.add(this.m_rCameraTransform);
        this.m_rModelTransform = new Checkbox(PsConfig.getMessage("rModelTransform"), this.m_gTransform, false);
        this.m_rModelTransform.addItemListener(this);
        pTypes.add(this.m_rModelTransform);
        this.m_rAmbientTransform = new Checkbox(PsConfig.getMessage("rAmbientTransform"), this.m_gTransform, false);
        this.m_rAmbientTransform.addItemListener(this);
        pTypes.add(this.m_rAmbientTransform);
        PsPanel pAmbient = new PsPanel();
        pAmbient.setLayout(new GridLayout(2, 2));
        this.add(pAmbient);
        this.m_lAmbient = new Label(PsConfig.getMessage("cAmbient"));
        pAmbient.add(this.m_lAmbient);
        this.m_cAmbient = new Choice();
        this.m_cAmbient.addItemListener(this);
        int i = 0;
        while (i < PgGeometryIf.AMBIENT_SPACES[this.m_spaceMode].length) {
            this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[this.m_spaceMode][i]);
            ++i;
        }
        pAmbient.add(this.m_cAmbient);
        this.m_lProj = new Label(PsConfig.getMessage("cProj"));
        pAmbient.add(this.m_lProj);
        this.m_cProj = new Choice();
        this.m_cProj.addItemListener(this);
        pAmbient.add(this.m_cProj);
        this.addLine(1);
        this.m_cClip = new Checkbox(PsConfig.getMessage("cClip"));
        this.m_cClip.addItemListener(this);
        this.m_cClip.setFont(PsConfig.getFont(3));
        this.m_cClip.setState(false);
        this.add(this.m_cClip);
        this.m_pClip = new PsPanel();
        this.m_pClip.setLayout(new GridLayout(2, 1));
        this.add(this.m_pClip);
        Panel pBottomButtons = new Panel();
        pBottomButtons.setLayout(new FlowLayout(1));
        this.add(pBottomButtons);
        this.m_bCenter = new Button(PsConfig.getMessage("bCenter"));
        this.m_bCenter.addActionListener(this);
        pBottomButtons.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage("bFit"));
        this.m_bFit.addActionListener(this);
        pBottomButtons.add(this.m_bFit);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        pBottomButtons.add(this.m_bReset);
        this.m_bResetAll = new Button(PsConfig.getMessage("bResetAll"));
        this.m_bResetAll.addActionListener(this);
        pBottomButtons.add(this.m_bResetAll);
    }
}

