/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuProj;
import jv.viewer.PvDisplay;
import jv.viewer.PvScene;
import jv.viewer.PvThickGraphics;

final class PvGeometry
extends PgJvxSrc
implements PvGeometryIf {
    protected PvDisplayIf m_display;
    protected PgGeometryIf m_geometry;
    protected static int PS_ZOOM = 1;
    protected Color m_backColor;
    protected boolean m_bShowEdgeAura;
    protected int m_drawingOrder = 0;
    protected PdVector[] m_bndBox;
    protected PiVector[] m_bndBoxTrans;
    protected Color m_globalBndboxColor;
    private int m_dimTrans;
    protected int m_dimOfColors;
    protected int m_pickedVertex;
    protected int[] m_texturePix;
    protected int m_textureWidth;
    protected int m_textureHeight;
    protected int m_textureDepth = 256;
    protected boolean m_bEnableZBuffer = false;
    protected PdVector[] m_faceTextureBnd;
    protected PiVector[] m_faceDestBnd;
    private int prevElemHeight;
    private int prevElemWidth;
    private transient Image m_destImage;
    private int imgHeight;
    private int imgWidth;
    private transient MemoryImageSource mis;
    protected int m_alpha;
    protected boolean m_bShowTransparency;
    protected boolean m_bShowVectors;
    private boolean m_bHasTaggedVertices;
    protected int m_numPolygonEdges;
    protected boolean m_bHasTaggedPolygons;
    protected boolean m_bHasTaggedEdges;
    protected boolean m_bHasTaggedBoundaries;
    protected boolean m_bHasTaggedElements;
    private boolean m_bHasNeighbours;
    private PdVector m_vt;
    protected PiVector[] m_vertexTrans;
    protected PiVector[] m_vertexNormalTrans;
    protected PiVector[] m_elementNormalTrans;
    protected PiVector[][] m_vectorTrans;
    protected boolean m_useVertices;
    protected boolean m_useUnusedVertices;
    protected boolean m_useElements;
    protected boolean m_usePolygons;
    private int[] xv = new int[this.m_maxDimOfElements];
    private int[] yv = new int[this.m_maxDimOfElements];
    private int[] zv = new int[this.m_maxDimOfElements];
    private double m_grey = 200.0;
    private double m_greyElem = 30.0;
    private boolean m_elemIsClipped;
    private int[] m_origInd = new int[this.m_maxDimOfElements];
    private PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgeOnce;
    protected boolean m_bEnableClip;
    protected double m_clipFar;
    protected double m_clipNear;
    protected PvScene m_scene;
    protected Dimension m_dispSize;
    private double m_heightFac;
    private double m_itemHeight;
    private boolean m_bShowCurrElement = false;
    private boolean m_bShowCurrEdge = false;
    private boolean m_bDrawingEdge = false;
    private boolean m_bDepthcueEdge = false;
    private boolean m_bUse_m_heightFac = false;
    private PdVector[] texCoord = null;
    private int[] xvSub = new int[3];
    private int[] yvSub = new int[3];
    private int[] zvSub = new int[3];
    private PdVector[] texSub = new PdVector[3];
    private int[][] elemSub = new int[this.m_maxDimOfElements][3];
    private int[] indVec = new int[this.m_maxDimOfElements];
    private PdVector[] currVertex = PdVector.realloc(null, this.m_maxDimOfElements, 3);
    private double[] angle = new double[this.m_maxDimOfElements];
    protected double[] m_elemCenter;
    protected PdVector m_lightDir = new PdVector(0.0, 0.7071, 0.7071);
    private static int MIS_IMAGE_OUTSIDE = -1;
    protected static int MIS_IMAGE_REQUIRED = 0;
    protected static int MIS_IMAGE_REDRAW = 1;
    private int[] m_elemMin = new int[2];
    private int[] m_elemMax = new int[2];
    private int m_elemWidth = 0;
    private int m_elemHeight = 0;
    protected boolean m_bNewZBuffer = false;
    private int m_currElementCol = -16777216;
    private int m_currEdgeCol = -16777216;
    private int m_currVertexCol = -16777216;
    private static int m_colMark = 254;
    private static int NNW = 1;
    private static int NWW = 2;
    private static int SWW = 3;
    private static int SSW = 4;
    private static int SSE = 5;
    private static int SEE = 6;
    private static int NEE = 7;
    private static int NNE = 8;
    private PiVector m_unusedVertex = new PiVector();
    private int m_numUnusedVertices = 0;
    PdMatrix m_projMat;
    PdMatrix m_viewMat;
    private PdVector vt = new PdVector(this.m_dim + 1);
    private PdVector vtExact = new PdVector(this.m_dim);
    int[] m_position = null;
    protected static int m_zMin = Integer.MAX_VALUE;
    protected static int m_zMax = Integer.MIN_VALUE;
    PdVector elemCenter = new PdVector(3);
    PiVector elemCenterTrans = new PiVector(3);

    private void drawVector_(Graphics g, int size, int x1, int y1, int z1, int x2, int y2, int z2, boolean showTip, Color col) {
        this.drawVector_(g, size, x1, y1, z1, x2, y2, z1, true, showTip, col);
    }

    private void drawVector_(Graphics g, int size, int x1, int y1, int z1, int x2, int y2, int z2, boolean bScale, boolean showTip, Color col) {
        this.drawLine(g, size, x1, y1, z1, x2, y2, z2, col);
        if (showTip) {
            this.drawVectorTip(g, size, x1, y1, z1, x2, y2, z2, bScale, col);
        }
    }

    private Color getEdgeColor_(int elemInd) {
        Color currCol;
        if (this.m_bShowTaggedEdges && this.m_bHasTaggedEdges && this.m_element[elemInd].hasTag(1)) {
            currCol = this.m_globalEdgeTagColor;
        } else {
            currCol = this.m_bShowEdgeColors && this.m_edgeColor != null ? this.m_edgeColor[elemInd] : this.m_globalEdgeColor;
            if (this.m_bShowDepthcue && !this.m_bShowElements && !this.m_bEnableZBuffer) {
                currCol = PdColor.getDimmedColor(currCol, this.m_heightFac, this.m_grey * (1.0 - this.m_heightFac));
            }
        }
        return currCol;
    }

    public boolean setVectorList(int ind, PdVector[] vector) {
        this.setVectors(ind, vector);
        return true;
    }

    public boolean hasTagPolygon(int anIndex, int aTag) {
        return this.m_polygon[anIndex].hasTag(aTag);
    }

    public int addPolygon(PiVector aPolygon) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.m_polygon[this.m_numPolygons - 1].setSize(aPolygon.getSize());
        this.m_polygon[this.m_numPolygons - 1].copy(aPolygon);
        this.computeNumPolygonEdges();
        return this.m_numPolygons - 1;
    }

    public void setState(int aKey, boolean aState) {
        switch (aKey) {
            case 85: {
                this.m_bDefaultLabelEnabled = aState;
                break;
            }
            case 86: {
                this.m_bShowTitle = aState;
                break;
            }
            case 80: {
                this.m_bShowIndices = aState;
                break;
            }
            case 81: {
                this.m_bShowVertexLabels = aState;
                break;
            }
            case 82: {
                this.m_bShowPolygonLabels = aState;
                break;
            }
            case 83: {
                this.m_bShowEdgeLabels = aState;
                break;
            }
            case 84: {
                this.m_bShowElementLabels = aState;
                break;
            }
            case 50: {
                this.m_bShowVertices = aState;
                break;
            }
            case 51: {
                this.m_bShowTaggedVertices = aState;
                break;
            }
            case 52: {
                this.m_bShowEdges = aState;
                break;
            }
            case 53: {
                this.m_bShowTaggedEdges = aState;
                break;
            }
            case 87: {
                this.m_bShowOutline = aState;
                break;
            }
            case 54: {
                this.m_bShowPolygons = aState;
                break;
            }
            case 55: {
                this.m_bShowTaggedPolygons = aState;
                break;
            }
            case 56: {
                this.m_bShowElements = aState;
                break;
            }
            case 57: {
                this.m_bShowTaggedElements = aState;
                break;
            }
            case 68: {
                this.m_bShowBackface = aState;
                break;
            }
            case 58: {
                this.m_bShowBoundaries = aState;
                break;
            }
            case 59: {
                this.m_bShowTaggedBoundaries = aState;
                break;
            }
            case 60: {
                this.m_bShowVertexNormals = aState;
                break;
            }
            case 62: {
                this.m_bShowElementNormals = aState;
                break;
            }
            case 64: {
                this.m_bShowPolygonNormals = aState;
                break;
            }
            case 61: {
                this.m_bShowVertexNormalArrow = aState;
                break;
            }
            case 63: {
                this.m_bShowElementNormalArrow = aState;
                break;
            }
            case 65: {
                this.m_bShowPolygonNormalArrow = aState;
                break;
            }
            case 88: {
                this.m_bShowPolygonStartArrow = aState;
                break;
            }
            case 89: {
                this.m_bShowPolygonEndArrow = aState;
                break;
            }
            case 69: {
                this.m_bShowBndBox = aState;
                break;
            }
            case 70: {
                this.m_bShowCenter = aState;
                break;
            }
            case 71: {
                this.m_bShowVertexTexture = aState;
                break;
            }
            case 72: {
                this.m_bShowElementTexture = aState;
                break;
            }
            case 73: {
                this.m_bShowTransparency = aState;
                break;
            }
            case 90: {
                this.m_bShowVertexColors = aState;
                break;
            }
            case 92: {
                this.m_bShowPolygonColors = aState;
                break;
            }
            case 93: {
                this.m_bShowEdgeColors = aState;
                break;
            }
            case 94: {
                this.m_bShowElementColors = aState;
                break;
            }
            case 99: {
                this.m_bShowElementBackColor = aState;
                break;
            }
            case 100: {
                this.m_bShowElementBackColors = aState;
                break;
            }
            default: {
                PsDebug.warning("invalid key = " + aKey);
            }
        }
    }

    protected boolean getState(int aKey) {
        switch (aKey) {
            case 50: {
                return this.m_bShowVertices;
            }
            case 69: {
                return this.m_bShowBndBox;
            }
        }
        PsDebug.warning("unsupported key = " + aKey);
        return false;
    }

    private boolean getElementBndBox(int[] min, int[] max, int[] xv, int[] yv, int len) {
        int k = 0;
        while (k < 2) {
            min[k] = Integer.MAX_VALUE;
            max[k] = Integer.MIN_VALUE;
            ++k;
        }
        int j = 0;
        while (j < len) {
            if (xv[j] < min[0]) {
                min[0] = xv[j];
            }
            if (xv[j] > max[0]) {
                max[0] = xv[j];
            }
            if (yv[j] < min[1]) {
                min[1] = yv[j];
            }
            if (yv[j] > max[1]) {
                max[1] = yv[j];
            }
            ++j;
        }
        return min[0] < this.m_dispSize.width && max[0] >= 0 && min[1] < this.m_dispSize.height && max[1] >= 0;
    }

    private int[][] triangulate(int[] xv, int[] yv, int[] zv, int len) {
        int numVertices = len;
        int i = 0;
        while (i < numVertices) {
            this.indVec[i] = (i + 1) % numVertices;
            ++i;
        }
        int maxIndPrev = -1;
        int indPrev = numVertices - 1;
        int indStart = 0;
        int numElems = 0;
        while (numElems < numVertices - 3) {
            int remainNum = numVertices - numElems;
            int ind = indStart;
            i = 0;
            while (i < remainNum) {
                this.currVertex[i].set(xv[ind], (double)yv[ind], 0.0);
                ind = this.indVec[ind];
                ++i;
            }
            PdVector.angleWithOrientation(this.angle, this.currVertex, remainNum);
            double maxAngle = Double.NEGATIVE_INFINITY;
            int maxInd = -1;
            ind = indStart;
            i = 0;
            while (i < remainNum) {
                if (this.angle[i] > maxAngle) {
                    maxAngle = this.angle[i];
                    maxInd = ind;
                    maxIndPrev = indPrev;
                }
                indPrev = ind;
                ind = this.indVec[ind];
                ++i;
            }
            if (maxInd == -1) {
                PsDebug.error("missing max angle");
                return null;
            }
            this.elemSub[numElems][0] = maxIndPrev;
            this.elemSub[numElems][1] = maxInd;
            this.elemSub[numElems][2] = this.indVec[maxInd];
            this.indVec[maxIndPrev] = this.indVec[maxInd];
            indPrev = maxIndPrev;
            indStart = this.indVec[maxInd];
            ++numElems;
        }
        this.elemSub[numElems][0] = indStart;
        this.elemSub[numElems][1] = this.indVec[indStart];
        this.elemSub[numElems][2] = this.indVec[this.indVec[indStart]];
        return this.elemSub;
    }

    private void drawLine(Graphics g, int size, int x1, int y1, int z1, int x2, int y2, int z2, Color col) {
        if (this.m_bEnableZBuffer) {
            if (size < 3) {
                this.drawLineZBuffer(g, new int[]{x1, x2}, new int[]{y1, y2}, new int[]{z1, z2}, 2, col);
            } else {
                this.drawLineZBuffer(g, size, new int[]{x1, x2}, new int[]{y1, y2}, new int[]{z1, z2}, 2, col);
            }
            return;
        }
        if (col != null) {
            g.setColor(col);
        }
        if (size < 3) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            PvThickGraphics.drawLine(g, size, x1, y1, x2, y2);
        }
    }

    protected int getZMin() {
        return m_zMin;
    }

    private void drawElementBnd(Graphics g, int elemInd, int len, int[] xv, int[] yv, int[] zv) {
        if (!(!this.m_bHasNeighbours || this.m_neighbour[elemInd].m_data.length < len || this.m_bEnableClip && this.m_elemIsClipped)) {
            int i = 0;
            while (i < len) {
                if (this.m_neighbour[elemInd].m_data[i] == -1) {
                    int i1 = (i + 1) % len;
                    int i2 = (i + 2) % len;
                    this.drawLine(g, (int)this.m_globalBndSize, xv[i1], yv[i1], zv[i1], xv[i2], yv[i2], zv[i2], this.m_globalBndColor);
                }
                ++i;
            }
        }
    }

    protected int getNumItems() {
        int numItems = 0;
        if (this.m_useVertices) {
            numItems += this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            numItems += this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            numItems += this.m_numElements;
        }
        if (this.m_usePolygons) {
            numItems += this.m_numPolygonEdges;
        }
        return numItems;
    }

    private void project(PiVector dest, PdVector src, PdMatrix projviewMat, PdMatrix modelMat) {
        double tmp;
        double scale;
        if (this.m_ambientMatrix != null) {
            this.vt.copyArray(src);
            if (this.m_position == null) {
                this.vt.m_data[this.m_dim] = 1.0;
                this.vt.leftMultMatrix(this.m_ambientMatrix);
            } else {
                if (this.vt.getSize() != this.m_ambientMatrix.getSize()) {
                    this.vt.setSize(this.m_ambientMatrix.getSize());
                }
                scale = PdVector.length(this.m_dim, this.m_ambientMatrix.m_data[0]);
                this.vt.m_data[this.m_dim] = 0.0;
                this.vt.leftMultMatrix(this.m_ambientMatrix);
                this.vt.multScalar(1.0 / scale);
            }
            this.vt.m_data[this.m_dim] = 0.0;
            src.copyArray(this.vt);
        }
        if (this.m_position == null && this.m_ambientProj != 0) {
            if (this.m_ambientMatrix != null) {
                this.vtExact.copyArray(this.vt);
            } else {
                this.vtExact.copyArray(src);
            }
            if (this.m_ambientSpace == 9 || this.m_ambientSpace == 6 || this.m_ambientSpace == 3 || this.m_ambientSpace == 1 || this.m_ambientSpace == 2 || this.m_ambientSpace == 4 || this.m_ambientSpace == 7 || this.m_ambientSpace == 10) {
                if (this.m_ambientProj == 1) {
                    PuProj.stereographic(this.vtExact, this.vtExact);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else if (this.m_ambientSpace == 5 || this.m_ambientSpace == 8 || this.m_ambientSpace == 11) {
                if (this.m_ambientProj == 2) {
                    PuProj.lorentz2Klein(this.vtExact, this.vtExact);
                } else if (this.m_ambientProj == 1) {
                    PuProj.lorentz2Poincare(this.vtExact, this.vtExact);
                } else if (this.m_ambientProj == 3) {
                    PuProj.lorentz2Uhm(this.vtExact, this.vtExact);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else {
                PsDebug.warning("unknown ambient space");
            }
            int j = 0;
            while (j < this.m_dim - 1) {
                src.m_data[j] = this.vtExact.m_data[j];
                ++j;
            }
            j = this.m_dim - 1;
            while (j < 3) {
                src.m_data[j] = 0.0;
                ++j;
            }
        }
        if (modelMat != null) {
            src.m_data[3] = 1.0;
            if (this.m_position == null) {
                src.leftMultMatrix(modelMat);
            } else {
                scale = PdVector.length(3, modelMat.m_data[2]);
                src.m_data[3] = 0.0;
                src.leftMultMatrix(modelMat);
                src.multScalar(1.0 / scale);
            }
        }
        src.m_data[3] = 1.0;
        if (this.m_position == null) {
            int i = 0;
            while (i < 3) {
                tmp = projviewMat.m_data[i][3];
                int j = 0;
                while (j < 3) {
                    tmp += projviewMat.m_data[i][j] * src.m_data[j];
                    ++j;
                }
                dest.m_data[i] = (int)(tmp + 0.5);
                ++i;
            }
        } else {
            double scale2 = PdVector.length(3, this.m_viewMat.m_data[2]);
            int xNew = PS_ZOOM * this.m_dispSize.width / 10;
            int yNew = PS_ZOOM * this.m_dispSize.height - xNew;
            double xCur = projviewMat.m_data[0][3];
            double yCur = projviewMat.m_data[1][3];
            tmp = projviewMat.m_data[0][3];
            int j = 0;
            while (j < 3) {
                tmp += projviewMat.m_data[0][j] * src.m_data[j] / scale2;
                ++j;
            }
            dest.m_data[0] = (int)(tmp + (double)xNew - xCur + 0.5);
            tmp = projviewMat.m_data[1][3];
            j = 0;
            while (j < 3) {
                tmp += projviewMat.m_data[1][j] * src.m_data[j] / scale2;
                ++j;
            }
            dest.m_data[1] = (int)(tmp + (double)yNew - yCur + 0.5);
            tmp = projviewMat.m_data[2][3];
            j = 0;
            while (j < 3) {
                tmp += projviewMat.m_data[2][j] * src.m_data[j] / scale2;
                ++j;
            }
            dest.m_data[2] = (int)(tmp + 0.5);
        }
    }

    private int discretizeBndEdge(int xc, int yc, int zc, int xn, int yn, int zn, PdVector as, PdVector bs, PiVector[] elementDestBnd, PdVector[] elementTextureBnd, int bndLength, boolean bShowCurrEdge, boolean bTopBnd, boolean bBottomBnd, boolean bCCW, int side, int[] destPix, int destWidth, int xMin, int yMin) {
        int destPixPos;
        int incrNE;
        int incrE;
        int d;
        double zs_inc;
        double ys_inc;
        double xs_inc;
        int nsteps;
        int oldBndLength = bndLength;
        int dx = xn - xc;
        int dy = yn - yc;
        double dz = zn - zc;
        int x = xc;
        int y = yc;
        double z = zc;
        double xs = as.m_data[0] + 0.5;
        double ys = as.m_data[1] + 0.5;
        double zs = as.m_data[2];
        int xIncr = 1;
        int yIncr = 1;
        if (dx < 0) {
            dx = -dx;
            xIncr = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yIncr = -1;
        }
        int destPixLength = destPix.length;
        int xAll = 0xFFFFFF;
        if (Math.abs(dx) <= Math.abs(dy)) {
            nsteps = Math.abs(dy);
            if (bndLength + nsteps >= elementTextureBnd.length) {
                return -1;
            }
            xs_inc = (bs.m_data[0] - as.m_data[0]) / (double)nsteps;
            ys_inc = (bs.m_data[1] - as.m_data[1]) / (double)nsteps;
            zs_inc = (bs.m_data[2] - as.m_data[2]) / (double)nsteps;
            if (nsteps == 0) {
                return bndLength;
            }
            dz /= (double)Math.abs(dy);
            d = 2 * dx - dy;
            incrE = 2 * dx;
            incrNE = 2 * (dx - dy);
            do {
                elementTextureBnd[bndLength].set(xs, ys, zs);
                elementDestBnd[bndLength].set(x, y, (int)z);
                if (this.m_bShowCurrEdge && x - xMin >= 0 && x - xMin < destWidth && (destPixPos = (y - yMin) * destWidth + (x - xMin)) >= 0 && destPixPos < destPixLength) {
                    destPix[destPixPos] = m_colMark << 24 | destPix[destPixPos] & xAll;
                }
                ++bndLength;
                xs += xs_inc;
                ys += ys_inc;
                zs += zs_inc;
                y += yIncr;
                z += dz;
                if (d <= 0) {
                    d += incrE;
                    continue;
                }
                d += incrNE;
                x += xIncr;
            } while (y != yn);
        } else {
            nsteps = Math.abs(dx);
            if (bndLength + nsteps >= elementTextureBnd.length) {
                return -1;
            }
            xs_inc = (bs.m_data[0] - as.m_data[0]) / (double)nsteps;
            ys_inc = (bs.m_data[1] - as.m_data[1]) / (double)nsteps;
            zs_inc = (bs.m_data[2] - as.m_data[2]) / (double)nsteps;
            if (nsteps == 0) {
                return bndLength;
            }
            dz /= (double)Math.abs(dx);
            d = 2 * dy - dx;
            incrE = 2 * dy;
            incrNE = 2 * (dy - dx);
            elementTextureBnd[bndLength].set(xs, ys, zs);
            elementDestBnd[bndLength].set(x, y, (int)z);
            if (this.m_bShowCurrEdge && x - xMin >= 0 && x - xMin < destWidth && (destPixPos = (y - yMin) * destWidth + (x - xMin)) >= 0 && destPixPos < destPixLength) {
                destPix[destPixPos] = m_colMark << 24 | destPix[destPixPos] & xAll;
            }
            ++bndLength;
            boolean bUseNE = bTopBnd && yIncr < 0 || bBottomBnd && yIncr > 0;
            while (x != xn) {
                if (d <= 0) {
                    xs += xs_inc;
                    ys += ys_inc;
                    zs += zs_inc;
                    d += incrE;
                    x += xIncr;
                    z += dz;
                } else if (bUseNE) {
                    xs += xs_inc;
                    ys += ys_inc;
                    zs += zs_inc;
                    d += incrNE;
                    z += dz;
                    y += yIncr;
                    if ((x += xIncr) != xn) {
                        elementTextureBnd[bndLength].set(xs, ys, zs);
                        elementDestBnd[bndLength].set(x, y, (int)z);
                        ++bndLength;
                    }
                } else {
                    elementTextureBnd[bndLength].set(xs, ys, zs);
                    elementDestBnd[bndLength].set(x, y, (int)z);
                    ++bndLength;
                    xs += xs_inc;
                    ys += ys_inc;
                    zs += zs_inc;
                    d += incrNE;
                    x += xIncr;
                    z += dz;
                    y += yIncr;
                }
                if (!this.m_bShowCurrEdge || x - xMin < 0 || x - xMin >= destWidth || (destPixPos = (y - yMin) * destWidth + (x - xMin)) < 0 || destPixPos >= destPixLength) continue;
                destPix[destPixPos] = m_colMark << 24 | destPix[destPixPos] & xAll;
            }
        }
        if (!bShowCurrEdge) {
            int i;
            if (side == NNW || side == NWW || side == SWW || side == NNE) {
                i = oldBndLength;
                while (i < bndLength) {
                    elementDestBnd[i].m_data[3] = 0;
                    ++i;
                }
            } else if (side == SEE || side == NEE) {
                i = oldBndLength;
                while (i < bndLength) {
                    elementDestBnd[i].m_data[3] = 0;
                    ++i;
                }
            } else if (side == SSE) {
                if (yIncr < 0) {
                    elementDestBnd[oldBndLength].m_data[3] = 0;
                    i = oldBndLength + 1;
                    while (i < bndLength) {
                        elementDestBnd[i].m_data[3] = elementDestBnd[i - 1].m_data[0] - elementDestBnd[i].m_data[0] + 1;
                        ++i;
                    }
                } else {
                    i = oldBndLength;
                    while (i < bndLength - 1) {
                        elementDestBnd[i].m_data[3] = elementDestBnd[i + 1].m_data[0] - elementDestBnd[i].m_data[0] + 1;
                        ++i;
                    }
                    elementDestBnd[bndLength - 1].m_data[3] = bndLength - 2 >= oldBndLength ? elementDestBnd[bndLength - 2].m_data[3] : 0;
                }
            } else if (side == SSW) {
                if (yIncr < 0) {
                    elementDestBnd[oldBndLength].m_data[3] = 0;
                    i = oldBndLength + 1;
                    while (i < bndLength) {
                        elementDestBnd[i].m_data[3] = elementDestBnd[i - 1].m_data[0] - elementDestBnd[i].m_data[0] - 1;
                        ++i;
                    }
                } else {
                    i = oldBndLength;
                    while (i < bndLength - 1) {
                        elementDestBnd[i].m_data[3] = elementDestBnd[i + 1].m_data[0] - elementDestBnd[i].m_data[0] - 1;
                        ++i;
                    }
                    elementDestBnd[bndLength - 1].m_data[3] = bndLength - 2 >= oldBndLength ? elementDestBnd[bndLength - 2].m_data[3] : 0;
                }
            }
        }
        return bndLength;
    }

    public boolean hasTagElement(int anIndex, int aTag) {
        return this.m_element[anIndex].hasTag(aTag);
    }

    public boolean setPolygonColor(int anIndex, Color aColor) {
        if (anIndex < 0) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aColor == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (anIndex >= this.m_numPolygons) {
            this.setNumPolygons(anIndex + 1);
        }
        this.assurePolygonColors();
        this.m_polygonColor[anIndex] = aColor;
        return true;
    }

    public void setNumVectors(int ind, int num, int dimOfVectors) {
        super.setNumVectors(ind, num, dimOfVectors);
        this.m_vectorTrans[ind] = PiVector.realloc(this.m_vectorTrans[ind], num, this.m_dimTrans);
    }

    public boolean setPolygonTag(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numPolygons - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aTag < 0 || aTag >= 32) {
            PsDebug.warning("tag=" + aTag + " out of range", this);
            return false;
        }
        this.m_polygon[anIndex].setTag(aTag);
        return true;
    }

    public boolean hasTagVertex(int anIndex, int aTag) {
        return this.m_vertex[anIndex].hasTag(aTag);
    }

    public int addVertex(PdVector aVertex) {
        this.setNumVertices(this.m_numVertices + 1);
        this.m_vertex[this.m_numVertices - 1].copy(aVertex);
        return this.m_numVertices - 1;
    }

    public void setGlobalBndSize(double aSize) {
        this.m_globalBndSize = aSize;
        if (this.m_globalBndSize > 1.0) {
            this.m_globalBndSize = 2.0 * aSize - 1.0;
        }
    }

    private boolean drawPolygonZBuffer(Graphics g, int size, int[] xv, int[] yv, int[] zv, int len, Color col) {
        if (col != null) {
            this.m_currElementCol = this.m_alpha | col.getRGB();
        }
        if (size < 3) {
            int misImage = -1;
            if (!this.m_bNewZBuffer && (misImage = this.assureMIS(xv, yv, len)) == MIS_IMAGE_OUTSIDE) {
                return false;
            }
            int i = 0;
            while (i < len) {
                int ip = (i + 1) % len;
                this.drawLine_(xv[i], yv[i], zv[i], xv[ip], yv[ip], zv[ip], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), col);
                ++i;
            }
            if (!this.m_bNewZBuffer) {
                this.drawMIS(g, misImage);
            }
        } else {
            int i = 0;
            while (i < len) {
                int ip = (i + 1) % len;
                this.drawLine_(g, size, xv[i], yv[i], zv[i], xv[ip], yv[ip], zv[ip], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), col);
                ++i;
            }
        }
        return true;
    }

    protected int getNumTaggedVertices() {
        int num = 0;
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertex[i].hasTag(1)) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public void setNumVectorFields(int num) {
        if (num == this.m_numVectorFields) {
            return;
        }
        PiVector[][] newVectorTrans = new PiVector[num][];
        int i = 0;
        while (i < Math.min(num, this.m_numVectorFields)) {
            newVectorTrans[i] = this.m_vectorTrans[i];
            ++i;
        }
        this.m_vectorTrans = newVectorTrans;
        this.m_bShowVectors = false;
        super.setNumVectorFields(num);
    }

    protected boolean untagAllVertices() {
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertex[i].clearTag(1);
            this.m_geometry.clearTagVertex(i, 1);
            ++i;
        }
        return true;
    }

    protected int getNumUnusedVertices() {
        return this.m_numUnusedVertices;
    }

    public boolean setPolygonNormal(int anIndex, PdVector aNormal) {
        if (anIndex < 0) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aNormal == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (anIndex >= this.m_numPolygons) {
            this.setNumPolygons(anIndex + 1);
        }
        this.assurePolygonNormals();
        this.m_polygonNormal[anIndex].copy(aNormal);
        return true;
    }

    protected PiVector getTaggedVertices() {
        int num = this.getNumTaggedVertices();
        if (num == 0) {
            return null;
        }
        PiVector tagInd = new PiVector(num);
        num = 0;
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertex[i].hasTag(1)) {
                tagInd.setEntry(num++, i);
            }
            ++i;
        }
        return tagInd;
    }

    protected boolean untagVertices(int xMin, int yMin, int width, int height) {
        Rectangle r = new Rectangle(xMin, yMin, width, height);
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertex[i].hasTag(1) && r.contains(this.m_vertexTrans[i].m_data[0], this.m_vertexTrans[i].m_data[1])) {
                PsDebug.notify("You unselected vertex no. " + i);
                this.m_vertex[i].clearTag(1);
                this.m_geometry.clearTagVertex(i, 1);
            }
            ++i;
        }
        return true;
    }

    protected void setDisplay(PvDisplayIf aDisplay) {
        this.m_display = aDisplay;
    }

    protected int[] getUnusedVertices() {
        return this.m_unusedVertex.m_data;
    }

    protected int computeNumPolygonEdges() {
        this.m_numPolygonEdges = 0;
        int i = 0;
        while (i < this.m_numPolygons) {
            if (this.m_polygon[i] != null) {
                this.m_numPolygonEdges += Math.max(this.m_polygon[i].getSize() - 1, 0);
            }
            ++i;
        }
        return this.m_numPolygonEdges;
    }

    protected void drawItem(Graphics g, int itemInd, double heightFac, double itemHeight) {
        this.m_heightFac = 0.2 + 0.8 * heightFac;
        this.m_itemHeight = itemHeight;
        if (!(this.m_bShowBackface || this.m_elementNormal != null && this.m_elementNormal.length >= this.m_numElements)) {
            this.m_bShowBackface = true;
            PsDebug.warning("missing normals, backelement culling switched off");
        }
        int offset = 0;
        if (this.m_useVertices) {
            if (itemInd < this.m_numVertices) {
                this.drawVertex(g, itemInd);
                return;
            }
            offset = this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            if (itemInd < this.m_numUnusedVertices) {
                this.drawVertex(g, this.m_unusedVertex.getEntry(itemInd));
                return;
            }
            offset = this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            if (itemInd - offset < this.m_numElements) {
                this.drawElement(g, itemInd - offset);
                return;
            }
            offset += this.m_numElements;
        }
        if (this.m_usePolygons) {
            if (itemInd - offset < this.m_numPolygonEdges) {
                this.m_bShowCurrEdge = false;
                this.m_bShowCurrElement = true;
                this.m_bDrawingEdge = true;
                this.drawPolygon(g, itemInd - offset);
                int j = 0;
                while (j < 2) {
                    if (this.m_origInd[j] != -1) {
                        this.drawVertex(g, this.m_origInd[j]);
                    }
                    ++j;
                }
                return;
            }
            PsDebug.error("itemInd out of range, index = " + itemInd, this);
        }
    }

    private void leftMult34(PdMatrix mat, PdVector src, PiVector dest) {
        int i = 0;
        while (i < 3) {
            double tmp = 0.0;
            int j = 0;
            while (j < 4) {
                tmp += mat.m_data[i][j] * src.m_data[j];
                ++j;
            }
            dest.m_data[i] = (int)(tmp + 0.5);
            ++i;
        }
    }

    private boolean isBackelementCulled(int elemInd, int elemLength) {
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length < elemInd) {
            return false;
        }
        return this.m_elementNormalTrans[elemInd].hasTag(14);
    }

    private int assureMIS(int[] xv, int[] yv, int len) {
        boolean bInside = this.getElementBndBox(this.m_elemMin, this.m_elemMax, xv, yv, len);
        if (!bInside) {
            return MIS_IMAGE_OUTSIDE;
        }
        this.m_elemWidth = this.m_elemMax[0] - this.m_elemMin[0] + 1;
        this.m_elemHeight = this.m_elemMax[1] - this.m_elemMin[1] + 1;
        if ((double)(this.m_elemHeight + this.m_elemWidth) > (double)(this.m_dispSize.height + this.m_dispSize.width) * 2.0) {
            return MIS_IMAGE_OUTSIDE;
        }
        if (this.mis == null || this.imgWidth < this.m_elemWidth || this.imgHeight < this.m_elemHeight) {
            this.imgWidth = Math.max(this.m_elemWidth, this.imgWidth);
            this.imgHeight = Math.max(this.m_elemHeight, this.imgHeight);
            this.m_pix.setSize(this.imgWidth * this.imgHeight);
            this.m_pixZero.setSize(this.imgWidth * this.imgHeight);
            this.mis = new MemoryImageSource(this.imgWidth, this.imgHeight, this.m_pix.m_data, 0, this.imgWidth);
            this.mis.setAnimated(true);
            return MIS_IMAGE_REQUIRED;
        }
        return MIS_IMAGE_REDRAW;
    }

    private void drawMIS(Graphics g, int misImage) {
        if (misImage == MIS_IMAGE_REQUIRED) {
            this.m_destImage = ((Component)((Object)this.m_display)).createImage(this.mis);
        } else {
            this.mis.newPixels(0, 0, Math.max(this.m_elemWidth, this.prevElemWidth), Math.max(this.m_elemHeight, this.prevElemHeight));
        }
        if (this.m_destImage != null) {
            g.drawImage(this.m_destImage, this.m_elemMin[0], this.m_elemMin[1], null);
        }
        System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, 0, this.imgWidth * this.m_elemHeight);
        this.prevElemWidth = this.m_elemWidth;
        this.prevElemHeight = this.m_elemHeight;
    }

    protected void setMIS(int width, int height, int[] pixData, int[] pixZeroData) {
        this.imgWidth = width;
        this.imgHeight = height;
        this.m_elemHeight = height;
        this.m_pix.m_data = pixData;
        this.m_pixZero.m_data = pixZeroData;
    }

    private void getElementCenter(double[] center, PiVector elem, PiVector[] vertexTrans, int dim) {
        int elemLen = elem.m_data.length;
        int k = 0;
        while (k < dim) {
            center[k] = 0.0;
            int i = 0;
            while (i < elemLen) {
                int n = k;
                center[n] = center[n] + (double)vertexTrans[elem.m_data[i]].m_data[k];
                ++i;
            }
            int n = k++;
            center[n] = center[n] / (double)elemLen;
        }
    }

    private void getElementCenter(double[] center, PiVector elem, PdVector[] vertex, int dim) {
        int elemLen = elem.m_data.length;
        int k = 0;
        while (k < dim) {
            center[k] = 0.0;
            int i = 0;
            while (i < elemLen) {
                int n = k;
                center[n] = center[n] + vertex[elem.m_data[i]].m_data[k];
                ++i;
            }
            int n = k++;
            center[n] = center[n] / (double)elemLen;
        }
    }

    protected void projectItems(PdMatrix projviewMat, PdMatrix projMat, PdMatrix viewMat, PdMatrix modelMat) {
        if (this.m_dim + 1 != this.vt.getSize()) {
            this.vt.setSize(this.m_dim + 1);
            this.vtExact.setSize(this.m_dim);
        }
        this.m_projMat = projMat;
        this.m_viewMat = viewMat;
        this.projectVertices(projviewMat, modelMat);
        int projSav = this.m_ambientProj;
        this.m_ambientProj = 0;
        int i = 0;
        while (i < 2) {
            this.m_vt.copyArray(this.m_bndBox[i]);
            this.project(this.m_bndBoxTrans[i], this.m_vt, projviewMat, modelMat);
            ++i;
        }
        this.m_ambientProj = projSav;
        if (this.m_bShowVertexNormals || this.m_bShowEdgeAura || this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor) {
            this.projectVertexNormals(projviewMat, modelMat);
        }
        if (this.m_bShowElementNormals || this.m_bShowEdgeAura || this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors) {
            this.projectElementNormals(projviewMat, modelMat);
        }
        if (this.m_bShowVectors) {
            this.projectVectors(projviewMat, modelMat);
        }
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(PgGeometryIf aGeometry) {
        if (aGeometry == null) {
            PsDebug.warning("missing geometry");
            return;
        }
        this.m_geometry = aGeometry;
        this.setName(aGeometry.getName() + "_Container");
        this.update(this.m_geometry);
    }

    protected void setPosition(int x, int y) {
        this.m_position = new int[]{x, y};
    }

    public int getDrawingOrder() {
        return this.m_drawingOrder;
    }

    public void setDrawingOrder(int pos) {
        this.m_drawingOrder = pos;
    }

    private void drawElementVectors(Graphics g, int elemInd, int len, int[] xv, int[] yv, int[] zv, int[] m_origInd) {
        int j = 0;
        while (j < this.m_numVectorFields) {
            if (this.m_bShowVectorField[j] && this.m_vectorIsElementBased[j]) {
                Color currCol = this.m_globalVectorColor[j];
                if (this.m_bShowVectorColors[j]) {
                    currCol = this.m_vectorColor[j][elemInd];
                }
                this.getElementCenter(this.m_elemCenter, this.m_element[elemInd], this.m_vertexTrans, 3);
                this.drawVector_(g, (int)this.m_globalVectorSize[j], (int)this.m_elemCenter[0], (int)this.m_elemCenter[1], (int)this.m_elemCenter[2], this.m_vectorTrans[j][elemInd].m_data[0], this.m_vectorTrans[j][elemInd].m_data[1], this.m_vectorTrans[j][elemInd].m_data[2], this.m_bShowVectorArrow[j], currCol);
            }
            ++j;
        }
    }

    public void init() {
        super.init();
        this.m_useVertices = true;
        this.m_useElements = true;
        this.m_bHasNeighbours = false;
        this.m_bShowTransparency = false;
        this.m_alpha = -16777216;
        this.m_bHasTaggedVertices = false;
        this.m_bHasTaggedPolygons = false;
        this.m_bHasTaggedEdges = false;
        this.m_bHasTaggedBoundaries = false;
        this.m_bHasTaggedElements = false;
        this.m_vertexTrans = null;
        this.m_vertexNormalTrans = null;
        this.m_elementNormalTrans = null;
        this.m_vectorTrans = null;
        this.m_globalBndboxColor = Color.magenta;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        this.m_bndBox[0].setConstant(-1.0);
        this.m_bndBox[1].setConstant(1.0);
        this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
        this.m_center = new PdVector(this.m_dim);
        this.m_center.setConstant(0.0);
        this.m_elemCenter = new double[Math.max(3, this.m_dim)];
    }

    protected void projectVectors(PdMatrix projviewMat, PdMatrix modelMat) {
        if (this.m_numVertices == 0 || this.m_numVectorFields == 0) {
            this.m_bShowVectors = false;
            return;
        }
        int j = 0;
        while (j < this.m_numVectorFields) {
            int k;
            int i;
            if (!this.m_vectorIsElementBased[j]) {
                i = 0;
                while (i < this.m_numVertices) {
                    k = 0;
                    while (k < this.m_dim) {
                        this.m_vt.m_data[k] = this.m_vertex[i].m_data[k] + this.m_globalVectorLength[j] * this.m_vector[j][i].m_data[k];
                        ++k;
                    }
                    this.project(this.m_vectorTrans[j][i], this.m_vt, projviewMat, modelMat);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m_numElements) {
                    this.getElementCenter(this.m_elemCenter, this.m_element[i], this.m_vertex, this.m_dim);
                    k = 0;
                    while (k < this.m_dim) {
                        this.m_vt.m_data[k] = this.m_elemCenter[k] + this.m_globalVectorLength[j] * this.m_vector[j][i].m_data[k];
                        ++k;
                    }
                    this.project(this.m_vectorTrans[j][i], this.m_vt, projviewMat, modelMat);
                    ++i;
                }
            }
            ++j;
        }
    }

    protected boolean setGeometryElement(int anInd, PiVector anElement) {
        this.setElement(anInd, anElement);
        return this.m_geometry.setElement(anInd, anElement);
    }

    protected int pickVertex(int x, int y) {
        Rectangle r = new Rectangle();
        int i = 0;
        while (i < this.m_numVertices) {
            r.setBounds(this.m_vertexTrans[i].m_data[0] - 3, this.m_vertexTrans[i].m_data[1] - 3, 7, 7);
            if (r.contains(x, y)) {
                PsDebug.notify("You selected vertex no. " + i);
                this.m_vertex[i].setTag(1);
                this.m_geometry.setTagVertex(i, 1);
                this.m_bHasTaggedVertices = true;
                this.m_pickedVertex = i;
                return this.m_pickedVertex;
            }
            ++i;
        }
        return -1;
    }

    protected int releaseVertex(int aVertexInd) {
        if (aVertexInd >= 0 && aVertexInd < this.m_numVertices) {
            this.m_vertex[aVertexInd].clearTag(1);
            this.m_geometry.clearTagVertex(aVertexInd, 1);
        }
        this.m_pickedVertex = -1;
        return -1;
    }

    public void setTexture(int[] texturePix, int width, int height) {
        this.m_texturePix = texturePix;
        this.m_textureWidth = width;
        this.m_textureHeight = height;
        if (texturePix == null) {
            this.setState(71, false);
            this.setState(72, false);
        }
    }

    public boolean setElementTexture(int anIndex, PdVector[] aTexture) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aTexture == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementTextures();
        this.m_elementTexture[anIndex] = PdVector.copyNew(aTexture, aTexture.length);
        return true;
    }

    public boolean setVertexTexture(int anIndex, PdVector aTex) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aTex == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexTextures();
        this.m_vertexTexture[anIndex].copy(aTex);
        return true;
    }

    protected boolean setGeometryVertex(int anInd, PdVector aVertex) {
        this.setVertex(anInd, aVertex);
        return this.m_geometry.setVertex(anInd, aVertex);
    }

    public void clearTagElement(int anIndex, int aTag) {
        this.m_element[anIndex].clearTag(aTag);
        this.m_geometry.clearTagElement(anIndex, aTag);
    }

    private void drawElement(Graphics g, int elemInd) {
        int elemLength = this.m_element[elemInd].m_data.length;
        if (elemLength == 0) {
            return;
        }
        if (!this.m_bShowBackface && this.isBackelementCulled(elemInd, elemLength)) {
            return;
        }
        if (this.m_bShowVertexTexture && this.m_vertexTexture == null) {
            this.m_bShowVertexTexture = false;
        }
        if (this.m_bShowElementTexture && this.m_elementTexture == null) {
            this.m_bShowElementTexture = false;
        }
        if ((this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) && this.texCoord == null) {
            this.texCoord = PdVector.realloc(this.texCoord, this.m_maxDimOfElements, 3);
        }
        if (this.m_bEnableClip) {
            this.m_elemIsClipped = false;
            if (this.m_bShowVertexTexture) {
                PdVector[] tex = new PdVector[elemLength];
                int i = 0;
                while (i < elemLength) {
                    tex[i] = this.m_vertexTexture[this.m_element[elemInd].m_data[i]];
                    ++i;
                }
                elemLength = this.clipElement(elemInd, elemLength, this.xv, this.yv, this.zv, this.m_origInd, this.texCoord, tex);
            } else {
                elemLength = this.m_bShowElementTexture ? this.clipElement(elemInd, elemLength, this.xv, this.yv, this.zv, this.m_origInd, this.texCoord, this.m_elementTexture[elemInd]) : this.clipElement(elemInd, elemLength, this.xv, this.yv, this.zv, this.m_origInd, null, null);
            }
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                int j = 0;
                while (j < elemLength) {
                    if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                        this.texCoord[j].m_data[0] = this.texCoord[j].m_data[0] * ((double)this.m_textureWidth - 1.0);
                        this.texCoord[j].m_data[1] = this.texCoord[j].m_data[1] * ((double)this.m_textureHeight - 1.0);
                    }
                    ++j;
                }
            }
            if (elemLength == 0) {
                return;
            }
        } else {
            int j = 0;
            while (j < elemLength) {
                int vertInd = this.m_element[elemInd].m_data[j];
                this.xv[j] = this.m_vertexTrans[vertInd].m_data[0];
                this.yv[j] = this.m_vertexTrans[vertInd].m_data[1];
                this.zv[j] = this.m_vertexTrans[vertInd].m_data[2];
                this.m_origInd[j] = vertInd;
                ++j;
            }
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                if (this.m_dimOfTextures == 3) {
                    j = 0;
                    while (j < elemLength) {
                        if (this.m_bShowVertexTexture) {
                            this.texCoord[j].copyArray(this.m_vertexTexture[this.m_element[elemInd].m_data[j]]);
                        } else if (this.m_bShowElementTexture) {
                            this.texCoord[j].copyArray(this.m_elementTexture[elemInd][j]);
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < elemLength) {
                        if (this.m_bShowVertexTexture) {
                            this.texCoord[j].copyArray(this.m_vertexTexture[this.m_element[elemInd].m_data[j]]);
                        } else if (this.m_bShowElementTexture) {
                            this.texCoord[j].copyArray(this.m_elementTexture[elemInd][j]);
                        }
                        this.texCoord[j].m_data[0] = this.texCoord[j].m_data[0] * ((double)this.m_textureWidth - 1.0);
                        this.texCoord[j].m_data[1] = this.texCoord[j].m_data[1] * ((double)this.m_textureHeight - 1.0);
                        ++j;
                    }
                }
            } else if (this.m_bEnableZBuffer) {
                j = 0;
                while (j < elemLength) {
                    this.texCoord[j].m_data[0] = this.texCoord[j].m_data[0] * ((double)this.m_textureWidth - 1.0);
                    this.texCoord[j].m_data[1] = this.texCoord[j].m_data[1] * ((double)this.m_textureHeight - 1.0);
                    ++j;
                }
            }
        }
        if (this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) {
            double srcZMin = PvScene.m_zMin;
            double srcZMax = PvScene.m_zMax;
            double zFac = 1.0;
            if (srcZMax - srcZMin != 0.0) {
                zFac = srcZMax - srcZMin;
            }
            int j = 0;
            while (j < elemLength) {
                this.texCoord[j].setEntry(2, Math.sqrt(((double)this.zv[j] - srcZMin) / zFac));
                ++j;
            }
        }
        this.m_bShowCurrElement = this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements;
        this.m_bShowCurrEdge = this.m_bShowEdges || this.m_bShowOutline || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges;
        this.m_bDrawingEdge = false;
        this.m_bDepthcueEdge = false;
        if (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements) {
            if ((this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) && elemLength > 4) {
                this.elemSub = this.triangulate(this.xv, this.yv, this.zv, elemLength);
                int i = 0;
                while (i < elemLength - 2) {
                    int j = 0;
                    while (j < 3) {
                        this.xvSub[j] = this.xv[this.elemSub[i][j]];
                        this.yvSub[j] = this.yv[this.elemSub[i][j]];
                        this.zvSub[j] = this.zv[this.elemSub[i][j]];
                        this.texSub[j] = this.texCoord[this.elemSub[i][j]];
                        ++j;
                    }
                    this.drawElement(g, elemInd, 3, this.xvSub, this.yvSub, this.zvSub, this.texSub);
                    ++i;
                }
            } else {
                this.drawElement(g, elemInd, elemLength, this.xv, this.yv, this.zv, this.texCoord);
            }
        }
        this.m_bShowCurrElement = true;
        this.m_bShowCurrEdge = false;
        this.m_bDrawingEdge = true;
        if ((this.m_bShowEdges || this.m_bShowOutline || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) && (!this.m_bShowVertexTexture && !this.m_bShowElementTexture && !this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || !this.m_bShowElements || this.m_bShowOutline)) {
            this.m_bDepthcueEdge = !this.m_bShowElements;
            this.drawElementEdges(g, elemInd, elemLength, this.xv, this.yv, this.zv, this.texCoord);
        }
        this.m_bDepthcueEdge = false;
        if (!(!this.m_bShowBoundaries || this.m_bEnableClip && this.m_elemIsClipped)) {
            this.drawElementBnd(g, elemInd, elemLength, this.xv, this.yv, this.zv);
        }
        if (!this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.drawElementVertices(g, elemInd, elemLength, this.m_origInd);
        }
        if ((this.m_bShowIndices || this.m_bShowElementLabels) && (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements)) {
            int xMean = 0;
            int yMean = 0;
            int j = elemLength - 1;
            while (j >= 0) {
                xMean += this.xv[j];
                yMean += this.yv[j];
                --j;
            }
            g.setColor(Color.orange);
            String name = this.m_element[elemInd].getName();
            if (name == null && this.m_bDefaultLabelEnabled) {
                name = String.valueOf(elemInd);
            }
            int[] off = this.m_labelAttribute[3].m_data;
            this.drawString(g, name, xMean / elemLength, yMean / elemLength, 0, off);
        }
        if (this.m_bShowElementNormals) {
            this.drawElementNormal(g, elemInd, elemLength, this.xv, this.yv, this.zv);
        }
        if (this.m_bShowVectors) {
            this.drawElementVectors(g, elemInd, elemLength, this.xv, this.yv, this.zv, this.m_origInd);
        }
    }

    private void drawElement(Graphics g, int elemInd, int len, int[] xv, int[] yv, int[] zv, PdVector[] texCoord) {
        Color currCol = this.m_globalElementColor;
        if (this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[elemInd].hasTag(1)) {
            currCol = this.m_globalElementTagColor;
        } else if (this.m_bShowElements) {
            currCol = (this.m_bShowElementBackColor || this.m_bShowElementBackColors) && this.isBackelementCulled(elemInd, len) ? (this.m_bShowElementBackColors && this.m_elementBackColor != null ? this.m_elementBackColor[elemInd] : this.m_globalElementBackColor) : (this.m_bShowElementColors && this.m_elementColor != null ? this.m_elementColor[elemInd] : this.m_globalElementColor);
            if (this.m_bShowDepthcue && !this.m_bEnableZBuffer) {
                currCol = PdColor.getDimmedColor(currCol, this.m_heightFac);
            } else if (this.m_elementNormal != null && this.m_elementNormal.length >= this.m_numElements) {
                double skp = PdVector.dot(this.m_elementNormal[elemInd], this.m_lightDir);
                if (skp < 0.0) {
                    skp = -skp;
                }
                skp = 1.0 - skp * 0.3;
                currCol = PdColor.getDimmedColor(currCol, skp);
            }
        } else {
            return;
        }
        if (this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) {
            this.m_currEdgeCol = this.m_alpha | this.getEdgeColor_(elemInd).getRGB();
            this.drawElementZBuffer(g, xv, yv, zv, len, currCol, texCoord);
        } else {
            g.setColor(currCol);
            g.fillPolygon(xv, yv, len);
        }
    }

    protected boolean removeGeometryElement(int anInd) {
        this.removeElement(anInd);
        this.m_geometry.removeElement(anInd);
        return true;
    }

    private void drawString(Graphics g, String name, int xPos, int yPos, int vSize, int[] off) {
        if (name == null) {
            return;
        }
        if (g.getFont() != PsConfig.getFont(off[4])) {
            g.setFont(PsConfig.getFont(off[4]));
        }
        int xoffPos = 0;
        int yoffPos = 0;
        FontMetrics fm = g.getFontMetrics();
        if (off[2] == 0) {
            xoffPos = vSize;
        } else if (off[2] == 1) {
            xoffPos = -fm.stringWidth(name) / 2;
        } else if (off[2] == 2) {
            xoffPos = -fm.stringWidth(name) - vSize;
        }
        if (off[3] == 0) {
            yoffPos = vSize;
        } else if (off[3] == 1) {
            yoffPos = fm.getHeight() / 2;
        } else if (off[3] == 2) {
            yoffPos = fm.getHeight() + vSize;
        }
        g.drawString(name, xPos + (off[0] + xoffPos) * PS_ZOOM, yPos + (off[1] + yoffPos) * PS_ZOOM);
    }

    protected boolean tagVertices(int xMin, int yMin, int width, int height) {
        Rectangle r = new Rectangle(xMin, yMin, width, height);
        int i = 0;
        while (i < this.m_numVertices) {
            if (r.contains(this.m_vertexTrans[i].m_data[0], this.m_vertexTrans[i].m_data[1])) {
                PsDebug.notify("You selected vertex no. " + i);
                this.m_vertex[i].setTag(1);
                this.m_geometry.setTagVertex(i, 1);
            }
            ++i;
        }
        return true;
    }

    private void drawElementEdges(Graphics g, int elemInd, int len, int[] xv, int[] yv, int[] zv, PdVector[] texCoord) {
        block9: {
            Color currCol;
            block5: {
                if (this.m_bShowEdgeAura && !this.m_bShowElements) {
                    g.setColor(this.m_backColor);
                    PvThickGraphics.drawPolygon(g, Math.max(6, (int)(2.0 * this.m_globalEdgeSize)), xv, yv, len, !this.isBackelementCulled(elemInd, len));
                }
                currCol = this.getEdgeColor_(elemInd);
                if (!this.m_bShowOutline || !this.m_bHasNeighbours || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements || this.m_bEnableClip && this.m_elemIsClipped) break block5;
                int i = 0;
                while (i < len) {
                    block6: {
                        int size;
                        int i2;
                        int i1;
                        block8: {
                            block7: {
                                int elemNeigh = this.m_neighbour[elemInd].m_data[i];
                                if (elemNeigh >= this.m_numElements) break block6;
                                i1 = (i + 1) % len;
                                i2 = (i + 2) % len;
                                size = (int)this.m_globalEdgeSize;
                                if (elemNeigh == -1 || this.isBackelementCulled(elemInd, len) == this.isBackelementCulled(elemNeigh, len)) break block7;
                                size = (int)(2.0 * this.m_globalBndSize + 1.0);
                                break block8;
                            }
                            if (!this.m_bShowEdges) break block6;
                        }
                        this.drawLine(g, size, xv[i1], yv[i1], zv[i1], xv[i2], yv[i2], zv[i2], currCol);
                    }
                    ++i;
                }
                break block9;
            }
            this.drawPolygon(g, (int)this.m_globalEdgeSize, xv, yv, zv, len, currCol);
        }
    }

    private void drawElementVertices(Graphics g, int elemInd, int len, int[] m_origInd) {
        int j = 0;
        while (j < len) {
            block5: {
                block6: {
                    if (m_origInd[j] == -1) break block5;
                    if (!this.m_bShowBackface || !this.m_bShowEdgeOnce || !this.m_bHasNeighbours || this.m_bEnableClip && this.m_elemIsClipped || this.m_numUnusedVertices != 0) break block6;
                    int elemNeigh1 = this.m_neighbour[elemInd].m_data[(j - 2 + len) % len];
                    int elemNeigh2 = this.m_neighbour[elemInd].m_data[(j - 1 + len) % len];
                    if (elemNeigh1 >= this.m_numElements || elemNeigh2 >= this.m_numElements) {
                        PsDebug.warning("void neighbour information, invoke: makeNeighbour()!");
                        return;
                    }
                    if (elemNeigh1 != -1 && this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(elemNeigh1) || elemNeigh2 != -1 && this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(elemNeigh2)) break block5;
                }
                this.drawVertex(g, m_origInd[j]);
            }
            ++j;
        }
    }

    protected void projectVertices(PdMatrix projviewMat, PdMatrix modelMat) {
        if (this.m_numVertices == 0) {
            return;
        }
        m_zMin = Integer.MAX_VALUE;
        m_zMax = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vt.copyArray(this.m_vertex[i]);
            this.project(this.m_vertexTrans[i], this.m_vt, projviewMat, modelMat);
            if (this.m_vertexTrans[i].m_data[2] < m_zMin) {
                m_zMin = this.m_vertexTrans[i].m_data[2];
            }
            if (this.m_vertexTrans[i].m_data[2] > m_zMax) {
                m_zMax = this.m_vertexTrans[i].m_data[2];
            }
            ++i;
        }
    }

    private void drawVectorTip(Graphics g, int size, int x1, int y1, int z1, int x2, int y2, int z2, boolean bScale, Color col) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double len = dx * dx + dy * dy;
        double tol = (double)PS_ZOOM * ((double)size + 4.0);
        if (len < 1.0) {
            return;
        }
        double newLen = bScale ? 2.0 * tol / Math.PI / Math.sqrt(len) * Math.atan(len / 50.0 / (double)PS_ZOOM / (double)PS_ZOOM) : 2.0 * tol / Math.PI / Math.sqrt(len) * Math.atan(8.0 / (double)PS_ZOOM / (double)PS_ZOOM);
        dx = (int)(dx * newLen);
        dy = (int)(dy * newLen);
        dz = (int)(dz * newLen);
        int ta = x2 + (int)(-dx + dy);
        int tb = y2 + (int)(-dx - dy);
        int tc = z2 - (int)dz;
        this.drawLine(g, size, x2, y2, z2, ta, tb, tc, col);
        ta = x2 + (int)(-dx - dy);
        tb = y2 + (int)(dx - dy);
        this.drawLine(g, size, x2, y2, z2, ta, tb, tc, col);
    }

    protected void setMaxNumVertices(int numVertices) {
        if (this.m_maxNumVertices == numVertices) {
            return;
        }
        super.setMaxNumVertices(numVertices);
        this.m_vertexTrans = PiVector.realloc(this.m_vertexTrans, numVertices, this.m_dimTrans);
        if (this.m_vertexNormal != null) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, numVertices, this.m_dimTrans);
        }
    }

    public boolean update(Object event) {
        int i;
        if (event != this.m_geometry) {
            return false;
        }
        PsDebug.notify("updating geometry");
        if (this.m_geometry == null) {
            PsDebug.warning("missing associated geometry");
            return false;
        }
        this.m_geometry.paint(this);
        if (!this.getName().startsWith(this.m_geometry.getName())) {
            this.setName(this.m_geometry.getName() + "_Container");
        }
        this.getBounds();
        if (this.m_bShowTaggedVertices) {
            this.m_bHasTaggedVertices = false;
            i = 0;
            while (i < this.m_numVertices) {
                if (this.m_vertex[i].hasTag(1)) {
                    this.m_bHasTaggedVertices = true;
                    break;
                }
                ++i;
            }
        }
        if (this.m_bShowTaggedPolygons) {
            this.m_bHasTaggedPolygons = false;
            i = 0;
            while (i < this.m_numPolygons) {
                if (this.m_polygon[i].hasTag(1)) {
                    this.m_bHasTaggedPolygons = true;
                    break;
                }
                ++i;
            }
        }
        if (this.m_bShowTaggedElements) {
            this.m_bHasTaggedElements = false;
            i = 0;
            while (i < this.m_numElements) {
                if (this.m_element[i].hasTag(1)) {
                    this.m_bHasTaggedElements = true;
                    break;
                }
                ++i;
            }
        }
        this.m_numUnusedVertices = 0;
        if (this.m_numVertices > 0 && this.m_bShowVertices && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.updateUnusedVertices();
        }
        this.m_useVertices = false;
        this.m_useUnusedVertices = false;
        this.m_useElements = false;
        this.m_usePolygons = false;
        if (this.m_numElements == 0 && this.m_numPolygonEdges == 0 && (this.m_bShowVertices || this.m_bShowTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors) || !this.m_bShowElements && !this.m_bShowEdges && !this.m_bShowBoundaries && !this.m_bShowElementNormals && !this.m_bShowVectors && !this.m_bShowPolygons) {
            this.m_useVertices = true;
        } else if (this.m_bShowVertices && this.m_numUnusedVertices > 0 && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.m_useUnusedVertices = true;
        }
        if (this.m_numPolygonEdges > 0 && (this.m_bShowPolygons || this.m_bShowTaggedPolygons || this.m_bShowPolygonNormals)) {
            this.m_usePolygons = true;
        }
        this.m_bHasNeighbours = false;
        if (this.m_numElements > 0 && (this.m_bShowElements || this.m_bShowEdges || this.m_bShowOutline || this.m_bShowBoundaries || this.m_bShowElementNormals || this.m_bShowVectors || this.m_bShowTaggedElements && this.m_bHasTaggedElements || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges)) {
            this.m_useElements = true;
            if (this.m_neighbour != null && this.m_neighbour.length >= this.m_numElements && this.m_neighbour[0] != null && this.m_neighbour[0].getSize() == this.m_element[0].getSize()) {
                this.m_bHasNeighbours = true;
            }
        }
        return true;
    }

    protected void drawTitle(Graphics g) {
        if (!this.m_bShowTitle) {
            return;
        }
        String name = this.m_geometry.getName();
        if (name == null) {
            return;
        }
        g.setColor(Color.black);
        int[] off = this.m_labelAttribute[5].m_data;
        this.drawString(g, name, this.m_bndBoxTrans[1].m_data[0], this.m_bndBoxTrans[1].m_data[1], 0, off);
    }

    protected int getZMax() {
        return m_zMax;
    }

    public boolean setPolygon(int anIndex, PiVector aPolygon) {
        if (!super.setPolygon(anIndex, aPolygon)) {
            return false;
        }
        this.computeNumPolygonEdges();
        return true;
    }

    public void clearTagPolygon(int anIndex, int aTag) {
        this.m_polygon[anIndex].clearTag(aTag);
        this.m_geometry.clearTagPolygon(anIndex, aTag);
    }

    private void drawPolygon(Graphics g, int edgeInd) {
        Color currCol;
        int polyInd = 0;
        while (polyInd < this.m_numPolygons) {
            int len = this.m_polygon[polyInd].getSize() - 1;
            if (edgeInd < len) break;
            edgeInd -= len;
            ++polyInd;
        }
        if (polyInd == this.m_numPolygons) {
            PsDebug.warning("edgeInd = " + edgeInd + " out of bounds.");
            return;
        }
        boolean bFirstEdge = edgeInd == 0;
        boolean bLastEdge = edgeInd == this.m_polygon[polyInd].getSize() - 2;
        int elemLength = 2;
        if (this.m_bEnableClip) {
            this.m_elemIsClipped = false;
            elemLength = this.clipPolygon(polyInd, edgeInd, this.xv, this.yv, this.zv, this.m_origInd);
            if (elemLength == 0) {
                return;
            }
        } else {
            int j = 0;
            while (j < elemLength) {
                int vertInd = this.m_polygon[polyInd].m_data[edgeInd + j];
                this.xv[j] = this.m_vertexTrans[vertInd].m_data[0];
                this.yv[j] = this.m_vertexTrans[vertInd].m_data[1];
                this.zv[j] = this.m_vertexTrans[vertInd].m_data[2];
                this.m_origInd[j] = vertInd;
                ++j;
            }
        }
        int pSize = (int)this.m_globalPolygonSize;
        if (this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons && this.m_polygon[polyInd].hasTag(1)) {
            pSize = (int)(2.0 * this.m_globalPolygonSize);
            currCol = this.m_globalPolygonTagColor;
        } else if (this.m_bShowPolygons) {
            if (this.m_bShowEdgeAura) {
                this.m_bDepthcueEdge = false;
                this.drawLine(g, Math.max(6, 2 * (int)this.m_globalPolygonSize), this.xv[0], this.yv[0], this.zv[0] - 30, this.xv[1], this.yv[1], this.zv[1] - 30, this.m_backColor);
            }
            currCol = this.m_bShowPolygonColors && this.m_polygonColor != null ? this.m_polygonColor[polyInd] : this.m_globalPolygonColor;
            if (this.m_bShowDepthcue && !this.m_bEnableZBuffer) {
                currCol = PdColor.getDimmedColor(currCol, this.m_heightFac, this.m_grey * (1.0 - this.m_heightFac));
            }
        } else {
            return;
        }
        this.m_bDepthcueEdge = true;
        this.drawLine(g, pSize, this.xv[0], this.yv[0], this.zv[0], this.xv[1], this.yv[1], this.zv[1], currCol);
        if (this.m_bShowPolygonEndArrow && bLastEdge) {
            this.drawVectorTip(g, pSize, this.xv[0], this.yv[0], this.zv[0], this.xv[1], this.yv[1], this.zv[1], false, currCol);
        }
        if (this.m_bShowPolygonStartArrow && bFirstEdge) {
            this.drawVectorTip(g, pSize, this.xv[1], this.yv[1], this.zv[1], this.xv[0], this.yv[0], this.zv[0], false, currCol);
        }
        if ((this.m_bShowIndices || this.m_bShowPolygonLabels) && (this.m_bShowPolygons || this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons)) {
            String name = this.m_polygon[polyInd].getName();
            if (name == null && this.m_bDefaultLabelEnabled) {
                name = String.valueOf(polyInd) + "," + String.valueOf(edgeInd);
            }
            int[] off = this.m_labelAttribute[2].m_data;
            this.drawString(g, name, (this.xv[0] + this.xv[1]) / 2, (this.yv[0] + this.yv[1]) / 2, pSize, off);
        }
    }

    private void drawPolygon(Graphics g, int size, int[] xv, int[] yv, int[] zv, int len, Color col) {
        if (this.m_bEnableZBuffer) {
            if (size < 3) {
                this.drawPolygonZBuffer(g, size, xv, yv, zv, len, col);
            } else {
                this.drawPolygonZBuffer(g, size, xv, yv, zv, len, col);
            }
            return;
        }
        g.setColor(col);
        if (size < 3) {
            g.drawPolygon(xv, yv, len);
        } else {
            PvThickGraphics.drawPolygon(g, size, xv, yv, len);
        }
    }

    public boolean setLabelAttributes(PiVector[] attr) {
        PiVector.copy(this.m_labelAttribute, 0, attr, 0, attr.length);
        return true;
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector.min(this.m_bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(this.m_bndBox[1], this.m_vertex, this.m_numVertices);
        int i = this.m_dimTrans - 1;
        while (i >= this.m_dim) {
            this.m_bndBox[0].setEntry(i, 0.0);
            this.m_bndBox[1].setEntry(i, 0.0);
            --i;
        }
        return this.m_bndBox;
    }

    protected void projectVertexNormals(PdMatrix projviewMat, PdMatrix modelMat) {
        if (this.m_numVertices == 0 || this.m_vertexNormal == null || this.m_vertexNormal.length < this.m_numVertices) {
            this.m_bShowVertexNormals = false;
            return;
        }
        int i = 0;
        while (i < this.m_numVertices) {
            int k = 0;
            while (k < this.m_dim) {
                this.m_vt.m_data[k] = this.m_vertex[i].m_data[k] + this.m_globalVertexNormalLength * this.m_vertexNormal[i].m_data[k];
                ++k;
            }
            this.project(this.m_vertexNormalTrans[i], this.m_vt, projviewMat, modelMat);
            ++i;
        }
    }

    protected void projectElementNormals(PdMatrix projviewMat, PdMatrix modelMat) {
        if (this.m_numElements == 0 || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements) {
            this.m_bShowElementNormals = false;
            return;
        }
        int i = 0;
        while (i < this.m_numElements) {
            this.getElementCenter(this.m_elemCenter, this.m_element[i], this.m_vertex, this.m_dim);
            int k = 0;
            while (k < this.m_dim) {
                this.m_vt.m_data[k] = this.m_elemCenter[k] + this.m_globalElementNormalLength * this.m_elementNormal[i].m_data[k];
                ++k;
            }
            this.project(this.m_elementNormalTrans[i], this.m_vt, projviewMat, modelMat);
            if (this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors || this.m_bShowEdgeAura) {
                int elemLen = this.m_element[i].m_data.length;
                if (this.m_dim >= 3) {
                    double cz = this.m_vertexTrans[this.m_element[i].m_data[0]].m_data[2];
                    int k2 = 1;
                    while (k2 < elemLen) {
                        cz += (double)this.m_vertexTrans[this.m_element[i].m_data[k2]].m_data[2];
                        ++k2;
                    }
                    if (this.m_elementNormalTrans[i].m_data[2] - (int)(cz / (double)elemLen) < 0) {
                        this.m_elementNormalTrans[i].setTag(14);
                    } else {
                        this.m_elementNormalTrans[i].clearTag(14);
                    }
                }
            }
            ++i;
        }
    }

    private void drawElementTexture_(int[] xv, int[] yv, int[] zv, int len, int xMin, int yMin, int[] destPix, int destWidth, int destHeight, PdVector[] texCoord, int[][] zbuffer) {
        int minYInd = 0;
        int minY = yv[0];
        int i = 1;
        while (i < len) {
            if (yv[i] < minY || yv[i] == minY && yv[(i + 1) % len] > yv[i]) {
                minY = yv[i];
                minYInd = i;
            }
            ++i;
        }
        int a = xv[(minYInd + 1) % len];
        int v = yv[(minYInd - 1 + len) % len];
        int q = yv[minYInd];
        int u = xv[(minYInd - 1 + len) % len];
        int b = yv[(minYInd + 1) % len];
        int p = xv[minYInd];
        boolean bCCW = a * (v - q) + u * (q - b) - (v - b) * p < 0;
        int bndLength = 0;
        int j = 0;
        while (j < len) {
            boolean bBottomBnd;
            boolean bTopBnd;
            i = (minYInd + j) % len;
            int in = (i + 1) % len;
            if (bCCW) {
                bTopBnd = xv[in] < xv[i];
                bBottomBnd = xv[in] > xv[i];
            } else {
                bTopBnd = xv[in] > xv[i];
                bBottomBnd = xv[in] < xv[i];
            }
            int dx = xv[in] - xv[i];
            int dy = yv[in] - yv[i];
            int side = Math.abs(dx) < Math.abs(dy) ? (bCCW && dx < 0 || !bCCW && dx > 0 ? (bCCW && dy < 0 || !bCCW && dy > 0 ? NEE : NWW) : (bCCW && dy > 0 || !bCCW && dy < 0 ? SWW : SEE)) : (bCCW && dx < 0 || !bCCW && dx > 0 ? (bCCW && dy < 0 || !bCCW && dy > 0 ? NNE : NNW) : (bCCW && dy > 0 || !bCCW && dy < 0 ? SSW : SSE));
            bndLength = this.discretizeBndEdge(xv[i], yv[i], zv[i], xv[in], yv[in], zv[in], texCoord[i], texCoord[in], this.m_faceDestBnd, this.m_faceTextureBnd, bndLength, this.m_bShowCurrEdge, bTopBnd, bBottomBnd, bCCW, side, destPix, destWidth, xMin, yMin);
            if (bndLength == -1) {
                return;
            }
            ++j;
        }
        if (bndLength == 0) {
            return;
        }
        int halfWay = (int)((double)(bndLength + 2) / 2.0);
        int y1d = -1;
        int rInd = 0;
        int lInd = 0;
        if (this.m_faceDestBnd[bndLength - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1] && this.m_faceDestBnd[bndLength - 1].m_data[1] == this.m_faceDestBnd[bndLength - 2].m_data[1] && Math.abs(this.m_faceDestBnd[bndLength - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[bndLength - 2].m_data[0] - this.m_faceDestBnd[0].m_data[0])) {
            --bndLength;
        }
        if (this.m_faceDestBnd[bndLength - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1]) {
            lInd = bndLength - 1;
        }
        if (this.m_faceDestBnd[0].m_data[1] == this.m_faceDestBnd[1].m_data[1]) {
            if (this.m_faceDestBnd[bndLength - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1]) {
                if (Math.abs(this.m_faceDestBnd[bndLength - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[bndLength - 1].m_data[0] - this.m_faceDestBnd[1].m_data[0])) {
                    rInd = 1;
                }
            } else {
                rInd = 1;
            }
        }
        i = 0;
        while (i < halfWay) {
            int rightOffset = 0;
            int leftOffset = 0;
            int x1d = this.m_faceDestBnd[rInd].m_data[0] - xMin;
            if (!this.m_bShowCurrEdge) {
                leftOffset = this.m_faceDestBnd[rInd].m_data[3];
            }
            if (x1d >= destWidth) {
                x1d = destWidth - 1;
            }
            if (x1d < 0) {
                x1d = 0;
            }
            if (this.m_faceDestBnd[rInd].m_data[1] - yMin <= y1d || this.m_faceDestBnd[rInd].m_data[1] < 0) {
                ++rInd;
            } else {
                y1d = this.m_faceDestBnd[rInd].m_data[1] - yMin;
                if (y1d < 0 || y1d >= destHeight) break;
                int z1d = this.m_faceDestBnd[rInd].m_data[2];
                while (this.m_faceDestBnd[lInd].m_data[1] - yMin < y1d && lInd > 0) {
                    --lInd;
                }
                if (lInd < 0) break;
                int x2d = this.m_faceDestBnd[lInd].m_data[0] - xMin;
                if (!this.m_bShowCurrEdge) {
                    rightOffset = this.m_faceDestBnd[lInd].m_data[3];
                }
                if (x2d >= destWidth) {
                    x2d = destWidth - 1;
                }
                if (x2d < 0) {
                    x2d = 0;
                }
                int y2d = y1d;
                y2d = this.m_faceDestBnd[lInd].m_data[1] - yMin;
                int z2d = this.m_faceDestBnd[lInd].m_data[2];
                if (y2d < 0 || y2d >= destHeight) {
                    y2d = y1d;
                }
                if (y2d + yMin < 0 || y2d + yMin >= this.m_dispSize.height) {
                    y2d = y1d;
                }
                this.drawScanLine(destPix, destWidth, x1d, y1d, z1d, x2d, y2d, z2d, this.m_faceTextureBnd[rInd].m_data, this.m_faceTextureBnd[lInd].m_data, zbuffer, xMin, yMin, leftOffset, rightOffset);
                ++rInd;
                lInd = lInd == 0 ? bndLength - 1 : --lInd;
            }
            ++i;
        }
    }

    public void assureVertexNormals() {
        super.assureVertexNormals();
        if (this.m_vertexNormalTrans == null || this.m_vertexNormalTrans.length != this.m_maxNumVertices) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, this.m_maxNumVertices, this.m_dimTrans);
        }
    }

    public void assureElementNormals() {
        super.assureElementNormals();
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length != this.m_maxNumElements) {
            this.m_elementNormalTrans = PiVector.realloc(this.m_elementNormalTrans, this.m_maxNumElements, this.m_dimTrans);
        }
    }

    public int[] removePolygon(int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numPolygons - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return null;
        }
        this.m_polygon[anIndex].setTag(2);
        return null;
    }

    public void setTagPolygon(int anIndex, int aTag) {
        this.m_polygon[anIndex].setTag(aTag);
        this.m_geometry.setTagPolygon(anIndex, aTag);
    }

    private int clipPolygon(int polyInd, int edgeInd, int[] xv, int[] yv, int[] zv, int[] origInd) {
        double xin = 0.0;
        double yin = 0.0;
        double zin = 0.0;
        double xout = 0.0;
        double yout = 0.0;
        double zout = 0.0;
        int ind = 0;
        int prev = 0;
        double t = 0.0;
        int j = 0;
        while (j < 2) {
            int vertInd = this.m_polygon[polyInd].m_data[edgeInd + j];
            if ((double)this.m_vertexTrans[vertInd].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[vertInd].m_data[2] > this.m_clipNear) {
                this.m_elemIsClipped = true;
                xout = this.m_vertexTrans[vertInd].m_data[0];
                yout = this.m_vertexTrans[vertInd].m_data[1];
                zout = this.m_vertexTrans[vertInd].m_data[2];
                if (prev == 1) {
                    t = zout < this.m_clipFar ? (zin - this.m_clipFar) / (zin - zout) : (zin - this.m_clipNear) / (zin - zout);
                    xv[ind] = (int)((1.0 - t) * xin + t * xout);
                    yv[ind] = (int)((1.0 - t) * yin + t * yout);
                    zv[ind] = (int)((1.0 - t) * zin + t * zout);
                    origInd[ind] = -1;
                    ++ind;
                }
                prev = -1;
            } else {
                xin = this.m_vertexTrans[vertInd].m_data[0];
                yin = this.m_vertexTrans[vertInd].m_data[1];
                zin = this.m_vertexTrans[vertInd].m_data[2];
                if (prev == -1) {
                    t = zout < this.m_clipFar ? (zin - this.m_clipFar) / (zin - zout) : (zin - this.m_clipNear) / (zin - zout);
                    xv[ind] = (int)((1.0 - t) * xin + t * xout);
                    yv[ind] = (int)((1.0 - t) * yin + t * yout);
                    zv[ind] = (int)((1.0 - t) * zin + t * zout);
                    origInd[ind] = -1;
                    ++ind;
                }
                xv[ind] = this.m_vertexTrans[vertInd].m_data[0];
                yv[ind] = this.m_vertexTrans[vertInd].m_data[1];
                zv[ind] = this.m_vertexTrans[vertInd].m_data[2];
                origInd[ind] = vertInd;
                ++ind;
                prev = 1;
            }
            ++j;
        }
        return ind;
    }

    public PvGeometry(int dim) {
        super(dim);
        this.m_dim = dim < 3 ? 3 : dim;
        this.m_dimTrans = 3;
        this.m_dimOfColors = 3;
        this.m_bShowBackface = true;
        this.m_bShowDepthcue = true;
        this.m_bShowEdgeOnce = true;
        this.m_clipFar = Double.NEGATIVE_INFINITY;
        this.m_clipNear = Double.POSITIVE_INFINITY;
        this.m_vt = new PdVector(4);
        this.init();
    }

    public int[] removeElement(int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return null;
        }
        this.m_element[anIndex].setTag(2);
        return null;
    }

    public boolean setVertexColor(int anIndex, Color aColor) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aColor == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexColors();
        this.m_vertexColor[anIndex] = aColor;
        return true;
    }

    public boolean setElementColor(int anIndex, Color aColor) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aColor == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementColors();
        this.m_elementColor[anIndex] = aColor;
        return true;
    }

    public boolean setVertexTag(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aTag < 0 || aTag >= 32) {
            PsDebug.warning("tag=" + aTag + " out of range", this);
            return false;
        }
        this.m_vertex[anIndex].setTag(aTag);
        return true;
    }

    public boolean setElementTag(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aTag < 0 || aTag >= 32) {
            PsDebug.warning("tag=" + aTag + " out of range", this);
            return false;
        }
        this.m_element[anIndex].setTag(aTag);
        return true;
    }

    public void setTransparency(double trans) {
        this.m_alpha = Math.abs(1.0 - trans) < 0.02 ? 0 : (Math.abs(trans) < 0.02 ? -16777216 : (255 - (int)(255.0 * trans) & 0xFF) << 24);
    }

    public int setVectorField(Object aVectorField) {
        int numVFs = this.getNumVectorFields();
        if (aVectorField == null) {
            this.setNumVectorFields(0);
            return 0;
        }
        this.setNumVectorFields(numVFs + 1);
        return this.m_numVectorFields;
    }

    public void showVectorField(int ind, boolean flag) {
        super.showVectorField(ind, flag);
        if (flag) {
            this.m_bShowVectors = flag;
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (this.m_geometry != null && this.m_geometry.isVisible() != flag) {
            this.m_geometry.setVisible(flag);
        }
    }

    public void clearTagVertex(int anIndex, int aTag) {
        this.m_vertex[anIndex].clearTag(aTag);
        this.m_geometry.clearTagVertex(anIndex, aTag);
    }

    public void setGlobalVertexNormalSize(double aSize) {
        this.m_globalVertexNormalSize = aSize;
        if (this.m_globalVertexNormalSize > 1.0) {
            this.m_globalVertexNormalSize = 2.0 * aSize - 1.0;
        }
    }

    public void setGlobalEdgeSize(double aSize) {
        this.m_globalEdgeSize = aSize;
        if (this.m_globalEdgeSize > 1.0) {
            this.m_globalEdgeSize = 2.0 * aSize - 1.0;
        }
    }

    public void setGlobalElementNormalSize(double aSize) {
        this.m_globalElementNormalSize = aSize;
        if (this.m_globalElementNormalSize > 1.0) {
            this.m_globalElementNormalSize = 2.0 * aSize - 1.0;
        }
    }

    public void setTagElement(int anIndex, int aTag) {
        this.m_element[anIndex].setTag(aTag);
        this.m_geometry.setTagElement(anIndex, aTag);
    }

    private void drawVertex(Graphics g, int vertInd) {
        Color currCol;
        if (this.m_vertex[vertInd].hasTag(2)) {
            return;
        }
        if (this.m_bEnableClip && ((double)this.m_vertexTrans[vertInd].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[vertInd].m_data[2] > this.m_clipNear)) {
            return;
        }
        if (this.m_bShowVertexNormals) {
            currCol = this.m_bShowDepthcue && !this.m_bEnableZBuffer ? PdColor.getDimmedColor(this.m_globalVertexNormalColor, this.m_heightFac) : this.m_globalVertexNormalColor;
            this.drawVector_(g, (int)this.m_globalVertexNormalSize, this.m_vertexTrans[vertInd].m_data[0], this.m_vertexTrans[vertInd].m_data[1], this.m_vertexTrans[vertInd].m_data[2], this.m_vertexNormalTrans[vertInd].m_data[0], this.m_vertexNormalTrans[vertInd].m_data[1], this.m_vertexNormalTrans[vertInd].m_data[2], this.m_bShowVertexNormalArrow, currCol);
        }
        if (this.m_bShowVectors) {
            int j = 0;
            while (j < this.m_numVectorFields) {
                if (this.m_bShowVectorField[j] && !this.m_vectorIsElementBased[j]) {
                    currCol = this.m_globalVectorColor[j];
                    if (this.m_bShowVectorColors[j]) {
                        currCol = this.m_vectorColor[j][vertInd];
                    }
                    this.drawVector_(g, (int)this.m_globalVectorSize[j], this.m_vertexTrans[vertInd].m_data[0], this.m_vertexTrans[vertInd].m_data[1], this.m_vertexTrans[vertInd].m_data[2], this.m_vectorTrans[j][vertInd].m_data[0], this.m_vectorTrans[j][vertInd].m_data[1], this.m_vectorTrans[j][vertInd].m_data[2], this.m_bShowVectorArrow[j], currCol);
                }
                ++j;
            }
        }
        int vSize = (int)this.m_globalVertexSize;
        if (this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[vertInd].hasTag(1)) {
            vSize = (int)(2.0 * this.m_globalVertexSize);
            currCol = this.m_globalVertexTagColor;
        } else if (this.m_bShowVertices) {
            currCol = this.m_bShowVertexColors && this.m_vertexColor != null ? this.m_vertexColor[vertInd] : this.m_globalVertexColor;
            if (this.m_bShowDepthcue) {
                currCol = PdColor.getDimmedColor(currCol, this.m_heightFac);
            }
        } else {
            return;
        }
        int vz = vSize * PS_ZOOM;
        int xPos = this.m_vertexTrans[vertInd].m_data[0];
        int yPos = this.m_vertexTrans[vertInd].m_data[1];
        boolean bDraw = true;
        if (this.m_bEnableZBuffer) {
            int[][] zBuffer = ((PvDisplay)this.m_display).getZBuffer();
            if (yPos >= 0 && yPos < zBuffer.length && xPos >= 0 && xPos < zBuffer[0].length && zBuffer[yPos][xPos] > this.m_vertexTrans[vertInd].m_data[2] + 50) {
                bDraw = false;
            }
        }
        if (bDraw && vz > 0) {
            g.setColor(currCol);
            g.fillOval(xPos - vz, yPos - vz, 2 * vz, 2 * vz);
            g.setColor(Color.black);
            g.drawOval(xPos - vz, yPos - vz, 2 * vz, 2 * vz);
        } else {
            g.setColor(Color.black);
        }
        if (this.m_bShowIndices || this.m_bShowVertexLabels) {
            String name = this.m_vertex[vertInd].getName();
            if (name == null && this.m_bDefaultLabelEnabled) {
                name = String.valueOf(vertInd);
            }
            int[] off = this.m_labelAttribute[0].m_data;
            this.drawString(g, name, xPos, yPos, vSize, off);
        }
    }

    private int clipElement(int elemInd, int elemLength, int[] xv, int[] yv, int[] zv, int[] origInd, PdVector[] texCoord, PdVector[] tex) {
        int OUTSIDE_FAR = -2;
        int OUTSIDE_NEAR = -1;
        int INSIDE = 1;
        double[] t = null;
        int ind = 0;
        int j = 0;
        while (j < elemLength) {
            block23: {
                int vnPos;
                int vcPos;
                int[] vtn;
                int[] vtc;
                int jn;
                int jc;
                block24: {
                    jc = j;
                    jn = (j + 1) % elemLength;
                    int vcInd = this.m_element[elemInd].m_data[jc];
                    int vnInd = this.m_element[elemInd].m_data[jn];
                    vtc = this.m_vertexTrans[vcInd].m_data;
                    vtn = this.m_vertexTrans[vnInd].m_data;
                    vcPos = INSIDE;
                    vnPos = INSIDE;
                    if ((double)vtc[2] < this.m_clipFar) {
                        vcPos = OUTSIDE_FAR;
                    }
                    if ((double)vtc[2] > this.m_clipNear) {
                        vcPos = OUTSIDE_NEAR;
                    }
                    if ((double)vtn[2] < this.m_clipFar) {
                        vnPos = OUTSIDE_FAR;
                    }
                    if ((double)vtn[2] > this.m_clipNear) {
                        vnPos = OUTSIDE_NEAR;
                    }
                    if (vcPos != INSIDE || vnPos != INSIDE) {
                        this.m_elemIsClipped = true;
                    }
                    if (vcPos == OUTSIDE_FAR && vnPos == OUTSIDE_FAR || vcPos == OUTSIDE_NEAR && vnPos == OUTSIDE_NEAR) break block23;
                    if (vcPos != INSIDE) break block24;
                    if (j < elemLength) {
                        xv[ind] = vtc[0];
                        yv[ind] = vtc[1];
                        zv[ind] = vtc[2];
                        if (tex != null) {
                            texCoord[ind].copyArray(tex[j]);
                        }
                        origInd[ind] = vcInd;
                        ++ind;
                    }
                    if (vnPos == INSIDE) break block23;
                }
                if (t == null) {
                    t = new double[2];
                }
                double xin = vtc[0];
                double yin = vtc[1];
                double zin = vtc[2];
                double xout = vtn[0];
                double yout = vtn[1];
                double zout = vtn[2];
                PdVector tin = null;
                PdVector tout = null;
                if (tex != null) {
                    tin = tex[jc];
                    tout = tex[jn];
                }
                int num = 1;
                if (vcPos == INSIDE && vnPos == OUTSIDE_FAR || vcPos == OUTSIDE_FAR && vnPos == INSIDE) {
                    t[0] = (zin - this.m_clipFar) / (zin - zout);
                } else if (vcPos == INSIDE && vnPos == OUTSIDE_NEAR || vcPos == OUTSIDE_NEAR && vnPos == INSIDE) {
                    t[0] = (zin - this.m_clipNear) / (zin - zout);
                } else if (vcPos == OUTSIDE_FAR && vnPos == OUTSIDE_NEAR) {
                    t[0] = (zin - this.m_clipFar) / (zin - zout);
                    t[1] = (zin - this.m_clipNear) / (zin - zout);
                    num = 2;
                } else if (vcPos == OUTSIDE_NEAR && vnPos == OUTSIDE_FAR) {
                    t[0] = (zin - this.m_clipNear) / (zin - zout);
                    t[1] = (zin - this.m_clipFar) / (zin - zout);
                    num = 2;
                }
                int i = 0;
                while (i < num) {
                    xv[ind] = (int)((1.0 - t[i]) * xin + t[i] * xout);
                    yv[ind] = (int)((1.0 - t[i]) * yin + t[i] * yout);
                    zv[ind] = (int)((1.0 - t[i]) * zin + t[i] * zout);
                    if (tex != null) {
                        texCoord[ind].m_data[0] = (1.0 - t[i]) * tin.m_data[0] + t[i] * tout.m_data[0];
                        texCoord[ind].m_data[1] = (1.0 - t[i]) * tin.m_data[1] + t[i] * tout.m_data[1];
                        if (tin.m_data.length > 2) {
                            texCoord[ind].m_data[2] = (1.0 - t[i]) * tin.m_data[2] + t[i] * tout.m_data[2];
                        }
                    }
                    origInd[ind] = -1;
                    ++ind;
                    ++i;
                }
            }
            ++j;
        }
        elemLength = ind;
        return elemLength;
    }

    protected boolean removeGeometryVertex(int anInd) {
        this.removeVertex(anInd);
        this.m_geometry.removeVertex(anInd);
        return true;
    }

    protected int addGeometryElement(PiVector anElement) {
        this.addElement(anElement);
        return this.m_geometry.addElement(anElement);
    }

    public boolean setVertexNormal(int anIndex, PdVector aNormal) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aNormal == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexNormals();
        this.m_vertexNormal[anIndex].copy(aNormal);
        return true;
    }

    public boolean setElementNormal(int anIndex, PdVector aNormal) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aNormal == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementNormals();
        this.m_elementNormal[anIndex].copy(aNormal);
        return true;
    }

    private void drawElementNormal(Graphics g, int elemInd, int len, int[] xv, int[] yv, int[] zv) {
        this.getElementCenter(this.m_elemCenter, this.m_element[elemInd], this.m_vertexTrans, 3);
        Color currCol = this.m_bShowDepthcue ? PdColor.getDimmedColor(this.m_globalElementNormalColor, this.m_heightFac) : this.m_globalElementNormalColor;
        this.drawVector_(g, (int)this.m_globalElementNormalSize, (int)this.m_elemCenter[0], (int)this.m_elemCenter[1], (int)this.m_elemCenter[2], this.m_elementNormalTrans[elemInd].m_data[0], this.m_elementNormalTrans[elemInd].m_data[1], this.m_elementNormalTrans[elemInd].m_data[2], this.m_bShowElementNormalArrow, currCol);
    }

    private void writePixel(int x, int y, int[] destPix, int destWidth, int xMin, int yMin, int[][] zbuffer, int col, double zs) {
        if (y < 0 || y >= zbuffer.length - 1 || x < 0 || x >= zbuffer[0].length) {
            return;
        }
        if ((int)zs < zbuffer[y][x]) {
            return;
        }
        int pixel = col;
        if (this.m_bShowDepthcue && this.m_bDepthcueEdge) {
            double depth = this.m_heightFac;
            if (!this.m_bUse_m_heightFac) {
                double srcZMin = PvScene.m_zMin;
                double srcZMax = PvScene.m_zMax;
                double zFac = 1.0;
                if (srcZMax - srcZMin != 0.0) {
                    zFac = srcZMax - srcZMin;
                }
                depth = (zs - srcZMin) / zFac;
            }
            int r = (int)((double)(pixel >> 16 & 0xFF) * depth);
            int g = (int)((double)(pixel >> 8 & 0xFF) * depth);
            int b = (int)((double)(pixel & 0xFF) * depth);
            int greyScale = (int)(this.m_grey * (1.0 - depth));
            pixel = (r += greyScale) << 16 | (g += greyScale) << 8 | (b += greyScale);
        }
        destPix[(y - yMin) * destWidth + (x - xMin)] = pixel = this.m_alpha | pixel;
        zbuffer[y][x] = (int)zs;
    }

    private void drawLine_(int x0, int y0, int z0, int x1, int y1, int z1, int[] destPix, int destWidth, int xMin, int yMin, int[][] zbuffer, Color col) {
        int currCol = col.getRGB();
        int dx = x1 - x0;
        int dy = y1 - y0;
        double dz = z1 - z0;
        int x = x0;
        int y = y0;
        double z = z0;
        int xIncr = 1;
        int yIncr = 1;
        if (dx < 0) {
            dx = -dx;
            xIncr = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yIncr = -1;
        }
        if (Math.abs(dx) >= Math.abs(dy)) {
            dz /= (double)Math.abs(dx);
            int d = 2 * dy - dx;
            int incrE = 2 * dy;
            int incrNE = 2 * (dy - dx);
            while (x != x1) {
                this.writePixel(x, y, destPix, destWidth, xMin, yMin, zbuffer, currCol, z);
                x += xIncr;
                z += dz;
                if (d <= 0) {
                    d += incrE;
                    continue;
                }
                d += incrNE;
                y += yIncr;
            }
        } else {
            dz /= (double)Math.abs(dy);
            int d = 2 * dx - dy;
            int incrE = 2 * dx;
            int incrNE = 2 * (dx - dy);
            while (y != y1) {
                this.writePixel(x, y, destPix, destWidth, xMin, yMin, zbuffer, currCol, z);
                y += yIncr;
                z += dz;
                if (d <= 0) {
                    d += incrE;
                    continue;
                }
                d += incrNE;
                x += xIncr;
            }
        }
    }

    public int[] removeVertex(int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return null;
        }
        this.m_vertex[anIndex].setTag(2);
        return null;
    }

    public void setTagVertex(int anIndex, int aTag) {
        this.m_vertex[anIndex].setTag(aTag);
        this.m_geometry.setTagVertex(anIndex, aTag);
    }

    private boolean drawLine_(Graphics g, int lineWidth, int x0, int y0, int z0, int x1, int y1, int z1, int[] destPix, int destWidth, int xMin, int yMin, int[][] zbuffer, Color col) {
        if (lineWidth == 1) {
            return false;
        }
        double halfWidth = (double)lineWidth / 2.0;
        double deltaX = x1 - x0;
        double deltaY = y0 - y1;
        double angle = x0 == x1 ? 0.0 : Math.atan(deltaY / deltaX) - 1.5707963267948966;
        int xOffset = (int)(halfWidth * Math.cos(angle));
        int yOffset = (int)(halfWidth * Math.sin(angle));
        int[] xCorner = new int[]{x0 + xOffset, x1 + xOffset, x1 - xOffset, x0 - xOffset};
        int[] yCorner = new int[]{y0 - yOffset, y1 - yOffset, y1 + yOffset, y0 + yOffset};
        int[] zCorner = new int[]{z0, z1, z1, z0};
        double srcZMin = PvScene.m_zMin;
        double srcZMax = PvScene.m_zMax;
        double zFac = 1.0;
        if (srcZMax - srcZMin != 0.0) {
            zFac = srcZMax - srcZMin;
        }
        int len = 4;
        PdVector[] texCoord = PdVector.realloc(null, len, 3);
        int j = 0;
        while (j < len) {
            texCoord[j].m_data[0] = (double)this.m_textureWidth - 1.0;
            texCoord[j].m_data[1] = (double)this.m_textureHeight - 1.0;
            texCoord[j].setEntry(2, ((double)zCorner[j] - srcZMin) / zFac);
            ++j;
        }
        this.drawElementZBuffer(g, xCorner, yCorner, zCorner, len, col, texCoord);
        return true;
    }

    protected int addGeometryVertex(PdVector aVertex) {
        this.addVertex(aVertex);
        return this.m_geometry.addVertex(aVertex);
    }

    public void setModelMatrix(PdMatrix modelMat) {
        super.setModelMatrix(modelMat);
        if (this.m_geometry != null) {
            this.m_geometry.setModelMatrix(modelMat);
        }
    }

    public void setAmbientMatrix(PdMatrix ambientMat, PdMatrix ambientInvMat) {
        super.setAmbientMatrix(ambientMat, ambientInvMat);
        if (this.m_geometry != null) {
            this.m_geometry.setAmbientMatrix(ambientMat, ambientInvMat);
        }
    }

    public void setPolygons(PiVector[] polygon) {
        super.setPolygons(polygon);
        this.computeNumPolygonEdges();
    }

    public void setGlobalPolygonNormalSize(double aSize) {
        this.m_globalPolygonNormalSize = aSize;
        if (this.m_globalPolygonNormalSize > 1.0) {
            this.m_globalPolygonNormalSize = 2.0 * aSize - 1.0;
        }
    }

    public void setGlobalPolygonSize(double aSize) {
        this.m_globalPolygonSize = (int)aSize;
        if (this.m_globalPolygonSize > 1.0) {
            this.m_globalPolygonSize = 2.0 * aSize - 1.0;
        }
    }

    private boolean drawElementZBuffer(Graphics g, int[] xv, int[] yv, int[] zv, int len, Color col, PdVector[] texCoord) {
        if (col != null) {
            this.m_currElementCol = this.m_alpha | col.getRGB();
        }
        int misImage = -1;
        if (!this.m_bNewZBuffer && (misImage = this.assureMIS(xv, yv, len)) == MIS_IMAGE_OUTSIDE) {
            return false;
        }
        this.drawElementTexture_(xv, yv, zv, len, this.m_elemMin[0], this.m_elemMin[1], this.m_pix.m_data, this.imgWidth, this.m_elemHeight, texCoord, ((PvDisplay)this.m_display).getZBuffer());
        if (!this.m_bNewZBuffer) {
            this.drawMIS(g, misImage);
        }
        return true;
    }

    private boolean drawLineZBuffer(Graphics g, int[] xv, int[] yv, int[] zv, int len, Color col) {
        if (col != null) {
            this.m_currElementCol = this.m_alpha | col.getRGB();
        }
        int misImage = -1;
        if (!this.m_bNewZBuffer && (misImage = this.assureMIS(xv, yv, len)) == MIS_IMAGE_OUTSIDE) {
            return false;
        }
        this.drawLine_(xv[0], yv[0], zv[0], xv[1], yv[1], zv[1], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), col);
        if (!this.m_bNewZBuffer) {
            this.drawMIS(g, misImage);
        }
        return true;
    }

    private boolean drawLineZBuffer(Graphics g, int size, int[] xv, int[] yv, int[] zv, int len, Color col) {
        this.drawLine_(g, size, xv[0], yv[0], zv[0], xv[1], yv[1], zv[1], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), col);
        return true;
    }

    protected int updateUnusedVertices() {
        int j;
        int USED = -1;
        this.m_unusedVertex.setSize(this.m_numVertices);
        this.m_unusedVertex.setConstant(0);
        int[] index = this.m_unusedVertex.m_data;
        int i = 0;
        while (i < this.m_numElements) {
            j = this.m_element[i].m_data.length - 1;
            while (j >= 0) {
                index[this.m_element[i].m_data[j]] = USED;
                --j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numPolygons) {
            j = this.m_polygon[i].m_data.length - 1;
            while (j >= 0) {
                index[this.m_polygon[i].m_data[j]] = USED;
                --j;
            }
            ++i;
        }
        int nouv = 0;
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] != USED) {
                index[nouv++] = i;
            }
            ++i;
        }
        this.m_numUnusedVertices = nouv;
        return this.m_numUnusedVertices;
    }

    public void setStateFromDisplay(int aKey, boolean aState) {
        if (this.m_geometry == null) {
            return;
        }
        switch (aKey) {
            case 50: {
                break;
            }
            default: {
                PsDebug.warning("invalid key = " + aKey);
            }
        }
        this.setState(aKey, aState);
        this.m_geometry.setState(aKey, aState);
    }

    private void drawScanLine(int[] destPix, int destWidth, int x1d, int y1d, int z1d, int x2d, int y2d, int z2d, double[] p1s, double[] p2s, int[][] zbuffer, int xMin, int yMin, int offset1, int offset2) {
        float zd;
        float zs;
        float ys;
        float xs;
        int pixel = 0;
        float zd_inc = 0.0f;
        float xs_inc = 0.0f;
        float ys_inc = 0.0f;
        float zs_inc = 0.0f;
        int nSteps = x2d - x1d;
        int xPos = xMin;
        int yPos = y1d + yMin;
        if (yPos < 0 || yPos >= this.m_dispSize.height) {
            return;
        }
        int offset = y1d * destWidth;
        if (nSteps >= 0) {
            offset += x1d;
            xs = (float)p1s[0];
            ys = (float)p1s[1];
            zs = (float)p1s[2];
            zd = (float)z1d + 0.5f;
            xPos += x1d;
        } else {
            offset += x2d;
            xs = (float)p2s[0];
            ys = (float)p2s[1];
            zs = (float)p2s[2];
            zd = (float)z2d + 0.5f;
            xPos += x2d;
            int tmp = offset1;
            offset1 = offset2;
            offset2 = tmp;
        }
        if (nSteps != 0) {
            xs_inc = (float)((p2s[0] - p1s[0]) / (double)nSteps);
            ys_inc = (float)((p2s[1] - p1s[1]) / (double)nSteps);
            zs_inc = (float)((p2s[2] - p1s[2]) / (double)nSteps);
            zd_inc = (float)(z2d - z1d) / (float)nSteps;
            if (nSteps < 0) {
                nSteps = -nSteps;
            }
        }
        nSteps += offset2;
        if (offset1 > 0) {
            int i = 0;
            while (i < offset1) {
                ++offset;
                ++xPos;
                xs += xs_inc;
                ys += ys_inc;
                zs += zs_inc;
                zd += zd_inc;
                --nSteps;
                ++i;
            }
        }
        while (nSteps >= 0) {
            if (xPos >= 0 && xPos < this.m_dispSize.width) {
                if (zbuffer != null && zbuffer[yPos][xPos] > (int)zd) {
                    if ((destPix[offset] >> 24 & 0xFF) == m_colMark) {
                        destPix[offset] = this.m_bNewZBuffer ? this.m_alpha | destPix[offset] & 0xFFFFFF : 0;
                    }
                } else {
                    if (zbuffer != null) {
                        zbuffer[yPos][xPos] = (int)zd;
                    }
                    if (this.m_bShowCurrEdge && (destPix[offset] >> 24 & 0xFF) == m_colMark) {
                        destPix[offset] = this.m_currEdgeCol;
                    } else if (this.m_bShowCurrElement) {
                        int pos;
                        pixel = this.m_texturePix != null && (this.m_bShowVertexTexture || this.m_bShowElementTexture) && !this.m_bDrawingEdge ? ((pos = (this.m_textureHeight - (int)ys - 1) * this.m_textureWidth + (int)xs) >= 0 && pos < this.m_texturePix.length ? this.m_texturePix[pos] : this.m_currElementCol) : this.m_currElementCol;
                        if (this.m_bShowDepthcue && (!this.m_bDrawingEdge || this.m_bDepthcueEdge)) {
                            int r = (int)((float)(pixel >> 16 & 0xFF) * zs);
                            int g = (int)((float)(pixel >> 8 & 0xFF) * zs);
                            int b = (int)((float)(pixel & 0xFF) * zs);
                            if (this.m_bDrawingEdge && this.m_bDepthcueEdge) {
                                int greyScale = (int)(this.m_grey * (1.0 - (double)zs));
                                r += greyScale;
                                g += greyScale;
                                b += greyScale;
                            }
                            pixel = r << 16 | g << 8 | b;
                        }
                        destPix[offset] = pixel = this.m_alpha | pixel;
                    } else if ((destPix[offset] >> 24 & 0xFF) == m_colMark) {
                        destPix[offset] = this.m_alpha | destPix[offset] & 0xFFFFFF;
                    }
                }
            }
            ++offset;
            ++xPos;
            xs += xs_inc;
            ys += ys_inc;
            zs += zs_inc;
            zd += zd_inc;
            --nSteps;
        }
    }

    protected void clearMIS() {
        this.mis = null;
        this.imgWidth = 0;
        this.imgHeight = 0;
        this.m_destImage = null;
        this.m_elemHeight = this.m_dispSize.height;
        this.m_elemMin[0] = 0;
        this.m_elemMin[1] = 0;
        this.m_pix.m_data = null;
        this.m_pixZero.m_data = null;
    }
}

