/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuReflect;
import jv.viewer.PvDisplay;

final class PvModelCamera
extends PsObject {
    private double SIZE = 10.0;
    protected PdMatrix m_ambient = new PdMatrix();
    protected PdMatrix m_ambientInv = new PdMatrix();
    protected PdMatrix m_incrAmbient = new PdMatrix();
    protected PdMatrix m_incrAmbientInv = new PdMatrix();
    protected PdMatrix m_model = new PdMatrix(4);
    protected PdMatrix m_modelInv = new PdMatrix(4);
    protected PdMatrix m_incrModel = new PdMatrix(4);
    protected PdMatrix m_incrModelInv = new PdMatrix(4);
    protected PdMatrix m_viewCamera = new PdMatrix(4);
    protected PdMatrix m_viewInvCamera = new PdMatrix(4);
    protected int m_mode;
    protected int m_transformationMode;
    protected double m_nHeight;
    protected double m_nWidth;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected double[] m_prevNormLoc = new double[2];
    protected double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;
    private static /* synthetic */ Class class$jv$viewer$PvModelCamera;

    protected void mouseAnimate() {
        switch (this.getTransformationMode()) {
            default: {
                PsDebug.warning("neither in model nor ambient transformation mode.");
                break;
            }
            case 1: {
                if (!this.m_display.isEnabledLocalTransform()) {
                    this.m_model.leftMult(this.m_viewCamera);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_model.leftMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    this.m_modelInv.rightMult(this.m_viewCamera);
                    break;
                }
                this.m_model.rightMult(this.m_incrModel);
                this.m_modelInv.leftMult(this.m_incrModelInv);
                break;
            }
            case 2: {
                this.m_ambient.rightMult(this.m_incrAmbient);
                this.m_ambientInv.leftMult(this.m_incrAmbientInv);
                break;
            }
        }
    }

    protected void mousePressed(int x, int y) {
        PvDisplay.normalizedCoordsFromViewport(this.m_prevNormLoc, x, y, (int)this.m_nWidth, (int)this.m_nHeight);
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * this.SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * this.SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
    }

    protected void mouseDragged(int x, int y, boolean bShiftConstraint) {
        PvDisplay.normalizedCoordsFromViewport(this.m_currNormLoc, x, y, (int)this.m_nWidth, (int)this.m_nHeight);
        double xValue = this.m_currNormLoc[0] * this.SIZE / 2.0;
        double yValue = this.m_currNormLoc[1] * this.SIZE / 2.0;
        double zValue = xValue + yValue;
        double dXValue = xValue - this.m_xTransValue;
        double dYValue = yValue - this.m_yTransValue;
        double dZValue = zValue - this.m_zTransValue;
        this.m_xTransValue = xValue;
        this.m_yTransValue = yValue;
        this.m_zTransValue = zValue;
        switch (this.m_transformationMode) {
            case 0: {
                return;
            }
            case 1: {
                this.m_incrModel.setIdentity();
                this.m_incrModelInv.setIdentity();
                if (this.m_mode == 1) {
                    double value = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
                    double dValue = value / this.m_scaleValue;
                    this.m_scaleTotal *= dValue;
                    this.m_scaleValue = value;
                    this.m_incrModel.m_data[0][0] = dValue;
                    this.m_incrModel.m_data[1][1] = dValue;
                    this.m_incrModel.m_data[2][2] = dValue;
                    this.m_incrModelInv.m_data[0][0] = 1.0 / dValue;
                    this.m_incrModelInv.m_data[1][1] = 1.0 / dValue;
                    this.m_incrModelInv.m_data[2][2] = 1.0 / dValue;
                    this.m_model.rightMult(this.m_incrModel);
                    this.m_modelInv.leftMult(this.m_incrModelInv);
                    return;
                }
                if (this.m_mode == 3) {
                    this.m_incrModel.m_data[0][3] = dXValue;
                    this.m_incrModel.m_data[1][3] = dYValue;
                    this.m_incrModelInv.m_data[0][3] = -dXValue;
                    this.m_incrModelInv.m_data[1][3] = -dYValue;
                } else if (this.m_mode == 4) {
                    this.m_incrModel.m_data[2][3] = dZValue;
                    this.m_incrModelInv.m_data[2][3] = -dZValue;
                } else if (this.m_mode == 0) {
                    double angle;
                    this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                    if (bShiftConstraint) {
                        int axis = 0;
                        if (this.m_currNormLoc[1] == this.m_prevNormLoc[1]) {
                            axis = 1;
                        }
                        if (this.m_vecAlt.getEntry(axis) != 0.0) {
                            this.m_vecAlt.setEntry(axis, 0.0);
                            this.m_vecAlt.normalize();
                        }
                        this.m_vec.setEntry(axis, 0.0);
                        this.m_vec.normalize();
                    }
                    if ((angle = Math.acos(PdVector.dot(this.m_vec, this.m_vecAlt))) < 1.0E-10) {
                        PsDebug.notify("angle too small");
                        return;
                    }
                    this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                    this.m_vecAlt.copy(this.m_vec);
                    if (this.m_rotAxis.length() < 1.0E-10) {
                        PsDebug.notify("rotAxis too small");
                        return;
                    }
                    if (!PuReflect.makeRotation(this.m_incrModel, this.m_rotAxis, angle)) {
                        return;
                    }
                    this.m_incrModelInv.transpose(this.m_incrModel);
                } else {
                    return;
                }
                if (!this.m_display.isEnabledLocalTransform()) {
                    this.m_model.leftMult(this.m_viewCamera);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_model.leftMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    this.m_modelInv.rightMult(this.m_viewCamera);
                    break;
                }
                this.m_model.rightMult(this.m_incrModel);
                this.m_modelInv.leftMult(this.m_incrModelInv);
                break;
            }
            case 2: {
                double angle;
                dXValue /= this.SIZE;
                dYValue /= this.SIZE;
                dZValue /= this.SIZE;
                int ambDim = this.m_incrAmbient.getSize() - 1;
                this.m_incrAmbient.setIdentity();
                this.m_incrAmbientInv.setIdentity();
                int ambientSpace = this.m_display.getAmbientSpace();
                if (this.m_mode == 1) {
                    double value = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
                    double dValue = value / this.m_scaleValue;
                    int i = 0;
                    while (i < ambDim) {
                        this.m_incrAmbient.m_data[i][i] = dValue;
                        this.m_incrAmbientInv.m_data[i][i] = 1.0 / dValue;
                        ++i;
                    }
                    this.m_scaleTotal *= dValue;
                    this.m_scaleValue = value;
                    break;
                }
                if (this.m_mode == 3) {
                    if (ambientSpace == 0) {
                        this.m_incrAmbient.m_data[0][ambDim] = dXValue;
                        this.m_incrAmbientInv.m_data[0][ambDim] = -dXValue;
                        break;
                    }
                    if (ambientSpace == 1 || ambientSpace == 3 || ambientSpace == 6 || ambientSpace == 9) {
                        this.m_incrAmbient.m_data[0][ambDim] = dXValue;
                        this.m_incrAmbient.m_data[1][ambDim] = dYValue;
                        this.m_incrAmbientInv.m_data[0][ambDim] = -dXValue;
                        this.m_incrAmbientInv.m_data[1][ambDim] = -dYValue;
                        break;
                    }
                    if (ambientSpace == 2) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, ambDim - 1, dXValue *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (ambientSpace == 4 || ambientSpace == 7 || ambientSpace == 10) {
                        PdMatrix tmpMat = new PdMatrix(ambDim + 1);
                        PvModelCamera.translateSpherical(tmpMat, 0, ambDim - 1, dXValue *= -Math.PI);
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 1, ambDim - 1, dYValue *= -Math.PI);
                        this.m_incrAmbient.rightMult(tmpMat);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (ambientSpace != 5 && ambientSpace != 8 && ambientSpace != 11) break;
                    PdMatrix tmpMat = new PdMatrix(ambDim + 1);
                    PvModelCamera.translateHyperbolic(tmpMat, 0, ambDim - 1, dXValue);
                    PvModelCamera.translateHyperbolic(this.m_incrAmbient, 1, ambDim - 1, dYValue);
                    this.m_incrAmbient.rightMult(tmpMat);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode == 4) {
                    if (ambientSpace == 1 || ambientSpace == 2 || ambientSpace == 4 || ambientSpace == 5) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, 1, dZValue *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (ambientSpace == 3) {
                        this.m_incrAmbient.m_data[2][ambDim] = dZValue;
                        this.m_incrAmbientInv.m_data[2][ambDim] = -dZValue;
                        break;
                    }
                    if (ambientSpace == 6 || ambientSpace == 9) {
                        this.m_incrAmbient.m_data[2][ambDim] = dXValue;
                        this.m_incrAmbientInv.m_data[2][ambDim] = -dXValue;
                        this.m_incrAmbient.m_data[3][ambDim] = dYValue;
                        this.m_incrAmbientInv.m_data[3][ambDim] = -dYValue;
                        break;
                    }
                    if (ambientSpace == 7) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 2, ambDim - 1, dZValue *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (ambientSpace == 10) {
                        PdMatrix tmpMat = new PdMatrix(ambDim + 1);
                        PvModelCamera.translateSpherical(tmpMat, 2, ambDim - 1, dXValue *= -Math.PI);
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 3, ambDim - 1, dYValue *= -Math.PI);
                        this.m_incrAmbient.rightMult(tmpMat);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (ambientSpace == 8) {
                        PvModelCamera.translateHyperbolic(this.m_incrAmbient, 2, ambDim - 1, dZValue);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (ambientSpace != 11) break;
                    PdMatrix tmpMat = new PdMatrix(ambDim + 1);
                    PvModelCamera.translateHyperbolic(tmpMat, 2, ambDim - 1, dZValue);
                    PvModelCamera.translateHyperbolic(this.m_incrAmbient, 3, ambDim - 1, dZValue);
                    this.m_incrAmbient.rightMult(tmpMat);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode != 0) break;
                if (ambientSpace == 0) {
                    return;
                }
                this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                if (bShiftConstraint) {
                    int axis = 0;
                    if (this.m_currNormLoc[1] == this.m_prevNormLoc[1]) {
                        axis = 1;
                    }
                    if (this.m_vecAlt.getEntry(axis) != 0.0) {
                        this.m_vecAlt.setEntry(axis, 0.0);
                        this.m_vecAlt.normalize();
                    }
                    this.m_vec.setEntry(axis, 0.0);
                    this.m_vec.normalize();
                }
                if ((angle = Math.acos(this.m_vec.dot(this.m_vecAlt))) < 1.0E-10) {
                    PsDebug.notify("angle too small");
                    return;
                }
                if (ambientSpace == 1 || ambientSpace == 5 || ambientSpace == 2) {
                    if (this.m_vec.getEntry(0) < this.m_vecAlt.getEntry(0)) {
                        angle = -angle;
                    }
                    PvModelCamera.translateSpherical(this.m_incrAmbient, 0, 1, angle);
                } else {
                    this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                    if (this.m_rotAxis.length() < 1.0E-10) {
                        PsDebug.notify("rotAxis too small");
                        return;
                    }
                    if (!PuReflect.makeRotation(this.m_incrAmbient, this.m_rotAxis, angle)) {
                        return;
                    }
                }
                this.m_vecAlt.copy(this.m_vec);
                this.m_incrAmbientInv.transpose(this.m_incrAmbient);
            }
        }
        this.m_ambient.rightMult(this.m_incrAmbient);
        this.m_ambientInv.leftMult(this.m_incrAmbientInv);
    }

    public void setCurrentView(PdMatrix viewMat, PdMatrix viewInvMat) {
        this.m_viewCamera.copy(viewMat);
        this.m_viewInvCamera.copy(viewInvMat);
    }

    public PvModelCamera(PvDisplay display) {
        this.m_display = display;
        if (this.getClass() == (class$jv$viewer$PvModelCamera != null ? class$jv$viewer$PvModelCamera : (class$jv$viewer$PvModelCamera = PvModelCamera.class$("jv.viewer.PvModelCamera")))) {
            this.init();
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int aMode) {
        this.m_mode = aMode;
    }

    public PdMatrix getAmbientInvMatrix() {
        return this.m_ambientInv;
    }

    public PdMatrix getModelInvMatrix() {
        return this.m_modelInv;
    }

    private static void translateHyperbolic(PdMatrix incrMat, int i, int j, double t) {
        incrMat.setIdentity();
        incrMat.m_data[i][i] = PuMath.cosh(t);
        incrMat.m_data[i][j] = PuMath.sinh(t);
        incrMat.m_data[j][i] = PuMath.sinh(t);
        incrMat.m_data[j][j] = PuMath.cosh(t);
    }

    public int getTransformationMode() {
        return this.m_transformationMode;
    }

    public void setTransformationMode(int aMode) {
        this.m_transformationMode = aMode;
    }

    public PdMatrix getAmbientMatrix() {
        return this.m_ambient;
    }

    public void setAmbientMatrix(PdMatrix ambientMat, PdMatrix ambientMatInv) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        if (ambientMat != null) {
            this.m_ambient.setSize(ambientMat.getISize(), ambientMat.getJSize());
            this.m_ambient.copy(ambientMat);
            this.m_incrAmbient.setSize(ambientMat.getISize(), ambientMat.getJSize());
        } else {
            this.m_ambient.setIdentity();
        }
        if (ambientMatInv != null) {
            this.m_ambientInv.setSize(ambientMatInv.getISize(), ambientMatInv.getJSize());
            this.m_ambientInv.copy(ambientMatInv);
            this.m_incrAmbientInv.setSize(ambientMatInv.getISize(), ambientMatInv.getJSize());
        } else {
            this.m_ambientInv.setIdentity();
        }
        this.m_incrAmbient.setIdentity();
        this.m_incrAmbientInv.setIdentity();
    }

    public PdMatrix getModelMatrix() {
        return this.m_model;
    }

    public void setModelMatrix(PdMatrix modelMat) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        if (modelMat != null) {
            this.m_model.copy(modelMat);
        } else {
            this.m_model.setIdentity();
        }
        this.m_modelInv.invert34(this.m_model);
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    protected void resizeImage(double aWidth, double aHeight) {
        if (aWidth == 0.0 || aHeight == 0.0) {
            PsDebug.warning("window has a dimension==0");
            return;
        }
        this.m_nWidth = aWidth;
        this.m_nHeight = aHeight;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_ambient.setIdentity();
        this.m_ambientInv.setIdentity();
        this.m_incrAmbient.setIdentity();
        this.m_incrAmbientInv.setIdentity();
        this.m_model.setIdentity();
        this.m_modelInv.setIdentity();
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    private static void translateSpherical(PdMatrix incrMat, int i, int j, double angle) {
        incrMat.setIdentity();
        incrMat.m_data[i][i] = Math.cos(angle);
        incrMat.m_data[i][j] = -Math.sin(angle);
        incrMat.m_data[j][i] = Math.sin(angle);
        incrMat.m_data[j][j] = Math.cos(angle);
    }
}

