/* _math.h - internal math and trig definitions
 * $Version: 1.5 $
 * Copyright (c) 1988-91, 93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __MATH
#define __MATH

#include <yvals.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro definitions
 */

#define mqerACS MQERACS
#define mqerASN MQERASN
#define mqerATN MQERATN
#define mqerAT2 MQERAT2
#define mqerCOS MQERCOS
#define mqerSIN MQERSIN
#define mqerTAN MQERTAN
#define mqerEXP MQEREXP
#define mqerLGE MQERLGE
#define mqerLGD MQERLGD
#define mqerY2X MQERY2X

#define	NPX_EXCEPTION	0X007F
#define	NPX_OVERFLOW	0X0008
#define	NPX_UNDERFLOW	0X0010
#define	NPX_PRECISION	0X0020

/*
 * function prototypes
 */

#ifdef __INT32__
double near     _Pascal mqerACS(double);
double near     _Pascal mqerASN(double);
double near     _Pascal mqerATN(double);
double near     _Pascal mqerAT2(double, double);
double near     _Pascal mqerCOS(double);
double near     _Pascal mqerSIN(double);
double near     _Pascal mqerTAN(double);
double near     _Pascal mqerEXP(double);
double near     _Pascal mqerLGE(double);
double near     _Pascal mqerLGD(double);
double near     _Pascal mqerY2X(double, double);
#else /* __INT16__ */
double far      _Pascal mqerACS(double);
double far      _Pascal mqerASN(double);
double far      _Pascal mqerATN(double);
double far      _Pascal mqerAT2(double, double);
double far      _Pascal mqerCOS(double);
double far      _Pascal mqerSIN(double);
double far      _Pascal mqerTAN(double);
double far      _Pascal mqerEXP(double);
double far      _Pascal mqerLGE(double);
double far      _Pascal mqerLGD(double);
double far      _Pascal mqerY2X(double, double);
#endif /* __INT32__ */
double          _Pascal _ceil(double);
unsigned int    _Pascal _clear87(void);
int             _Pascal _err_map(int);
double          _Pascal _floor(double);
double          _Pascal _j0(double);
double          _Pascal _j1(double);
double          _Pascal _jn(int, double);
double          _Pascal _modf(double, double *);
double          _Pascal _sqrt(double);
double          _Pascal _square(double);
unsigned int    _Pascal _status87(void);
double          _Pascal _y0(double);
double          _Pascal _y1(double);
double          _Pascal _yn(int, double);

#ifdef __cplusplus
}
#endif
#endif /* __MATH */


