/* 
 * mailbox.h C++ class for iRMX mailboxes
 * $Version: 1.3 $
 * Copyright (c) 1993 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __MMAILBOX_H_
#define __MMAILBOX_H_

#include <string.h>
#include <rmxobj.h>

	/*
	 * class Mailbox: iRMX mailboxes.
	 */
class Mailbox : public RMXObject
{
	public:
		~Mailbox() { };

	protected:

	private:

};

	/*
	 * class MsgMailbox
	 *              Abstract class for FIFO- and priority- queued message mailboxes.
	 *      These will be subclassed.  It also serves as an abstract class for the
	 *      ReturnMailbox class.
	 */
class MsgMailbox : public RMXObject
{
	public:
		~MsgMailbox()
			{ rqdeletemailbox(token, &cur_excep); };
		void sendNoResponse(RMXObject &);
		void send(RMXObject &, RMXObject &);
		RMXObject *receiveTimeout(RMXObject **resp_obj, unsigned short timeout);
		RMXObject *receiveNow(RMXObject **resp_obj);
		RMXObject *receiveForever(RMXObject **resp_obj);

	protected:

	private:
		RMXObject *receive(RMXObject &, unsigned short timeout);

};

inline void MsgMailbox::sendNoResponse (RMXObject &obj)
{
	rqsendmessage (token, obj.token, (selector) 0, &cur_excep);
}

inline void MsgMailbox::send (RMXObject &obj, RMXObject &resp_obj)
{
	rqsendmessage (token, obj.token, resp_obj.token, &cur_excep);
}

class FIFOMsgMailbox : public MsgMailbox
{
	public:
		FIFOMsgMailbox(unsigned char fast_queue_size = 8);

	protected:

	private:

};

class PriorityMsgMailbox : public MsgMailbox
{
	public:
		PriorityMsgMailbox(unsigned char fast_queue_size = 8);

	protected:

	private:

};

	/*
	 * class DataMailbox
	 *              Abstract class for FIFO- and priority- queued data mailboxes.
	 *      These will be subclassed.
	 */
class DataMailbox : public RMXObject
{
	public:
		~DataMailbox()
			{ rqdeletemailbox(token, &cur_excep); };
		void send(unsigned char far *msg_ptr, unsigned short length);
		void sendString(unsigned char far *msg_ptr);
		unsigned short receiveTimeout(unsigned char far *msg_ptr,
										unsigned short timeout);
		unsigned short receiveNow(unsigned char far *msg_ptr);
		unsigned short receiveForever(unsigned char far *msg_ptr);

	protected:

	private:
		RMXObject *receive(RMXObject &, unsigned short timeout);

};

inline void DataMailbox::send(unsigned char far *msg_ptr, 
	unsigned short length)
{
	rqsenddata (token, msg_ptr, length, &cur_excep);
}

inline void DataMailbox::sendString(unsigned char far *msg_ptr)
{
	rqsenddata (token, msg_ptr, strlen((const char *)msg_ptr), &cur_excep);
}

inline unsigned short DataMailbox::receiveTimeout (unsigned char far *msg_ptr,
											unsigned short timeout)
{
	return rqreceivedata (token, msg_ptr, timeout, &cur_excep);
}

inline unsigned short DataMailbox::receiveNow (unsigned char far *msg_ptr)
{
	return receiveTimeout (msg_ptr, 0);
}

inline unsigned short DataMailbox::receiveForever (unsigned char far *msg_ptr)
{
	return receiveTimeout (msg_ptr, 0xFFFF);
}

class FIFODataMailbox : public DataMailbox
{
	public:
		FIFODataMailbox(void);

	protected:

	private:

};

class PriorityDataMailbox : public DataMailbox
{
	public:
		PriorityDataMailbox(void);

	protected:

	private:

};

#endif  /*      __MMAILBOX_H_   */
