/* nucleus.h iRMX header
 * $Version: 1.10 $
 * Copyright (C) 1989-91, 93 Intel Corporation, ALL RIGHTS RESERVED
 */

#ifndef __NUCLEUSH__
#define __NUCLEUSH__

#include <yvals.h>
#include <rmxtypes.h>
#include <_noalign.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * -------------------- iRMX Nucleus definitions -------------------- 
 */

/*
 * iRMX Nucleus macro definitions
 */

#ifndef _NUM_CHILDREN
#define _NUM_CHILDREN   2
#endif
#ifndef _NUM_TOKENS
#define _NUM_TOKENS     2
#endif

/*
 * iRMX Nucleus type definitions
 */

typedef struct
{
    void far *          exceptionhandlerptr;
    UINT_8              exceptionmode;

} EXCEPTIONSTRUCT;


typedef struct
{
    UINT_8              access;
    UINT_8              limitmode;

} ACCESSSTRUCT;


typedef struct
{
    SELECTOR            targetjob;
    SELECTOR            parentjob;
    UINT_32             poolmax;
    UINT_32             poolmin;
    UINT_32             initialsize;
    UINT_32             allocated;
    UINT_32             available;
    UINT_32             borrowed;

} EPOOLATTRIBSTRUCT;


typedef struct
{
    UINT_16             portid;
    UINT_8              type;
    UINT_8              reserveda;
    UINT_16             numtrans;
    UINT_16             reserved[2];
    SELECTOR            sinkport;
    UINT_32             defaultremotesocket;
    SELECTOR            bufferpool;
    UINT_16             flags;
    UINT_8              reservedb;

} GETPORTATTRIBSTRUCT;


typedef struct
{
    UINT_16             maxnum;
    UINT_16             actual;
    SELECTOR            children[_NUM_CHILDREN];    /* adjust # of children! */

} OFFSPRINGSTRUCT;


typedef struct
{
    UINT_16             poolmax;
    UINT_16             poolmin;
    UINT_16             initialsize;
    UINT_16             allocated;
    UINT_16             available;

} POOLATTRIBSTRUCT;


typedef struct
{
    UINT_16             flags;
    UINT_16             status;
    UINT_16             transid;
    UINT_32             datalength;
    SELECTOR            forwardingport;
    UINT_32             remotesocket;
    UINT_8              controlmsg[20];
    UINT_8              reserved[4];

} RECEIVEINFOSTRUCT;


typedef struct
{
    UINT_16             flags;
    UINT_16             status;
    UINT_16             transid;
    UINT_32             datalength;
    SELECTOR            forwardingport;
    UINT_32             remotesocket;
    UINT_8              controlmsg[20];
    UINT_8              reserved[4];

} REPLYINFOSTRUCT;


typedef struct
{
    UINT_16             numslots;
    UINT_16             numused;
    SELECTOR            tokens[_NUM_TOKENS];    /* adjust to fit numused */

} TOKENLISTSTRUCT;



/*
 * iRMX Nucleus function prototypes
 */

UINT_32 _Fparam          rqgettime
(
	UINT_16 far *
);

void _Fparam             rqsettime
(
	UINT_32,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatejob
(
    UINT_16,
    SELECTOR,
    NATIVE_WORD,
    NATIVE_WORD,
    UINT_16,
    UINT_16,
    UINT_8,
    EXCEPTIONSTRUCT far *,
    UINT_16,
    UINT_8,
    void (far *)(void),
    SELECTOR,
    void far *,
    NATIVE_WORD,
    UINT_16,
    UINT_16 far *
);

SELECTOR _Fparam        rqecreatejob
(
    UINT_16,
    SELECTOR,
    UINT_32,
    UINT_32,
    UINT_16,
    UINT_16,
    UINT_8,
    EXCEPTIONSTRUCT far *,
    UINT_16,
    UINT_8,
    void (far *)(void),
    SELECTOR,
    void far *,
    NATIVE_WORD,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqdeletejob
(
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqoffspring
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqeoffspring
(
    SELECTOR,
    OFFSPRINGSTRUCT far *,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatetask
(
    UINT_8,
    void (far *)(void),
    SELECTOR,
    void far *,
    NATIVE_WORD,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqdeletetask
(
    SELECTOR,
    UINT_16 far *
);

UINT_8 _Fparam          rqgetpriority
(
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqgettasktokens
(
    UINT_8,
    UINT_16 far *
);

void _Fparam            rqresumetask
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqsetpriority
(
    SELECTOR,
    UINT_8,
    UINT_16 far *
);

void _Fparam            rqesetmaxpriority
(
    SELECTOR,
    UINT_8,
    UINT_16 far *
);

void _Fparam            rqsleep
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqsuspendtask
(
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatemailbox
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqdeletemailbox
(
    SELECTOR,
    UINT_16 far *
);

UINT_16 _Fparam         rqreceivedata
(
    SELECTOR,
    void far *,
    UINT_16,
    UINT_16 far *
);

SELECTOR _Fparam        rqreceivemessage
(
    SELECTOR,
    UINT_16,
    SELECTOR far *,
    UINT_16 far *
);

void _Fparam            rqsenddata
(
    SELECTOR,
    void far *,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqsendmessage
(
    SELECTOR,
    SELECTOR,
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatesemaphore
(
    UINT_16,
    UINT_16,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqdeletesemaphore
(
    SELECTOR,
    UINT_16 far *
);

UINT_16 _Fparam         rqreceiveunits
(
    SELECTOR,
    UINT_16,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqsendunits
(
    SELECTOR,
    UINT_16,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatesegment
(
    NATIVE_WORD,
    UINT_16 far *
);

void _Fparam            rqdeletesegment
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqgetpoolattrib
(
    POOLATTRIBSTRUCT far *,
    UINT_16 far *
);

void _Fparam            rqegetpoolattrib
(
    EPOOLATTRIBSTRUCT far *,
    UINT_16 far *
);

NATIVE_WORD _Fparam     rqgetsize
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqsetpoolmin
(
    NATIVE_WORD,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatebufferpool
(
    UINT_16,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqdeletebufferpool
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqreleasebuffer
(
    SELECTOR,
    SELECTOR,
    UINT_16,
    UINT_16 far *
);

SELECTOR _Fparam        rqrequestbuffer
(
    SELECTOR,
    UINT_32,
    UINT_16 far *
);

void _Fparam            rqechangedescriptor
(
    SELECTOR,
    UINT_32,
    NATIVE_WORD,
    UINT_16 far *
);

SELECTOR _Fparam        rqecreatedescriptor
(
    UINT_32,
    NATIVE_WORD,
    UINT_16 far *
);

void _Fparam            rqedeletedescriptor
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqcatalogobject
(
    SELECTOR,
    SELECTOR,
    void far *,
    UINT_16 far *
);

void _Fparam            rqechangeobjectaccess
(
    SELECTOR,
    UINT_8,
    UINT_8,
    UINT_16 far *
);

UINT_32 _Fparam         rqegetaddress
(
    void far *,
    UINT_16 far *
);

void _Fparam            rqegetobjectaccess
(
    SELECTOR,
    ACCESSSTRUCT far *,
    UINT_16 far *
);

UINT_16 _Fparam         rqgettype
(
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqlookupobject
(
    SELECTOR,
    void far *,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rquncatalogobject
(
    SELECTOR,
    void far *,
    UINT_16 far *
);

void _Fparam            rqgetexceptionhandler
(
    EXCEPTIONSTRUCT far *,
    UINT_16 far *
);

void _Fparam            rqsetexceptionhandler
(
    EXCEPTIONSTRUCT far *,
    UINT_16 far *
);

void _Fparam            rqdisable
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqenable
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqendinittask
(void);

void _Fparam            rqenterinterrupt
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqexitinterrupt
(
    UINT_16,
    UINT_16 far *
);

void _Fparam			rqeexitinterrupt 
(
	UINT_8,
	UINT_16,
	UINT_16
);

UINT_16 _Fparam         rqgetlevel
(
    UINT_16 far *
);

void _Fparam            rqresetinterrupt
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqsetinterrupt
(
    UINT_16,
    UINT_8,
    void (far *)(void),
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqsignalinterrupt
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqetimedinterrupt
(
    UINT_16,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqwaitinterrupt
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqaltercomposite
(
    SELECTOR,
    SELECTOR,
    UINT_16,
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreatecomposite
(
    SELECTOR,
    TOKENLISTSTRUCT far *,
    UINT_16 far *
);

void _Fparam            rqdeletecomposite
(
    SELECTOR,
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqinspectcomposite
(
    SELECTOR,
    SELECTOR,
    TOKENLISTSTRUCT far *,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreateextension
(
    UINT_16,
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqdeleteextension
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqdisabledeletion
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqenabledeletion
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqforcedelete
(
    SELECTOR,
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqesetosextension
(
    UINT_16,
    void (far *)(void),
    UINT_16 far *
);

void _Fparam            rqsignalexception
(
    UINT_16,
    UINT_8,
    NATIVE_WORD,
    UINT_16,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqacceptcontrol
(
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreateregion
(
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqdeleteregion
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqreceivecontrol
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqsendcontrol
(
    UINT_16 far *
);

void _Fparam            rqattachbufferpool
(
    SELECTOR,
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqattachport
(
    SELECTOR,
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqbroadcast
(
    SELECTOR,
    UINT_32,
    UINT_8 far *,
    UINT_16 far *
);

void _Fparam            rqcancel
(
    SELECTOR,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqconnect
(
    SELECTOR,
    UINT_32,
    UINT_16 far *
);

SELECTOR _Fparam        rqcreateport
(
    UINT_16,
    void far *,
    UINT_16 far *
);

void _Fparam            rqdeleteport
(
    SELECTOR,
    UINT_16 far *
);

SELECTOR _Fparam        rqdetachbufferpool
(
    SELECTOR,
    UINT_16 far *
);

void _Fparam            rqdetachport
(
    SELECTOR,
    UINT_16 far *
);

UINT_16 _Fparam         rqgethostid
(
    UINT_16 far *
);

void _Fparam            rqgetportattributes
(
    SELECTOR,
    GETPORTATTRIBSTRUCT far *,
    UINT_16 far *
);

UINT_8 far * _Fparam    rqreceive
(
    SELECTOR,
    UINT_16,
    RECEIVEINFOSTRUCT far *,
    UINT_16 far *
);

void _Fparam            rqreceivefragment
(
    SELECTOR,
    UINT_32,
    UINT_16,
    UINT_8 far *,
    UINT_32,
    UINT_16,
    UINT_16 far *
);

UINT_8 far * _Fparam    rqreceivereply
(
    SELECTOR,
    UINT_16,
    UINT_16,
    REPLYINFOSTRUCT far *,
    UINT_16 far *
);

void _Fparam            rqreceivesignal
(
    SELECTOR,
    UINT_16,
    UINT_16 far *
);

UINT_16 _Fparam         rqsend
(
    SELECTOR,
    UINT_32,
    UINT_8 far *,
    UINT_8 far *,
    UINT_32,
    UINT_16,
    UINT_16 far *
);

UINT_16 _Fparam         rqsendrsvp
(
    SELECTOR,
    UINT_32,
    UINT_8 far *,
    UINT_8 far *,
    UINT_32,
    UINT_8 far *,
    UINT_32,
    UINT_16,
    UINT_16 far *
);

UINT_16 _Fparam         rqsendreply
(
    SELECTOR,
    UINT_32,
    UINT_16,
    UINT_8 far *,
    UINT_8 far *,
    UINT_32,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqsendsignal
(
    SELECTOR,
    UINT_16 far *
);

UINT_8 _Fparam          rqgetinterconnect
(
    UINT_8,
    UINT_16,
    UINT_16 far *
);

void _Fparam            rqsetinterconnect
(
    UINT_8,
    UINT_8,
    UINT_16,
    UINT_16 far *
);



/*
 * -------------------- iRMX Nucleus definitions -------------------- 
 */


/*
 * iRMX Nucleus macro definitions
 */

#ifndef  _NUM_TOKENS
#define  _NUM_TOKENS        2
#endif
#ifndef  _NUM_CHILDREN
#define  _NUM_CHILDREN      2
#endif


/*
 * iRMX Nucleus type definitions
 */

typedef struct
{
    UINT_8              access;
    UINT_8              limit_mode;

} ACCESS_STRUCT;


typedef struct
{
    UINT_16             actual;
    SELECTOR            children[_NUM_CHILDREN];    /* adjust to actual */

} CHILD_JOBS_STRUCT;


typedef struct
{
    UINT_16             port_id;
    UINT_8              type;
    UINT_8              reserved;
    UINT_16             flags;

} DATA_PORT_CREATION_INFO_STRUCT;


typedef struct
{
    SELECTOR            target_job;
    SELECTOR            parent_job;
    UINT_32             pool_max;
    UINT_32             pool_min;
    UINT_32             initial_size;
    UINT_32             allocated;
    UINT_32             available;
    UINT_32             borrowed;

} E_POOL_ATTRIB_STRUCT;


typedef struct
{
    void far *          exception_handler_ptr;
    UINT_8              exception_mode;

} EXCEPTION_STRUCT;


typedef struct
{
    UINT_16             max_num;
    UINT_16             actual;
    SELECTOR            children[_NUM_CHILDREN];    /* adjust to max_num */

} OFFSPRING_STRUCT;


typedef struct
{
    UINT_16             pool_max;
    UINT_16             pool_min;
    UINT_16             initial_size;
    UINT_16             allocated;
    UINT_16             available;

} POOL_ATTRIB_STRUCT;


typedef struct
{
    UINT_16             port_id;
    UINT_8              type;
    UINT_8              reserved_a;
    UINT_16             num_trans;
    UINT_16             reserved[2];
    SELECTOR            sink_port;
    UINT_32             default_remote_socket;
    SELECTOR            buffer_pool;
    UINT_16             flags;
    UINT_8              reserved_b;

} PORT_ATTRIB_STRUCT;


typedef struct
{
    UINT_16             flags;
    UINT_16             status;
    UINT_16             trans_id;
    UINT_32             data_length;
    SELECTOR            forwarding_port;
    UINT_32             remote_socket;
    UINT_8              control_msg[20];
    UINT_8              reserved[4];

} RECEIVE_INFO_STRUCT;


typedef struct
{
    UINT_16             flags;
    UINT_16             status;
    UINT_16             trans_id;
    UINT_32             data_length;
    SELECTOR            forwarding_port;
    UINT_32             remote_socket;
    UINT_8              control_msg[20];
    UINT_8              reserved[4];

} REPLY_INFO_STRUCT;


typedef struct
{
    UINT_8              message_id;
    UINT_8              reserved_a;
    UINT_8              type;
    UINT_8              reserved_b;
    UINT_16             flags;

} SIGNAL_PORT_CREATION_INFO_STRUCT;


typedef struct
{
     WORD               hostid;
     WORD               portid;

} SOCKET_STRUCT;


typedef struct
{
    UINT_16             num_slots;
    UINT_16             num_used;
    SELECTOR            tokens[_NUM_TOKENS];    /* adjust to fit num_used */

} TOKEN_LIST_STRUCT;


/*
 * iRMX Nucleus macro overrides
 */

#define  rq_accept_control          rqacceptcontrol
#define  rq_alter_composite         rqaltercomposite
#define  rq_attach_buffer_pool      rqattachbufferpool
#define  rq_attach_port             rqattachport
#define  rq_broadcast               rqbroadcast
#define  rq_cancel                  rqcancel
#define  rq_catalog_object          rqcatalogobject
#define  rq_connect                 rqconnect
#define  rq_create_job              rqcreatejob
#define  rq_create_buffer_pool      rqcreatebufferpool
#define  rq_create_composite        rqcreatecomposite
#define  rq_create_extension        rqcreateextension
#define  rq_create_mailbox          rqcreatemailbox
#define  rq_create_port             rqcreateport
#define  rq_create_region           rqcreateregion
#define  rq_create_segment          rqcreatesegment
#define  rq_create_semaphore        rqcreatesemaphore
#define  rq_create_task             rqcreatetask
#define  rq_delete_buffer_pool      rqdeletebufferpool
#define  rq_delete_composite        rqdeletecomposite
#define  rq_delete_extension        rqdeleteextension
#define  rq_delete_job              rqdeletejob
#define  rq_delete_mailbox          rqdeletemailbox
#define  rq_delete_port             rqdeleteport
#define  rq_delete_region           rqdeleteregion
#define  rq_delete_segment          rqdeletesegment
#define  rq_delete_semaphore        rqdeletesemaphore
#define  rq_delete_task             rqdeletetask
#define  rq_detach_buffer_pool      rqdetachbufferpool
#define  rq_detach_port             rqdetachport
#define  rq_disable                 rqdisable
#define  rq_disable_deletion        rqdisabledeletion
#define  rq_enable                  rqenable
#define  rq_enable_deletion         rqenabledeletion
#define  rq_end_init_task           rqendinittask
#define  rq_enter_interrupt         rqenterinterrupt
#define  rq_exit_interrupt          rqexitinterrupt
#define  rqe_exit_interrupt         rqeexitinterrupt
#define  rq_force_delete            rqforcedelete
#define  rq_get_exception_handler   rqgetexceptionhandler
#define  rq_get_host_id             rqgethostid
#define  rq_get_interconnect        rqgetinterconnect
#define  rq_get_level               rqgetlevel
#define  rq_get_pool_attrib         rqgetpoolattrib
#define  rq_get_port_attributes     rqgetportattributes
#define  rq_get_priority            rqgetpriority
#define  rq_get_size                rqgetsize
#define  rq_get_task_tokens         rqgettasktokens
#define  rq_get_type                rqgettype
#define  rq_inspect_composite       rqinspectcomposite
#define  rq_lookup_object           rqlookupobject
#define  rq_offspring               rqoffspring
#define  rq_receive                 rqreceive
#define  rq_receive_control         rqreceivecontrol
#define  rq_receive_data            rqreceivedata
#define  rq_receive_fragment        rqreceivefragment
#define  rq_receive_message         rqreceivemessage
#define  rq_receive_reply           rqreceivereply
#define  rq_receive_signal          rqreceivesignal
#define  rq_receive_units           rqreceiveunits
#define  rq_release_buffer          rqreleasebuffer
#define  rq_request_buffer          rqrequestbuffer
#define  rq_reset_interrupt         rqresetinterrupt
#define  rq_resume_task             rqresumetask
#define  rq_send                    rqsend
#define  rq_send_control            rqsendcontrol
#define  rq_send_data               rqsenddata
#define  rq_send_message            rqsendmessage
#define  rq_send_reply              rqsendreply
#define  rq_send_rsvp               rqsendrsvp
#define  rq_send_signal             rqsendsignal
#define  rq_send_units              rqsendunits
#define  rq_set_exception_handler   rqsetexceptionhandler
#define  rq_set_interconnect        rqsetinterconnect
#define  rq_set_interrupt           rqsetinterrupt
#define  rq_set_pool_min            rqsetpoolmin
#define  rq_set_priority            rqsetpriority
#define  rq_signal_exception        rqsignalexception
#define  rq_signal_interrupt        rqsignalinterrupt
#define  rq_sleep                   rqsleep
#define  rq_suspend_task            rqsuspendtask
#define  rq_uncatalog_object        rquncatalogobject
#define  rq_wait_interrupt          rqwaitinterrupt
#define  rqe_change_descriptor      rqechangedescriptor
#define  rqe_change_object_access   rqechangeobjectaccess
#define  rqe_create_descriptor      rqecreatedescriptor
#define  rqe_create_job             rqecreatejob
#define  rqe_delete_descriptor      rqedeletedescriptor
#define  rqe_dos_request            rqedosrequest
#define  rqe_get_address            rqegetaddress
#define  rqe_get_object_access      rqegetobjectaccess
#define  rqe_get_pool_attrib        rqegetpoolattrib
#define  rqe_offspring              rqeoffspring
#define  rqe_set_max_priority       rqesetmaxpriority
#define  rqe_set_os_extension       rqesetosextension
#define  rqe_set_vm86_extension     rqesetvm86extension
#define  rqe_timed_interrupt        rqetimedinterrupt
#define  rq_get_time                rqgettime
#define  rq_set_time                rqsettime

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif      /* __NUCLEUSH__ */
