/* unistd.h
 * $Version: 1.16 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _UNISTD
#define _UNISTD

#include <yvals.h>
#include <sys/stat.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * [1]-STANDARD C DEFINITIONS
 */
#if (_model_rmx) || (_model_blue) || (_model_posix) || (_model_green)

/*
 * macro definitions
 */

#define F_OK        0
#define X_OK        1
#define W_OK        2
#define R_OK        4

#undef _POSIX_JOB_CONTROL
#undef _POSIX_SAVED_IDS
#define _POSIX_VERSION          198808L
#define _POSIX_CHOWN_RESTRICTED -1
#define _POSIX_NO_TRUNC         -1
#define _POSIX_VDISABLE         -1

#endif /* rmx, blue, posix and green */

/*
 * [2]-COMMON DEFINITIONS THAT ARE NOT STANDARD C DEFINITIONS
 */
#if (_model_blue) || (_model_posix) || (_model_green)
#endif /* blue, posix and green */

/*
 * [3]-COMMON NETWORK DEFINITIONS (same as _UNIX_SOURCE)
 */
#if (_model_blue) || (_model_green)

/*
 * ulimit macro definitions
 */

#define UL_GFILLIM  1 /* Get file size limit. */
#define UL_SFILLIM  2 /* Set file size limit. */
#define UL_GBRKVAL  3 /* Get maximum break value. */
#define UL_GNFILES  4 /* Get maximum number of files. */

/*
 * function prototypes
 */

int         _Pascal chroot (char *);
int         _Pascal chsize (int, long32);
char      * _Pascal crypt (char *, char *);
char      * _Pascal mktemp(char *);
int         _Pascal setmode (int, int);
int         _Pascal setpgrp (void);
long32      _Pascal ulimit (int, long32);

#endif /* blue and green */

/*
 * [4]-COMMON NON-POSIX DEFINITIONS
 */
#if (_model_rmx) || (_model_blue)
#include <io.h>
#endif /* rmx and blue */

/*
 * [5]-POSIX SPECIFIC DEFINITIONS (same as _POSIX_SOURCE)
 */
#if (_model_posix) || (_model_green)

#include <sys/types.h>

#define F_ULOCK 0
#define F_LOCK  1
#define F_TLOCK 2
#define F_TEST  3
#define GF_PATH "/etc/group"
#define PF_PATH "/etc/passwd"

/*
 * function Prototypes
 */
        
int         _Pascal access (const char *, int);
u_int       _Pascal alarm (unsigned int);
int         _Pascal chdir (const char *);
int         _Pascal chown (const char *, uid_t, gid_t);
int         _Pascal close (int);
int         _Pascal dup (int);
int         _Pascal dup2 (int, int);
int         _Cdecl execl (const char *, const char *, ...);
int         _Cdecl execle (const char *, const char *, ...);
int         _Cdecl execlp (const char *, const char *, ...);
int         _Pascal execv (const char *, const char **);
int         _Pascal execve (const char *, const char **, const char **);
int         _Pascal execvp (const char *, const char **);
int         _Pascal execvpe (const char *, const char **, const char **);
void        _Pascal _exit(int);
pid_t       _Pascal fork (void);
char      * _Pascal getcwd (char *, int);
gid_t       _Pascal getegid (void); 
uid_t       _Pascal geteuid (void); 
gid_t       _Pascal getgid (void); 
char      * _Pascal getlogin (void);
pid_t       _Pascal getpgrp (void);
int         _Pascal getpid (void);
int         _Pascal getppid (void);
uid_t       _Pascal getuid (void); 
int         _Pascal isatty (int);
off_t       _Pascal lseek (int, off_t, int);
int         _Pascal pause (void);
int         _Pascal pipe (int *);
int         _Pascal read (int, char *, unsigned int);
int         _Pascal rmdir (const char *);
int         _Pascal setgid (gid_t); 
pid_t       _Pascal setsid (void);
int         _Pascal setuid (uid_t); 
u_int       _Pascal sleep (unsigned int);
int         _Pascal unlink (const char *);
int         _Pascal write (int, const char *, unsigned int);

#endif /* posix and green */

/*
 * [6]-RMX SPECIFIC DEFINITIONS
 */
#if (_model_rmx)
#endif /* rmx */

/*
 * [7]-NON-POSIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_blue)
#endif /* blue */

/*
 * [8]-UNIX/UNIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_green)
#endif /* green */

#ifdef __cplusplus
}
#endif
#endif /* _UNISTD */

