#include <stdio.h>
#include <stdlib.h>
#include <rmxemb.h>
#include <nucleus.h>
#include <rmx_err.h>

#include "router.h"

/****************************************************************************
*  set exception handler to a new mode
****************************************************************************/
void set_exception(u16 except_mode) {
    EXCEPTION_STRUCT except_info;
    WORD status;
    
    rq_get_exception_handler((EXCEPTIONSTRUCT far *)&except_info,
			     &status);
    ERR(status);
    except_info.exception_mode = except_mode;
    rq_get_exception_handler((EXCEPTIONSTRUCT far *)&except_info,
			     &status);
    ERR(status);
}

/****************************************************************************
*  Print error message and exit
****************************************************************************/
void err_handler(u16 line, char *fname, u16 status) {
    fprintf(stderr, "Error %x occurred at %s:%d\n", status, fname, line);
    exit(status);
}

/****************************************************************************
*  configures the terminal for output from the pq serial driver.
****************************************************************************/
void set_term(u16 *except_ptr) {
    SERIAL_CONFIG_STRUCT	serial_cfg;
    MODEM_CONTROL_STRUCT	serial_modem;
    
    serial_cfg.rx_buffer_size = 2048 ;
    serial_cfg.baud_rate = 9600;
    serial_cfg.parity_mode = no_parity ;
    serial_cfg.stop_bits = 1 ;
    serial_cfg.send_break = 0 ;
    serial_cfg.data_bits = 8 ;
    serial_cfg.initial_modem_lines.rts = line_on ;
    serial_cfg.initial_modem_lines.dtr = line_on ;
    serial_cfg.tx_clock_src = internal_clock ;
    serial_cfg.rx_clock_src = internal_clock ;
    serial_cfg.flow_control = no_flow_control ;
    serial_cfg.transfer_mode = interrupt_transfer ;
    serial_cfg.interrupt_select.rx_ready = 1 ;
    serial_cfg.interrupt_select.tx_ready = 1 ;
    serial_cfg.interrupt_select.rx_error = 0 ;
    serial_cfg.interrupt_select.modem_status = 0 ;

    pq_serial_config (1, &serial_cfg, except_ptr);
    
	/***  Start driver  ***/
    
    serial_modem.rts = line_on ;
    serial_modem.dtr = line_on ;
    
    pq_serial_control (1, START_CONTROL, &serial_modem, except_ptr);
}

void clear_screen(void) {}
    
int kbhit(void) {
    UINT_32 count, success;
    char c;
    u16 status;
    
    success = pq_serial_read(1, /* COM1 */
			     &c,
			     NULL, /* don't return status info */
			     1, /* 1 byte */
			     NULL, /* reserved */
			     PQ_NO_WAIT,
			     &status);
    if (status != E_OK) {
	if (status != E_TIME)
	    ERR(status);
	else
	    return 0;
    }
    ungetc(c, stdin);
    return 1;
}
