//  This is -*- c++ -*- code

#ifndef __HUMAN_PLAYER_H__
#define __HUMAN_PLAYER_H__

#include <6170.h>
#include "board.h"
#include "player.h"
#include "top_node.h"
class move;

class http_response;

class human_player : public player {
    // Overview: A human_player is an interface for a human to play a
    // game on a board.
public:
    // Constructors:

    human_player(string name, long time_in_msecs, top_node *tnode, bool
		 start_detached);
    // Checks: total_time >= 0;
    // Effects:  Creates a new human_player, not associated with
    // any game which will have have up total_time seconds to complete
    // all moves, the given name, and in a detached state if
    // start_detached is true.  The given top_node is stored for later
    // possible interactions.. Assigns a name to the new
    // human_player.

    // Methods:
    virtual void detach();
    // Requires: this be attached
    // Modifies: this, top
    // Effects: Detaches this and adds the game, player touple to the top
    // node so another can connect.

    virtual void attach(string name);
    // Requires: this not be attached. 
    // Modifies: this, top
    // Effects: Attaches this, notifies the top_node
    // that it is associated with, and sets name as given.
    
    virtual void display(extensions *ext, ostream &body) const;

    virtual void you_moved(move &m);

    virtual void opponent_moved (move &m, int p);

    virtual void state_changed(void);

    bool is_attached() const;
    // Effects: returns true if this is attached else returns false.
    
    http_response *human_player::get (string request, extensions *ext);
    
protected:
    virtual void associate(game *g);
    
private:

    human_player();
    // Disable default constructor

    void operator= (human_player &);
    // Disable equality operator

    bool attached;
    // Am I attached to a game?
    int my_index;
    // My player index

    top_node *top;
    // The top node that this is associated with
};

inline bool human_player::is_attached() const {
    return attached;
}

#endif
