#ifndef _EXPIRED_RESPONSE_H
#define _EXPIRED_RESPONSE_H

#include "ps5/http_response.h"

class expired_response : public normal_response {
    // An "expired_response" is a "normal_response" that expires immediately,
    // which means that a web browser is not allowed to cache the result.
public:
    expired_response(bool html);
	// Effects: Create a new "expired_response" that is an HTML response if
	// "html" is true, else it is a plain text response.

    // overridden methods
    virtual void headers(ostream &o);
	// Effects: Provides at least the headers described in "http_response",
	//    plus an "Expires:" header that indicates that the data
	//    expires immediately.
	// Inherited: Provides exactly the headers mentioned above.
protected:
};

#endif /* _EXPIRED_RESPONSE_H */
