#ifndef _HTTP_SERVER_H
#define _HTTP_SERVER_H

#include "ps5/web_node.h"

class server;

class http_server {
// abstract: An "http_server" represents an HTTP server. It translates
//           incoming requests from a TCP connection into "web_node"
//           requests. The server may be running in either normal or
//           debugging mode. It prints diagnostic information
//           to stderr when debugging is turned on.
public:
    http_server(int port, web_node *root);
    // effects: Make a new, empty "http_server" that watches port "port"
    //          on this machine, and transfers requests to the node "root".
    //          It is running in normal mode.

    void handle_one();
    // effects: Process the next incoming request to this server; wait for
    //          it if necessary. The incoming request is translated to a
    //          call on the "get" method of the root node. The "request"
    //          argument is the requested URL, and the "extensions"
    //          argument of the method contains a mapping from "." to "".

    int file_descriptor();
    // effects: Return the file descriptor corresponding to this server,
    //          for use in a "select()" call.

    web_node *root();
    // effects: Return the root of the local URL tree, to which requests
    //          are transferred.

    void close();
    // effects: Terminate acceptance of new incoming requests.

    void debug(bool on);
    // effects: Control debugging.

private:
    void operator=(http_server &); http_server(http_server const &);

    server *serv;
    web_node *root_;
    bool debugging;

// "serv" maintains the TCP rendezvous socket
// "root_" is the root.
// "debugging" tells whether the server is debugging.
};

#endif /* _HTTP_SERVER_H */
