// This is -*- c++ -*- code
// $Header: /mit/6.170/groups/se01/.cvsroot/src/include/top_node.h,v 1.9 1995/12/11 21:09:40 daveg Exp $




#ifndef __TOP_NODE_H__
#define __TOP_NODE_H__

#include <6170.h>

// This file defines a subclass of dir_node that handles certain
// top-level requests internally instead of having children.  This is
// necessary to deal with top level requests, because they will be of
// the form /foo?bar not/foo/?bar

#include <6170.h>
#include <ps5/dir_node.h>
#include <game.h>


class top_node: public dir_node {

  public:
    
    // Constructors:
    top_node(string uri, string image_base);
    // Effects: creates an empty top node with a base URI of uri that
    // finds images and other static documents under image_base, a
    // full URI.
    // Requires: both URIs include trailing slashes

    // Methods:

    void add_to_detached(game *g, int player_num);
    // Requires: that the specified player is associated with a game.
    // Modifies: this
    // Effects: Adds the given game to the list of detached games.
    
    void remove_from_detached(game *g);
    // Modifies: this
    // Effects: Removes the given game from list of detached games

    virtual http_response * get(string request, extensions *ext);
    // Effects: processes top-level protocol requests as specified in Section \tex{\ref{p:top}}

    virtual http_response *get_self(string query_args, extensions *);

  private:
    top_node(const top_node &);
    void operator = (const top_node &);

    // Abstraction function: open_games is an array of games that are
    // open; kids of this are games that exist in some state.

    // Rep invarient: open_games contains a game at most once; games
    // in open_games also appear in descendents.
    struct open {
	game *g;
	int pn;			// Player number of detached player
    };
    
    map <string, open> *open_games;
    int randomizing_mask; // Mask used to make numbers not repeat between runs
    string image_uri;
    http_response * welcome( extensions *ext) ;
    // Effects: returns the welcome page.

    http_response *new_game(string query_args, extensions *ext);
    // Effects: handles new game request.

    http_response *incomplete_games( extensions *ext) ;
    // Effects: returns page of incomplete games.

    http_response *ref_new_game(string query_args, extensions *ext);
    // Effects: handles new game request, as specified for refereed games.

};

#endif // __TOP_NODE_H__
