// This is -*- c++ -*- code

// $Id: tic_board.h,v 1.5 1995/12/01 03:39:17 hartmans Exp $

#ifndef __TIC_BOARD_H__
#define __TIC_BOARD_H__

#include <6170.h>
#include <typeinfo.h>
#include "board.h"

class tic_board : public board {
  // Overview: This class is a subtype of class board, for the purpose of
  // playing the game tic-tac-toe.  This is not a virtual subclass, it can be
  // instantiated. This is a heap abstraction. Valid positions are 'X' and 'O'
  // X always goes first.

  public:
    enum tic_piece {                      // Tic-tac-toe pieces
      no_piece,
      x_piece,
      o_piece
      };

    // Constructors and Destructors

    tic_board();
    // Effects: Constructs a tic_board that is not
    // associated with any game.  

    virtual ~tic_board();
    // Effects: Destroys anything in need of destroying. :-)

    // Methods
    virtual bool is_legal_move(move &m, int player_num) const;

    virtual game::move_result apply(move &m, int player_num);

    virtual bool unapply(move &m, int player_num);

    virtual int winner();

    virtual http_response *get(string request, extensions *extras);

    virtual void display(extensions *ext, ostream& body, 
			 int player_num) const;

    virtual bool valid_move_available(int player_num) const;

    virtual move_generator* valid_moves(int player_num) const;

    virtual board::value eval_move_delta(move &m, int player_num) const;

    virtual board::value evaluate(int player_num) const;

    virtual board * clone() const;

    virtual void* force (typeinfo_t &t);

//Subclass specific methods:
    static char piece_to_name(tic_piece cpiece);
    // Effects: Returns a char corresponding to the piece cpiece.
 
    static tic_piece player_to_piece(int p);
    // Effects: Returns a piece corresponding to a player, or
    // no_piece if a player isn't mapped

    static int piece_to_player(tic_piece t);

    int check_for_winner();
    // Effects: Checks the board, if a winning player exists, returns
    // the index of the winning player. If the game is not over, returns
    // NULL. If the game has ended in a draw, returns a pointer to
    // the drawn_player. FIXME

    static typeinfo_t typeinfo;

  protected:
    virtual void associate(game *g);

    void clone_part(tic_board &b) const;
    
  private:
    void operator= (tic_board &);
    array<array <tic_piece> > board_rep;      // The tic-tac-toe board
    int won_player;                          // The player who has won
    int turn_token;                          // Player number
};
#endif
