// Notes:  The checks clauses in the first two procedures are only
//         applicable for Problem 1.  The code has been commented out
//         for Problem 2, because that question specifies that there
//         shouldn't be a checks clause.

void make_map(istream& i, mapcc* enc, mapcc* dec);
//checks:   i is a valid file that can be read.  enc and dec are allocated.
//          The format of the file named by i is as such:
//          char1 char2 char3 <EOL>
//          where char1 is not repeated as the first char on a line and
//          char3 isn't repeated at third char on line.
//modifies: i, enc, dec
// effects: Takes in an istream i containing the encode function.  Fills
//          in the encode and decode maps corresponding to i.

void crypt (istream& i, ostream& o, mapcc* m);
//checks:   i is a valid file.  o can be overwritten.  m is allocated.
//          Every character in i has already been mapped into m.
//modifies: i, o
//effects:  Reverses and translates teh characters in i using the function
//          in m and outputs the results in o.


void crypt_file( string fnct, string in, string out, bool dir);
//requires: The format of the file named by in is as such:
//          char1 char2 char3 <EOL>
//          where char1 is not repeated as the first char on a line and
//          char3 isn't repeated at third char on line.
//          The files named by fnct and in exist and can be read.
//          The file named by out can be overwritten.
//          Every character from in has a map character from fnct.
//effects:  The file specified by out will be overwritten, with
//          the encrypted and reversed form of the file specified 
//          by in.  Encryption will be according to the map specified
//          in the file named fnct, and in the direction specified by
//          dir.


