#include "digraph.h"

bool eqi(int i, int j) {
    return i==j;
} 


digraph::digraph() {
    graph = new table<int, NODE>(eqi);
}


bool digraph::add_node(int node) {
    NODE node_t = new table<int, float>(eqi);
    
    if (!graph->lookup(node, node_t)) {
	graph->insert(node, node_t); 
	return true;
    }
    return false;
}


bool digraph::add_edge(int from_node, int to_node, float wt){
    NODE node_t = new table<int, float>(eqi);
    float temp;
        
    if (!graph->lookup(to_node, node_t))
	return false;
    
    if (graph->lookup(from_node, node_t)) {
	if (node_t->lookup(to_node, temp))
	    return false;
	node_t->insert(to_node, wt);
	return true;
    }
    return false;
}


bool digraph::lookup_edge(int from_node, int to_node, float &wt) const {
    NODE node_t= new table<int, float>(eqi);
        
    if (graph->lookup(from_node, node_t)) {
	if (node_t->lookup(to_node, wt))
	    return true;
    }
    return false;
}



bool digraph::remove_edge(int from_node, int to_node) {
    NODE node_t = new table<int, float>(eqi);

    if (graph->lookup(from_node, node_t)) {
	if (node_t->remove(to_node))
	    return true;
    }
    return false;
}



generator<int>* digraph::nodes() const {
    return graph->keys();
}



bool digraph::successors(int node, generator<int> *&gi) const {
    NODE node_t = new table<int, float>(eqi);    

    if (graph->lookup(node, node_t)) {
	gi = node_t->keys();
	return true;
    }
    return false;
}

bool digraph::rep_ok() {
    int i,j,k;
    int start, end, end2;
    NODE lookup1;
    
    if (!graph->rep_ok())
	return false;
    
    for(i=0; i < graph->length(); i++) {
	start = graph->get_key(i);
	graph->lookup(start, lookup1);
	for(j=0; j < lookup1->length(); j++) {
	    end = lookup1->get_key(j);
	    if (start ==  end)
		return false; 
	    for(k=j+1; k < lookup1->length(); k++) {
		end2 = lookup1->get_key(k);
		if (end ==  end2)
		    return false;
	    } 
	}
    }
    return true;
}


ostream& operator << (ostream& out, digraph const *&d) {
    generator<int> *starts = d->nodes();
    generator<int> *ends;
    int x,y;
    float wt;
    
    while (starts->get(x)) {
	d->successors(x, ends);
	while (ends->get(y)) {
	    d->lookup_edge(x,y,wt);
	    out << "<(" << x <<","<< y <<"), " << wt << ">\n";
	}
    }
    return out;
}



