// Copyright 1995 Barbara Liskov

#include <values.h>
#include "database.h"
#include "generator.h"
#include "check.h"
#include "pattern.h"
#include "time.h"
#include "6170.h"
#include "map.h"


class file_generator: public generator<file *> {
  public:
    file_generator(database* d,
		   string name,
		   string owner,
		   string times,
		   int minsize);
    bool get(file*& f);
  private:
    database* db; // Database to search in
    int index; // Current index in the database rep
    int minsize, mindate, maxdate; // Ranges based on given size and times
    pattern *name_p, *owner_p; // Patterns based on the given name and owner
    bool nameskip, ownerskip, timeskip, sizeskip;
    database *namedb, *ownerdb, *timedb;
    database *thisdb;
    typedef map<string, database * > *LOOKUP;
    static LOOKUP namemap;
    static LOOKUP ownermap;
    static LOOKUP timemap;
};

database::database() : rep(1000) {
}

database::database(istream &input) : rep(1000) {
    string s;
    while (read_line(input, s)) rep.append(new file(s));
}

void database::add(file *insertion) {
    rep.append(insertion);
}

generator<file *> *database::satisfiers(string name, string owner,
					string times, int minsize,
					string &errmsg) {

    // XXX Check for validity and put error in errmsg
    return new file_generator(this, name, owner, times, minsize);
}

map<string, database *>*file_generator::namemap =  new map<string, database *>;
map<string, database *>*file_generator::ownermap = new map<string, database *>;
map<string, database *>*file_generator::timemap =  new map<string, database *>;


file_generator::file_generator(database* d, string name1, string owner1,
			       string times1, int minsize1) {
    name_p = create_simple_pattern(name1);
    // * matches everything...
    nameskip = (name1 == "*");
    owner_p = create_simple_pattern(owner1);
    ownerskip = (owner1 == "*");
    check(get_query_times(times1, ~MAXINT, MAXINT, mindate, maxdate), 
	  "invalid query time");
    timeskip = (times1 == "*");
    minsize = minsize1;
    sizeskip = (minsize == 0);
    index = 0;
    thisdb = NULL;
    
    db =d;
    
    if (sizeskip && nameskip && ownerskip && !timeskip){
	if (!timemap->find(times1, db)) {
	    timedb = new database();
	    timemap->add(times1,timedb);
	    thisdb = timedb;
	}
    }
    
    else if (sizeskip && nameskip && timeskip && !ownerskip) {
	if (!ownermap->find(owner1, db)) {
	    ownerdb = new database();
	    timemap->add(owner1, ownerdb);
	    thisdb = ownerdb;
	}
    }
    
    else if (sizeskip && timeskip && ownerskip && !nameskip) {
	if (!namemap->find(name1, db)){
	    namedb = new database();
	    namemap->add(name1, namedb);
	    thisdb = namedb;
	}
    }
    
    else if (!nameskip)
	namemap->find(name1, db);
    else if (!ownerskip)
	namemap->find(owner1, db);
    else if (!timeskip)
	namemap->find(times1, db);
}

bool file_generator::get(file*& f) {
    file *cur;
    int curtime;
    int length = (db->rep).length();
    
    for (; index < length; index++) {
	cur = (db->rep)[index];
	
	// Do the fastest comparisons first
	if (sizeskip || (cur->size() >= minsize)) 
	    if (nameskip || (name_p->match(cur->name())))
		if (ownerskip || (owner_p->match(cur->owner()))) {
		    if (!timeskip) {
			check (db_time_to_int(cur->time() , curtime), 
			       "invalid time in db");
			if (curtime >= mindate)
			    if (curtime <= maxdate) {
				f = cur;
				if (thisdb)
				    thisdb->add(cur);
				index++;
				return true;
			    }
		    }
		    else {  // if timeskip
			f = cur;
			if (thisdb)
			    thisdb->add(cur);
			index++;
			return true;
		    }
		}
    }
    return false;
}
