/*
  area.h - Header for area data type.
*/

/* ---------- Data structures ---------- */
struct area;
struct area_ops {
    void (*term)(struct area *);
    int (*mouse)(struct area *, XButtonEvent *);
    int (*draw)(struct area *, Region);
    int (*resize)(struct area *, XConfigureEvent *);
    int (*key)(struct area *, XKeyEvent *);
    int (*activate)(struct area *, XMapEvent *);
    int (*deactivate)(struct area *, XUnmapEvent *);
};

struct aop {
    int x;
    int y;
    int width;
    int height;
    struct wind *owner;
    struct area_ops *aops;
};

struct area {
    int type;
    XRectangle bounds;
    struct wind *owner;
    struct area_ops *aops;
    void *data;
    long click_ticks;
};

/* ---------- Method functions ---------- */
int area_mouse(struct area *, XButtonEvent *);
int area_draw(struct area *, Region);
int area_resize(struct area *, XConfigureEvent *);
int area_key(struct area *, XKeyEvent *);
int area_activate(struct area *, XMapEvent *);
int area_deactivate(struct area *, XUnmapEvent *);

/* ---------- Functions ---------- */
/*
 * area_create(aop, dsize) --> struct area *
 * 
 * Create an area with initial values specified in aop and a data size
 * specified in dsize.
 */
struct area *area_create(struct aop *, size_t);

/*
 * area_destroy(area)
 * 
 * Destroy the area and all of its stuff.
 */
void area_destroy(struct area *);


/*
 * area_getx(area)
 * area_gety(area)
 * 
 * Get the x/y coordinate of the upper left corner of the area.
 */
#define area_getx(a)  ((a)->bounds.x)
#define area_gety(a)  ((a)->bounds.y)

/*
 * area_inrgn(area, rgn) -> int
 * 
 * Returns TRUE if the area intersects rgn.
 */
int area_inrgn(struct area *, Region);

/*
 * area_containspoint(area, x, y)
 * 
 * Returns TRUE if the point (x,y) is inside the area.
 */
int area_containspoint(struct area *, int, int);

/*
 * area_isdoubleclick(area) --> bool
 * 
 * Determine if the area was last clicked within a time period small enough
 * to be considered a double-click.
 */
int area_isdoubleclick(struct area *);

/*
 * area_clear(area) --> result
 * 
 * Clear the area's bounds rectangle and prepare to refresh.
 */
int area_clear(struct area *);

/*
 * area_clearrect(area, rectp, exposure) --> result
 * 
 * Clear rect from in area.  rectp is in window coords.  If you wish an
 * exposure event generated, the exposure should be TRUE.
 */
int area_clearrect(struct area *, XRectangle *, int);
