/*
 * game.h - Game info for Freecell.
 */

/* ---------- Macros ---------- */
#define GAME_CELLS  0x0100
#define GAME_SUITS  0x0200
#define GAME_STACKS 0x0400

#define GAME_NUM_CELLS   4
#define GAME_NUM_SUITS   4
#define GAME_NUM_STACKS  8

/* ---------- Structure definition ---------- */
struct cstack;
struct cpile;
struct game {
     struct cslot *cells[GAME_NUM_CELLS]; /* Free cells */
     struct cpile *suits[GAME_NUM_SUITS]; /* Suit piles */
     struct cstack *stacks[GAME_NUM_STACKS]; /* Stacks of cards in play */
     int selected_item;		/* Itemcode for selected item */
     pipn_e topinsuit[4];	/* Top card in suit piles */
};

/* ---------- Functions ---------- */
/*
 * game_create() -> struct game *
 * 
 * Make a game structure but don't put any cards in it.  
 */
struct game *game_create(void);

/*
 * game_reinit(game, gamenum) --> result
 * 
 * Initialize a game to gamenum or some random game (if gamenum is 0).
 */
int game_reinit(struct game *, int);

/*
 * game_destroy(game)
 * 
 * Destroy the game but none of the contained items.
 */
#define game_destroy(g)  (free(g))

/*
 * game_getstack(game, stacknum)
 * 
 * Return the desired stack in game.
 */
#define game_getstack(g,i)  ((g)->stacks[(i)])

/*
 * game_getsuit(game, suitnum)
 * 
 * Return the desired suitpile in game.
 */
#define game_getsuit(g,i)   ((g)->suits[(i)])

/*
 * game_getcell(game, cellnum)
 * 
 * Return the card in the desired cell.
 */
#define game_getcell(g,i)   ((g)->cells[(i)])

/*
 * game_clickitem(game, itemcode);
 * 
 * Tell the game that an item has been clicked.
 */
int game_clickitem(struct game *, int);

/*
 * game_dclickitem(game, itemcode);
 * 
 * Tell the game that an item has been double-clicked.
 */
int game_dclickitem(struct game *, int);

/*
 * game_itemcode(what, which)
 * 
 * Create an itemcode that refers to which of what type.
 */
#define game_itemcode(w,h)    ((w) | (h))

