#include <sys/time.h>
#include "xgrav.h"


#define	BUTTONRATE	150000   /* .15 second (value in microseconds) */

#define	BUT_NONE	0
#define	BUT_ANGLE_D	1
#define	BUT_ANGLE_U	2
#define	BUT_VELOCITY_D	3
#define	BUT_VELOCITY_U	4



vectortype vector[MAXPLAYERS];
int pushbutton[MAXPLAYERS];
long pushtime[MAXPLAYERS];
int pushnumber[MAXPLAYERS];

extern double cos(), sin();
extern double atan2();

long current_usec() /* checks the current time in microseconds and */ 
{
  struct timeval tv;
  
  gettimeofday(&tv, (struct timezone *)NULL);
  return tv.tv_usec + 1000000*(tv.tv_sec%100);
}

int elapsed(start, length) /* returns whether length microseconds have elapsed since start. Not reliable when length is more than 10^8 usec (100 seconds) */
  long start, length;
{
  long now;
  
  now = current_usec();
  if (start <= now) {
    if (now-start > length) return 1;
    else return 0;
  }
  else {  /* the current time has rolled over; add 10^8 to it */
    if (now+100000000-start > length) return 1;
    else return 0;
  }
}

#define NUMLEVELS 21

void updownbuttons(int pnum)
{
  float newr, newtheta;
  float stepsize;
  static float degtorad = PI/180.0;
  static float steplev[NUMLEVELS] = {0.05, 0.05, 0.05, 0.05, 0.1, 0.1, 0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 2.0, 2.0, 5.0};
  
  if (!vector[pnum].flag) return;  /* if there's no vector set, do nothing */
  
  if (pushnumber[pnum] < NUMLEVELS)
    stepsize = steplev[pushnumber[pnum]];
  else 
    stepsize = steplev[NUMLEVELS-1];
  pushnumber[pnum] += 1;
  newr = vector[pnum].r;
  newtheta = vector[pnum].theta;
  switch (pushbutton[pnum]) {
  case BUT_ANGLE_D:
    newtheta -= (stepsize*degtorad);
    break;
  case BUT_ANGLE_U:
    newtheta += (stepsize*degtorad);
    break;
  case BUT_VELOCITY_D:
    newr -= stepsize;
    break;
  case BUT_VELOCITY_U:	    
    newr += stepsize;
    break;
  };
  buttonvector(pnum, newr, newtheta);
  pushtime[pnum] = current_usec();
}


vectordraw(playernum)
  int playernum;
  
{
  int x1, y1;
  char rtxt[10], thetatxt[10];
  float degrees;
  
  x1 = player[playernum].shipx + (player[playernum].winw/2) + (player[playernum].shipwidth/2);
  y1 = player[playernum].shipy + (player[playernum].winh/2) +  (player[playernum].shipwidth/2);
  sprintf(rtxt, "%-6.2f", vector[playernum].r);
  degrees = 180.0*vector[playernum].theta/(3.141593);
  if (degrees < 0.0) degrees += 360.0;
  sprintf(thetatxt, "%-6.2f", degrees);
  XDrawLine(player[playernum].dpy, player[playernum].win, player[playernum].invertpen,x1 ,y1 , x1 + vector[playernum].x, y1 + vector[playernum].y);
  XDrawImageString(player[playernum].dpy, player[playernum].win, player[playernum].textpen, player[playernum].anglebuttonminx+54, player[playernum].anglebuttonminy+17, thetatxt, strlen(thetatxt));
  XDrawImageString(player[playernum].dpy, player[playernum].win, player[playernum].textpen, player[playernum].velocitybuttonminx+54, player[playernum].velocitybuttonminy+17, rtxt, strlen(rtxt));
}

constrainvector(playernum)
  int playernum;
  
{ 
  if (vector[playernum].theta < 0.0) vector[playernum].theta += (2*PI);
  else if (vector[playernum].theta >= 2*PI) vector[playernum].theta -= (2*PI);
  if (vector[playernum].r > VECTORLIMIT) {
    vector[playernum].r = (float) VECTORLIMIT;
    vector[playernum].x =(int)(vector[playernum].r * (float)cos(vector[playernum].theta));
    vector[playernum].y =(int)(vector[playernum].r * (float)sin(vector[playernum].theta));
  }
  else if (vector[playernum].r <= 0.0) {
    vector[playernum].r = .001;	/* stupid player... */
    vector[playernum].x = 0;
    vector[playernum].y = 0;
  }
}

clickvector (playernum, x, y)
  int playernum, x, y;
  
{
  if (player[playernum].ready)
    return;
  if (vector[playernum].flag)
    vectordraw(playernum); 
  vector[playernum].x = x;
  vector[playernum].y = y;
  vector[playernum].r =(float) distance(x,y,0,0);
  if (x!=0 || y!=0)
    vector[playernum].theta = (float) atan2((double)y, (double)x);
  else
    vector[playernum].theta = 0.0;
  constrainvector(playernum);
  vector[playernum].flag = 1;
  vectordraw(playernum); 
}

buttonvector (playernum, r, theta)
  int playernum;
  float r, theta;
  
{
  if (player[playernum].ready)
    return;
  if (vector[playernum].flag)
    vectordraw(playernum); 
  vector[playernum].r = r;
  vector[playernum].theta = theta;
  vector[playernum].x =(int)(r * (float) cos((double) theta));
  vector[playernum].y =(int)(r * (float) sin((double) theta));
  constrainvector(playernum);
  vector[playernum].flag = 1;
  vectordraw(playernum); 
  
}

void game ()
  
{
  XEvent event, nextevent;
  Bool eventp;
  int temp, tempx, tempy, numready;
  int draggable[MAXPLAYERS];
  char c;
  
  numready=0;
  for (temp = 0; temp<numplayers; temp++) {
    draggable[temp] = 0;
    pushbutton[temp] = BUT_NONE;
    pushnumber[temp] = 0;
    player[temp].ready = !player[temp].alive;
    if (player[temp].ready)
      numready++;
  }
  redrawg();
  while (numready!=numplayers) {
    for (temp = 0; temp<numplayers; temp++) {
      eventp = XCheckWindowEvent(player[temp].dpy, player[ temp].win, GAME_EVENT_MASKS, &event);
      if (eventp) switch (event.type) {
      case Expose:
	eventp = XCheckWindowEvent(player[temp].dpy, player[temp].win, GAME_EVENT_MASKS, &nextevent);
	while (eventp && nextevent.type == Expose) {
	  eventp = XCheckWindowEvent(player[temp].dpy, player[temp].win, GAME_EVENT_MASKS, &nextevent);
	};
	if (eventp) {
	  XPutBackEvent(player[temp].dpy, &nextevent);
	};
	redrawg1(temp);
	break;
      case KeyPress:
	if (XLookupString(&event.xkey, &c, 1, NULL, NULL) == 1) {
	}
	break;
      case ButtonPress:
	draggable[temp]=0;
	if (event.xbutton.button == 1) {
	  if (event.xbutton.x > player[temp].firebuttonminx && event.xbutton.x < player[temp].firebuttonmaxx && event.xbutton.y > player[temp].firebuttonminy && event.xbutton.y < player[temp].firebuttonmaxy) {
	    /*fire*/
	    if (!player[temp].ready && vector[temp].flag) {
	      player[temp].ready = 1;
	      numready++;
	      XCopyArea(player[temp].dpy, player[temp].firebutton2bm, player[temp].win, player[temp].whitepen, 0, 0, BUTWIDTH, BUTHEIGHT, player[temp].firebuttonminx, player[temp].firebuttonminy);
	    }
	    
	  }
	  else if (event.xbutton.x > (player[temp].anglebuttonminx + 46) && event.xbutton.x < (player[temp].anglebuttonmaxx - 23) && event.xbutton.y > player[temp].anglebuttonminy && event.xbutton.y < player[temp].anglebuttonmaxy) {
	    /*set angle-entry flag*/
	    player[temp].keymode = ANGLEMODE;
	  }
	  else if (event.xbutton.x > (player[temp].velocitybuttonminx + 46) && event.xbutton.x < (player[temp].velocitybuttonmaxx - 23) && event.xbutton.y > player[temp].velocitybuttonminy && event.xbutton.y < player[temp].velocitybuttonmaxy) {
	    /*set vel-entry flag*/
	    player[temp].keymode = VELMODE;
	  }
	  /*else if ([[up/down arrows]])*/
	  else if (event.xbutton.x > (player[temp].anglebuttonminx + 26) && event.xbutton.x < (player[temp].anglebuttonminx + 49) && event.xbutton.y > player[temp].anglebuttonminy && event.xbutton.y < player[temp].anglebuttonmaxy) {
	    pushbutton[temp] = BUT_ANGLE_U;
	    pushnumber[temp] = 0;
	    updownbuttons(temp);
	  }
	  else if (event.xbutton.x > (player[temp].anglebuttonmaxx - 26) && event.xbutton.x < (player[temp].anglebuttonmaxx) && event.xbutton.y > player[temp].anglebuttonminy && event.xbutton.y < player[temp].anglebuttonmaxy) {
	    pushbutton[temp] = BUT_ANGLE_D;
	    pushnumber[temp] = 0;
	    updownbuttons(temp);
	  }
	  
	  else if (event.xbutton.x > (player[temp].velocitybuttonminx + 26) && event.xbutton.x < (player[temp].velocitybuttonminx + 49) && event.xbutton.y > player[temp].velocitybuttonminy && event.xbutton.y < player[temp].velocitybuttonmaxy) {
	    pushbutton[temp] = BUT_VELOCITY_U;
	    pushnumber[temp] = 0;
	    updownbuttons(temp);
	  }
	  else if (event.xbutton.x > (player[temp].velocitybuttonmaxx - 26) && event.xbutton.x < (player[temp].velocitybuttonmaxx) && event.xbutton.y > player[temp].velocitybuttonminy && event.xbutton.y < player[temp].velocitybuttonmaxy) {
	    pushbutton[temp] = BUT_VELOCITY_D;
	    pushnumber[temp] = 0;
	    updownbuttons(temp);
	  }
	  
	  /*end of up/down arrow code*/
	  else {
	    player[temp].keymode = NOMODE;
	    tempx = player[temp].shipx + (player[temp].winh/2) + (player[temp].shipheight/2);
	    tempy = player[temp].shipy + (player[temp].winw/2)+ (player[temp].shipwidth/2);
	    if (distance(event.xbutton.x, event.xbutton.y, tempx, tempy) < VECTORCLICKLIMIT) {
	      draggable[temp] = 1;
	      clickvector(temp,(-tempx + event.xbutton.x), (-tempy + event.xbutton.y));
	    }
	  }
	}
	break;
      case MotionNotify:
	if (draggable[temp]) {
	  tempx = player[temp].shipx + (player[temp].winh/2) + (player[temp].shipheight/2);
	  tempy = player[temp].shipy + (player[temp].winw/2)+ (player[temp].shipwidth/2);
	  clickvector(temp,(-tempx + event.xbutton.x), (-tempy + event.xbutton.y));
	}
	break;
      case ButtonRelease:
	if (event.xbutton.button == 1) {
	  pushbutton[temp] = BUT_NONE;
	};
	break;
      default:
	break;
      } /*end switch*/
      if (pushbutton[temp] && elapsed(pushtime[temp], BUTTONRATE)) {
	updownbuttons(temp);
      };
    }
    
  } /*end data entry mode*/
  /*all trajectories have been entered.  proceed to fire missiles*/
  for (temp = 0; temp < numplayers; temp++)
    vectordraw(temp);
  flushall(numplayers);
}
