#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define PI 3.141593
#define NUMSURFACES 4
/* #define MAXMAPS 20 */ /* MAXMAPS is not used anywhere */
#define ABSMAXPLANETS 25
#define MAXPLAYERS 5
#define HIGH 800
#define WIDE 800
#define GALAXYW 800
#define GALAXYH 800
#define GALAXYRADIUS 600
#define ESCAPERADIUS 1600.0
#define ESCAPERADIUSSQUARED 2560000.0
#define COARSELIMIT (450.0)
#define SQUARECOARSELIMIT (202500.0)
#define ZOOMFACTOR (0.25)
#define BUTWIDTH (69)
#define BUTHEIGHT (27)
#define BUTWIDEWIDTH (128)
#define UPDOWNBUTTONSIZE (23) /*one third of a regular button*/
#define MINSHIPRADIUS 400
#define MAXSHIPRADIUS 700
#define MINSHIPTOSHIPSPACING 100
#define MINSHIPTOPLANETSPACING 50
#define MINPLANETSPACING 75
#define PLANETSIZERANGE 3
#define PLANETDENSITYRANGE 1
#define PLANETDENSITYLOGBASE 2 /*must be integer*/
#define PLANETSIZELOGBASE 2 /*must be integer*/
#define PLANETSIZEMIN 16
#define MISSILEMASS 1
#define NOMODE 0
#define ANGLEMODE 1
#define VELMODE 2
#define VECTORCLICKLIMIT 130
#define VECTORLIMIT 100
#define GAME_EVENT_MASKS (ButtonPressMask | ButtonReleaseMask | KeyPressMask | ExposureMask | Button1MotionMask)

extern float floatdistance();
extern float floatsqrdistance();
extern long current_usec();

typedef struct _playertype {
    Display *dpy;
    Window win;
    GC whitepen, invertpen, textpen, blackpen, andpen, copypen;
    GC planetpen[NUMSURFACES];
    int scn;
    int winh;
    int winw;
    int ready;
    int zoomed;
    int readybuttonminx, readybuttonmaxx, readybuttonminy, readybuttonmaxy;
    int vetobuttonminx, vetobuttonmaxx, vetobuttonminy, vetobuttonmaxy;
    int firebuttonminx, firebuttonmaxx, firebuttonminy, firebuttonmaxy;
    int anglebuttonminx, anglebuttonmaxx, anglebuttonminy, anglebuttonmaxy;
    int velocitybuttonminx, velocitybuttonmaxx, velocitybuttonminy, velocitybuttonmaxy;
    int zoombuttonminx, zoombuttonmaxx, zoombuttonminy, zoombuttonmaxy;
    Pixmap readybuttonbm;
    Pixmap readybutton2bm;
    Pixmap vetobuttonbm;
    Pixmap vetobutton2bm;
    Pixmap blankbuttonbm;
    Pixmap firebuttonbm;
    Pixmap firebutton2bm;
    Pixmap anglebuttonbm;
    Pixmap velocitybuttonbm;
    Pixmap zoombuttonbm;
    Pixmap zoombutton2bm;
    Pixmap shipbm[MAXPLAYERS];
    Pixmap hulkbm;
    Pixmap trails;
    int shipx, shipy, shipheight, shipwidth;
    int alive;
    int keymode;
} playertype;
typedef struct _planettype {
    int size;
    int density;
    int x;
    int y;
    int diameter;
    int mass;
    int surface;
} planettype;
typedef struct _vectortype {
    float r,theta;
    int x, y, flag;
} vectortype;
typedef struct _missiletype {
    float x, y, oldx, oldy;
    float vx, vy;
    int flag;
} missiletype;

extern planettype planet[ABSMAXPLANETS];
extern playertype player[MAXPLAYERS];
extern char *shipname[MAXPLAYERS];
extern int numplayers, maxplanets, minplanets, numplanets;
extern vectortype vector[MAXPLAYERS];
extern missiletype missile[MAXPLAYERS]; 
extern int scribble, planetsurf;
