#ifdef SOLARIS
#include <string.h>
#else
#include <strings.h>
#endif
#include "xgrav.h"

#include "stars1.bm"
#include "stars2.bm"
#include "stars3.bm"
#include "stars4.bm"
#include "stars0.bm"
#include "fencepost.bm"
#include "readybutton.bm"
#include "readybutton2.bm"
#include "firebutton.bm"
#include "firebutton2.bm"
#include "zoombutton.bm"
#include "zoombutton2.bm"
#include "vetobutton.bm"
#include "vetobutton2.bm"
#include "blankbutton.bm"
#include "anglebutton.bm"
#include "velocitybutton.bm"
#include "hulk.bm"
static char *surffile[NUMSURFACES] = {
    "plan1.bm",
    "plan2.bm",
    "plan3.bm",
    "plan4.bm",
};

void starfield(dpy, win, scn, playernum)
Display *dpy; /*xwindows stuff*/
Window win;
int scn;
int playernum;

{ /*starfield*/
    XGCValues sgcvalues;
    GC stargc;
    int numacross, numdown, tempx, tempy, temp, which;
    int depth = DisplayPlanes(dpy,scn);
    int fg = WhitePixel(dpy,scn);
    int bg = BlackPixel(dpy,scn);
    Pixmap starbm[12]; 
    Pixmap back; 

    for (temp=0;temp<7;temp++) {
	starbm[temp] = XCreateBitmapFromData(dpy, win, stars0_bits, stars0_width, stars0_height);
    }
    starbm[7] = XCreateBitmapFromData(dpy, win, stars1_bits, stars1_width, stars1_height);
    starbm[8] = XCreateBitmapFromData(dpy, win, stars2_bits, stars2_width, stars2_height);
    starbm[9] = XCreateBitmapFromData(dpy, win, stars3_bits, stars3_width, stars3_height);
    starbm[10] = XCreateBitmapFromData(dpy, win, stars4_bits, stars4_width, stars4_height);
    starbm[11] = XCreateBitmapFromData(dpy, win, fencepost_bits, fencepost_width, fencepost_height);
    numacross = (player[playernum].winw + 17) / 16;
    numdown = (player[playernum].winh + 17)/ 16;
    back = XCreatePixmap(dpy, win, player[playernum].winw, player[playernum].winh, DefaultDepth(dpy, scn));

    sgcvalues.function=GXcopy;
    sgcvalues.foreground = BlackPixel(dpy, scn);
    sgcvalues.background = WhitePixel(dpy, scn);
    stargc = XCreateGC(dpy, back, GCForeground | GCBackground | GCFunction, &sgcvalues);
    for (tempx=0; tempx < numacross; tempx++) {
	for (tempy=0; tempy < numdown; tempy++) {
	    Pixmap thisone;
	    int thisx, thisy;
	    which = (random() % 11);
	    thisone=starbm[which];
	    thisx = tempx*16;
	    thisy = tempy*16;
	    XCopyPlane(dpy, thisone, back, stargc,
		       0, 0, 16, 16, thisx, thisy, 0x1);
	}
    }
    XSetWindowBackgroundPixmap(dpy, win, back);
    XFreePixmap(dpy, back);
    player[playernum].readybuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, readybutton_bits,
				    readybutton_width, readybutton_height,
				    fg, bg, depth);
    player[playernum].readybutton2bm =
	XCreatePixmapFromBitmapData(dpy, win, readybutton2_bits,
				    readybutton2_width, readybutton2_height,
				    fg, bg, depth);
    player[playernum].vetobuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, vetobutton_bits,
				    vetobutton_width, vetobutton_height,
				    fg, bg, depth);
    player[playernum].vetobutton2bm =
	XCreatePixmapFromBitmapData(dpy, win, vetobutton2_bits,
				    vetobutton2_width, vetobutton2_height,
				    fg, bg, depth);
    player[playernum].firebuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, firebutton_bits,
				    firebutton_width, firebutton_height,
				    fg, bg, depth);
    player[playernum].firebutton2bm =
	XCreatePixmapFromBitmapData(dpy, win, firebutton2_bits,
				    firebutton2_width, firebutton2_height,
				    fg, bg, depth);
    player[playernum].zoombuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, zoombutton_bits,
				    zoombutton_width, zoombutton_height,
				    fg, bg, depth);
    player[playernum].zoombutton2bm =
	XCreatePixmapFromBitmapData(dpy, win, zoombutton2_bits,
				    zoombutton2_width, zoombutton2_height,
				    fg, bg, depth);
    player[playernum].blankbuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, blankbutton_bits,
				    blankbutton_width, blankbutton_height,
				    fg, bg, depth);
    player[playernum].anglebuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, anglebutton_bits,
				    anglebutton_width, anglebutton_height,
				    fg, bg, depth);
    player[playernum].velocitybuttonbm =
	XCreatePixmapFromBitmapData(dpy, win, velocitybutton_bits,
				    velocitybutton_width,
				    velocitybutton_height, fg, bg, depth);
    player[playernum].hulkbm =
	XCreatePixmapFromBitmapData(dpy, win, hulk_bits, hulk_width,
				    hulk_height, fg, bg, depth);

    player[playernum].readybuttonminx = 0;
    player[playernum].readybuttonmaxx = player[playernum].readybuttonminx+BUTWIDTH-1;
    player[playernum].readybuttonminy = 0;
    player[playernum].readybuttonmaxy = player[playernum].readybuttonminy+BUTHEIGHT-1;

    player[playernum].vetobuttonminx = 69;
    player[playernum].vetobuttonmaxx = player[playernum].vetobuttonminx+BUTWIDTH-1;
    player[playernum].vetobuttonminy = 0;
    player[playernum].vetobuttonmaxy = player[playernum].vetobuttonminy+BUTHEIGHT-1;

    player[playernum].firebuttonminx = 138;
    player[playernum].firebuttonmaxx = player[playernum].firebuttonminx+BUTWIDTH-1;
    player[playernum].firebuttonminy = 0;
    player[playernum].firebuttonmaxy = player[playernum].firebuttonminy+BUTHEIGHT-1;

    player[playernum].anglebuttonminx = 207;
    player[playernum].anglebuttonmaxx = player[playernum].anglebuttonminx+BUTWIDEWIDTH-1;
    player[playernum].anglebuttonminy = 0;
    player[playernum].anglebuttonmaxy = player[playernum].anglebuttonminy+BUTHEIGHT-1;

    player[playernum].velocitybuttonminx = 335;
    player[playernum].velocitybuttonmaxx = player[playernum].velocitybuttonminx+BUTWIDEWIDTH-1;
    player[playernum].velocitybuttonminy = 0;
    player[playernum].velocitybuttonmaxy = player[playernum].velocitybuttonminy+BUTHEIGHT-1;

    player[playernum].zoombuttonminx = 545;
    player[playernum].zoombuttonmaxx = player[playernum].zoombuttonminx+BUTWIDTH-1;
    player[playernum].zoombuttonminy = 0;
    player[playernum].zoombuttonmaxy = player[playernum].zoombuttonminy+BUTHEIGHT-1;


} /*starfield*/

void initwindow(winnum, dvname)
int winnum;
char *dvname;

{ /*initwindow*/
    XSetWindowAttributes attr;
    XGCValues gcvalues;
    XSizeHints hints;
    int temp, foo;


    player[winnum].dpy = XOpenDisplay(dvname);
    if (player[winnum].dpy == (Display *) NULL) {
	fprintf(stderr, "xgrav: could not open display.\n");
	exit (-1);
    }
#if 0
    /* for debugging */
    XSynchronize(player[winnum].dpy, True);
#endif
    player[winnum].scn = DefaultScreen(player[winnum].dpy);
    player[winnum].win = XCreateSimpleWindow(player[winnum].dpy, DefaultRootWindow(player[winnum].dpy), 50, 50, HIGH, WIDE, 1, WhitePixel(player[winnum].dpy, player[winnum].scn), BlackPixel(player[ winnum].dpy, player[ winnum].scn));
    XStoreName(player[winnum].dpy, player[winnum].win, "XGrav");
    player[winnum].winh = HIGH;
    player[winnum].winw = WIDE;
    attr.event_mask = ButtonPressMask | ButtonReleaseMask | KeyPressMask | ExposureMask | Button1MotionMask;
    /* somewhere in here, set the resize-increment-hint to 16. */
    hints.min_width = WIDE;
    hints.max_width = WIDE;
    hints.min_height = HIGH;
    hints.max_height = HIGH;
    hints.flags = PMinSize | PMaxSize;
    XSetNormalHints(player[winnum].dpy, player[winnum].win, &hints);
    XChangeWindowAttributes(player[winnum].dpy, player[winnum].win, CWEventMask, &attr);
    starfield(player[winnum].dpy, player[winnum].win, player[winnum].scn, winnum);
    gcvalues.foreground = WhitePixel (player[winnum].dpy, player[winnum].scn);
    gcvalues.background = WhitePixel (player[winnum].dpy, player[winnum].scn);
    gcvalues.fill_style = FillSolid;
    player[winnum].whitepen = XCreateGC(player[winnum].dpy, player[winnum].win, GCForeground | GCBackground | GCFillStyle, &gcvalues); 
    gcvalues.foreground = BlackPixel (player[winnum].dpy, player[winnum].scn);
    gcvalues.background = WhitePixel (player[winnum].dpy, player[winnum].scn);
    player[winnum].textpen = XCreateGC(player[winnum].dpy, player[winnum].win, GCBackground | GCForeground, &gcvalues);
    gcvalues.foreground = WhitePixel (player[winnum].dpy, player[winnum].scn);
    gcvalues.background = BlackPixel (player[winnum].dpy, player[winnum].scn);
    player[winnum].copypen = XCreateGC(player[winnum].dpy, player[winnum].win, GCBackground | GCForeground, &gcvalues);
    gcvalues.function=GXxor;
    gcvalues.foreground = gcvalues.foreground ^ gcvalues.background;
    gcvalues.background = 0;
    player[winnum].invertpen = XCreateGC(player[winnum].dpy, player[winnum].win, GCFunction | GCForeground | GCBackground, &gcvalues);
    gcvalues.foreground = BlackPixel (player[winnum].dpy, player[winnum].scn);
    gcvalues.background = BlackPixel (player[winnum].dpy, player[winnum].scn);
    player[winnum].blackpen = XCreateGC(player[winnum].dpy, player[winnum].win, GCBackground | GCForeground, &gcvalues);
    gcvalues.function=GXor;
    gcvalues.foreground = WhitePixel (player[winnum].dpy, player[winnum].scn);
    /* XXX On some servers, black | white is black, not white. */
    if (!gcvalues.foreground && gcvalues.background)
	gcvalues.function = GXand;
    player[winnum].andpen = XCreateGC(player[winnum].dpy, player[winnum].win, GCFunction | GCForeground | GCBackground, &gcvalues);
    if (!planetsurf) {
	for (temp = 0; temp < NUMSURFACES; temp++) {
	    player[winnum].planetpen[temp] = player[winnum].whitepen;
	}
    }
    else {
	GC surfgc = NULL;
	gcvalues.function=GXcopy;
	gcvalues.background = BlackPixel (player[winnum].dpy, player[winnum].scn);
	gcvalues.fill_style = FillTiled;
	for (temp = 0; temp < NUMSURFACES; temp++) {
	    Pixmap surf, surf2;
	    unsigned int surf_width, surf_height;
	    char filnm[512];
	    strcpy(filnm, BITMAPDIR);
	    strcat(filnm, surffile[temp]);
	    if (XReadBitmapFile(player[winnum].dpy, player[winnum].win, filnm, &surf_width, &surf_height, &surf, &foo, &foo) != BitmapSuccess) {
		fprintf(stderr,"xgrav: error reading planet surface bitmap.");
		exit(-1);
	    };
	    surf2 = XCreatePixmap(player[winnum].dpy, player[winnum].win,
				  surf_width, surf_height,
				  DefaultDepth(player[winnum].dpy,
					       player[winnum].scn));
	    if (!surfgc) {
		XGCValues vals;
		vals.function = GXcopy;
		vals.foreground = BlackPixel(player[winnum].dpy,
					     player[winnum].scn);
		vals.background = WhitePixel(player[winnum].dpy,
					     player[winnum].scn);
		surfgc = XCreateGC(player[winnum].dpy, surf2,
				   GCFunction|GCForeground|GCBackground,
				   &vals);
	    }
	    XCopyPlane(player[winnum].dpy, surf, surf2,
		       surfgc, 0, 0, surf_width,
		       surf_height, 0, 0, 0x1);
	    XFreePixmap(player[winnum].dpy, surf);
	    gcvalues.tile = surf2;
	    player[winnum].planetpen[temp] = XCreateGC(player[winnum].dpy, player[winnum].win, GCFunction | GCFillStyle | GCTile | GCForeground | GCBackground, &gcvalues);
	};
	if (surfgc)
	    XFreeGC(player[winnum].dpy, surfgc);
    }

    XClearWindow(player[ winnum].dpy, player[winnum].win);
    XFlush(player[winnum].dpy);
    XMapWindow(player[winnum].dpy, player[winnum].win);
    
    for (temp = 0; temp<numplayers; temp++) {
	if (XReadBitmapFile(player[winnum].dpy, player[winnum].win, shipname[temp], (unsigned int *) &player[winnum].shipwidth, (unsigned int *) &player[winnum].shipheight, &player[winnum].shipbm[temp], &foo, &foo) != BitmapSuccess) {
	    fprintf(stderr,"xgrav: error reading ship bitmap.\n");
	    exit(-1);
	} 
    }
    player[winnum].trails = XCreatePixmap(player[winnum].dpy, player[winnum].win, player[winnum].winw, player[winnum].winh,
					  DefaultDepth(player[winnum].dpy,
						       player[winnum].scn));
} /*initwindow*/

