/**
  * (c) Copyright  2003-2006, Marvell International Ltd. 
  * All Rights Reserved
  *
  * This software file (the "File") is distributed by Marvell International 
  * Ltd. under the terms of the GNU General Public License Version 2, June 1991 
  * (the "License").  You may use, redistribute and/or modify this File in 
  * accordance with the terms and conditions of the License, a copy of which 
  * is available along with the File in the license.txt file or by writing to 
  * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
  * 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
  *
  * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE 
  * IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE 
  * ARE EXPRESSLY DISCLAIMED.  The License provides additional details about 
  * this warranty disclaimer.
  *
  */

#ifndef	_OS_MACROS_H
#define _OS_MACROS_H

extern spinlock_t	driver_lock;

#define UpdateTransStart(dev) { \
	dev->trans_start = jiffies; \
}

#define OS_SET_THREAD_STATE(x)		set_current_state(x)

#define MODULE_GET	try_module_get(THIS_MODULE)
#define MODULE_PUT	module_put(THIS_MODULE)

static inline int CopyMulticastAddrs(wlan_adapter *Adapter, 
						struct net_device *dev)
{
	int			i = 0;
	struct dev_mc_list	*mcptr = dev->mc_list;
				
	for (i = 0; i < dev->mc_count; i++) {
		memcpy(&Adapter->MulticastList[i], mcptr->dmi_addr, ETH_ALEN);
		mcptr = mcptr->next;
	}


	return i;

}

static inline int os_upload_rx_packet(wlan_private *priv, 
				struct sk_buff *skb)
{

#define IPFIELD_ALIGN_OFFSET	2
	PRINTM(INFO, "skb->data=%p\n", skb->data);

	skb->dev = priv->wlan_dev.netdev;
	skb->protocol = eth_type_trans(skb, priv->wlan_dev.netdev);
	skb->ip_summed = CHECKSUM_UNNECESSARY;

	
	netif_rx(skb);

	return 0;
}

static inline void os_free_tx_packet(wlan_private *priv)
{
	ulong	flags;

	spin_lock_irqsave(&priv->adapter->CurrentTxLock, flags);
	
	if (priv->adapter->CurrentTxSkb) {
		kfree_skb(priv->adapter->CurrentTxSkb);
	}

	priv->adapter->CurrentTxSkb = NULL;
	
	spin_unlock_irqrestore(&priv->adapter->CurrentTxLock, flags);
}

/* netif carrier_on/off and start(wake)/stop_queue handling
		carrier_on	carrier_off	start_queue	stop_queue
 open		x(connect)	x(disconnect)	x
 close				x				x
 assoc		x				x
 adhoc-start	x				x
 adhoc-join	x				x
 scan-begin			x				x
 scan-end	x				x
 deauth				x				x
 ps-sleep			x				x
 ps-awake	x				x
 ds-enter			x				x
 ds-exit	x				x
 xmit								x
 xmit-done					x
 tx-timeout
 */

static inline void os_carrier_on(wlan_private *priv) 
{
	if (!netif_carrier_ok(priv->wlan_dev.netdev) &&
		(priv->adapter->MediaConnectStatus == WlanMediaStateConnected))
		netif_carrier_on(priv->wlan_dev.netdev);
}

static inline void os_carrier_off(wlan_private *priv) 
{
	if (netif_carrier_ok(priv->wlan_dev.netdev))
		netif_carrier_off(priv->wlan_dev.netdev);
}

static inline void os_start_queue(wlan_private *priv) 
{
	if (netif_queue_stopped(priv->wlan_dev.netdev) && 
 		(priv->adapter->MediaConnectStatus == WlanMediaStateConnected)) {
		netif_wake_queue(priv->wlan_dev.netdev);
	}
}

static inline void os_stop_queue(wlan_private *priv) 
{
	if (!netif_queue_stopped(priv->wlan_dev.netdev)) {
		netif_stop_queue(priv->wlan_dev.netdev);
	}
}

static inline int os_queue_is_active(wlan_private *priv)
{
    return (netif_carrier_ok(priv->wlan_dev.netdev)
            && !netif_queue_stopped(priv->wlan_dev.netdev));
}

#endif /* _OS_MACROS_H */
