/*
 *
 * Definitions for HTC Himalaya
 *
 * Copyright 2004 Xanadux.org
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * Author: w4xy@xanadux.org
 *
 */

/* Names based on h1900-gpio.h */

#ifndef _BLUEANGEL_GPIO_H_
#define _BLUEANGEL_GPIO_H_

#define BLUEANGEL_IRQ(gpio) \
        IRQ_GPIO(GPIO_NR_BLUEANGEL_ ## gpio)

#define GPIO_NR_BLUEANGEL_POWER_BUTTON_N 	0
#define GPIO_NR_BLUEANGEL_WARM_RST_N	 	1
#define GPIO_NR_BLUEANGEL_TSC2200_KB_N		2
#define GPIO_NR_BLUEANGEL_ASIC3_IRQ    	 	3
#define GPIO_NR_BLUEANGEL_GSM_ALERTING		6
#define	GPIO_NR_BLUEANGEL_USB_DETECT_N 	 	8
#define GPIO_NR_BLUEANGEL_SD_IRQ_N 		11
#define GPIO_NR_BLUEANGEL_TS_IRQ_N 		16
#define GPIO_NR_BLUEANGEL_WLAN_IRQ_N 		17
#define GPIO_NR_BLUEANGEL_BOARDID3		21
#define GPIO_NR_BLUEANGEL_BOARDID0		66		
#define GPIO_NR_BLUEANGEL_BOARDID1		67
#define GPIO_NR_BLUEANGEL_DPRAM_RX_FULL_N	68
#define GPIO_NR_BLUEANGEL_DPRAM_TX_EMPTY_N	69
#define GPIO_NR_BLUEANGEL_BOARDID2		76

#define IRQ_NR_BLUEANGEL_TSC2200_TS	IRQ_GPIO(GPIO_NR_BLUEANGEL_TS_IRQ_N)
#define IRQ_NR_BLUEANGEL_POWER_BUTTON	IRQ_GPIO(GPIO_NR_BLUEANGEL_POWER_BUTTON_N)
#define IRQ_NR_BLUEANGEL_TSC2200_KB	IRQ_GPIO(GPIO_NR_BLUEANGEL_TSC2200_KB_N)
#define IRQ_NR_BLUEANGEL_ASIC3		IRQ_GPIO(GPIO_NR_BLUEANGEL_ASIC3_IRQ)
#define IRQ_NR_BLUEANGEL_GSM_ALERTING	IRQ_GPIO(GPIO_NR_BLUEANGEL_GSM_ALERTING)
#define IRQ_NR_BLUEANGEL_RX_FULL	IRQ_GPIO(GPIO_NR_BLUEANGEL_DPRAM_RX_FULL_N)
#define IRQ_NR_BLUEANGEL_TX_EMPTY	IRQ_GPIO(GPIO_NR_BLUEANGEL_DPRAM_TX_EMPTY_N)

#define BLUEANGEL_ASIC3_GPIO_PHYS     0x0c000000
#define BLUEANGEL_ASIC3_MMC_PHYS      0x0e000000

#endif /* _BLUEANGEL_GPIO_H_ */
