/* 
 * Linux kernel interface for external power suppliers/supplicants
 *
 * Copyright (c) 2007  Anton Vorontsov <cbou@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __EXTERNAL_POWER_H__
#define __EXTERNAL_POWER_H__

#include <linux/list.h>

/* kernel interface for external power suppliers, like AC or USB */

struct power_supply {
	char *name;
	char *type;
	int nominal_voltage;
	int (*is_online)(struct power_supply *psy);
	char **supplied_to;
	size_t num_supplicants;

	/* private */
	struct list_head bound_supplicants;
	struct device *dev;
};

extern void power_supply_changed(struct power_supply *psy);
extern int power_supply_register(struct device *parent,
                                 struct power_supply *psy);
extern void power_supply_unregister(struct power_supply *psy);

/* kernel interface for external power supplicants (batteries so far) */

struct power_supplicant {
	char *name;
	/* used to notify supplicant about external power arrival/outage,
	 * do not sleep there, this is called from irq, most probably */
	void (*power_supply_changed)(struct power_supplicant *pst,
	                             struct power_supply *psy);

	/* private */
	struct list_head bound_supplies;
	struct list_head node;
};

extern int power_supplicant_am_i_supplied(struct power_supplicant *pst);
extern int power_supplicant_register(struct power_supplicant *pst);
extern void power_supplicant_unregister(struct power_supplicant *pst);

#endif /* __EXTERNAL_POWER_H__ */
