#include <linux/delay.h>
#include <linux/gpio_keys.h>
#include <linux/init.h>
#include <linux/input.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/mach-types.h>
#include <asm/setup.h>

#include <asm/mach/irq.h>
#include <asm/mach/arch.h>
#include <asm/arch/bitfield.h>
#include <asm/arch/irda.h>
#include <asm/arch/pxafb.h>
#include <asm/arch/pxa27x_keyboard.h>
#include <asm/arch/pxa-regs.h>
#include <asm/arch/serial.h>
#include <asm/arch/htcuniversal-gpio.h>

#include "../generic.h"

static struct pxafb_mode_info o2atom_lcd_mode = {
        .pixclock               = 210000,
        .xres                   = 240,
        .yres                   = 320,
        .bpp                    = 16,
        .hsync_len              = 4,
        .vsync_len              = 6,
        .left_margin            = 3,
        .right_margin           = 2,
        .upper_margin           = 2,
        .lower_margin           = 2,
};

static struct pxafb_mach_info o2atom_lcd = {
        .modes                  = &o2atom_lcd_mode,
        .num_modes              = 1,
        .lccr0                  = LCCR0_LDDALT | LCCR0_Act,
};

#define O2ATOM_CF_BASE (0x14000000)
static struct resource o2atom_cf_resources[] = {
        [0] = {
                .start  = O2ATOM_CF_BASE,
                .end    = O2ATOM_CF_BASE + (0x020000000 - 1),
                .flags  = IORESOURCE_MEM | IORESOURCE_MEM_8AND16BIT,
        },
};

static struct platform_device o2atom_cf_device = {
        .name           = "o2atom_vlio_cf",
        .id             = -1,
        .resource       = o2atom_cf_resources,
        .num_resources  = ARRAY_SIZE(o2atom_cf_resources),
};

static struct platform_device o2atom_ts_device = {
        .name           = "pxa2xx-ac97",
        .id             = -1,
};

static void o2atom_irda_transceiver_mode(struct device *dev, int mode) {
}

static struct pxaficp_platform_data o2atom_ficp_platform_data = {
       .transceiver_cap  = IR_SIRMODE | IR_FIRMODE,
       .transceiver_mode = o2atom_irda_transceiver_mode,
};

// Bluetooth and GSM support

static void o2atom_bt_configure(int state)
{
        switch (state) {
                case PXA_UART_CFG_PRE_STARTUP:
                        break;
                case PXA_UART_CFG_POST_STARTUP:
                        printk("96: %d\n", GPLR(96) & GPIO_bit(96));
                        pxa_gpio_mode(86 | GPIO_OUT | GPIO_DFLT_HIGH);
                        msleep(500);
                        printk("96: %d\n", GPLR(96) & GPIO_bit(96));
                        pxa_gpio_mode(114 | GPIO_OUT | GPIO_DFLT_HIGH);
                        break;
                case PXA_UART_CFG_PRE_SHUTDOWN:
                        break;
                case PXA_UART_CFG_POST_SHUTDOWN:
                        break;
                default:
                        break;
        }
}

static void o2atom_phone_configure(int state)
{
        switch (state) {
                case PXA_UART_CFG_PRE_STARTUP:
                        break;
                case PXA_UART_CFG_POST_STARTUP:
                        printk("37: %d\n", GPLR(37) & GPIO_bit(37));
                        pxa_gpio_mode(82 | GPIO_OUT | GPIO_DFLT_HIGH); // RESET
                        mdelay(500);
                        printk("37: %d\n", GPLR(37) & GPIO_bit(37));
                        GPCR(82) = GPIO_bit(82);
                        mdelay(500);
                        break;
                case PXA_UART_CFG_PRE_SHUTDOWN:
                        break;
                case PXA_UART_CFG_POST_SHUTDOWN:
                        break;
                default:
                        break;
        }
}

static struct platform_pxa_serial_funcs o2atom_pxa_bt_funcs = {
        .configure = o2atom_bt_configure
};

static struct platform_pxa_serial_funcs o2atom_pxa_ff_funcs = {
        .configure = o2atom_phone_configure
};

// PXA keypad support

static struct pxa27x_keyboard_platform_data o2atom_kbd = {
        .nr_rows = 3,
        .nr_cols = 5,
        .keycodes = {
                {	 /* row 0 */
                        KEY_A,
			KEY_B,
			KEY_C,
			KEY_D,
			KEY_E,
                }, {    /* row 1 */
                        KEY_F,
			KEY_G,
			KEY_H,
			KEY_I,
			KEY_J,
                }, {    /* row 2 */
                        KEY_K,
			KEY_L,
			KEY_M,
			KEY_N,
			KEY_O,
                },
        },
        .gpio_modes = {
                 GPIO_NR_HTCUNIVERSAL_KP_MKIN0_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKIN1_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKIN2_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKOUT0_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKOUT1_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKOUT2_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKOUT3_MD,
                 GPIO_NR_HTCUNIVERSAL_KP_MKOUT4_MD,
         },
};

static struct platform_device o2atom_pxa_keyboard = {
        .name   = "pxa27x-keyboard",
        .id     = -1,
        .dev    =  {
                .platform_data  = &o2atom_kbd,
        },
};

// GPIO button Support

#define GPIO_O2ATOM_POWER 0
static struct gpio_keys_button o2atom_button_table[] = {
        { KEY_POWER, GPIO_O2ATOM_POWER, 1 },
};

static struct gpio_keys_platform_data o2atom_pxa_keys_data = {
        .buttons = o2atom_button_table,
        .nbuttons = ARRAY_SIZE(o2atom_button_table),
};

static struct platform_device o2atom_pxa_keys = {
        .name = "gpio-keys",
        .dev = {
                .platform_data = &o2atom_pxa_keys_data,
        },
        .id = -1,
};

static void __init o2atom_init(void)
{
        set_pxa_fb_info(&o2atom_lcd);
        platform_device_register(&o2atom_cf_device);
        platform_device_register(&o2atom_ts_device);
        platform_device_register(&o2atom_pxa_keyboard);
	platform_device_register(&o2atom_pxa_keys);
}

static void __init o2atom_map_io(void)
{
        pxa_map_io();
        pxa_set_btuart_info(&o2atom_pxa_bt_funcs);
        pxa_set_ffuart_info(&o2atom_pxa_ff_funcs);
}

static void __init o2atom_init_irq(void)
{
        pxa_init_irq();
        pxa_set_ficp_info(&o2atom_ficp_platform_data);
}

MACHINE_START(O2ATOM, "O2 XDA Atom")
        .phys_io        = 0x40000000,
        .io_pg_offst    = (io_p2v(0x40000000) >> 18) & 0xfffc,
        .boot_params    = 0xa0000100,
        .map_io         = o2atom_map_io,
        .init_irq       = o2atom_init_irq,
        .init_machine   = o2atom_init,
        .timer          = &pxa_timer,
MACHINE_END
