/* 
 * include/asm-arm/arch-pxa/htcsable-gpio.h
 * History:
 *
 * 2004-12-10 Michael Opdenacker. Wrote down GPIO settings as identified by Jamey Hicks.
 *            Reused the h2200-gpio.h file as a template.
 */

#ifndef _HTCSABLE_GPIO_H_
#define _HTCSABLE_GPIO_H_

#include <asm/arch/pxa-regs.h>

#define GET_HTCSABLE_GPIO(gpio) \
	(GPLR(GPIO_NR_HTCSABLE_ ## gpio) & GPIO_bit(GPIO_NR_HTCSABLE_ ## gpio))

#define SET_HTCSABLE_GPIO(gpio, setp) \
do { \
if (setp) \
	GPSR(GPIO_NR_HTCSABLE_ ## gpio) = GPIO_bit(GPIO_NR_HTCSABLE_ ## gpio); \
else \
	GPCR(GPIO_NR_HTCSABLE_ ## gpio) = GPIO_bit(GPIO_NR_HTCSABLE_ ## gpio); \
} while (0)

#define SET_HTCSABLE_GPIO_N(gpio, setp) \
do { \
if (setp) \
	GPCR(GPIO_NR_HTCSABLE_ ## gpio ## _N) = GPIO_bit(GPIO_NR_HTCSABLE_ ## gpio ## _N); \
else \
	GPSR(GPIO_NR_HTCSABLE_ ## gpio ## _N) = GPIO_bit(GPIO_NR_HTCSABLE_ ## gpio ## _N); \
} while (0)

#define HTCSABLE_IRQ(gpio) \
	IRQ_GPIO(GPIO_NR_HTCSABLE_ ## gpio)
	
#define GPIO_NR_HTCSABLE_KEY_ON_N			 0
#define GPIO_NR_HTCSABLE_GP_RST_N			 1

#define GPIO_NR_HTCSABLE_PHONE_3       11 /* phone-related output */

#define GPIO_NR_HTCSABLE_ASIC3_EXT_INT			 9
#define GPIO_NR_HTCSABLE_ASIC3_SDIO_INT_N		13

#define GPIO_NR_HTCSABLE_I2S_BCK      28
#define GPIO_NR_HTCSABLE_I2S_DIN      29
#define GPIO_NR_HTCSABLE_I2S_DOUT     30
#define GPIO_NR_HTCSABLE_I2S_SYNC     31

#define GPIO_NR_HTCSABLE_I2S_SYSCLK     113
#define GPIO_NR_HTCSABLE_TOUCHPANEL_IRQ_N		115

#define EGPIO6_BT_3V3_ON    (1<<6)  /* Bluetooth 3.3V enable */

/* TODO: should be checked */

#define GPIO_NR_HTCSABLE_TOUCHSCREEN_SPI_CLK_MD	(23 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCSABLE_TOUCHSCREEN_SPI_CS_N_MD	(24 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCSABLE_TOUCHSCREEN_SPI_DO_MD	(25 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_TOUCHSCREEN_SPI_DI_MD	(26 | GPIO_ALT_FN_1_IN)

#define GPIO_NR_HTCSABLE_I2S_BCK_MD		(28 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCSABLE_I2S_DIN_MD		(29 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCSABLE_I2S_DOUT_MD		(30 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCSABLE_I2S_SYNC_MD		(31 | GPIO_ALT_FN_1_OUT)

/* nope - this should be STUART!
#define GPIO_NR_HTCSABLE_COM_RXD_MD		(34 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_COM_CTS_MD		(35 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_COM_TXD_MD		(39 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_COM_RTS_MD		(41 | GPIO_ALT_FN_2_OUT)
*/

#define GPIO_NR_HTCSABLE_PHONE_RXD_MD		(42 | GPIO_ALT_FN_1_IN) /* BTUART */
#define GPIO_NR_HTCSABLE_PHONE_TXD_MD		(43 | GPIO_ALT_FN_2_OUT) /* BTUART */
#define GPIO_NR_HTCSABLE_PHONE_UART_CTS_MD		(44 | GPIO_ALT_FN_1_IN) /* BTUART */
#define GPIO_NR_HTCSABLE_PHONE_UART_RTS_MD		(45 | GPIO_ALT_FN_2_OUT) /* BTUART */

#define GPIO_NR_HTCSABLE_BT_RXD_MD	(34 | GPIO_ALT_FN_1_IN) /* FFUART */
#define GPIO_NR_HTCSABLE_BT_TXD_MD	(39 | GPIO_ALT_FN_2_OUT) /* FFUART */
#define GPIO_NR_HTCSABLE_BT_UART_CTS_MD	(35 | GPIO_ALT_FN_1_IN) /* FFUART */
#define GPIO_NR_HTCSABLE_BT_UART_RTS_MD	(41 | GPIO_ALT_FN_2_OUT) /* FFUART */

#define GPIO_NR_HTCSABLE_STD_RXD_MD		(46 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCSABLE_STD_TXD_MD		(47 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCSABLE_POE_N_MD			(48 | GPIO_ALT_FN_2_OUT | GPIO_DFLT_HIGH)
#define GPIO_NR_HTCSABLE_PWE_N_MD			(49 | GPIO_ALT_FN_2_OUT | GPIO_DFLT_HIGH)

#define GPIO_NR_HTCSABLE_I2S_SYSCLK_MD		(113 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCSABLE_ACX           (111)
#define GPIO_NR_HTCSABLE_PWM1OUT_MD		(115 | GPIO_ALT_FN_3_OUT)

#define GPIO_NR_HTCSABLE_I2C_SCL_MD		(117 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCSABLE_I2C_SDA_MD		(118 | GPIO_ALT_FN_1_OUT)

/****************************************************************
 * Pull out keyboard
 ****************************************************************/

#define GPIO_NR_HTCSABLE_KP_MKIN0	100
#define GPIO_NR_HTCSABLE_KP_MKIN1	101
#define GPIO_NR_HTCSABLE_KP_MKIN2	102
#define GPIO_NR_HTCSABLE_KP_MKIN3	37
#define GPIO_NR_HTCSABLE_KP_MKIN4	38
#define GPIO_NR_HTCSABLE_KP_MKIN5	90
#define GPIO_NR_HTCSABLE_KP_MKIN6	91
#define GPIO_NR_HTCSABLE_KP_MKIN7	36

#define GPIO_NR_HTCSABLE_KP_MKOUT0	103
#define GPIO_NR_HTCSABLE_KP_MKOUT1	104
#define GPIO_NR_HTCSABLE_KP_MKOUT2	105
#define GPIO_NR_HTCSABLE_KP_MKOUT3	106
#define GPIO_NR_HTCSABLE_KP_MKOUT4	107
#define GPIO_NR_HTCSABLE_KP_MKOUT5	108
#define GPIO_NR_HTCSABLE_KP_MKOUT6	40
#define GPIO_NR_HTCSABLE_KP_MKOUT7	22

#define GPIO_NR_HTCSABLE_KP_MKIN0_MD 	(GPIO_NR_HTCSABLE_KP_MKIN0 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN1_MD 	(GPIO_NR_HTCSABLE_KP_MKIN1 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN2_MD 	(GPIO_NR_HTCSABLE_KP_MKIN2 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN3_MD 	(GPIO_NR_HTCSABLE_KP_MKIN3 | GPIO_ALT_FN_3_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN4_MD 	(GPIO_NR_HTCSABLE_KP_MKIN4 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN5_MD 	(GPIO_NR_HTCSABLE_KP_MKIN5 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN6_MD 	(GPIO_NR_HTCSABLE_KP_MKIN6 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCSABLE_KP_MKIN7_MD 	(GPIO_NR_HTCSABLE_KP_MKIN7 | GPIO_ALT_FN_3_IN)

#define GPIO_NR_HTCSABLE_KP_MKOUT0_MD (GPIO_NR_HTCSABLE_KP_MKOUT0 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT1_MD (GPIO_NR_HTCSABLE_KP_MKOUT1 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT2_MD (GPIO_NR_HTCSABLE_KP_MKOUT2 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT3_MD (GPIO_NR_HTCSABLE_KP_MKOUT3 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT4_MD (GPIO_NR_HTCSABLE_KP_MKOUT4 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT5_MD (GPIO_NR_HTCSABLE_KP_MKOUT5 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT6_MD (GPIO_NR_HTCSABLE_KP_MKOUT6 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCSABLE_KP_MKOUT7_MD (GPIO_NR_HTCSABLE_KP_MKOUT7 | GPIO_ALT_FN_1_OUT)
#endif /* _HTCSABLE_GPIO_H */
