/*
 * Definitions related to sockets: types, address families, options.
 * Last Revision: 1/8/94
 */

/*
 * Types
 */

#ifndef _SYS_SOCKET_INCLUDED
#define _SYS_SOCKET_INCLUDED

#define	SOCK_STREAM	1		/* stream socket */
#define	SOCK_DGRAM	2		/* datagram socket */

/*
 * Option flags per-socket.
 */

#define	SO_DEBUG	0x01		/* turn on debugging info recording */
#define	SO_ACCEPTCONN	0x02		/* socket has had listen() */
#define	SO_REUSEADDR	0x04		/* allow local address reuse */
#define	SO_KEEPALIVE	0x08		/* keep connections alive */
#define	SO_DONTROUTE	0x10		/* just use interface addresses */
#define SO_BROADCAST	0x20		/* permit sending of broadcast msgs */
#define	SO_USELOOPBACK	0x40		/* bypass hardware when possible */
#define	SO_LINGER	0x80		/* linger on close if data present */
#define	SO_OOBINLINE	0x100		/* leave received OOB data in line */

/*
 * Additional options, not kept in so_options.
 */
#define SO_SNDBUF	0x1001		/* send buffer size */
#define SO_RCVBUF	0x1002		/* receive buffer size */
#define SO_SNDLOWAT	0x1003		/* send low-water mark */
#define SO_RCVLOWAT	0x1004		/* receive low-water mark */
#define SO_SNDTIMEO	0x1005		/* send timeout */
#define SO_RCVTIMEO	0x1006		/* receive timeout */
#define SO_ERROR	0x1007		/* get error status and clear */
#define SO_TYPE		0x1008		/* get socket type */

/*
 * Structure used for manipulating linger option.
 */
struct linger {
       int	l_onoff;		/* option on/off */
       int	l_linger;		/* linger time */
};

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define	SOL_SOCKET	0xffff		/* options for socket level */

/*
 * Address families.
 */

#define	AF_UNIX		1		/* local to host (pipes, portals) */
#define	AF_INET		2		/* internetwork: UDP, TCP, etc. */


/* Structure used by socket address */
struct sockaddr {
       unsigned short sa_family;      /* family type */
       char           sa_data[14];    /* sap address */
};

/* Structure used for protocol infomation in raw sockets */
struct sockproto {
       unsigned short sp_family;      /* family */
       unsigned short sp_protocol;    /* protocol */
};

struct msghdr {
	caddr_t	msg_name;		/* optional address */
	int	msg_namelen;		/* size of address */
	struct	iovec *msg_iov;		/* scatter/gather array */
	int	msg_iovlen;		/* # elements in msg_iov */
	caddr_t	msg_accrights;		/* access rights sent/received */
	int	msg_accrightslen;
};

#define	MSG_OOB		0x1		/* process out-of-band data */
#define	MSG_PEEK	0x2		/* peek at incoming message */
#define	MSG_DONTROUTE	0x4		/* send without using routing tables */


#ifndef IS_SOCKET_CLIB_ITSELF
  /* BSDIPC system calls */
  extern int accept();
  extern int bind();
  extern int connect();
  extern int getpeername();
  extern int getsockname();
  extern int getsockopt();
  extern int listen();
  extern int recv();
  extern int recvfrom();
  extern int recvmsg();
  extern int send();
  extern int sendto();
  extern int sendmsg();
  extern int setsockopt();
  extern int shutdown();
  extern int socket();
  extern int socketpair();

  /* BSDIPC libary routines
  extern struct hostent *gethostent();
  extern struct hostent *gethostbyname();
  extern struct hostent *gethostbyaddr();
  extern int sethostent();
  extern int endhostent();
  extern struct netent *getnetent();
  extern struct netent *getnetbyname();
  extern struct netent *getnetbyaddr();
  extern int setnetent();
  extern int endnetent();
  extern struct protoent *getprotoent();
  extern struct protoent *getprotobyname();
  extern struct protoent *getprotobynumber();
  extern int setprotoent();
  extern int endprotoent();
  extern struct servent *getservent();
  extern struct servent *getservbyname();
  extern struct servent *getservbyport();
  extern int setservent();
  extern int endservent();
*/
#endif   /* IS_SOCKET_CLIB_ITSELF */
#endif   /* _SYS_SOCKET_INCLUDED */
