
#ifndef _Goban_h_INCLUDED
#define _Goban_h_INCLUDED

#define XtNblackColor "blackColor"
#define XtNwhiteColor "whiteColor"
#define XtNboardColor "boardColor"
#define XtNlineColor "lineColor"
#define XtNboardSize "boardSize"
#define XtNgobanMenu "gobanMenu"
#define XtNmode "mode"
#define XtNclientData "clientData"
#define XtNwhiteCapturesLabel "whiteCapturesLabel"
#define XtNblackCapturesLabel "blackCapturesLabel"
#define XtNshell "shell"
#define XtCShell "Shell"
#define XtCCapturesLabel "CapturesLabel"

typedef struct _GobanRec *GobanWidget;
typedef struct _GobanClassRec *GobanWidgetClass;

extern WidgetClass gobanWidgetClass;

enum { NoPiece, WhitePiece, BlackPiece, WhiteTerritory, BlackTerritory, MarkerPiece };

typedef enum {
    GobanNone,
    GobanPlaying,
    GobanObserving,
    GobanScrewingAround
} GobanMode;

Boolean XGobanReceivedMove (Widget w,	/* TRUE means we're on sync */
			    int move, int h, int v); /* FALSE means help me! */

Boolean XGobanReceivedHandicap (Widget w,
			 int move, int hcap);

Boolean XGobanReceivedPass (Widget w, int move);

Boolean XGobanReceivedRemove (Widget w, int h, int v);

void XGobanResetGame (Widget w, GobanMode m);

void XGobanSetPiece (Widget w, int h, int v, int piece);

void XGobanFirst (Widget w);
void XGobanBackward (Widget w);
void XGobanCurrent (Widget w);
void XGobanForward (Widget w);
void XGobanLast (Widget w);
void XGobanUndo (Widget w);
void XGobanNew (Widget w);
void XGobanPass (Widget w);
void XGobanDone (Widget w);
void XGobanClear (Widget w);
void XGobanQuit (Widget w);
void XGobanHandicap (Widget w, int hcap);

#endif
