;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI Master       ;
;*  for PIC16 family                                                            ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            16SPIMI.asm                                     ;    
;* Dependencies:        P16xxx.inc                                      ;
;*                      SPIMInt.Def                                     ;
;*                      SPIMInt.Inc                                     ;
;* Processor:           PIC16xxxx                                       ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Apr 14, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************************************;


;***********************************************************************;
;_SPIMINTCODE                                                           ;
                                                                        ;
;***********************************************************************;


_SPIMINTINIT    CODE                            
;***********************************************************************;
; Function: SPIMIntInit                                                 ;
;                                                                       ;
; PreCondition: TRIS bits of the SCK,SDO are to be made o/p and         ;
;        TRIS bit of SDI as i/p. Slave Chip Select has to be generated. ;
;                                                                       ;
; Overview:                                                             ;
;       This routine is used for MSSP/SSP/BSSP Module Initialization    ;
;       It initializes Module according to compile time selection and   ;
;       flushes the Rx and Tx buffer. It clears all SPI errors          ;
;                                                                       ;
; Input: CLM options                                                    ;
;                                                                       ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPIMIntInit:                                    ;
                                                ;
        GLOBAL  SPIMIntInit                     ;
                                                ;
        BANKSEL SSPCON                          ;
        movlw   SPIM_SPEED                      ;Select SPI clock and enable SSP 
        movwf   SSPCON                          ;
                                                ;
        bsf     INTCON,PEIE                     ;
        bsf     INTCON,GIE                      ;
                                                ;
        BANKSEL _vSPIMIntTxBufWrPtr             ;
        clrf    _vSPIMIntTxBufWrPtr             ;
        clrf    _vSPIMIntTxBufRdPtr             ;
        clrf    _vSPIMIntRxBufWrPtr             ;
        clrf    _vSPIMIntRxBufRdPtr             ;
        clrf    _vSPIMTxDataCount               ;
        clrf    _vSPIMRxDataCount               ;
                                                ;
        clrf    vSPIMIntStatus                  ;
        bsf     vSPIMIntStatus,SPIMTxBufEmpty   ;
        bsf     vSPIMIntStatus,SPIMRxBufEmpty   ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;21



_SPIMINTPUT    CODE
;***********************************************************************;
; Function: SPIMIntPut                                                  ;
;                                                                       ;
; PreCondition: SPIMIntInit should have calledand slave should          ;
;    have been selected.                                                ;
;                                                                       ;
; Overview:                                                             ;
;       This sends data over SPI Bus if Bus is free, else writes data   ;
;    into the buffer                                                    ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPIMIntPut:                                     ;
                                                ;
        GLOBAL  SPIMIntPut                      ;
                                                ;
        btfss   vSPIMIntStatus,SPIMBusy         ;check is busy
        goto    SPIDirectTx                     ;
                                                ;
        #if SPIM_TX_BUF_LENGTH == 1             ;
                                                ;
        movwf   vSPIMIntTxBuffer                ;
        bsf     vSPIMIntStatus,SPIMTxBufFull    ;
        bcf     vSPIMIntStatus,SPIMTxBufEmpty   ;9
                                                ;
        #else                                   ;
                                                ;
        BANKSEL PIE1                            ;
        bcf     PIE1,SSPIE                      ;
                                                ;
        call    _SPIMIntWrTxBuf                 ;If busy save in buffer
                                                ;
        BANKSEL _vSPIMTxDataCount               ;
        incf    _vSPIMTxDataCount,f             ;Increment Data Count
                                                ;
        BANKSEL PIE1                            ;
        bsf     PIE1,SSPIE                      ;
                                                ;
        #endif                                  ;
                                                ;
        return                                  ;17 + 
                                                ;
SPIDirectTx                                     ;
        bsf     vSPIMIntStatus,SPIMBusy         ;If not busy set busy
                                                ;
        BANKSEL SSPBUF                          ;
        movwf   SSPBUF                          ;write data into SSPBUf
                                                ;
        bcf     PIR1,SSPIF                      ;clear serial_sync intrupt flag
                                                ;
        bsf     STATUS,RP0                      ;
        bsf     PIE1,SSPIE                      ;enable SSP module interrupt
                                                ;
        return                                  ;
                                                ;
;***********************************************;49    



        #if SPIM_TX_BUF_LENGTH != 1             ;
                                                ;
;***********************************************************************;
; Function: _SPIMIntWrTxBuf                                             ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This writes data into buffer.                                   ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: Buffer                                                        ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPIMIntWrTxBuf:                                ;
        btfsc   vSPIMIntStatus,SPIMTxBufFull    ;
        return                                  ;
                                                ;
        BANKSEL _vSPIMIntTempReg                ;
        movwf   _vSPIMIntTempReg                ;save the wreg content (data) in temflg
                                                ;
        movf    FSR,w                           ;
        movwf   _vSPIMIntDupFSR                 ;
                                                ;
        BANKSEL _vSPIMIntTxBufWrPtr             ;
        movlw   vSPIMIntTxBuffer                ;load wreg with write pointer address
        addwf   _vSPIMIntTxBufWrPtr,w           ;
                                                ;
        movwf   FSR                             ;increment write pointer
        BANKSEL _vSPIMIntTempReg                ;
        movf    _vSPIMIntTempReg,w              ;read data from SSPBUF
        movwf   INDF                            ;move wreg content to write pointer pointing location
                                                ;
        movf    _vSPIMIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPIMIntTxBufWrPtr             ;
        incf    _vSPIMIntTxBufWrPtr,f           ;increment write pointer
        movlw   SPIM_TX_BUF_LENGTH              ;check for overflow of pointer
        xorwf   _vSPIMIntTxBufRdPtr,w           ;campare it with write pointer
        btfsc   STATUS,Z                        ;
        clrf    _vSPIMIntTxBufWrPtr             ;
                                                ;
        movf    _vSPIMIntTxBufWrPtr,w           ;Check is buffer full
        xorwf   _vSPIMIntTxBufRdPtr,w           ;
        btfsc   STATUS,Z                        ;
        bsf     vSPIMIntStatus,SPIMTxBufFull    ;
                                                ;
        bcf     vSPIMIntStatus,SPIMTxBufEmpty   ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;32

        #endif                                  ;
                                                ;


_SPIMINTGET    CODE
;***********************************************************************;
; Function: SPIMIntGet                                                  ;
;                                                                       ;
; PreCondition: SPIMIntRecv should have called.                         ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: Buffer                                                         ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPIMIntGet:                                     ;
                                                ;
        GLOBAL  SPIMIntGet                      ;
                                                ;
        #if SPIM_RX_BUF_LENGTH == 1             ;
                                                ;
        movf    vSPIMIntRxBuffer,W              ;
        bcf     vSPIMIntStatus,SPIMRxBufFull    ;
        bsf     vSPIMIntStatus,SPIMRxBufEmpty   ;7
                                                ;
        #else                                   ;
                                                ;
        BANKSEL PIE1                            ;
        bcf     PIE1,SSPIE                      ;
                                                ;
        call    _SPIMIntRdRxBuf                 ;Read the byte from buffer
                                                ;
        BANKSEL PIE1                            ;
        bsf     PIE1,SSPIE                      ;
                                                ;
        #endif                                  ;
                                                ;
        return                                  ;12
                                                ;
;***********************************************;47    



        #if SPIM_RX_BUF_LENGTH != 1             ;
                                                ;
;***********************************************************************;
; Function: _SPIMIntRdRxBuf                                             ;
;                                                                       ;
; PreCondition: SPIMIntRecvEn should have called.                       ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: Buffer                                                         ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPIMIntRdRxBuf:                                ;
                                                ;
        btfsc   vSPIMIntStatus,SPIMRxBufEmpty   ;
        return                                  ;
                                                ;
        BANKSEL _vSPIMIntDupFSR                 ;
        movf    FSR,w                           ;
        movwf   _vSPIMIntDupFSR                 ;
                                                ;
        BANKSEL _vSPIMIntRxBufRdPtr             ;
        movlw   vSPIMIntRxBuffer                ;load wreg with read pointer address
        addwf   _vSPIMIntRxBufRdPtr,w           ;
        movwf   FSR                             ;load fsr with read pointer address
        movf    INDF,w                          ;move wreg the content of read pointer address
                                                ;
        BANKSEL _vSPIMIntTempReg                ;
        movwf   _vSPIMIntTempReg                ;read data is saved in temflg
                                                ;
        movf    _vSPIMIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPIMIntRxBufRdPtr             ;
        incf    _vSPIMIntRxBufRdPtr,f           ;increment read pointer
        movlw   SPIM_RX_BUF_LENGTH              ;check for over flow of pointer
        xorwf   _vSPIMIntRxBufRdPtr,w           ;
        btfsc   STATUS,Z                        ;
        clrf    _vSPIMIntRxBufRdPtr             ;
                                                ;
        movf    _vSPIMIntRxBufRdPtr,w           ;Check is buffer empty
        xorwf   _vSPIMIntRxBufWrPtr,w           ;
        btfsc   STATUS,Z                        ;
        bsf     vSPIMIntStatus,SPIMRxBufEmpty   ;
                                                ;
        BANKSEL _vSPIMIntTempReg                ;
        movf    _vSPIMIntTempReg,w              ;Get the read data in 'W'
                                                ;
        bcf     vSPIMIntStatus,SPIMRxBufFull    ;
        bcf     vSPIMIntStatus,SPIMRxBufOverFlow;
                                                ;
        return                                  ;
;***********************************************;35

        #endif                                  ;
                                                ;


_SPIMINTGETCOUNT CODE                            
;***********************************************************************;
; Function: SPIMIntSetGetCount                                          ;
;                                                                       ;
; PreCondition: SPIMIntPut should have called.                          ;
;                                                                       ;
; Overview:                                                             ;
;       This stores the number of bytes to be received.                 ; 
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPIMIntSetGetCount                              ;
                                                ;
        GLOBAL  SPIMIntSetGetCount              ;
                                                ;
        BANKSEL _vSPIMRxDataCount               ;
        addwf   _vSPIMRxDataCount,f             ;Append Data Count
                                                ;
        btfss   vSPIMIntStatus,SPIMBusy         ;check is busy
        goto    SPINoBusy                       ;
                                                ;
        #if SPIM_TX_BUF_LENGTH == 1             ;
                                                ;
        clrf    _vSPIMStartRxCount              ;
        bsf     _vSPIMStartRxCount,0            ;
                                                ;
        #else                                   ;
                                                ;
        movf    _vSPIMTxDataCount,w             ;If busy
;        addlw    001h                          ;
        movwf   _vSPIMStartRxCount              ;Record the count to start reception
                                                ;
        #endif                                  ;
                                                ;
        return                                  ;
                                                ;
SPINoBusy                                       ;
        bsf     vSPIMIntStatus,SPIMBusy         ;If not busy set busy
                                                ;
        bsf     vSPIMIntStatus,SPIMSave         ;If not busy set busy
                                                ;
        BANKSEL SSPBUF                          ;enable reception
        movlw   000h                            ;
        movwf   SSPBUF                          ;
                                                ;
        bsf     STATUS,RP0                      ;
        bsf     PIE1,SSPIE                      ;enable SSP module interrupt
                                                ;
        return                                  ;
                                                ;
;***********************************************;17    



_SPIMINTISR    CODE
;***********************************************************************;
; Function: SPIMIntISR                                                  ;
;                                                                       ;
; PreCondition: Must be called from an interrupt handler                ;
;                                                                       ;
; Overview:                                                             ;
;       This is a Interrupt service routine for Serial Interrupt.       ;
;       It handles Reception and Transmission of data on interrupt.     ;
;       Call it from Interrupt service routine.                         ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 2 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPIMIntISR:                                     ;
        GLOBAL  SPIMIntISR                      ;
                                                ;
        BANKSEL PIR1                            ;
        btfss   PIR1,SSPIF                      ;check which interrupt has occurred sspif or bclif
        return                                  ;
                                                ;
        movf    SSPCON,w                        ;
        andlw   00ch                            ;
        btfss   STATUS,Z                        ;
        return                                  ;check is Master Mode
                                                ;
;-----------------------------------------------;
                                                ;
        movf    SSPBUF,w                        ;
                                                ;
        btfss   vSPIMIntStatus,SPIMSave         ;check is data to be stored
        goto    SPIMNoSave                      ;12
                                                ;If so
        btfsc   vSPIMIntStatus,SPIMRxBufFull    ;check is buffer empty
        goto    SPIMRxBufFullErr                ;
                                                ;
        #if SPIM_RX_BUF_LENGTH == 1             ;
                                                ;
        movwf   vSPIMIntRxBuffer                ;
        bsf     vSPIMIntStatus,SPIMRxBufFull    ;
        bcf     vSPIMIntStatus,SPIMRxBufEmpty   ;+1
                                                ;
        #else                                   ;
                                                ;
        call    _SPIMIntWrRxBuf                 ;If not empty store in buffer
                                                ;
        #endif                                  ;
                                                ;
        BANKSEL _vSPIMRxDataCount               ;
        decf    _vSPIMRxDataCount,f             ;decrement RxData Count
                                                ;
SPIMNoSave                                      ;
        btfsc   vSPIMIntStatus,SPIMTxBufEmpty   ;
        goto    SPIChkRx                        ;
                                                ;
        #if SPIM_TX_BUF_LENGTH == 1             ;
                                                ;
        movf    vSPIMIntTxBuffer,W              ;
        bcf     vSPIMIntStatus,SPIMTxBufFull    ;
        bsf     vSPIMIntStatus,SPIMTxBufEmpty   ;-2
                                                ;
        #else                                   ;
                                                ;
        call    _SPIMIntRdTxBuf                 ;
                                                ;
        BANKSEL _vSPIMTxDataCount               ;
        decf    _vSPIMTxDataCount,f             ;
                                                ;
        #endif                                  ;
                                                ;
        movf    _vSPIMRxDataCount,f             ;decrement RxData Count
        btfss   STATUS,Z                        ;check is '0'
        goto    SPITxRx                         ;
                                                ;
        decfsz  _vSPIMStartRxCount,f            ;decrement RxData Count
        goto    SPITxRx                         ;
        bsf     vSPIMIntStatus,SPIMSave         ;
                                                ;
SPITxRx                                         ;
        BANKSEL SSPBUF                          ;
        movwf   SSPBUF                          ;
                                                ;
        bcf     PIR1,SSPIF                      ;
        return                                  ;
                                                ;
SPIChkRx                                        ;
        bsf     vSPIMIntStatus,SPIMSave         ;
        BANKSEL _vSPIMRxDataCount               ;
        movlw   000h                            ;
        movf    _vSPIMRxDataCount,f             ;decrement RxData Count
        btfss   STATUS,Z                        ;check is '0'
        goto    SPITxRx                         ;
        bcf     vSPIMIntStatus,SPIMSave         ;
                                                ;
;-----------------------------------------------;
SPIMEnd                                         ;
        bcf     vSPIMIntStatus,SPIMBusy         ;
        bcf     PIR1,SSPIF                      ;
        bsf     STATUS,RP0                      ;
        bcf     PIE1,SSPIE                      ;
        return                                  ;
                                                ;
SPIMRxBufFullErr                                ;
        bsf     vSPIMIntStatus,SPIMRxBufOverFlow;
        return                                  ;
                                                ;
;***********************************************;39 + 32 + 35



        #if SPIM_TX_BUF_LENGTH != 1             ;
                                                ;
;***********************************************************************;
; Function: _SPIMIntRdTxBuf                                             ;
;                                                                       ;
; PreCondition: SPIMIntRecvEn should have called.                       ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: Buffer                                                         ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPIMIntRdTxBuf:                                ;
                                                ;
        btfsc   vSPIMIntStatus,SPIMTxBufEmpty   ;
        return                                  ;
                                                ;
        BANKSEL _vSPIMIntDupFSR                 ;
        movf    FSR,w                           ;
        movwf   _vSPIMIntDupFSR                 ;
                                                ;
        BANKSEL _vSPIMIntTxBufRdPtr             ;
        movlw   vSPIMIntTxBuffer                ;load wreg with read pointer address
        addwf   _vSPIMIntTxBufRdPtr,w           ;
        movwf   FSR                             ;load fsr with read pointer address
        movf    INDF,w                          ;move wreg the content of read pointer address
                                                ;
        BANKSEL _vSPIMIntTempReg                ;
        movwf   _vSPIMIntTempReg                ;read data is saved in temflg
                                                ;
        movf    _vSPIMIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPIMIntTxBufRdPtr             ;
        incf    _vSPIMIntTxBufRdPtr,f           ;increment read pointer
        movlw   SPIM_TX_BUF_LENGTH              ;check for over flow of pointer
        xorwf   _vSPIMIntTxBufRdPtr,w           ;
        btfsc   STATUS,Z                        ;
        clrf    _vSPIMIntTxBufRdPtr             ;
                                                ;
        movf    _vSPIMIntTxBufRdPtr,w           ;Check is buffer empty
        xorwf   _vSPIMIntTxBufWrPtr,w           ;
        btfsc   STATUS,Z                        ;
        bsf     vSPIMIntStatus,SPIMTxBufEmpty   ;
                                                ;
        BANKSEL _vSPIMIntTempReg                ;
        movf    _vSPIMIntTempReg,w              ;Get the read data in 'W'
                                                ;
        bcf     vSPIMIntStatus,SPIMTxBufFull    ;
                                                ;
        return                                  ;
;***********************************************;

        #endif                                  ;
                                                ;


        #if SPIM_RX_BUF_LENGTH != 1             ;
                                                ;
;***********************************************************************;
; Function: _SPIMIntWrRxBuf                                             ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This writes data into buffer.                                   ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: Buffer                                                        ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPIMIntWrRxBuf:                                ;
        btfsc   vSPIMIntStatus,SPIMRxBufFull    ;
        return                                  ;
                                                ;
                                                ;
        BANKSEL _vSPIMIntTempReg                ;
        movwf   _vSPIMIntTempReg                ;save the wreg content (data) in temflg
                                                ;
        movf    FSR,w                           ;
        movwf   _vSPIMIntDupFSR                 ;
                                                ;
        BANKSEL _vSPIMIntRxBufWrPtr             ;
        movlw   vSPIMIntRxBuffer                ;load wreg with write pointer address
        addwf   _vSPIMIntRxBufWrPtr,w           ;
                                                ;
        movwf   FSR                             ;increment write pointer
        BANKSEL _vSPIMIntTempReg                ;
        movf    _vSPIMIntTempReg,w              ;read data from SSPBUF
        movwf   INDF                            ;move wreg content to write pointer pointing location
                                                ;
        movf    _vSPIMIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPIMIntRxBufWrPtr             ;
        incf    _vSPIMIntRxBufWrPtr,f           ;increment write pointer
        movlw   SPIM_RX_BUF_LENGTH              ;check for overflow of pointer
        xorwf   _vSPIMIntRxBufWrPtr,w           ;campare it with write pointer
        btfsc   STATUS,Z                        ;
        clrf    _vSPIMIntRxBufWrPtr             ;
                                                ;
        movf    _vSPIMIntRxBufWrPtr,w           ;Check is buffer full
        xorwf   _vSPIMIntRxBufRdPtr,w           ;
        btfsc   STATUS,Z                        ;
        bsf     vSPIMIntStatus,SPIMRxBufFull    ;
                                                ;
        bcf     vSPIMIntStatus,SPIMRxBufEmpty   ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;

        #endif                                  ;
                                                ;


_SPIMINTDISRXBUF    CODE
;***********************************************************************;
; Function: SPIMIntDiscardRxBuf                                         ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This flushes the buffer.                                        ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: Buffer                                                        ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPIMIntDiscardRxBuf:                            ;
        GLOBAL  SPIMIntDiscardRxBuf             ;
                                                ;
        BANKSEL _vSPIMIntRxBufRdPtr             ;
        clrf    _vSPIMIntRxBufRdPtr             ;
        clrf    _vSPIMIntRxBufWrPtr             ;
        bsf     vSPIMIntStatus,SPIMRxBufEmpty   ;
        bcf     vSPIMIntStatus,SPIMRxBufFull    ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;10




;***********************************************;
;       END
;***********************************************;

