;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI Master       ;
;*  for PIC16/PIC18 family                                                      ;
;*                                                                              ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            SPIMPol.asm                                     ;        
;* Dependencies:        P16xxx.inc                                      ;
;*                      P18xxx.inc                                      ;
;*                      SPIMPol.Inc                                     ;
;*                      SPIMPol.Def                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Feb 28, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************;***********************;
                                                ;
#define BSSP_MODULE                             ;Module definition to generate error message for
#define SSP_MODULE                              ;Processor which do not have this module.
#define MSSP_MODULE                             ;
#define _GEN_MODULE_ERROR                       ;
                                                ;
#define _ADD_PROC_INC_FILE                      ;
                                                ;
        #include "P18xxx.inc"                   ;
        #include "P16xxx.inc"                   ;
                                                ;
#define SPIMPol_Source                          ;
                                                ;
        #include "SPIMPol.Inc"                  ;
                                                ;
;***********************************************;


;***********************************************;
                                                ;
                                                ;
        #ifdef  _PIC18xxx                       ;
    #include "18SPIMP.asm"                      ;
        #endif                                  ;
                                                ;
        #ifdef  _PIC16xxx                       ;
    #include "16SPIMP.asm"                      ;
        #endif                                  ;
                                                ;
                                                ;
;***********************************************;

;***********************************************;
        END                                     
;***********************************************;
