#include "patch.h"

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/kthread.h>
#include <linux/stop_machine.h>
#include <linux/cpu.h>

#define OP_JMP_FAR      0xEA

static u16 read_cs(void) {
    u16 cs;
    asm("movw %%cs, %0" : "=r"(cs));
    return cs;
}

static int __apply_patches(void * pat) {
    struct runtime_patch * patches = (struct runtime_patch *)pat;
    u16 cs = read_cs();

    struct runtime_patch * p = patches;
    while(p->old) {
        *((u8*)p->old) = OP_JMP_FAR;
        *((u32*)(p->old+1)) = (u32)p->replacement;
        *((u16*)(p->old+5)) = cs;
        p++;
    }

    return 0;
}

int apply_runtime_patches(struct runtime_patch * patches) {
    return stop_machine_run(__apply_patches, patches, NR_CPUS);
}
