#ifndef BYTEQ_H
#define BYTEQ_H

typedef struct bytequeue_str {
    Int size;
    Int head;
    Int tail;
    unsigned char *data;
} Bytequeue;

#define BYTEQUEUE_LENGTH(b)  ( (b)->tail - (b)->head >= 0 ?         \
			       (b)->tail - (b)->head      :         \
			       (b)->tail - (b)->head + (b)->size )

#define BYTEQUEUE_SPACE(b)   ( (b)->size - BYTEQUEUE_LENGTH(b) - 1 )
#define BYTEQUEUE_EMPTY(b)   ( (b)->head - (b)->tail == 0 )
#define BYTEQUEUE_FULL(b)    ( BYTEQUEUE_SPACE(b) == 0 )

#include "byteq.pro"

#endif
