/**
 ** confexec.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


/* Configure an executable */

#include CONFIG

#include "stringlb.h"

#include "util.h"

#include "iob.h"
#include "cmdlineo.h"
#include "confexec.h"
#include "table.h"
#include "filelib.h"

#define CONFIGURE_MAXLEN 1000

#ifdef UNIX
    #include <sys/types.h>
    #include <sys/stat.h>
#endif
 
static char *prefix1= CONFIGURE_PREFIX1;
static char *prefix2= CONFIGURE_PREFIX2;

Int 	    check_file_string (char *str, FILE *f);
void 	    fgetstr	      (char *buf, Int maxlen, FILE *in);
void 	    configure__executable (char *executable_name, void *in, void *out, Table *change);


void configure_exec_non_interactive(char *executable_name, Table *changes)
{
    configure__executable(executable_name, NULL, NULL, changes);
}
					  
void configure_executable(char *executable_name, void *in, void *out)
{
    configure__executable(executable_name, in, out, NULL);
}

void configure__executable(char *executable_name, void *in, void *out, Table *changes)
{
    FILE *exec;
    char *str, *pad, *desc;
    
    str= malloc(CONFIGURE_MAXLEN);
    pad= malloc(CONFIGURE_MAXLEN);
    desc= malloc(CONFIGURE_MAXLEN);
    if (!str || !pad || !desc) {
	printf("out of memory in configure\n");
	exit(1);
    }

    {
	char *name1= filenm_remove_suffix(executable_name);
	char *backup_name= string_append(name1, ".bak");

#ifdef UNIX        
	if (rename(executable_name, backup_name)) {
	    exec= fopen(executable_name, READ_BINARY);
	    if (exec) {
		printf("You do not have write permission for the directory\n");
		printf("in which the executable resides\n");
	    }
	    else {
		printf("Could not find executable name %s\n",
		       executable_name);
		if (in || out) {
		    printf("You must be in the directory where the executable resides\n");
		    printf("in order to configure it\n");
		}
	    }
	    exit(-1);
	}
#endif        
	printf("Backing up %s to %s\n", executable_name, backup_name);
#ifdef UNIX    
	if (filenm_copy(executable_name, backup_name)) {
	    printf("Could not create new executable\n");
	    exit(-1);
	}
#else
	if (filenm_copy(backup_name, executable_name)) {
	    printf("Could not create new executable\n");
	    exit(-1);
	}
#endif
	printf("Done\n");
    	free(name1);
	free(backup_name);
    }

    exec= fopen(executable_name, READ_WRITE_BINARY);
    if (!exec) {
	printf("Could not open %s for input\n", executable_name);
	exit(1);
    }
    rewind(exec);

    while (!feof(exec)) {
	if (check_file_string(prefix1, exec) &&
	    check_file_string(prefix2, exec)) {
	    char *prompt=0;
	    long pos;
	    Int  len;

	    /* Found a configuration string */
	    pos= ftell(exec);
	    /*printf("pos before read %ld %ld\n", ftell(exec), pos);*/
	    fgetstr(str, CONFIGURE_MAXLEN, exec);
	    fgetstr(pad, CONFIGURE_MAXLEN, exec);
	    fgetstr(desc, CONFIGURE_MAXLEN, exec);
	    /*printf("pos after read %ld\n", ftell(exec));*/

	    len= strlen(str) + strlen(pad);
	    /*printf("len= %d (+ 2 nulls)\n", len);*/

	    if (changes) {
		if (table_get(changes, &str)) {
		    printf("Changed %s to ", str);
		    strcpy(str, *(char**)table_get(changes, &str));
		    printf("%s\n", str);
		}
	    }
	    else {
		prompt= string_append(desc, ":  ");
		cmd_get_line(prompt, in, out, str);
		printf("\n");
	    }
		
	    len -= strlen(str);
	    if (len < 0) {
		printf("String too long.  Update aborted\n");
		exit(1);
	    }

	    fseek(exec, pos, 0);
	    /*printf("beginning pos %ld\n", ftell(exec));*/
	    fputs(str, exec);
	    putc(0, exec);
	    while (len--) putc(' ', exec);
	    putc(0, exec);
	    pos= ftell(exec);
	    fseek(exec, pos, 0);
	    /*printf("pos now %ld\n", ftell(exec));*/
	    free(prompt);
	}
    }
    printf("Finished configuring\n");
    fclose(exec);
    free(desc);
    free(pad);
    free(str);
}






Int check_file_string(char *str, FILE *f)
{
    Int c, matched= 0;
    while (1) {
	c= getc(f);
	if (c == *str) {
	    str++;
	    matched= 1;
	    if (!*str) return 1;
	}
	else {
	    if (matched) ungetc(c, f);
	    return 0;
	}
    }
}

void fgetstr(char *buf, Int maxlen, FILE *in)
{
    while (--maxlen) {
	if (!(*buf++= (char)getc(in))) return;
    }
    *buf= 0;
}

	   
	
