/**
 ** runtype.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  runtype.c
 **
 ** v1.0  Sun Jun  2 14:01:06 1991  Randy Sargent.  created
 ** v1.1  Mon Aug 12 13:35:20 1991  Randy Sargent.  added services
 **/

#include CONFIG
#include "util.h"

#include "runtype.h"
#include "stringlb.h"

char *runtype_types[]= {
    "illegal",
    "list",
    "symbol",
    "Int",
    "float",
    "bool",
    "fixnum",
    "func",
    "prim",
    "macro",
    "spform",
    "env",
    "code",
    "thunk",
    "vector",
    "intvector",
    "floatvector",
    "boolvector",
    "fixnumvector",
    "proc",
    "sequence",
    "wrapper",
    "any",
    "max",
    "nothing here!",
    "nothing here!",
    "nothing here!",
    "nothing here!"
  };
    
Generic_object Illegal_storage= {runtype_illegal};
void *Illegal= &Illegal_storage;

Service_func services[service_max][runtype_max];
void display_illegal(void *obj);

void runtype_leaf_gc(void *o)
{
}

Int runtype_tab= 0;

/* 0 if successful */
Int runtype_init_module(void)
{
    static Int done= 0;
    if (!done) {
	done= 1;
	runtype_register_service(runtype_illegal,
				 service_display, (Service_func) display_illegal);
	runtype_register_service(runtype_illegal,
				 service_print, (Service_func) display_illegal);
	if (strcmp(runtype_types[runtype_illegal], "illegal") ||
	    strcmp(runtype_types[runtype_max], "max")) {
	    die(("runtype_types must be updated in runtype.c"));
	}
    }
    return 0;
}

Int runtype_gc_debug= 0;

void runtype_gc(void *obj)
{
    Int runtype;

    
    if (!obj) {
	if (runtype_gc_debug) {proc_printf("%*sNull\n", runtype_tab, "");}
	return;
    }

    runtype= RUNTYPE(obj);

    /* mark, check mark here */
    if (runtype & 128) {
	if (runtype_gc_debug) {
	    proc_printf("%*s%lx %s(%d): already marked\n",
		   runtype_tab, "",
		   (long) obj,
		   runtype_types[runtype & ~128], runtype & ~128);
	}
	return;
    }

    if (runtype_gc_debug) {
	proc_printf("%*s%lx %s(%d)\n",
	       runtype_tab, "",
	       (long) obj,
	       runtype_types[runtype], runtype);
	runtype_tab += 2;
    }

    RUNTYPE(obj) = runtype | 128;
	
    if (services[service_gc][runtype]) {
	(*services[service_gc][runtype])(obj);
    }
    else {
	die(("No gc service for %lx %s(%d)\n",
	     (long) obj, runtype_types[runtype], runtype));
    }
    
    if (runtype_gc_debug) runtype_tab -= 2;
}
    
void display(void *obj)
{
    Generic_object *g= obj;

    if (services[service_display][g->runtype]) {
	(*services[service_display][g->runtype])(obj);
    }
    else {
	die(("No display service for %lx %s(%d)\n",
	     (long)g,
	     runtype_types[g->runtype], g->runtype));
    }
}

void display_illegal(void *obj)
{
    UNUSED(obj);
    proc_printf("[Illegal] ");
}

void print(void *obj)
{
    Generic_object *g= obj;

    if (!obj) {
	proc_printf("[NULL]");
	return;
    }
    if (services[service_print][g->runtype]) {
	(*services[service_print][g->runtype])(obj);
    }
    else {
	die(("No print service for %lx %s(%d)\n",
	     (long)g,
	     runtype_types[g->runtype], g->runtype));
    }
}

char *sprint(void *obj)
{
    Generic_object *g= obj;

    if (!obj) {
	return string_copy("[NULL]");
    }
    if (services[service_sprint][g->runtype]) {
	return (*(Service_func_string)
		services[service_sprint][g->runtype])(obj);
    }
    else {
	die(("No print service for %lx %s(%d)\n",
	     (long)g,
	     runtype_types[g->runtype], g->runtype));
	return string_copy("");
    }
}

void runtype_register_service(Runtype type, Service service, Service_func func)
{
    services[service][type]= (Service_func) func;
}


    
