/* hello-world.c:  Simple test program
 *
 * (c) 1996, 1997 D. Jeff Dionne
 * This is free software, under the GNU public license v2
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "../testlib.h"

#define MainForm 1000
#define EntryField 3002
#define RedAlert 1000

#define BREAKPOINT() {asm volatile ("trap #1");}

char msg[] = "This is a message!";

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
  short err;
  EventType e;
  UInt TestLibRefNum;

  if (!cmd) {

    err = SysLibFind("Test Library", &TestLibRefNum);
    if (err) {
      err = SysLibLoad('libr', 'Test', &TestLibRefNum);
      ErrFatalDisplayIf(err, "Cannot load Test Library!");
    }
    err = TestLibOpen(TestLibRefNum);

#ifdef DEBUG
    set_debug_traps();
    BREAKPOINT();
#endif
    FrmGotoForm(MainForm);

    while(1) {
      EvtGetEvent(&e, 100);
      if (SysHandleEvent(&e)) continue;
      if (MenuHandleEvent((void *)0, &e, &err)) continue;

      switch (e.eType) {

      case frmLoadEvent:
        FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
        break;

      case frmOpenEvent:
        FrmDrawForm(FrmGetActiveForm());
        break;

      case menuEvent:
        err = TestLibTest(TestLibRefNum, 6);

	printf("TestLibTest(6)=%d\n",err);
        break;

      case appStopEvent:
	TestLibClose(TestLibRefNum, &err);
        SysLibRemove(TestLibRefNum);
        return 0;

      default:
        FrmHandleEvent(FrmGetActiveForm(), &e);
      }
    }
  }
}
