/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyInteger
extends PyObject {
    public static PyClass __class__;
    private int value;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$io$Serializable;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;

    public int getValue() {
        return this.value;
    }

    protected String safeRepr() {
        return "'int' object";
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean __nonzero__() {
        return this.value != 0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Integer.TYPE || clazz == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = PyInteger.class$("java.lang.Number"))) || clazz == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PyInteger.class$("java.lang.Object"))) || clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = PyInteger.class$("java.lang.Integer"))) || clazz == (class$Ljava$io$Serializable != null ? class$Ljava$io$Serializable : (class$Ljava$io$Serializable = PyInteger.class$("java.io.Serializable")))) {
            return new Integer(this.value);
        }
        if (clazz == Boolean.TYPE || clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = PyInteger.class$("java.lang.Boolean")))) {
            return new Boolean(this.value != 0);
        }
        if (clazz == Byte.TYPE || clazz == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = PyInteger.class$("java.lang.Byte")))) {
            return new Byte((byte)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = PyInteger.class$("java.lang.Short")))) {
            return new Short((short)this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = PyInteger.class$("java.lang.Long")))) {
            return new Long(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = PyInteger.class$("java.lang.Float")))) {
            return new Float(this.value);
        }
        if (clazz == Double.TYPE || clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = PyInteger.class$("java.lang.Double")))) {
            return new Double(this.value);
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        int n = ((PyInteger)pyObject).value;
        return this.value < n ? -1 : (this.value > n ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return pyObject;
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyInteger;
    }

    private static final int coerce(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).value;
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = this.value;
        int n2 = PyInteger.coerce(pyObject);
        int n3 = n2;
        int n4 = n + n3;
        if ((n4 ^ n) < 0 && (n4 ^ n3) < 0) {
            throw Py.OverflowError("integer addition: " + this + " + " + pyObject);
        }
        return Py.newInteger(n4);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    private static PyInteger _sub(int n, int n2) {
        int n3 = n - n2;
        if ((n3 ^ n) < 0 && (n3 ^ ~n2) < 0) {
            throw Py.OverflowError("integer subtraction: " + n + " - " + n2);
        }
        return Py.newInteger(n3);
    }

    public PyObject __sub__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return PyInteger._sub(this.value, PyInteger.coerce(pyObject));
    }

    public PyObject __rsub__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(pyObject), this.value);
    }

    public PyObject __mul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(this.value);
        }
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        double d = this.value;
        if ((d *= (double)n) > 2.147483647E9 || d < -2.147483648E9) {
            throw Py.OverflowError("integer multiplication: " + this + " * " + pyObject);
        }
        return Py.newInteger((int)d);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    private static int divide(int n, int n2) {
        if (n2 == 0) {
            throw Py.ZeroDivisionError("integer division or modulo");
        }
        if (n2 < 0) {
            if (n > 0) {
                return (n - n2 - 1) / n2;
            }
        } else if (n < 0) {
            return (n - n2 + 1) / n2;
        }
        return n / n2;
    }

    public PyObject __div__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.value, PyInteger.coerce(pyObject)));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(pyObject), this.value));
    }

    private static int modulo(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    public PyObject __mod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        return Py.newInteger(PyInteger.modulo(this.value, n, PyInteger.divide(this.value, n)));
    }

    public PyObject __rmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        return Py.newInteger(PyInteger.modulo(n, this.value, PyInteger.divide(n, this.value)));
    }

    public PyObject __divmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = PyInteger.divide(this.value, n);
        return new PyTuple(new PyObject[]{new PyInteger(n2), new PyInteger(PyInteger.modulo(this.value, n, n2))});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyInteger.canCoerce(pyObject2)) {
            return null;
        }
        return PyInteger._pow(this.value, PyInteger.coerce(pyObject), pyObject2);
    }

    public PyObject __rpow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyInteger.canCoerce(pyObject2)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(pyObject), this.value, pyObject2);
    }

    /*
     * Unable to fully structure code
     */
    private static PyInteger _pow(int var0, int var1_1, PyObject var2_2) {
        var3_3 = 0;
        var4_4 = var0;
        var6_5 = false;
        if (var4_4 < 0L) {
            var4_4 = -var4_4;
            var6_5 = (var1_1 & 1) != 0;
        }
        var7_6 = 1L;
        if (var1_1 < 0) {
            if (var0 != 0) {
                throw Py.ValueError("cannot raise integer to a negative power");
            }
            throw Py.ZeroDivisionError("cannot raise 0 to a negative power");
        }
        if (var2_2 == null || (var3_3 = PyInteger.coerce(var2_2)) != 0) ** GOTO lbl26
        throw Py.ValueError("pow(x, y, z) with z==0");
lbl-1000:
        // 1 sources

        {
            if ((var1_1 & 1) != 0) {
                var7_6 *= var4_4;
                if (var3_3 != 0) {
                    var7_6 %= (long)var3_3;
                }
                if (var7_6 > 0x7FFFFFFFL) {
                    throw Py.OverflowError("integer pow()");
                }
            }
            if ((var1_1 >>= 1) == 0) break;
            var4_4 *= var4_4;
            if (var3_3 != 0) {
                var4_4 %= (long)var3_3;
            }
            if (var4_4 <= 0x7FFFFFFFL) continue;
            throw Py.OverflowError("integer pow()");
lbl26:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl27:
        // 2 sources

        var9_7 = (int)var7_6;
        if (var6_5) {
            var9_7 = -var9_7;
        }
        if (var3_3 != 0) {
            var9_7 = PyInteger.modulo(var9_7, var3_3, PyInteger.divide(var9_7, var3_3));
        }
        return Py.newInteger(var9_7);
    }

    public PyObject __lshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            return null;
        }
        int n = ((PyInteger)pyObject).value;
        if (n > 31) {
            return new PyInteger(0);
        }
        return Py.newInteger(this.value << n);
    }

    public PyObject __rshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            return null;
        }
        int n = ((PyInteger)pyObject).value;
        return Py.newInteger(this.value >>> n);
    }

    public PyObject __and__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            return null;
        }
        int n = ((PyInteger)pyObject).value;
        return Py.newInteger(this.value & n);
    }

    public PyObject __xor__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            return null;
        }
        int n = ((PyInteger)pyObject).value;
        return Py.newInteger(this.value ^ n);
    }

    public PyObject __or__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            return null;
        }
        int n = ((PyInteger)pyObject).value;
        return Py.newInteger(this.value | n);
    }

    public PyObject __neg__() {
        int n = -this.value;
        if (this.value < 0 && n < 0) {
            throw Py.OverflowError("integer negation");
        }
        return Py.newInteger(n);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        if (this.value >= 0) {
            return this;
        }
        return this.__neg__();
    }

    public PyObject __invert__() {
        return Py.newInteger(~this.value);
    }

    public PyInteger __int__() {
        return this;
    }

    public PyLong __long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return new PyFloat((double)this.value);
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    public PyString __oct__() {
        if (this.value < 0) {
            return new PyString("0" + Long.toString(0x100000000L + (long)this.value, 8));
        }
        if (this.value > 0) {
            return new PyString("0" + Integer.toString(this.value, 8));
        }
        return new PyString("0");
    }

    public PyString __hex__() {
        if (this.value < 0) {
            return new PyString("0x" + Long.toString(0x100000000L + (long)this.value, 16));
        }
        return new PyString("0x" + Integer.toString(this.value, 16));
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyInteger(int n) {
        this.value = n;
    }
}

