/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.StringFormatter;
import org.python.core.StringFuncs;
import org.python.core.__builtin__;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.ucnhashAPI;

public class PyString
extends PySequence
implements ClassDictInit {
    private static char[] hexdigit = "0123456789ABCDEF".toCharArray();
    private static ucnhashAPI pucnHash = null;
    private String string;
    private transient int cached_hashcode = 0;
    private transient boolean interned = false;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$io$Serializable;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("__str__", (PyObject)new StringFuncs("__str__", 1, 0));
        pyObject.__setitem__("__len__", (PyObject)new StringFuncs("__len__", 2, 0));
        pyObject.__setitem__("__repr__", (PyObject)new StringFuncs("__repr__", 3, 0));
        pyObject.__setitem__("islower", (PyObject)new StringFuncs("islower", 4, 0));
        pyObject.__setitem__("isalpha", (PyObject)new StringFuncs("isalpha", 5, 0));
        pyObject.__setitem__("isdigit", (PyObject)new StringFuncs("isdigit", 6, 0));
        pyObject.__setitem__("isupper", (PyObject)new StringFuncs("isupper", 7, 0));
        pyObject.__setitem__("isspace", (PyObject)new StringFuncs("isspace", 8, 0));
        pyObject.__setitem__("istitle", (PyObject)new StringFuncs("istitle", 9, 0));
        pyObject.__setitem__("isnumeric", (PyObject)new StringFuncs("isnumeric", 10, 0));
        pyObject.__setitem__("__cmp__", (PyObject)new StringFuncs("__cmp__", 11, 1));
        pyObject.__setitem__("__add__", (PyObject)new StringFuncs("__add__", 12, 1));
        pyObject.__setitem__("__mod__", (PyObject)new StringFuncs("__mod__", 13, 1));
        pyObject.__setitem__("lower", (PyObject)new StringFuncs("lower", 101, 0));
        pyObject.__setitem__("upper", (PyObject)new StringFuncs("upper", 102, 0));
        pyObject.__setitem__("swapcase", (PyObject)new StringFuncs("swapcase", 103, 0));
        pyObject.__setitem__("strip", (PyObject)new StringFuncs("strip", 104, 0));
        pyObject.__setitem__("lstrip", (PyObject)new StringFuncs("lstrip", 105, 0));
        pyObject.__setitem__("rstrip", (PyObject)new StringFuncs("rstrip", 106, 0));
        pyObject.__setitem__("split", (PyObject)new StringFuncs("split", 107, 0, 2));
        pyObject.__setitem__("index", (PyObject)new StringFuncs("index", 108, 1, 3));
        pyObject.__setitem__("rindex", (PyObject)new StringFuncs("rindex", 109, 1, 3));
        pyObject.__setitem__("count", (PyObject)new StringFuncs("count", 110, 1, 3));
        pyObject.__setitem__("find", (PyObject)new StringFuncs("find", 111, 1, 3));
        pyObject.__setitem__("rfind", (PyObject)new StringFuncs("rfind", 112, 1, 3));
        pyObject.__setitem__("capitalize", (PyObject)new StringFuncs("capitalize", 113, 0));
        pyObject.__setitem__("endswith", (PyObject)new StringFuncs("endswith", 114, 1, 3));
        pyObject.__setitem__("join", (PyObject)new StringFuncs("join", 115, 1));
        pyObject.__setitem__("replace", (PyObject)new StringFuncs("replace", 116, 2, 3));
        pyObject.__setitem__("startswith", (PyObject)new StringFuncs("startswith", 117, 1, 3));
        pyObject.__setitem__("translate", (PyObject)new StringFuncs("translate", 118, 1, 2));
        pyObject.__setitem__("toString", null);
        pyObject.__setitem__("internedString", null);
        pyObject.__setitem__("hashCode", null);
        pyObject.__setitem__("equals", null);
        pyObject.__setitem__("__int__", null);
        pyObject.__setitem__("__long__", null);
        pyObject.__setitem__("__float__", null);
        pyObject.__setitem__("__tojava__", null);
        pyObject.__setitem__("atof", null);
        pyObject.__setitem__("atoi", null);
        pyObject.__setitem__("atol", null);
        pyObject.__setitem__("encode_UnicodeEscape", null);
        pyObject.__setitem__("decode_UnicodeEscape", null);
    }

    protected String safeRepr() {
        return "'string' object";
    }

    public PyString __str__() {
        return this;
    }

    public int __len__() {
        return this.string.length();
    }

    public String toString() {
        return this.string;
    }

    public String internedString() {
        if (this.interned) {
            return this.string;
        }
        this.string = this.string.intern();
        this.interned = true;
        return this.string;
    }

    public PyString __repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.string, true));
    }

    public static String encode_UnicodeEscape(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char c = '\u0000';
        boolean bl2 = false;
        if (bl) {
            c = string.indexOf(39) >= 0 && string.indexOf(34) == -1 ? (char)'\"' : '\'';
            stringBuffer.append(c);
        }
        int n2 = 0;
        while (n-- > 0) {
            char c2 = string.charAt(n2++);
            if (bl && (c2 == c || c2 == '\\')) {
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                continue;
            }
            if (c2 >= '\u0100') {
                if (bl && !bl2) {
                    stringBuffer.insert(0, 'u');
                    bl2 = true;
                }
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(hexdigit[c2 >> 12 & 0xF]);
                stringBuffer.append(hexdigit[c2 >> 8 & 0xF]);
                stringBuffer.append(hexdigit[c2 >> 4 & 0xF]);
                stringBuffer.append(hexdigit[c2 & 0xF]);
                continue;
            }
            if (bl && c2 == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (bl && c2 == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (bl && c2 == '\b') {
                stringBuffer.append("\\b");
                continue;
            }
            if (bl && c2 == '\f') {
                stringBuffer.append("\\f");
                continue;
            }
            if (bl && c2 == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c2 < ' ' || c2 >= '\u0080') {
                stringBuffer.append('\\');
                stringBuffer.append(hexdigit[c2 >> 6 & 7]);
                stringBuffer.append(hexdigit[c2 >> 3 & 7]);
                stringBuffer.append(hexdigit[c2 & 7]);
                continue;
            }
            stringBuffer.append(c2);
        }
        if (bl) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String decode_UnicodeEscape(String string, int n, int n2, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c != '\\') {
                stringBuffer.append(c);
                ++n3;
                continue;
            }
            int n4 = ++n3;
            ++n3;
            c = string.charAt(n4);
            switch (c) {
                case '\n': {
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 'v': {
                    stringBuffer.append('\u000b');
                    break;
                }
                case 'a': {
                    stringBuffer.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n5 = Character.digit(c, 8);
                    int n6 = 0;
                    while (n6 < 2 && n3 < n2) {
                        c = string.charAt(n3);
                        if (c < '0' || c > '7') break;
                        n5 = (n5 << 3) + Character.digit(c, 8);
                        ++n6;
                        ++n3;
                    }
                    stringBuffer.append((char)n5);
                    break;
                }
                case 'x': {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < 2 && n3 < n2) {
                        c = string.charAt(n3 + n6);
                        int n7 = Character.digit(c, 16);
                        if (n7 == -1) {
                            codecs.decoding_error("unicode escape", stringBuffer, string2, "truncated \\xXX");
                            ++n6;
                            break;
                        }
                        n5 = (n5 << 4 & 0xFFFFFFF0) + n7;
                        ++n6;
                    }
                    n3 += n6;
                    stringBuffer.append((char)n5);
                    break;
                }
                case 'u': {
                    if (!bl) {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        break;
                    }
                    if (n3 + 4 > n2) {
                        codecs.decoding_error("unicode escape", stringBuffer, string2, "truncated \\uXXXX");
                        break;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < 4) {
                        c = string.charAt(n3 + n6);
                        int n8 = Character.digit(c, 16);
                        if (n8 == -1) {
                            codecs.decoding_error("unicode escape", stringBuffer, string2, "truncated \\uXXXX");
                            break;
                        }
                        n5 = (n5 << 4 & 0xFFFFFFF0) + n8;
                        ++n6;
                    }
                    n3 += n6;
                    stringBuffer.append((char)n5);
                    break;
                }
                case 'N': {
                    if (!bl) {
                        stringBuffer.append('\\');
                        stringBuffer.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject pyObject = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(pyObject = pyObject.__call__()).__tojava__(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : PyString.class$("java.lang.Object"));
                        if (pucnHash.getCchMax() < 0) {
                            codecs.decoding_error("unicode escape", stringBuffer, string2, "Unicode names not loaded");
                        }
                    }
                    if (string.charAt(n3) == '{') {
                        int n9;
                        int n10 = n9 = n3 + 1;
                        int n11 = pucnHash.getCchMax();
                        while (n10 < n2 && string.charAt(n10) != '}' && n10 - n9 <= n11) {
                            ++n10;
                        }
                        if (n10 != n2 && string.charAt(n10) == '}') {
                            int n12 = pucnHash.getValue(string, n9, n10);
                            if (n12 < 0) {
                                codecs.decoding_error("unicode escape", stringBuffer, string2, "Invalid Unicode Character Name");
                                stringBuffer.append('\\');
                                stringBuffer.append(string.charAt(n3 - 1));
                                break;
                            }
                            if (n12 < 65536) {
                                stringBuffer.append((char)n12);
                            } else {
                                stringBuffer.append((char)(55296 + ((n12 -= 65536) >> 10)));
                                stringBuffer.append((char)(56320 + (n12 & 0xFFFF03FF)));
                            }
                            n3 = n10 + 1;
                            break;
                        }
                        codecs.decoding_error("unicode escape", stringBuffer, string2, "Unicode name missing closing brace");
                        stringBuffer.append('\\');
                        stringBuffer.append(string.charAt(n3 - 1));
                        break;
                    }
                    codecs.decoding_error("unicode escape", stringBuffer, string2, "Missing opening brace for Unicode Character Name escape");
                }
                default: {
                    stringBuffer.append('\\');
                    stringBuffer.append(string.charAt(n3 - 1));
                    break;
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PyString)) {
            return false;
        }
        PyString pyString = (PyString)object;
        if (this.interned && pyString.interned) {
            return this.string == pyString.string;
        }
        return this.string.equals(pyString.string);
    }

    public int __cmp__(PyObject pyObject) {
        if (!(pyObject instanceof PyString)) {
            return -2;
        }
        int n = this.string.compareTo(((PyString)pyObject).string);
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public PyObject __eq__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.equals(string) ? Py.One : Py.Zero;
    }

    public PyObject __ne__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.equals(string) ? Py.Zero : Py.One;
    }

    public PyObject __lt__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) < 0 ? Py.One : Py.Zero;
    }

    public PyObject __le__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) <= 0 ? Py.One : Py.Zero;
    }

    public PyObject __gt__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) > 0 ? Py.One : Py.Zero;
    }

    public PyObject __ge__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) >= 0 ? Py.One : Py.Zero;
    }

    private static String coerce(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            return pyObject.toString();
        }
        return null;
    }

    public int hashCode() {
        if (this.cached_hashcode == 0) {
            this.cached_hashcode = this.string.hashCode();
        }
        return this.cached_hashcode;
    }

    private byte[] getBytes() {
        byte[] byArray = new byte[this.string.length()];
        this.string.getBytes(0, this.string.length(), byArray, 0);
        return byArray;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = PyString.class$("java.lang.String"))) || clazz == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PyString.class$("java.lang.Object"))) || clazz == (class$Ljava$io$Serializable != null ? class$Ljava$io$Serializable : (class$Ljava$io$Serializable = PyString.class$("java.io.Serializable")))) {
            return this.string;
        }
        if (clazz == Character.TYPE && this.string.length() == 1) {
            return new Character(this.string.charAt(0));
        }
        if (clazz.isArray()) {
            if (clazz.getComponentType() == Byte.TYPE) {
                return this.getBytes();
            }
            if (clazz.getComponentType() == Character.TYPE) {
                return this.string.toCharArray();
            }
        }
        if (clazz.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    protected PyObject get(int n) {
        return Py.newString(this.string.charAt(n));
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 == 1) {
            return new PyString(this.string.substring(n, n2));
        }
        int n4 = PySequence.sliceLength(n, n2, n3);
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = n;
        while (n5 < n4) {
            cArray[n5++] = this.string.charAt(n6);
            n6 += n3;
        }
        return new PyString(new String(cArray));
    }

    public boolean __contains__(PyObject pyObject) {
        if (!(pyObject instanceof PyString) || pyObject.__len__() != 1) {
            throw Py.TypeError("string member test needs char left operand");
        }
        PyString pyString = (PyString)pyObject;
        return this.string.indexOf(pyString.string) >= 0;
    }

    protected PyObject repeat(int n) {
        int n2 = this.string.length();
        char[] cArray = new char[n2 * n];
        int n3 = 0;
        while (n3 < n) {
            this.string.getChars(0, n2, cArray, n3 * n2);
            ++n3;
        }
        return new PyString(new String(cArray));
    }

    public PyObject __add__(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            PyString pyString = (PyString)pyObject;
            return new PyString(this.string.concat(pyString.string));
        }
        return null;
    }

    public PyObject __mod__(PyObject pyObject) {
        StringFormatter stringFormatter = new StringFormatter(this.string);
        return new PyString(stringFormatter.format(pyObject));
    }

    public PyInteger __int__() {
        return Py.newInteger(this.atoi(10));
    }

    public PyLong __long__() {
        return this.atol(10);
    }

    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    public PyComplex __complex__() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = this.string.length();
        while (n < n2 && Character.isSpaceChar(this.string.charAt(n))) {
            ++n;
        }
        if (n == n2) {
            throw Py.ValueError("empty string for complex()");
        }
        double d = -1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 1;
        block7: do {
            char c = this.string.charAt(n);
            switch (c) {
                case '\u0000': {
                    if (n != n2) {
                        throw Py.ValueError("null byte in argument for complex()");
                    }
                    if (bl3) continue block7;
                    bl4 = true;
                    break;
                }
                case '-': {
                    n3 = -1;
                }
                case '+': {
                    if (bl3) {
                        bl4 = true;
                    }
                    if ((c = this.string.charAt(++n)) != '\u0000' && c != '+' && c != '-' && !Character.isSpaceChar(c)) continue block7;
                    bl4 = true;
                    break;
                }
                case 'J': 
                case 'j': {
                    if (bl2 || bl3) {
                        bl4 = true;
                        break;
                    }
                    d3 = d < 0.0 ? (double)n3 : (double)n3 * d;
                    bl2 = true;
                    if ((c = this.string.charAt(++n)) == '+' || c == '-') continue block7;
                    bl3 = true;
                    break;
                }
                default: {
                    boolean bl5;
                    if (Character.isSpaceChar(c)) {
                        while (n < n2 && Character.isSpaceChar(this.string.charAt(n))) {
                            ++n;
                        }
                        if (n != n2) {
                            bl4 = true;
                            break;
                        }
                        bl3 = true;
                        break;
                    }
                    c = this.string.charAt(n);
                    boolean bl6 = bl5 = c == '.' || Character.isDigit(c);
                    if (bl3 || !bl5) {
                        bl4 = true;
                        break;
                    }
                    int n4 = this.endDouble(this.string, n);
                    d = Double.valueOf(this.string.substring(n, n4));
                    n = n4;
                    c = this.string.charAt(n);
                    if (c == 'J' || c == 'j') continue block7;
                    if (bl) {
                        bl4 = true;
                        break;
                    }
                    d2 = (double)n3 * d;
                    bl = true;
                    if (bl2) {
                        bl3 = true;
                    }
                    d = -1.0;
                    n3 = 1;
                    break;
                }
            }
        } while (n < n2 && !bl4);
        if (bl4) {
            throw Py.ValueError("malformed string for complex() " + this.string.substring(n));
        }
        return new PyComplex(d2, d3);
    }

    private int endDouble(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            char c;
            if (!Character.isDigit(c = string.charAt(n++)) && c != '.' && (c != 'e' && c != 'E' || n >= n2 || (c = string.charAt(n++)) != '+' && c != '-')) break;
        }
        return n - 1;
    }

    public String lower() {
        return this.string.toLowerCase();
    }

    public String upper() {
        return this.string.toUpperCase();
    }

    public String title() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            cArray[n2] = bl ? Character.toLowerCase(c) : Character.toTitleCase(c);
            bl = Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isTitleCase(c);
            ++n2;
        }
        return new String(cArray);
    }

    public String swapcase() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                cArray[n2] = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                cArray[n2] = Character.toUpperCase(c);
            }
            ++n2;
        }
        return new String(cArray);
    }

    public String strip() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n && Character.isWhitespace(cArray[n2])) {
            ++n2;
        }
        int n3 = n - 1;
        while (n3 >= 0 && Character.isWhitespace(cArray[n3])) {
            --n3;
        }
        if (n3 >= n2) {
            return n3 < n - 1 || n2 > 0 ? this.string.substring(n2, n3 + 1) : this.string;
        }
        return "";
    }

    public String lstrip() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n && Character.isWhitespace(cArray[n2])) {
            ++n2;
        }
        return n2 > 0 ? this.string.substring(n2, n) : this.string;
    }

    public String rstrip() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        int n2 = n - 1;
        while (n2 >= 0 && Character.isWhitespace(cArray[n2])) {
            --n2;
        }
        return n2 < n - 1 ? this.string.substring(0, n2 + 1) : this.string;
    }

    public PyList split() {
        return this.split(null, -1);
    }

    public PyList split(String string) {
        return this.split(string, -1);
    }

    /*
     * Unable to fully structure code
     */
    public PyList split(String var1_1, int var2_2) {
        if (var1_1 != null) {
            return this.splitfields(var1_1, var2_2);
        }
        var3_3 = new PyList();
        var4_4 = this.string.toCharArray();
        var5_5 = var4_4.length;
        if (var2_2 < 0) {
            var2_2 = var5_5;
        }
        var6_6 = 0;
        var7_7 = 0;
        ** GOTO lbl21
        {
            ++var7_7;
            do {
                if (var7_7 < var5_5 && Character.isWhitespace(var4_4[var7_7])) continue block0;
                if (var7_7 == var5_5) break block0;
                var8_8 = var7_7;
                while (var7_7 < var5_5 && !Character.isWhitespace(var4_4[var7_7])) {
                    ++var7_7;
                }
                var3_3.append(new PyString(this.string.substring(var8_8, var7_7)));
                ++var6_6;
lbl21:
                // 2 sources

            } while (var7_7 < var5_5 && var6_6 < var2_2);
        }
        if (var7_7 < var5_5) {
            while (var7_7 < var5_5 && Character.isWhitespace(var4_4[var7_7])) {
                ++var7_7;
            }
            var3_3.append(new PyString(this.string.substring(var7_7, var5_5)));
        }
        return var3_3;
    }

    private PyList splitfields(String string, int n) {
        if (string.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        PyList pyList = new PyList();
        int n2 = this.string.length();
        if (n < 0) {
            n = n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n) {
            int n6 = this.string.indexOf(string, n3);
            if (n6 == -1) break;
            ++n4;
            pyList.append(new PyString(this.string.substring(n3, n6)));
            n3 = n6 + n5;
        }
        if (n3 <= n2) {
            pyList.append(new PyString(this.string.substring(n3, n2)));
        }
        return pyList;
    }

    public PyList splitlines() {
        return this.splitlines(false);
    }

    /*
     * Unable to fully structure code
     */
    public PyList splitlines(boolean var1_1) {
        var2_2 = new PyList();
        var3_3 = this.string.toCharArray();
        var4_4 = var3_3.length;
        var5_5 = 0;
        var6_6 = 0;
        ** GOTO lbl17
        {
            ++var6_6;
            do {
                if (var6_6 < var4_4 && (Character.getType(var3_3[var6_6]) & 13) == 0) continue block0;
                var7_7 = var6_6;
                if (var6_6 < var4_4) {
                    var6_6 = var3_3[var6_6] == '\r' && var6_6 + 1 < var4_4 && var3_3[var6_6 + 1] == '\n' ? (var6_6 += 2) : ++var6_6;
                    if (var1_1) {
                        var7_7 = var6_6;
                    }
                }
                var2_2.append(new PyString(this.string.substring(var5_5, var7_7)));
                var5_5 = var6_6;
lbl17:
                // 2 sources

            } while (var6_6 < var4_4);
        }
        if (var5_5 < var4_4) {
            var2_2.append(new PyString(this.string.substring(var5_5, var4_4)));
        }
        return var2_2;
    }

    public int index(String string) {
        return this.index(string, 0, this.string.length());
    }

    public int index(String string, int n) {
        return this.index(string, n, this.string.length());
    }

    public int index(String string, int n, int n2) {
        int n3;
        int n4 = this.string.length();
        if (n < 0) {
            n = n4 + n;
        }
        if (n2 < 0) {
            n2 = n4 + n2;
        }
        if ((n3 = n2 < n4 ? this.string.substring(n, n2).indexOf(string) : this.string.indexOf(string, n)) == -1) {
            throw Py.ValueError("substring not found in string.index");
        }
        return n3;
    }

    public int rindex(String string) {
        return this.rindex(string, 0, this.string.length());
    }

    public int rindex(String string, int n) {
        return this.rindex(string, n, this.string.length());
    }

    public int rindex(String string, int n, int n2) {
        int n3;
        int n4 = this.string.length();
        if (n < 0) {
            n = n4 + n;
        }
        if (n2 < 0) {
            n2 = n4 + n2;
        }
        if ((n3 = n > 0 ? this.string.substring(n, n2).lastIndexOf(string) : this.string.lastIndexOf(string, n2)) == -1) {
            throw Py.ValueError("substring not found in string.rindex");
        }
        return n3;
    }

    public int count(String string) {
        return this.count(string, 0, this.string.length());
    }

    public int count(String string, int n) {
        return this.count(string, n, this.string.length());
    }

    public int count(String string, int n, int n2) {
        int n3 = this.string.length();
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < 0) {
            n2 += n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n += n3;
        }
        if (n < 0) {
            n = 0;
        }
        int n4 = string.length();
        n2 = n2 + 1 - n4;
        if (n4 == 0) {
            return n2 - n;
        }
        int n5 = 0;
        while (n < n2) {
            int n6 = this.string.indexOf(string, n);
            if (n6 >= n2 || n6 == -1) break;
            ++n5;
            n = n6 + n4;
        }
        return n5;
    }

    public int find(String string) {
        return this.find(string, 0, this.string.length());
    }

    public int find(String string, int n) {
        return this.find(string, n, this.string.length());
    }

    public int find(String string, int n, int n2) {
        int n3 = this.string.length();
        if (n < 0) {
            n = n3 + n;
        }
        if (n2 < 0) {
            n2 = n3 + n2;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            n = n2;
        }
        int n4 = string.length();
        int n5 = this.string.indexOf(string, n);
        if (n5 > (n2 -= n4)) {
            return -1;
        }
        return n5;
    }

    public int rfind(String string) {
        return this.rfind(string, 0, this.string.length());
    }

    public int rfind(String string, int n) {
        return this.rfind(string, n, this.string.length());
    }

    public int rfind(String string, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.string.length();
        if (n < 0) {
            n = n5 + n;
        }
        if (n2 < 0) {
            n2 = n5 + n2;
        }
        if (n2 > n5) {
            n2 = n5;
        }
        if (n > n2) {
            n = n2;
        }
        if ((n4 = this.string.lastIndexOf(string, n2 -= (n3 = string.length()))) < n) {
            return -1;
        }
        return n4;
    }

    public double atof() {
        StringBuffer stringBuffer = null;
        int n = this.string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (Character.isDigit(c)) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(this.string);
                }
                int n3 = Character.digit(c, 10);
                stringBuffer.setCharAt(n2, Character.forDigit(n3, 10));
            }
            ++n2;
        }
        String string = this.string;
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Py.ValueError("invalid literal for __float__: " + this.string);
        }
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int n) {
        if (n != 0 && n < 2 || n > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        int n2 = 0;
        int n3 = this.string.length();
        while (n2 < n3 && Character.isWhitespace(this.string.charAt(n2))) {
            ++n2;
        }
        while (n3 > n2 && Character.isWhitespace(this.string.charAt(n3 - 1))) {
            --n3;
        }
        char c = '\u0000';
        if (n2 < n3 && ((c = this.string.charAt(n2)) == '-' || c == '+')) {
            ++n2;
            while (n2 < n3 && Character.isWhitespace(this.string.charAt(n2))) {
                ++n2;
            }
        }
        if ((n == 0 || n == 16) && this.string.charAt(n2) == '0') {
            if (n2 < n3 - 1 && this.string.charAt(n2 + 1) == 'x') {
                if (n == 0) {
                    n = 16;
                }
                n2 += 2;
            } else if (n == 0) {
                n = 8;
            }
        }
        if (n == 0) {
            n = 10;
        }
        String string = this.string;
        if (n2 > 0 || n3 < this.string.length()) {
            string = this.string.substring(n2, n3);
        }
        try {
            long l = Long.parseLong(string, n);
            if (l < 0L && (c != '-' || l != -l)) {
                throw Py.ValueError("invalid literal for __int__: " + this.string);
            }
            if (c == '-') {
                l = -l;
            }
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                throw Py.ValueError("invalid literal for __int__: " + this.string);
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            throw Py.ValueError("invalid literal for __int__: " + this.string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("invalid literal for __int__: " + this.string);
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int n) {
        String string = this.string;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        while (n3 > n2 && Character.isWhitespace(string.charAt(n3 - 1))) {
            --n3;
        }
        if (n3 > n2 && (string.charAt(n3 - 1) == 'L' || string.charAt(n3 - 1) == 'l')) {
            --n3;
        }
        char c = '\u0000';
        if (n2 < n3 && ((c = this.string.charAt(n2)) == '-' || c == '+')) {
            ++n2;
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
        }
        if (n == 0) {
            if (string.charAt(n2) != '0') {
                n = 10;
            } else if (string.charAt(n2 + 1) == 'x' || string.charAt(n2 + 1) == 'X') {
                n = 16;
                n2 += 2;
            } else {
                n = 8;
            }
        }
        if (n < 2 || n > 36) {
            throw Py.ValueError("invalid base for long literal:" + n);
        }
        if (n2 > 0 || n3 < string.length()) {
            string = string.substring(n2, n3);
        }
        try {
            BigInteger bigInteger = null;
            bigInteger = c == '-' ? new BigInteger("-" + string, n) : new BigInteger(string, n);
            return new PyLong(bigInteger);
        }
        catch (NumberFormatException numberFormatException) {
            throw Py.ValueError("invalid literal for __int__: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("invalid literal for __int__: " + string);
        }
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 32;
            ++n2;
        }
        return new String(cArray);
    }

    public String ljust(int n) {
        int n2 = n - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        return this.string + PyString.spaces(n2);
    }

    public String rjust(int n) {
        int n2 = n - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        return PyString.spaces(n2) + this.string;
    }

    public String center(int n) {
        int n2 = n - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        int n3 = n2 / 2;
        if (n2 % 2 > 0 && n % 2 > 0) {
            ++n3;
        }
        return PyString.spaces(n3) + this.string + PyString.spaces(n2 - n3);
    }

    public String zfill(int n) {
        String string = this.string;
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        char c = string.charAt(0);
        char[] cArray = new char[n];
        int n3 = n - n2;
        int n4 = 0;
        int n5 = 0;
        if (c == '+' || c == '-') {
            cArray[0] = c;
            ++n4;
            ++n3;
            n5 = 1;
        }
        while (n4 < n3) {
            cArray[n4] = 48;
            ++n4;
        }
        string.getChars(n5, string.length(), cArray, n4);
        return new String(cArray);
    }

    public String expandtabs() {
        return this.expandtabs(8);
    }

    public String expandtabs(int n) {
        String string = this.string;
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.5));
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = cArray[n4];
            if (c == '\t') {
                int n5 = n - n3 % n;
                n3 += n5;
                while (n5-- > 0) {
                    stringBuffer.append(' ');
                }
            } else {
                if (c == '\n' || c == '\r') {
                    n3 = -1;
                }
                stringBuffer.append(c);
                ++n3;
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String capitalize() {
        if (this.string.length() == 0) {
            return this.string;
        }
        String string = this.string.substring(0, 1).toUpperCase();
        return string.concat(this.string.substring(1).toLowerCase());
    }

    public String replace(String string, String string2) {
        return this.replace(string, string2, this.string.length());
    }

    public String replace(String string, String string2, int n) {
        PyString pyString = new PyString(string2);
        return pyString.join(this.split(string, n));
    }

    public String join(PyObject pyObject) {
        PyObject pyObject2;
        int n = __builtin__.len(pyObject);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((pyObject2 = pyObject.__finditem__(n2)) != null) {
            if (!(pyObject2 instanceof PyString)) {
                throw Py.TypeError("sequence item " + n2 + ": expected string, " + pyObject2.safeRepr() + " found");
            }
            if (n2 > 0) {
                stringBuffer.append(this.string);
            }
            stringBuffer.append(pyObject2.__str__());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean startswith(String string) {
        return this.string.startsWith(string);
    }

    public boolean startswith(String string, int n) {
        return this.string.startsWith(string, n);
    }

    public boolean startswith(String string, int n, int n2) {
        if (n < 0 || n + string.length() > this.string.length()) {
            return false;
        }
        String string2 = this.string.substring(n, n2);
        return string2.startsWith(string);
    }

    public boolean endswith(String string) {
        return this.string.endsWith(string);
    }

    public boolean endswith(String string, int n) {
        return this.endswith(string, n, this.string.length());
    }

    public boolean endswith(String string, int n, int n2) {
        int n3 = this.string.length();
        if (n < 0 || n > n3 || string.length() > n3) {
            return false;
        }
        int n4 = n2 = n2 <= n3 ? n2 : n3;
        if (n2 < n) {
            return false;
        }
        String string2 = this.string.substring(n, n2);
        return string2.endsWith(string);
    }

    public String translate(String string) {
        return this.translate(string, null);
    }

    public String translate(String string, String string2) {
        if (string.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuffer stringBuffer = new StringBuffer(this.string.length());
        int n = 0;
        while (n < this.string.length()) {
            char c = this.string.charAt(n);
            if (string2 == null || string2.indexOf(c) < 0) {
                try {
                    stringBuffer.append(string.charAt(c));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw Py.TypeError("translate() only works for 8-bit character strings");
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String translate(PyObject pyObject) {
        StringBuffer stringBuffer = new StringBuffer(this.string.length());
        int n = 0;
        while (n < this.string.length()) {
            char c = this.string.charAt(n);
            PyInteger pyInteger = Py.newInteger(c);
            PyObject pyObject2 = pyObject.__finditem__(pyInteger);
            if (pyObject2 == null) {
                stringBuffer.append(c);
            } else if (pyObject2 instanceof PyInteger) {
                int n2 = ((PyInteger)pyObject2).getValue();
                stringBuffer.append((char)n2);
            } else if (pyObject2 != Py.None) {
                if (pyObject2 instanceof PyString) {
                    if (pyObject2.__len__() != 1) {
                        throw new PyException(Py.NotImplementedError, "1-n mappings are currently not implemented");
                    }
                    stringBuffer.append(pyObject2.toString());
                } else {
                    throw Py.TypeError("character mapping must return integer, None or unicode");
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean islower() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isLowerCase(this.string.charAt(0));
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (Character.isUpperCase(c) || Character.isTitleCase(c)) {
                return false;
            }
            if (!bl && Character.isLowerCase(c)) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isupper() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isUpperCase(this.string.charAt(0));
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (Character.isLowerCase(c) || Character.isTitleCase(c)) {
                return false;
            }
            if (!bl && Character.isUpperCase(c)) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isalpha() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isLetter(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (!Character.isLetter(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isalnum() {
        int n = this.string.length();
        if (n == 1) {
            return this._isalnum(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (!this._isalnum(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean _isalnum(char c) {
        return Character.isLetterOrDigit(c) || Character.getType(c) == 10;
    }

    public boolean isdecimal() {
        int n = this.string.length();
        if (n == 1) {
            char c = this.string.charAt(0);
            return this._isdecimal(c);
        }
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (!this._isdecimal(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean _isdecimal(char c) {
        return Character.getType(c) == 9;
    }

    public boolean isdigit() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isDigit(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (!Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isnumeric() {
        int n = this.string.length();
        if (n == 1) {
            return this._isnumeric(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (!this._isnumeric(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean _isnumeric(char c) {
        int n = Character.getType(c);
        return n == 9 || n == 10 || n == 11;
    }

    public boolean istitle() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isTitleCase(this.string.charAt(0)) || Character.isUpperCase(this.string.charAt(0));
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (Character.isUpperCase(c) || Character.isTitleCase(c)) {
                if (bl2) {
                    return false;
                }
                bl2 = true;
                bl = true;
            } else if (Character.isLowerCase(c)) {
                if (!bl2) {
                    return false;
                }
                bl2 = true;
                bl = true;
            } else {
                bl2 = false;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isspace() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isWhitespace(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isunicode() {
        int n = this.string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = this.string.charAt(n2);
            if (c > '\u00ff') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PyString encode() {
        return this.encode(null, null);
    }

    public PyString encode(String string) {
        return this.encode(string, null);
    }

    public PyString encode(String string, String string2) {
        return codecs.encode(this, string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyString() {
        this.string = "";
    }

    public PyString(String string) {
        this.string = string;
    }

    public PyString(char c) {
        this(String.valueOf(c));
    }
}

